/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface © The Monotype Corporation plc. Data © The Monotype Corporation
 * plc/Type Solutions Inc. 1990-1992. All Rights Reserved
 * 
 * Trademark:
 * Arial® Trademark of The Monotype Corporation plc registered in the US Pat & TM
 * Off. and elsewhere.
 * 
 * Description:
 * Contemporary sans serif design, Arial contains more humanist characteristics
 * than many of its predecessors and as such is more in tune with the mood of the
 * last decades of the twentieth century.  The overall treatment of curves is
 * softer and fuller than in most industrial style sans serif faces.  Terminal
 * strokes are cut on the diagonal which helps to give the face a less mechanical
 * appearance.  Arial is an extremely versatile family of typefaces which can be
 * used with equal success for text setting in reports, presentations, magazines
 * etc, and for display use in newspapers, advertising and promotions.
 * 
 * Manufacturer:
 * Monotype Typography
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_arial.html
 * 
 * License information:
 * http://www.monotype.com/html/type/license.html
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 4 2 2 2 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-17 -313 360 76.2176","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"T":7,"A":20}},"\u00a0":{"w":100},"!":{"d":"41,-64r-10,-137r0,-57r39,0v1,69,-5,130,-9,194r-20,0xm32,0r0,-36r37,0r0,36r-37,0","w":100},"\"":{"d":"25,-166v-5,-28,-10,-57,-8,-92r36,0v2,35,-3,64,-8,92r-20,0xm83,-166v-5,-28,-10,-57,-8,-92r36,0v2,35,-3,64,-9,92r-19,0","w":127},"#":{"d":"18,4r15,-74r-29,0r0,-27r35,0r13,-63r-48,0r0,-27r53,0r15,-75r27,0r-16,75r56,0r15,-75r27,0r-16,75r31,0r0,27r-36,0r-13,63r49,0r0,27r-54,0r-16,74r-26,0r15,-74r-55,0r-16,74r-26,0xm65,-97r55,0r13,-63r-55,0"},"$":{"d":"183,-73v2,43,-32,78,-75,78r0,32r-18,0r0,-32v-49,-4,-73,-29,-77,-77r32,-6v3,33,19,53,45,57r0,-101v-35,-7,-74,-27,-72,-72v1,-41,27,-69,72,-72r0,-15r18,0r0,15v40,4,64,26,69,63r-33,5v-3,-24,-15,-37,-36,-42r0,92v48,10,72,26,75,75xm90,-240v-32,2,-52,44,-31,70v6,7,17,14,31,18r0,-88xm108,-21v34,-1,56,-49,34,-78v-6,-7,-17,-13,-34,-19r0,97"},"%":{"d":"75,-126v-37,0,-55,-29,-54,-70v0,-34,18,-66,54,-66v35,0,56,29,56,68v0,39,-22,67,-56,68xm104,-195v0,-27,-7,-45,-28,-45v-22,0,-27,18,-27,47v0,28,6,45,27,45v22,0,28,-18,28,-47xm76,9r141,-271r26,0r-141,271r-26,0xm242,9v-36,0,-54,-29,-54,-69v0,-37,18,-67,54,-67v34,1,56,29,56,68v0,39,-21,68,-56,68xm270,-60v0,-27,-6,-45,-27,-45v-22,0,-28,19,-28,48v0,26,7,45,28,45v22,0,27,-19,27,-48","w":320},"&":{"d":"112,-262v34,0,60,24,60,55v0,24,-17,46,-49,63r46,59v5,-10,10,-22,13,-36r32,7v-6,22,-12,40,-22,55v12,16,25,29,40,40r-21,25v-13,-8,-26,-20,-40,-36v-18,20,-40,33,-74,34v-45,2,-83,-33,-82,-75v1,-40,29,-60,62,-77v-18,-21,-27,-30,-29,-57v-2,-32,30,-57,64,-57xm110,-236v-30,0,-39,38,-17,55r14,16v21,-13,29,-18,32,-41v1,-17,-13,-30,-29,-30xm50,-73v-2,35,40,65,77,41v10,-6,18,-14,24,-23r-58,-72v-26,16,-41,26,-43,54","w":240},"'":{"d":"24,-166v-5,-28,-10,-57,-8,-92r36,0v2,35,-3,64,-9,92r-19,0","w":68},"(":{"d":"107,-262v-66,97,-72,231,0,338r-23,0v-31,-40,-62,-101,-62,-169v1,-74,27,-121,62,-169r23,0","w":119},")":{"d":"107,-93v1,68,-32,129,-63,169r-22,0v71,-107,66,-242,0,-338r22,0v35,49,62,96,63,169","w":119},"*":{"d":"11,-210r8,-25v19,7,33,12,41,17v-2,-21,-4,-36,-4,-44r26,0v0,12,-2,27,-4,44v12,-6,25,-12,41,-17r8,25v-15,5,-29,7,-43,9v7,6,17,18,30,34r-21,15v-7,-9,-15,-22,-24,-38v-9,17,-16,29,-23,38r-21,-15v14,-17,23,-29,29,-34v-15,-3,-29,-5,-43,-9","w":140},"+":{"d":"90,-42r0,-70r-70,0r0,-30r70,0r0,-70r30,0r0,70r70,0r0,30r-70,0r0,70r-30,0","w":210},",":{"d":"32,0r0,-36r36,0v1,40,2,77,-29,87r-9,-14v15,-6,20,-16,20,-37r-18,0","w":100},"-":{"d":"11,-77r0,-32r98,0r0,32r-98,0","w":119},"\u00ad":{"d":"11,-77r0,-32r98,0r0,32r-98,0","w":119},".":{"d":"33,0r0,-36r36,0r0,36r-36,0","w":100},"\/":{"d":"0,4r75,-266r25,0r-75,266r-25,0","w":100},"0":{"d":"99,4v-67,0,-84,-54,-84,-131v0,-75,16,-132,84,-132v67,0,84,56,84,132v0,74,-16,131,-84,131xm99,-233v-46,6,-52,44,-52,106v0,65,8,98,52,105v44,-6,51,-40,51,-105v0,-65,-6,-99,-51,-106"},"1":{"d":"39,-194v32,-13,61,-39,75,-65r20,0r0,259r-32,0r0,-202v-14,14,-43,31,-63,39r0,-31","k":{"1":27}},"2":{"d":"181,-187v0,78,-96,103,-126,157r126,0r0,30r-170,0v6,-90,131,-106,137,-188v2,-26,-21,-46,-48,-45v-31,0,-51,20,-51,52r-32,-3v3,-47,35,-75,84,-75v46,0,80,30,80,72"},"3":{"d":"136,-140v88,26,42,150,-39,145v-45,-3,-78,-32,-82,-73r32,-4v6,31,18,50,50,50v30,1,54,-23,53,-53v0,-37,-34,-60,-72,-47r3,-28v28,4,58,-12,58,-42v0,-23,-19,-41,-42,-41v-28,0,-43,20,-47,47r-32,-6v7,-38,36,-64,78,-67v71,-6,103,95,40,119"},"4":{"d":"116,0r0,-62r-111,0r0,-29r117,-167r26,0r0,167r35,0r0,29r-35,0r0,62r-32,0xm116,-91r0,-116r-80,116r80,0"},"5":{"d":"186,-87v0,102,-163,129,-171,19r33,-2v3,29,21,48,50,48v31,0,54,-28,54,-63v0,-60,-78,-75,-102,-33r-29,-4r25,-132r128,0r0,30r-103,0r-14,69v54,-41,129,2,129,68"},"6":{"d":"14,-121v0,-103,66,-171,142,-121v14,9,20,27,23,47r-31,3v-4,-35,-42,-53,-70,-32v-23,18,-33,45,-33,91v13,-20,34,-34,63,-34v43,-1,77,38,76,83v-2,50,-31,88,-81,88v-63,0,-89,-47,-89,-125xm101,-139v-29,0,-52,24,-51,56v1,33,19,61,52,61v29,0,49,-26,49,-60v0,-33,-19,-57,-50,-57"},"7":{"d":"53,0v4,-86,46,-174,90,-224r-126,0r0,-30r167,0r0,24v-47,54,-92,133,-98,230r-33,0"},"8":{"d":"15,-75v1,-36,19,-57,49,-65v-71,-23,-35,-126,35,-119v70,-9,105,99,37,119v29,9,47,30,48,66v1,46,-38,78,-85,78v-48,0,-85,-33,-84,-79xm99,-233v-23,0,-42,18,-42,40v0,24,18,41,43,41v23,0,41,-18,41,-40v0,-23,-19,-41,-42,-41xm99,-126v-29,0,-53,23,-52,52v2,30,22,52,53,52v29,1,52,-22,52,-51v0,-30,-23,-53,-53,-53"},"9":{"d":"184,-134v0,81,-20,135,-92,138v-42,2,-68,-26,-72,-64r30,-2v5,25,16,40,43,40v49,0,58,-49,60,-99v-11,18,-35,34,-62,34v-43,0,-76,-38,-76,-85v0,-49,34,-90,81,-87v64,4,88,47,88,125xm99,-115v31,-1,50,-24,50,-58v0,-33,-19,-60,-49,-60v-30,1,-53,29,-53,62v0,31,22,56,52,56"},":":{"d":"33,-151r0,-36r36,0r0,36r-36,0xm33,0r0,-36r36,0r0,36r-36,0","w":100},";":{"d":"32,-151r0,-36r36,0r0,36r-36,0xm32,0r0,-36r36,0v1,40,2,77,-29,87r-9,-14v15,-6,20,-16,20,-37r-18,0","w":100},"\u037e":{"d":"32,-151r0,-36r36,0r0,36r-36,0xm32,0r0,-36r36,0v1,40,2,77,-29,87r-9,-14v15,-6,20,-16,20,-37r-18,0","w":100},"<":{"d":"20,-113r0,-29r170,-72r0,31r-135,56r135,56r0,31","w":210},"=":{"d":"190,-152r-170,0r0,-29r170,0r0,29xm190,-73r-170,0r0,-30r170,0r0,30","w":210},">":{"d":"190,-113r-170,73r0,-31r135,-56r-135,-56r0,-31r170,72r0,29","w":210},"?":{"d":"182,-192v0,61,-74,60,-69,129r-30,0v-10,-71,61,-75,67,-127v3,-24,-25,-47,-50,-46v-31,2,-47,20,-52,52r-32,-4v6,-45,33,-74,83,-74v46,0,83,28,83,70xm81,0r0,-36r36,0r0,36r-36,0"},"@":{"d":"238,1v-22,0,-33,-7,-34,-30v-13,16,-30,30,-54,30v-108,0,-62,-192,28,-192v25,0,42,14,53,33r6,-27r31,0r-30,145v0,7,5,11,12,11v38,-8,68,-51,68,-97v0,-70,-56,-111,-126,-111v-89,0,-145,64,-146,152v-1,91,61,134,151,135v57,0,101,-22,124,-53r31,0v-26,46,-78,80,-155,79v-107,-1,-177,-53,-177,-158v0,-107,64,-180,174,-180v88,0,146,52,150,137v3,58,-51,127,-106,126xm180,-164v-61,-1,-88,129,-23,139v41,-6,61,-45,64,-89v1,-28,-16,-50,-41,-50","w":365},"A":{"d":"-1,0r99,-258r37,0r106,258r-39,0r-30,-78r-108,0r-28,78r-37,0xm74,-106r87,0r-45,-125v-9,45,-28,84,-42,125","w":240,"k":{"\u2019":27,"y":7,"w":7,"v":7,"Y":27,"W":13,"V":27,"T":27," ":20}},"B":{"d":"221,-75v1,89,-104,75,-195,75r0,-258v82,0,182,-14,182,66v0,27,-15,46,-36,55v29,8,48,29,49,62xm175,-188v0,-52,-64,-37,-115,-39r0,78v50,-2,115,12,115,-39xm186,-75v0,-55,-70,-43,-126,-44r0,89v56,-2,126,12,126,-45","w":240},"C":{"d":"136,-25v43,0,68,-26,76,-65r34,8v-12,51,-48,86,-107,86v-84,1,-113,-57,-121,-135v-14,-136,189,-182,223,-56r-33,8v-11,-33,-29,-53,-69,-54v-60,-1,-86,44,-86,102v0,61,25,106,83,106","w":259},"D":{"d":"241,-130v0,82,-35,130,-120,130r-93,0r0,-258r89,0v89,-3,124,46,124,128xm206,-131v0,-64,-21,-99,-90,-96r-54,0r0,197r55,0v68,2,89,-37,89,-101","w":259},"E":{"d":"28,0r0,-258r187,0r0,31r-152,0r0,79r142,0r0,30r-142,0r0,88r158,0r0,30r-193,0","w":240},"F":{"d":"30,0r0,-258r173,0r0,31r-139,0r0,80r121,0r0,30r-121,0r0,117r-34,0","w":219,"k":{"A":20,".":40,",":40}},"G":{"d":"54,-130v-8,101,111,128,170,77r0,-48r-76,0r0,-30r110,0r0,95v-29,22,-61,40,-107,40v-80,0,-127,-52,-132,-132v-8,-116,138,-177,215,-100v10,10,16,25,20,42r-31,9v-9,-35,-33,-55,-75,-56v-64,0,-89,42,-94,103","w":280},"H":{"d":"29,0r0,-258r34,0r0,106r134,0r0,-106r34,0r0,258r-34,0r0,-121r-134,0r0,121r-34,0","w":259},"I":{"d":"34,0r0,-258r34,0r0,258r-34,0","w":100},"J":{"d":"152,-82v13,80,-77,109,-124,67v-13,-12,-18,-32,-18,-58r31,-4v1,34,9,51,38,51v31,0,39,-19,39,-54r0,-178r34,0r0,176","w":180},"K":{"d":"26,0r0,-258r34,0r0,128r128,-128r47,0r-108,105r112,153r-45,0r-91,-130r-43,41r0,89r-34,0","w":240},"L":{"d":"26,0r0,-258r34,0r0,228r127,0r0,30r-161,0","k":{"\u2019":20,"y":13,"Y":27,"W":27,"V":27,"T":27," ":13}},"M":{"d":"27,0r0,-258r51,0r73,221r76,-221r46,0r0,258r-33,0r0,-216r-75,216r-31,0r-74,-219r0,219r-33,0","w":299},"N":{"d":"27,0r0,-258r35,0r136,203r0,-203r32,0r0,258r-35,0r-135,-202r0,202r-33,0","w":259},"O":{"d":"141,4v-77,0,-122,-55,-124,-130v-2,-80,49,-136,124,-136v78,0,123,54,123,134v0,78,-48,132,-123,132xm141,-233v-57,0,-88,40,-88,108v0,57,35,100,87,100v55,0,90,-43,89,-104v-1,-60,-30,-104,-88,-104","w":280},"P":{"d":"224,-183v0,78,-78,83,-162,78r0,105r-34,0r0,-258v90,1,196,-17,196,75xm189,-182v0,-59,-69,-43,-127,-45r0,92v57,-1,127,12,127,-47","w":240,"k":{"A":27,".":46,",":46," ":7}},"Q":{"d":"262,-129v0,45,-14,77,-39,101v16,11,31,19,44,24r-10,24v-19,-7,-38,-18,-56,-32v-89,47,-191,-16,-186,-117v4,-77,45,-133,124,-133v77,0,123,53,123,133xm51,-129v0,75,53,122,122,97v-11,-7,-21,-11,-33,-14r8,-25v20,6,36,13,49,24v55,-50,34,-192,-58,-186v-55,3,-88,41,-88,104","w":280},"R":{"d":"234,-187v-1,42,-29,66,-72,70v46,24,63,76,93,117r-42,0v-30,-37,-46,-92,-92,-113v-15,-2,-41,-1,-59,-1r0,114r-34,0r0,-258v90,3,209,-22,206,71xm199,-187v0,-56,-81,-40,-137,-42r0,85v57,-2,136,14,137,-43","w":259,"k":{"Y":7,"W":7,"V":7,"T":7}},"S":{"d":"177,-136v81,33,37,140,-51,140v-65,0,-107,-28,-110,-87r32,-3v4,41,33,55,76,60v56,6,90,-59,34,-80v-45,-17,-132,-19,-132,-85v0,-83,139,-91,175,-35v8,12,12,26,13,41r-33,2v5,-62,-119,-67,-122,-10v-2,44,93,40,118,57","w":240},"T":{"d":"93,0r0,-227r-85,0r0,-31r205,0r0,31r-86,0r0,227r-34,0","w":219,"k":{"y":20,"w":20,"u":13,"s":40,"r":13,"o":40,"i":13,"e":40,"c":40,"a":40,"O":7,"A":27,";":40,":":40,".":40,"-":20,",":40," ":7}},"U":{"d":"127,-26v108,0,60,-141,70,-232r34,0r0,149v1,76,-28,113,-101,113v-74,0,-102,-37,-102,-113r0,-149r34,0v9,90,-34,232,65,232","w":259},"V":{"d":"101,0r-99,-258r36,0r81,230r83,-230r35,0r-101,258r-35,0","w":240,"k":{"y":13,"u":13,"r":13,"o":20,"i":7,"e":20,"a":27,"A":27,";":13,":":13,".":33,"-":20,",":33}},"W":{"d":"73,0r-69,-258r35,0r50,222r61,-222r41,0r37,131v9,32,16,63,20,91r53,-222r35,0r-71,258r-33,0r-62,-227r-62,227r-35,0","w":339,"k":{"y":3,"u":7,"r":7,"o":7,"e":7,"a":13,"A":13,";":7,":":7,".":20,"-":7,",":20}},"X":{"d":"2,0r99,-134r-88,-124r41,0r67,98r73,-98r37,0r-91,122r98,136r-42,0r-76,-109r-77,109r-41,0","w":240},"Y":{"d":"100,0r0,-109r-99,-149r42,0r77,122r78,-122r39,0r-103,149r0,109r-34,0","w":240,"k":{"v":20,"u":20,"q":33,"p":27,"o":33,"i":13,"e":33,"a":27,"A":27,";":23,":":20,".":46,"-":33,",":46," ":7}},"Z":{"d":"7,0r0,-32r132,-165v9,-12,19,-21,27,-30r-144,0r0,-31r185,0r0,31r-161,197r165,0r0,30r-204,0","w":219},"[":{"d":"24,72r0,-330r70,0r0,26r-38,0r0,277r38,0r0,27r-70,0","w":100},"\\":{"d":"75,4r-75,-266r25,0r75,266r-25,0","w":100},"]":{"d":"77,72r-70,0r0,-27r38,0r0,-277r-38,0r0,-26r70,0r0,330","w":100},"^":{"d":"42,-121r-33,0r63,-141r25,0r62,141r-31,0r-44,-105","w":168},"_":{"d":"-5,72r0,-23r209,0r0,23r-209,0"},"`":{"d":"82,-210r-26,0r-40,-49r42,0","w":119},"a":{"d":"175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"b":{"d":"185,-96v10,81,-84,134,-132,73r0,23r-29,0r0,-258r31,0r0,92v47,-57,140,-8,130,70xm104,-165v-33,0,-51,31,-51,70v0,44,15,73,49,73v33,0,51,-31,51,-72v0,-41,-16,-71,-49,-71"},"c":{"d":"47,-94v-15,78,93,98,99,26r31,4v-5,40,-35,68,-78,68v-54,0,-87,-39,-85,-97v-17,-102,139,-138,160,-39r-31,5v-6,-23,-18,-38,-43,-38v-37,0,-54,28,-53,71","w":180},"d":{"d":"91,-191v24,0,41,12,52,26r0,-93r31,0r0,258r-29,0r0,-24v-12,19,-29,28,-52,28v-53,-2,-81,-43,-81,-97v0,-55,26,-96,79,-98xm94,-165v-34,0,-49,29,-49,72v0,41,18,71,51,71v32,0,49,-29,49,-69v0,-44,-16,-74,-51,-74"},"e":{"d":"102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0"},"f":{"d":"108,-231v-33,-9,-51,6,-45,44r36,0r0,25r-36,0r0,162r-32,0r0,-162r-28,0r0,-25r28,0v-7,-60,24,-85,81,-72","w":100,"k":{"\u2019":-7,"f":7}},"g":{"d":"176,-25v13,94,-74,121,-138,86v-15,-8,-20,-26,-20,-46r31,5v-1,35,56,37,77,21v18,-14,19,-25,18,-65v-14,16,-31,24,-52,24v-51,2,-80,-45,-80,-94v1,-55,25,-96,80,-97v22,0,41,9,55,27r0,-23r29,0r0,162xm95,-165v-33,0,-51,29,-51,68v0,42,16,71,51,71v35,0,52,-28,52,-70v0,-39,-20,-69,-52,-69"},"h":{"d":"105,-164v-69,0,-47,96,-50,164r-31,0r0,-258r31,0r0,93v38,-46,121,-31,121,47r0,118r-32,0v-8,-60,25,-164,-39,-164"},"i":{"d":"24,-221r0,-37r32,0r0,37r-32,0xm24,0r0,-187r32,0r0,187r-32,0","w":79},"j":{"d":"24,-221r0,-37r31,0r0,37r-31,0xm55,10v4,55,-26,74,-72,62r6,-26v28,7,35,-3,35,-37r0,-196r31,0r0,197","w":79},"k":{"d":"24,0r0,-258r32,0r0,147r74,-76r41,0r-71,70r79,117r-39,0r-62,-95r-22,21r0,74r-32,0","w":180},"l":{"d":"23,0r0,-258r32,0r0,258r-32,0","w":79},"m":{"d":"102,-163v-67,0,-42,97,-47,163r-31,0r0,-187r28,0r0,27v15,-38,98,-44,109,2v28,-52,116,-43,116,30r0,128r-32,0r0,-118v1,-31,-8,-44,-33,-45v-67,-2,-41,99,-46,163r-31,0r0,-121v-1,-26,-7,-42,-33,-42","w":299},"n":{"d":"105,-163v-69,-3,-46,97,-50,163r-31,0r0,-187r28,0r0,27v33,-53,123,-40,123,45r0,115r-31,0v-8,-59,25,-161,-39,-163"},"o":{"d":"99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"p":{"d":"186,-95v8,78,-84,130,-131,76r0,91r-31,0r0,-259r29,0r0,25v12,-17,27,-29,54,-29v54,1,74,43,79,96xm104,-166v-32,0,-52,34,-52,74v0,41,17,70,50,70v34,0,51,-31,51,-73v0,-41,-16,-71,-49,-71"},"q":{"d":"13,-95v-11,-82,88,-129,133,-67r0,-25r28,0r0,259r-31,0r0,-92v-45,55,-141,3,-130,-75xm94,-166v-32,0,-49,31,-49,72v0,41,18,72,52,72v31,0,49,-30,49,-69v0,-42,-18,-75,-52,-75"},"r":{"d":"114,-151v-36,-23,-59,12,-59,53r0,98r-32,0r0,-187r29,0r0,29v13,-32,41,-42,73,-23","w":119,"k":{"\u2019":-13,".":20,",":20}},"s":{"d":"138,-99v56,31,18,103,-47,103v-48,0,-73,-19,-80,-60r31,-5v-2,47,89,53,92,9v-16,-47,-118,-16,-118,-85v0,-61,103,-69,132,-30v5,7,9,16,11,28r-31,5v2,-39,-81,-42,-81,-7v0,32,70,31,91,42","w":180},"t":{"d":"61,-53v-2,25,10,28,32,25r4,28v-45,6,-67,0,-67,-55r0,-107r-24,0r0,-25r24,0r0,-46r31,-19r0,65r32,0r0,25r-32,0r0,109","w":100},"u":{"d":"93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"v":{"d":"76,0r-71,-187r33,0r52,150r53,-150r33,0r-71,187r-29,0","w":180,"k":{".":27,",":27}},"w":{"d":"58,0r-57,-187r33,0r41,148v8,-38,28,-107,39,-148r32,0r38,144r42,-144r31,0r-58,187r-33,0r-37,-144r-38,144r-33,0","w":259,"k":{".":20,",":20}},"x":{"d":"3,0r68,-97r-63,-90r39,0r42,65v15,-24,30,-42,46,-65r37,0r-64,88r69,99r-38,0r-49,-74r-49,74r-38,0","w":180},"y":{"d":"22,72r-3,-30v38,11,50,-10,58,-42r-71,-187r34,0r39,108v5,14,9,29,13,44v14,-54,35,-101,53,-152r32,0r-89,233v-12,23,-35,37,-66,26","w":180,"k":{".":27,",":27}},"z":{"d":"7,0r0,-26r119,-136r-112,1r0,-26r153,0r0,21r-121,140r126,-1r0,27r-165,0","w":180},"{":{"d":"46,-9v0,-44,-1,-66,-36,-70r0,-29v34,-3,37,-25,36,-67v-2,-63,6,-89,66,-87r0,28v-30,-1,-37,4,-36,36v0,67,1,84,-37,105v29,13,36,33,37,79v1,48,-6,61,36,62r0,28v-59,3,-67,-25,-66,-85","w":120},"|":{"d":"33,76r0,-338r28,0r0,338r-28,0","w":93},"}":{"d":"74,-178v0,44,1,66,36,70r0,29v-34,3,-37,26,-36,68v1,63,-6,89,-66,87r0,-28v30,1,37,-4,36,-36v0,-64,1,-86,37,-105v-29,-15,-37,-32,-37,-79v0,-48,7,-62,-36,-62r0,-28v58,-3,67,25,66,84","w":120},"~":{"d":"61,-122v-23,0,-30,10,-46,24r0,-36v34,-42,92,-8,135,3v19,0,35,-14,45,-25r0,38v-14,12,-26,19,-49,20v-28,1,-59,-24,-85,-24","w":210},"\u00c4":{"d":"67,-274r0,-36r33,0r0,36r-33,0xm132,-274r0,-36r33,0r0,36r-33,0xm-1,0r99,-258r37,0r106,258r-39,0r-30,-78r-108,0r-28,78r-37,0xm74,-106r87,0r-45,-125v-9,45,-28,84,-42,125","w":240},"\u00c5":{"d":"116,-249v-18,0,-31,-14,-31,-32v0,-18,13,-32,31,-32v17,0,32,14,32,32v1,18,-14,33,-32,32xm117,-300v-10,0,-20,9,-19,19v-1,11,9,19,19,19v10,0,19,-9,18,-19v1,-10,-9,-19,-18,-19xm-1,0r99,-258r37,0r106,258r-39,0r-30,-78r-108,0r-28,78r-37,0xm74,-106r87,0r-45,-125v-9,45,-28,84,-42,125","w":240},"\u00d6":{"d":"91,-274r0,-36r33,0r0,36r-33,0xm156,-274r0,-36r33,0r0,36r-33,0xm141,4v-77,0,-122,-55,-124,-130v-2,-80,49,-136,124,-136v78,0,123,54,123,134v0,78,-48,132,-123,132xm141,-233v-57,0,-88,40,-88,108v0,57,35,100,87,100v55,0,90,-43,89,-104v-1,-60,-30,-104,-88,-104","w":280},"\u00dc":{"d":"80,-274r0,-36r33,0r0,36r-33,0xm145,-274r0,-36r33,0r0,36r-33,0xm127,-26v108,0,60,-141,70,-232r34,0r0,149v1,76,-28,113,-101,113v-74,0,-102,-37,-102,-113r0,-149r34,0v9,90,-34,232,65,232","w":259},"\u00e1":{"d":"81,-210r24,-49r41,0r-38,49r-27,0xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e0":{"d":"175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29xm126,-210r-26,0r-40,-49r42,0"},"\u00e4":{"d":"50,-223r0,-36r33,0r0,36r-33,0xm115,-223r0,-36r33,0r0,36r-33,0xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e5":{"d":"99,-202v-17,0,-32,-16,-32,-33v0,-17,15,-31,32,-32v17,0,32,16,32,33v0,17,-15,31,-32,32xm99,-254v-9,0,-19,9,-18,19v-1,11,8,19,18,19v10,0,19,-10,19,-19v0,-9,-10,-19,-19,-19xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e7":{"d":"100,35v-2,-11,-13,-11,-28,-11r9,-32r24,0r-6,19v17,1,30,11,30,26v0,31,-43,37,-76,31r2,-20v21,1,42,3,45,-13xm47,-94v-15,78,93,98,99,26r31,4v-5,40,-35,68,-78,68v-54,0,-87,-39,-85,-97v-17,-102,139,-138,160,-39r-31,5v-6,-23,-18,-38,-43,-38v-37,0,-54,28,-53,71","w":180},"\u00e9":{"d":"82,-210r23,-49r42,0r-39,49r-26,0xm102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0"},"\u00e8":{"d":"102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0xm121,-210r-26,0r-40,-49r42,0"},"\u00ed":{"d":"35,0r0,-187r31,0r0,187r-31,0xm33,-210r24,-49r41,0r-39,49r-26,0","w":100},"\u00ee":{"d":"53,-240r-20,30r-36,0r38,-49r34,0r39,49r-36,0xm35,0r0,-187r31,0r0,187r-31,0","w":100},"\u00ef":{"d":"35,0r0,-187r31,0r0,187r-31,0xm2,-223r0,-36r33,0r0,36r-33,0xm67,-223r0,-36r33,0r0,36r-33,0","w":100},"\u00f1":{"d":"129,-215v-15,3,-59,-37,-60,1r-23,0v-1,-23,15,-40,36,-40v14,-3,57,33,59,-1r23,0v0,24,-12,40,-35,40xm105,-163v-69,-3,-46,97,-50,163r-31,0r0,-187r28,0r0,27v33,-53,123,-40,123,45r0,115r-31,0v-8,-59,25,-161,-39,-163"},"\u00f3":{"d":"82,-210r23,-49r42,0r-39,49r-26,0xm99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"\u00f6":{"d":"50,-223r0,-36r33,0r0,36r-33,0xm116,-223r0,-36r33,0r0,36r-33,0xm99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"\u00f9":{"d":"93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164xm128,-210r-26,0r-40,-49r42,0"},"\u00fb":{"d":"99,-240r-20,30r-36,0r38,-49r34,0r39,49r-36,0xm93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"\u00fc":{"d":"49,-223r0,-36r33,0r0,36r-33,0xm115,-223r0,-36r33,0r0,36r-33,0xm93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"\u00a3":{"d":"190,-7v-55,33,-123,-30,-173,12r-12,-30v26,-14,49,-50,37,-91r-34,0r0,-26r27,0v-27,-60,6,-120,71,-120v44,0,73,28,78,67r-32,4v0,-56,-94,-59,-92,-2v0,13,3,30,10,51r55,0r0,26r-50,0v10,34,-9,61,-28,82v49,-15,93,26,133,-2"},"\u00df":{"d":"101,-236v-33,2,-43,19,-42,62r0,174r-32,0r0,-176v-2,-57,24,-84,75,-86v35,-1,65,20,65,50v1,28,-23,49,-27,72v10,34,69,40,69,85v0,48,-62,77,-103,48v-11,-8,-19,-19,-25,-31r27,-13v9,36,68,39,68,-1v0,-40,-68,-44,-68,-83v0,-28,29,-46,28,-73v0,-16,-15,-30,-35,-28","w":219},"\u2122":{"d":"86,-114r0,-122r-46,0r0,-22r117,0r0,22r-47,0r0,122r-24,0xm173,-114r0,-144r35,0r36,115r35,-115r34,0r0,144r-21,0r0,-121r-37,121r-22,0r-38,-122r0,122r-22,0","w":360},"\u00ab":{"d":"60,-93r45,80r-25,0r-56,-80r56,-80r26,0xm128,-93r46,80r-27,0r-55,-80r55,-80r27,0"},"\u00bb":{"d":"139,-93r-46,-80r26,0r56,80r-56,80r-26,0xm71,-93r-46,-80r26,0r55,80r-55,80r-26,0"},"\u2026":{"d":"42,0r0,-36r36,0r0,36r-36,0xm162,0r0,-36r36,0r0,36r-36,0xm282,0r0,-36r36,0r0,36r-36,0","w":360},"\u2013":{"d":"-1,-81r0,-25r201,0r0,25r-201,0"},"\u2014":{"d":"0,-81r0,-25r360,0r0,25r-360,0","w":360},"\u201c":{"d":"49,-214r0,36r-34,0v-1,-40,-2,-74,29,-84r7,12v-13,7,-19,16,-19,36r17,0xm103,-214r0,36r-34,0v-1,-41,0,-74,29,-84r8,12v-13,7,-19,16,-20,36r17,0","w":119},"\u201d":{"d":"15,-224r0,-36r34,0v1,40,2,74,-29,84r-8,-12v13,-6,20,-17,20,-36r-17,0xm70,-224r0,-36r34,0v1,41,0,74,-29,84r-8,-12v13,-6,19,-17,19,-36r-16,0","w":119},"\u2018":{"d":"56,-214r0,36r-34,0v-1,-41,0,-74,30,-84r7,12v-13,7,-19,16,-19,36r16,0","w":79,"k":{"\u2018":7}},"\u2019":{"d":"22,-224r0,-36r34,0v1,41,0,74,-29,84r-8,-12v13,-6,19,-17,19,-36r-16,0","w":79,"k":{"\u2019":7,"s":7," ":13}},"\u00ff":{"d":"43,-223r0,-36r33,0r0,36r-33,0xm108,-223r0,-36r33,0r0,36r-33,0xm22,72r-3,-30v38,11,50,-10,58,-42r-71,-187r34,0r39,108v5,14,9,29,13,44v14,-54,35,-101,53,-152r32,0r-89,233v-12,23,-35,37,-66,26","w":180},"\u20ac":{"d":"20,-164v6,-76,101,-122,175,-84r-7,33v-50,-42,-129,-5,-132,51r120,0r-5,23r-118,0r0,23r113,0r-4,24r-105,0v2,62,85,89,131,52r0,36v-78,31,-156,-11,-166,-88r-27,0r5,-24r18,0r0,-23r-23,0r5,-23r20,0"},"\u0142":{"d":"23,-101r-22,19r0,-27r22,-20r0,-129r32,0r0,103r24,-21r0,28r-24,20r0,128r-32,0r0,-101","w":79},"\u00d7":{"d":"28,-72r56,-55r-56,-55r22,-22r55,55r55,-55r21,22r-55,55r56,55r-22,21r-55,-55r-55,55","w":210},"\u0107":{"d":"75,-210r23,-49r41,0r-38,49r-26,0xm47,-94v-15,78,93,98,99,26r31,4v-5,40,-35,68,-78,68v-54,0,-87,-39,-85,-97v-17,-102,139,-138,160,-39r-31,5v-6,-23,-18,-38,-43,-38v-37,0,-54,28,-53,71","w":180},"\u0105":{"d":"223,60v-26,17,-81,14,-77,-28v0,-10,2,-24,7,-41r22,0v-13,23,-9,56,18,56v9,0,19,-3,30,-8r0,21xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u0119":{"d":"165,64v-27,18,-80,15,-77,-28v0,-10,2,-23,7,-40r22,0v-13,22,-9,55,18,55v9,0,19,-3,30,-8r0,21xm102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0"},"\u015b":{"d":"69,-210r24,-49r41,0r-39,49r-26,0xm138,-99v56,31,18,103,-47,103v-48,0,-73,-19,-80,-60r31,-5v-2,47,89,53,92,9v-16,-47,-118,-16,-118,-85v0,-61,103,-69,132,-30v5,7,9,16,11,28r-31,5v2,-39,-81,-42,-81,-7v0,32,70,31,91,42","w":180},"\u017a":{"d":"69,-210r23,-49r42,0r-39,49r-26,0xm7,0r0,-26r119,-136r-112,1r0,-26r153,0r0,21r-121,140r126,-1r0,27r-165,0","w":180},"\u017c":{"d":"70,-210r0,-39r39,0r0,39r-39,0xm7,0r0,-26r119,-136r-112,1r0,-26r153,0r0,21r-121,140r126,-1r0,27r-165,0","w":180},"\u2032":{"d":"22,-166v1,-34,5,-64,12,-92r36,0v-6,34,-16,64,-28,92r-20,0","w":67},"\u2033":{"d":"22,-166v1,-34,5,-64,12,-92r36,0v-6,34,-16,64,-28,92r-20,0xm72,-166v1,-34,5,-64,12,-92r36,0v-6,34,-16,64,-28,92r-20,0","w":127}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface © The Monotype Corporation plc. Data © The Monotype Corporation
 * plc/Type Solutions Inc. 1990-1992. All Rights Reserved
 * 
 * Trademark:
 * Arial® Trademark of The Monotype Corporation plc registered in the US Pat & TM
 * Off. and elsewhere.
 * 
 * Description:
 * Contemporary sans serif design, Arial contains more humanist characteristics
 * than many of its predecessors and as such is more in tune with the mood of the
 * last decades of the twentieth century.  The overall treatment of curves is
 * softer and fuller than in most industrial style sans serif faces.  Terminal
 * strokes are cut on the diagonal which helps to give the face a less mechanical
 * appearance.  Arial is an extremely versatile family of typefaces which can be
 * used with equal success for text setting in reports, presentations, magazines
 * etc, and for display use in newspapers, advertising and promotions.
 * 
 * Manufacturer:
 * Monotype Typography
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_arial.html
 * 
 * License information:
 * http://www.monotype.com/html/type/license.html
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":700,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 4 2 2 2 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-17 -315 360 76.147","underline-thickness":"37.793","underline-position":"-19.3359","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"A":13}},"\u00a0":{"w":100},"!":{"d":"45,-66v-5,-63,-15,-121,-13,-192r54,0v2,71,-7,129,-13,192r-28,0xm34,0r0,-49r50,0r0,49r-50,0","w":119},"\"":{"d":"29,-166v-6,-28,-11,-56,-9,-92r53,0v2,35,-2,64,-8,92r-36,0xm108,-166v-6,-28,-11,-56,-9,-92r54,0v2,35,-2,64,-8,92r-37,0","w":170},"#":{"d":"27,-64r-24,0r0,-39r32,0r10,-52r-42,0r0,-39r50,0r14,-68r40,0r-14,68r38,0r14,-68r41,0r-14,68r24,0r0,39r-32,0r-11,52r43,0r0,39r-51,0r-14,68r-39,0r14,-68r-39,0r-14,68r-40,0xm85,-155r-10,52r39,0r10,-52r-39,0"},"$":{"d":"184,-77v1,44,-31,76,-73,80r0,33r-25,0r0,-32v-42,-5,-67,-34,-74,-76r46,-5v4,17,15,33,28,39r0,-74v-40,-12,-67,-33,-67,-78v0,-39,30,-68,67,-71r0,-17r25,0r0,17v38,5,60,25,66,61r-44,6v-3,-14,-11,-23,-22,-28r0,69v48,14,72,26,73,76xm86,-223v-29,6,-30,54,0,61r0,-61xm111,-36v24,-2,40,-34,23,-55v-5,-6,-12,-10,-23,-13r0,68"},"%":{"d":"73,-126v-39,0,-57,-25,-57,-68v0,-42,18,-68,56,-68v39,0,57,25,57,68v0,42,-18,68,-56,68xm72,-234v-17,1,-18,16,-18,40v0,24,2,36,18,40v26,0,26,-82,0,-80xm110,10r-37,0r137,-272r36,0xm247,10v-40,0,-58,-26,-58,-68v0,-42,18,-68,57,-68v39,0,57,25,57,68v0,42,-17,68,-56,68xm246,-98v-17,2,-18,16,-18,40v0,24,1,37,18,40v17,-2,18,-16,18,-40v0,-24,-1,-37,-18,-40","w":320},"&":{"d":"214,-61v8,8,31,25,40,30r-30,38v-15,-7,-29,-17,-42,-30v-44,49,-172,32,-166,-48v2,-41,27,-62,59,-79v-15,-16,-27,-32,-27,-56v0,-35,31,-56,72,-56v40,0,71,23,71,59v0,33,-18,41,-47,61r36,47v4,-8,8,-17,11,-29r45,10v-7,26,-11,37,-22,53xm121,-227v-41,2,-19,42,-1,55v10,-8,28,-20,28,-32v0,-14,-12,-24,-27,-23xm100,-118v-39,12,-49,83,5,82v21,-1,32,-9,46,-20","w":259},"'":{"d":"25,-166v-6,-28,-11,-56,-9,-92r54,0v2,35,-2,64,-8,92r-37,0","w":85},"(":{"d":"108,-262v-55,100,-54,241,0,338r-34,0v-31,-46,-53,-103,-55,-169v-1,-69,26,-126,56,-169r33,0","w":119},")":{"d":"101,-96v-1,69,-23,124,-55,172r-34,0v54,-95,55,-240,0,-338r33,0v31,44,56,98,56,166","w":119},"*":{"d":"43,-139r-26,-21r33,-34r-45,-11r10,-31v15,6,29,13,41,21v-3,-19,-4,-35,-4,-47r31,0v0,9,-1,24,-4,47r44,-19r9,32v-13,3,-28,5,-45,8r31,36r-27,18r-23,-40v-7,13,-16,27,-25,41","w":140},"+":{"d":"82,-37r0,-67r-67,0r0,-46r67,0r0,-67r45,0r0,67r68,0r0,46r-68,0r0,67r-45,0","w":210},",":{"d":"25,-49r49,0v2,53,-1,95,-44,106r-9,-20v19,-5,27,-15,28,-37r-24,0r0,-49","w":100},"-":{"d":"20,-69r0,-49r97,0r0,49r-97,0","w":119},"\u00ad":{"d":"20,-69r0,-49r97,0r0,49r-97,0","w":119},".":{"d":"26,0r0,-49r49,0r0,49r-49,0","w":100},"\/":{"d":"-1,4r64,-266r37,0r-64,266r-37,0","w":100},"0":{"d":"15,-128v0,-79,18,-131,84,-131v66,0,83,54,83,132v0,78,-17,131,-83,131v-65,0,-84,-50,-84,-132xm99,-37v48,0,32,-111,27,-152v-2,-18,-10,-28,-27,-29v-35,7,-32,41,-32,91v0,52,-4,83,32,90"},"1":{"d":"28,-194v27,-9,65,-37,74,-65r40,0r0,259r-50,0r0,-186v-18,17,-40,29,-64,37r0,-45","k":{"1":20}},"2":{"d":"182,-187v1,71,-71,97,-98,141r98,0r0,46r-173,0v3,-65,81,-112,113,-153v20,-24,12,-67,-23,-65v-23,2,-33,15,-35,40r-49,-4v5,-51,34,-76,85,-77v46,-1,82,29,82,72"},"3":{"d":"136,-139v91,25,42,143,-38,143v-46,0,-81,-29,-84,-72r47,-6v3,21,16,37,37,37v22,1,36,-18,36,-42v0,-32,-25,-50,-57,-37r5,-40v45,8,58,-61,13,-62v-18,1,-31,15,-32,34r-46,-7v8,-43,32,-65,80,-68v69,-4,108,91,39,120"},"4":{"d":"112,0r0,-52r-105,0r0,-43r111,-164r42,0r0,164r32,0r0,43r-32,0r0,52r-48,0xm112,-95r0,-88r-59,88r59,0"},"5":{"d":"189,-86v0,103,-162,125,-173,20r49,-5v2,19,18,36,37,36v24,0,37,-22,37,-51v0,-49,-52,-62,-77,-28r-40,-6r25,-134r131,0r0,46r-93,0r-8,44v58,-28,112,19,112,78"},"6":{"d":"15,-125v0,-82,27,-134,95,-134v42,0,66,26,73,64r-48,6v0,-32,-39,-38,-55,-15v-7,9,-12,28,-14,58v44,-51,121,-3,121,63v0,50,-33,89,-82,87v-63,-2,-90,-51,-90,-129xm105,-131v-21,0,-34,18,-34,44v0,27,14,50,36,50v23,0,32,-18,32,-45v0,-29,-11,-49,-34,-49"},"7":{"d":"50,0v2,-81,37,-158,78,-208r-113,0r0,-46r169,0r0,36v-43,45,-85,132,-86,218r-48,0"},"8":{"d":"15,-74v0,-32,17,-55,43,-65v-22,-9,-37,-26,-37,-53v0,-41,31,-67,77,-67v76,0,106,96,42,120v26,10,43,31,44,63v0,48,-35,81,-83,81v-48,0,-87,-32,-86,-79xm99,-220v-17,0,-31,13,-31,31v0,19,12,31,30,31v18,0,31,-12,31,-31v0,-18,-13,-31,-30,-31xm99,-118v-22,0,-36,19,-36,40v-1,24,16,43,37,43v22,0,35,-18,35,-43v0,-23,-15,-40,-36,-40"},"9":{"d":"184,-129v0,81,-28,134,-95,134v-43,0,-66,-26,-73,-65r48,-5v0,31,40,38,55,15v7,-9,12,-29,14,-59v-44,51,-122,5,-122,-63v0,-49,35,-89,83,-87v63,3,90,52,90,130xm94,-123v21,0,34,-20,34,-45v0,-27,-13,-50,-36,-50v-22,0,-32,18,-32,46v0,29,11,49,34,49"},":":{"d":"35,-137r0,-50r50,0r0,50r-50,0xm35,0r0,-49r50,0r0,49r-50,0","w":119},";":{"d":"34,-137r0,-50r49,0r0,50r-49,0xm34,-49r49,0v2,52,1,96,-43,106r-10,-20v18,-6,27,-16,28,-37r-24,0r0,-49","w":119},"\u037e":{"d":"34,-137r0,-50r49,0r0,50r-49,0xm34,-49r49,0v2,52,1,96,-43,106r-10,-20v18,-6,27,-16,28,-37r-24,0r0,-49","w":119},"<":{"d":"193,-29r-176,-77r0,-43r176,-76r0,50r-123,47r123,49r0,50","w":210},"=":{"d":"15,-143r0,-46r180,0r0,46r-180,0xm15,-65r0,-46r180,0r0,46r-180,0","w":210},">":{"d":"17,-29r0,-50r123,-48r-123,-48r0,-50r177,77r0,42","w":210},"?":{"d":"111,-260v61,0,113,51,83,105v-6,11,-48,44,-59,60v-3,5,-3,15,-3,29r-45,0v-12,-71,62,-74,68,-122v3,-21,-20,-35,-42,-35v-29,1,-43,17,-49,44r-45,-6v1,-44,43,-75,92,-75xm87,0r0,-49r50,0r0,49r-50,0","w":219},"@":{"d":"191,43v56,1,97,-14,121,-46r38,0v-25,51,-81,79,-156,79v-110,0,-183,-55,-183,-161v0,-107,70,-177,180,-177v89,0,146,50,149,135v1,66,-53,129,-116,127v-19,0,-28,-5,-32,-20v-43,44,-115,10,-115,-54v0,-76,86,-160,141,-93r5,-19r46,0r-29,141v0,6,2,9,7,9v36,-8,61,-49,62,-92v0,-63,-51,-102,-119,-102v-93,0,-147,60,-147,148v0,84,62,125,148,125xm176,-159v-37,0,-52,47,-54,83v-1,26,11,44,32,44v40,0,53,-47,55,-86v1,-23,-13,-41,-33,-41","w":351},"A":{"d":"259,0r-57,0r-23,-59r-103,0r-21,59r-55,0r100,-258r55,0xm163,-102r-36,-96r-35,96r71,0","w":259,"k":{"\u2019":20,"y":13,"w":7,"v":13,"Y":33,"W":20,"V":27,"T":27," ":13}},"B":{"d":"242,-75v0,66,-41,75,-128,75r-88,0r0,-258v88,3,202,-21,204,65v0,27,-18,47,-37,56v29,8,49,28,49,62xm179,-185v0,-43,-52,-27,-101,-30r0,60v45,-2,101,11,101,-30xm188,-77v0,-49,-61,-32,-110,-35r0,69v47,-3,110,14,110,-34","w":259},"C":{"d":"134,-40v34,0,51,-23,57,-55r51,16v-15,51,-46,83,-108,83v-71,0,-117,-54,-117,-131v0,-139,187,-188,224,-60r-52,13v-5,-24,-25,-45,-54,-44v-44,1,-64,35,-64,88v0,56,18,90,63,90","w":259},"D":{"d":"242,-126v0,80,-32,126,-118,126r-98,0r0,-258r95,0v89,-2,121,47,121,132xm188,-129v2,-75,-30,-91,-110,-85r0,171r39,0v59,2,70,-28,71,-86","w":259},"E":{"d":"26,0r0,-258r191,0r0,44r-139,0r0,57r130,0r0,43r-130,0r0,71r144,0r0,43r-196,0","w":240},"F":{"d":"27,0r0,-258r176,0r0,44r-124,0r0,61r107,0r0,43r-107,0r0,110r-52,0","w":219,"k":{"A":20,".":40,",":40}},"G":{"d":"71,-132v0,87,83,114,135,70r0,-33r-60,0r0,-43r112,0r0,102v-20,21,-69,41,-110,40v-82,-1,-131,-52,-131,-134v0,-80,44,-131,128,-132v62,0,99,26,110,76r-52,9v-7,-25,-27,-41,-58,-41v-49,1,-74,33,-74,86","w":280},"H":{"d":"26,0r0,-258r52,0r0,102r102,0r0,-102r52,0r0,258r-52,0r0,-113r-102,0r0,113r-52,0","w":259},"I":{"d":"25,0r0,-258r52,0r0,258r-52,0","w":100},"J":{"d":"87,-40v29,0,31,-16,32,-51r0,-167r52,0v-8,109,36,267,-85,262v-52,-2,-81,-30,-80,-84r49,-5v1,29,9,45,32,45"},"K":{"d":"27,0r0,-258r52,0r0,115r105,-115r70,0r-97,101r102,157r-67,0r-71,-121r-42,43r0,78r-52,0","w":259},"L":{"d":"28,0r0,-256r52,0r0,213r129,0r0,43r-181,0","w":219,"k":{"\u2019":20,"y":13,"Y":33,"W":20,"V":27,"T":27," ":7}},"M":{"d":"25,0r0,-258r78,0r47,176r46,-176r78,0r0,258r-48,0r0,-203r-51,203r-50,0r-51,-203r0,203r-49,0","w":299},"N":{"d":"27,0r0,-258r50,0r106,172r0,-172r48,0r0,258r-52,0r-104,-168r0,168r-48,0","w":259},"O":{"d":"141,4v-76,0,-126,-52,-125,-131v1,-85,41,-133,124,-135v78,-1,126,54,126,134v0,81,-48,132,-125,132xm141,-218v-48,0,-72,36,-72,89v0,53,25,89,72,89v48,0,71,-37,71,-90v0,-53,-24,-88,-71,-88","w":280},"P":{"d":"224,-178v0,76,-62,85,-146,81r0,97r-52,0r0,-258r84,0v81,-4,114,15,114,80xm170,-178v-1,-42,-45,-36,-92,-36r0,73v47,0,92,5,92,-37","w":240,"k":{"A":27,".":46,",":46," ":7}},"Q":{"d":"265,-129v0,43,-10,72,-31,96v13,9,26,17,41,22r-19,37v-27,-10,-23,-10,-58,-33v-94,36,-182,-18,-182,-122v0,-82,45,-133,125,-133v78,0,125,52,124,133xm69,-129v0,60,35,102,91,86v-11,-7,-21,-12,-32,-16r15,-29v17,6,33,14,49,26v38,-46,23,-162,-51,-156v-47,4,-72,36,-72,89","w":280},"R":{"d":"237,-185v0,42,-27,66,-68,71v42,23,61,73,89,114r-62,0r-65,-94v-11,-13,-27,-14,-53,-14r0,108r-52,0r0,-258r110,0v68,-3,101,17,101,73xm184,-182v0,-46,-59,-29,-106,-32r0,65v47,-3,106,12,106,-33","w":259,"k":{"Y":13,"W":7,"V":7}},"S":{"d":"184,-142v73,44,30,156,-65,147v-65,-6,-99,-31,-106,-89r51,-5v6,32,21,47,56,50v46,4,72,-50,26,-63v-47,-14,-124,-26,-124,-88v0,-77,119,-89,167,-51v16,14,25,33,26,57r-52,2v-5,-26,-17,-35,-47,-37v-29,-2,-59,20,-36,41v14,13,87,26,104,36","w":240},"T":{"d":"84,0r0,-214r-76,0r0,-44r205,0r0,44r-77,0r0,214r-52,0","w":219,"k":{"y":27,"w":27,"u":27,"s":27,"r":20,"o":27,"i":7,"e":27,"c":27,"a":27,"O":7,"A":27,";":40,":":40,".":40,"-":20,",":40}},"U":{"d":"132,4v-85,0,-106,-36,-106,-124r0,-138r52,0r0,140v-2,56,7,78,52,78v44,0,49,-24,49,-75r0,-143r52,0r0,136v4,90,-19,126,-99,126","w":259},"V":{"d":"92,0r-92,-258r56,0r65,191r64,-191r55,0r-93,258r-55,0","w":240,"k":{"y":13,"u":13,"r":20,"o":27,"i":7,"e":20,"a":20,"A":27,";":20,":":20,".":33,"-":20,",":33}},"W":{"d":"63,0r-62,-258r53,0r39,177r47,-177r62,0r46,180r39,-180r52,0r-62,258r-55,0r-52,-193r-51,193r-56,0","w":339,"k":{"y":7,"u":7,"r":7,"o":7,"i":3,"e":7,"a":13,"A":20,";":7,":":7,".":20,"-":7,",":20}},"X":{"d":"0,0r88,-134r-80,-124r61,0r52,83r50,-83r61,0r-80,125r88,133r-63,0r-57,-89r-58,89r-62,0","w":240},"Y":{"d":"94,0r0,-108r-95,-150r61,0r61,102r60,-102r59,0r-94,150r0,108r-52,0","w":240,"k":{"v":20,"u":20,"q":27,"p":20,"o":27,"i":13,"e":20,"a":20,"A":33,";":27,":":27,".":40,"-":20,",":40," ":7}},"Z":{"d":"4,0r0,-47r135,-167r-120,0r0,-44r189,0r0,41r-141,174r146,0r0,43r-209,0","w":219},"[":{"d":"26,73r0,-331r87,0r0,39r-40,0r0,253r40,0r0,39r-87,0","w":119},"\\":{"d":"-1,-262r37,0r64,266r-37,0","w":100},"]":{"d":"94,-258r0,331r-87,0r0,-39r40,0r0,-253r-40,0r0,-39r87,0","w":119},"^":{"d":"20,-122r66,-140r40,0r64,140r-50,0r-35,-86r-35,86r-50,0","w":210},"_":{"d":"-3,71r0,-32r205,0r0,32r-205,0"},"`":{"d":"87,-210r-31,0r-49,-52r56,0","w":119},"a":{"d":"95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"b":{"d":"206,-95v11,86,-93,131,-136,68r0,27r-46,0r0,-258r49,0r0,93v49,-57,143,-12,133,70xm114,-153v-27,0,-41,23,-41,56v0,37,14,62,43,62v27,0,39,-24,39,-58v0,-37,-12,-60,-41,-60","w":219},"c":{"d":"15,-93v0,-107,150,-136,174,-38r-49,8v-3,-19,-14,-30,-34,-29v-29,1,-40,20,-40,55v0,66,70,83,77,25r48,9v-10,42,-36,66,-86,67v-56,0,-90,-39,-90,-97"},"d":{"d":"15,-94v-9,-83,83,-128,133,-71r0,-93r49,0r0,258r-46,0r0,-27v-43,63,-147,18,-136,-67xm107,-153v-28,0,-42,23,-42,56v0,39,13,62,42,62v27,0,41,-26,41,-58v0,-36,-12,-60,-41,-60","w":219},"e":{"d":"62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0"},"f":{"d":"124,-221v-27,-8,-49,-1,-43,34r37,0r0,39r-37,0r0,148r-49,0r0,-148r-28,0r0,-39r28,0v-11,-69,41,-86,98,-69","w":119,"k":{"\u2019":-7}},"g":{"d":"108,76v-56,1,-87,-16,-87,-64r57,7v2,17,10,18,28,19v42,3,43,-26,41,-68v-45,64,-140,15,-132,-64v-10,-85,90,-131,136,-66r0,-27r46,0r0,168v2,69,-24,94,-89,95xm106,-153v-27,0,-41,23,-41,56v0,34,14,57,40,57v28,0,43,-22,43,-56v0,-34,-14,-57,-42,-57","w":219},"h":{"d":"116,-153v-61,0,-36,94,-41,153r-49,0r0,-258r49,0r0,95v41,-52,121,-31,121,53r0,110r-50,0r0,-99v0,-39,-1,-54,-30,-54","w":219},"i":{"d":"26,-212r0,-46r49,0r0,46r-49,0xm26,0r0,-187r49,0r0,187r-49,0","w":100},"j":{"d":"25,-212r0,-46r49,0r0,46r-49,0xm-8,28v26,5,33,-2,33,-37r0,-178r49,0r0,181v9,72,-31,92,-91,76","w":100},"k":{"d":"24,0r0,-258r49,0r0,137r58,-66r61,0r-64,69r69,118r-54,0r-46,-84r-24,24r0,60r-49,0"},"l":{"d":"26,0r0,-258r49,0r0,258r-49,0","w":100},"m":{"d":"109,-153v-59,0,-31,95,-37,153r-50,0r0,-187r46,0r0,26v26,-39,92,-40,111,0v30,-48,118,-40,118,42r0,119r-50,0r0,-107v0,-33,-3,-46,-26,-46v-57,0,-32,95,-37,153r-49,0r0,-102v-1,-35,0,-51,-26,-51","w":320},"n":{"d":"71,-159v36,-53,125,-40,125,43r0,116r-50,0v-7,-52,23,-153,-30,-153v-61,0,-36,93,-41,153r-50,0r0,-187r46,0r0,28","w":219},"o":{"d":"111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"p":{"d":"207,-94v0,82,-86,130,-133,71r0,94r-50,0r0,-258r46,0r0,28v11,-17,32,-32,59,-32v48,1,78,43,78,97xm115,-152v-27,0,-42,23,-42,55v0,35,14,62,43,62v27,0,40,-23,40,-59v0,-34,-13,-58,-41,-58","w":219},"q":{"d":"16,-95v0,-84,97,-130,136,-64r0,-28r45,0r0,258r-49,0r0,-94v-10,15,-31,27,-55,27v-49,-1,-77,-45,-77,-99xm107,-35v27,0,42,-27,42,-61v0,-34,-13,-56,-41,-56v-29,0,-42,23,-42,59v0,35,13,58,41,58","w":219},"r":{"d":"129,-139v-48,-23,-60,18,-56,81r0,58r-49,0r0,-187r46,0r0,27v14,-31,43,-39,75,-22","w":140,"k":{"\u2019":-13,".":20,",":20}},"s":{"d":"167,-95v38,45,-4,99,-69,99v-49,0,-80,-20,-90,-57r50,-8v5,20,16,27,40,30v32,4,51,-29,15,-37v-64,-14,-92,-14,-98,-66v-7,-59,95,-69,136,-44v12,8,20,20,25,36r-46,9v0,-27,-63,-31,-69,-7v2,24,89,25,106,45"},"t":{"d":"115,-3v-47,18,-87,4,-87,-63r0,-81r-23,0r0,-40r23,0r0,-37r50,-29r0,66r33,0r0,40r-33,0r0,75v-3,35,5,40,33,31","w":119},"u":{"d":"105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"v":{"d":"77,0r-75,-187r52,0r45,127r46,-127r51,0r-74,187r-45,0","k":{".":27,",":27}},"w":{"d":"61,0r-59,-187r48,0r35,123r32,-123r47,0r31,123r36,-123r49,0r-60,187r-48,0r-32,-120r-31,120r-48,0","w":280,"k":{".":13,",":13}},"x":{"d":"2,0r67,-96r-64,-91r60,0r33,52r35,-52r58,0r-63,89r69,98r-61,0r-38,-58r-38,58r-58,0"},"y":{"d":"2,-187r53,0r45,133r43,-133r51,0r-77,212v-11,40,-47,59,-98,48r-5,-39v33,9,54,-7,59,-33","k":{".":27,",":27}},"z":{"d":"6,0r0,-38r95,-109v-26,2,-60,1,-88,1r0,-41r154,0r0,35r-96,110r102,-1r0,43r-167,0","w":180},"{":{"d":"49,-3v0,-48,0,-64,-38,-69r0,-42v35,-2,40,-23,38,-63v-3,-69,17,-86,82,-85r0,42v-74,-12,-5,97,-69,127v31,9,33,64,33,101v0,24,9,25,36,26r0,42v-61,2,-82,-16,-82,-79","w":140},"|":{"d":"31,76r0,-338r39,0r0,338r-39,0","w":100},"}":{"d":"90,-183v-2,47,1,65,38,69r0,42v-35,2,-40,22,-38,62v3,70,-16,87,-82,86r0,-42v27,0,36,-2,36,-25v0,-37,1,-94,33,-102v-32,-24,-31,-39,-33,-100v-1,-26,-7,-27,-36,-27r0,-42v61,-2,84,15,82,79","w":140},"~":{"d":"146,-92v-27,0,-63,-25,-86,-24v-16,0,-32,9,-48,25r0,-46v35,-46,97,-12,138,0v19,-1,36,-11,48,-25r0,47v-9,11,-32,23,-52,23","w":210},"\u00c4":{"d":"67,-272r0,-43r43,0r0,43r-43,0xm143,-272r0,-43r42,0r0,43r-42,0xm259,0r-57,0r-23,-59r-103,0r-21,59r-55,0r100,-258r55,0xm163,-102r-36,-96r-35,96r71,0","w":259},"\u00c5":{"d":"127,-309v18,0,35,15,35,34v0,18,-17,35,-35,35v-18,0,-34,-17,-34,-35v0,-17,17,-34,34,-34xm127,-259v9,1,17,-7,16,-16v1,-9,-7,-15,-16,-15v-8,0,-15,7,-15,15v0,9,6,17,15,16xm259,0r-57,0r-23,-59r-103,0r-21,59r-55,0r100,-258r55,0xm163,-102r-36,-96r-35,96r71,0","w":259},"\u00d6":{"d":"79,-272r0,-43r42,0r0,43r-42,0xm154,-272r0,-43r43,0r0,43r-43,0xm141,4v-76,0,-126,-52,-125,-131v1,-85,41,-133,124,-135v78,-1,126,54,126,134v0,81,-48,132,-125,132xm141,-218v-48,0,-72,36,-72,89v0,53,25,89,72,89v48,0,71,-37,71,-90v0,-53,-24,-88,-71,-88","w":280},"\u00dc":{"d":"70,-272r0,-43r42,0r0,43r-42,0xm146,-272r0,-43r42,0r0,43r-42,0xm132,4v-85,0,-106,-36,-106,-124r0,-138r52,0r0,140v-2,56,7,78,52,78v44,0,49,-24,49,-75r0,-143r52,0r0,136v4,90,-19,126,-99,126","w":259},"\u00e1":{"d":"75,-210r25,-52r55,0r-48,52r-32,0xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e0":{"d":"95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25xm125,-210r-31,0r-49,-52r56,0"},"\u00e4":{"d":"41,-220r0,-42r43,0r0,42r-43,0xm117,-220r0,-42r43,0r0,42r-43,0xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e5":{"d":"100,-270v18,0,35,15,35,34v0,18,-18,35,-35,35v-17,0,-34,-17,-34,-35v0,-17,17,-34,34,-34xm100,-220v8,0,16,-8,16,-16v0,-8,-8,-16,-16,-16v-8,0,-15,8,-15,16v0,8,7,16,15,16xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e7":{"d":"151,35v0,39,-58,43,-95,36r0,-21v25,2,57,7,62,-14v-1,-18,-29,-17,-46,-12r5,-17v29,-11,74,-4,74,28xm15,-93v0,-107,150,-136,174,-38r-49,8v-3,-19,-14,-30,-34,-29v-29,1,-40,20,-40,55v0,66,70,83,77,25r48,9v-10,42,-36,66,-86,67v-56,0,-90,-39,-90,-97"},"\u00e9":{"d":"74,-210r24,-52r55,0r-48,52r-31,0xm62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0"},"\u00e8":{"d":"62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0xm124,-210r-31,0r-49,-52r56,0"},"\u00ed":{"d":"26,0r0,-187r49,0r0,187r-49,0xm22,-210r24,-52r56,0r-49,52r-31,0","w":100},"\u00ee":{"d":"-9,-210r37,-52r46,0r36,52r-40,0r-20,-26r-19,26r-40,0xm26,0r0,-187r49,0r0,187r-49,0","w":100},"\u00ef":{"d":"26,0r0,-187r49,0r0,187r-49,0xm-8,-220r0,-42r42,0r0,42r-42,0xm67,-220r0,-42r43,0r0,42r-43,0","w":100},"\u00f1":{"d":"140,-213v-26,2,-62,-33,-68,1r-22,0v-2,-25,9,-44,32,-44v23,0,60,35,67,-1r22,0v1,28,-9,43,-31,44xm71,-159v36,-53,125,-40,125,43r0,116r-50,0v-7,-52,23,-153,-30,-153v-61,0,-36,93,-41,153r-50,0r0,-187r46,0r0,28","w":219},"\u00f3":{"d":"86,-210r24,-52r55,0r-48,52r-31,0xm111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"\u00f6":{"d":"50,-220r0,-42r42,0r0,42r-42,0xm125,-220r0,-42r43,0r0,42r-43,0xm111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"\u00f9":{"d":"105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154xm135,-210r-31,0r-49,-52r56,0","w":219},"\u00fb":{"d":"50,-210r37,-52r46,0r36,52r-39,0r-21,-26r-19,26r-40,0xm105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"\u00fc":{"d":"51,-220r0,-42r42,0r0,42r-42,0xm126,-220r0,-42r43,0r0,42r-43,0xm105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"\u00a3":{"d":"195,-8v-52,36,-127,-29,-174,12r-19,-42v23,-16,41,-37,37,-71r-37,0r0,-39r28,0v-23,-61,12,-114,75,-114v47,0,75,26,80,68r-48,7v1,-45,-66,-46,-67,-3v0,12,6,31,9,42r55,0r0,39r-47,0v3,32,-9,42,-26,64v39,-17,78,22,115,-5"},"\u00df":{"d":"101,-223v-28,3,-26,19,-27,56r0,167r-50,0r0,-167v-1,-63,18,-94,77,-95v42,-1,70,18,72,53v1,19,-21,46,-22,61v6,32,56,50,56,92v0,64,-95,80,-119,27r34,-20v6,18,36,18,36,-4v0,-21,-10,-19,-30,-39v-20,-19,-29,-34,-29,-45v0,-16,23,-50,23,-68v0,-10,-10,-19,-21,-18","w":219},"\u2122":{"d":"82,-114r0,-119r-44,0r0,-25r117,0r0,25r-43,0r0,119r-30,0xm172,-114r0,-144r46,0r26,99r26,-99r46,0r0,144r-28,0r0,-115r-31,115r-26,0r-31,-115r0,115r-28,0","w":360},"\u00ab":{"d":"111,-173r-45,79r45,82r-39,0r-55,-82r55,-79r39,0xm180,-173r-45,79r45,82r-39,0r-55,-82r55,-79r39,0"},"\u00bb":{"d":"88,-12r45,-80r-45,-81r38,0r56,81r-56,80r-38,0xm19,-12r45,-80r-45,-81r38,0r56,81r-56,80r-38,0"},"\u2026":{"d":"275,0r0,-49r50,0r0,49r-50,0xm155,0r0,-49r50,0r0,49r-50,0xm35,0r0,-49r50,0r0,49r-50,0","w":360},"\u2013":{"d":"-1,-75r0,-37r201,0r0,37r-201,0"},"\u2014":{"d":"0,-75r0,-37r360,0r0,37r-360,0","w":360},"\u201c":{"d":"73,-153r-50,0v-2,-53,1,-96,44,-107r10,20v-18,6,-28,15,-28,37r24,0r0,50xm155,-153r-49,0v-3,-52,-1,-97,43,-107r10,20v-18,6,-27,16,-28,37r24,0r0,50","w":180},"\u201d":{"d":"105,-258r50,0v3,53,-1,97,-44,107r-10,-20v18,-6,28,-15,28,-37r-24,0r0,-50xm22,-258r50,0v2,53,0,97,-44,107r-10,-20v18,-6,28,-15,28,-37r-24,0r0,-50","w":180},"\u2018":{"d":"76,-153r-49,0v-2,-52,-1,-97,43,-107r10,20v-18,6,-27,16,-28,37r24,0r0,50","w":100,"k":{"\u2018":13}},"\u2019":{"d":"25,-257r49,0v2,53,-1,95,-44,106r-9,-20v19,-5,27,-15,28,-37r-24,0r0,-49","w":100,"k":{"\u2019":13,"s":13," ":20}},"\u00ff":{"d":"40,-220r0,-42r43,0r0,42r-43,0xm116,-220r0,-42r43,0r0,42r-43,0xm2,-187r53,0r45,133r43,-133r51,0r-77,212v-11,40,-47,59,-98,48r-5,-39v33,9,54,-7,59,-33"},"\u20ac":{"d":"21,-168v9,-72,94,-116,168,-83r-10,48v-34,-32,-102,-7,-105,35r97,0r-6,27r-94,0r0,23r89,0r-5,28r-80,0v6,54,80,65,113,29r0,54v-74,33,-158,-12,-168,-83r-26,0r6,-28r17,0r0,-23r-23,0r6,-27r21,0"},"\u0142":{"d":"26,-127r0,-131r49,0r0,89r24,-20r0,33r-24,21r0,135r-49,0r0,-93r-24,20r0,-33","w":100},"\u00d7":{"d":"20,-74r53,-53r-54,-53r33,-33r53,53r53,-53r32,32r-53,53r54,54r-33,33r-54,-54r-53,53","w":210},"\u0107":{"d":"76,-210r24,-52r56,0r-49,52r-31,0xm15,-93v0,-107,150,-136,174,-38r-49,8v-3,-19,-14,-30,-34,-29v-29,1,-40,20,-40,55v0,66,70,83,77,25r48,9v-10,42,-36,66,-86,67v-56,0,-90,-39,-90,-97"},"\u0105":{"d":"213,68v-33,17,-80,8,-79,-33v0,-10,3,-24,7,-40r26,0v-6,21,-6,57,22,54v7,0,15,-2,24,-5r0,24xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u0119":{"d":"160,68v-33,16,-80,8,-78,-33v0,-10,2,-24,6,-40r26,0v-6,21,-6,57,22,54v7,0,15,-2,24,-5r0,24xm62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0"},"\u015b":{"d":"80,-210r24,-52r55,0r-48,52r-31,0xm167,-95v38,45,-4,99,-69,99v-49,0,-80,-20,-90,-57r50,-8v5,20,16,27,40,30v32,4,51,-29,15,-37v-64,-14,-92,-14,-98,-66v-7,-59,95,-69,136,-44v12,8,20,20,25,36r-46,9v0,-27,-63,-31,-69,-7v2,24,89,25,106,45"},"\u017a":{"d":"56,-210r24,-52r56,0r-49,52r-31,0xm6,0r0,-38r95,-109v-26,2,-60,1,-88,1r0,-41r154,0r0,35r-96,110r102,-1r0,43r-167,0","w":180},"\u017c":{"d":"63,-215r0,-47r49,0r0,47r-49,0xm6,0r0,-38r95,-109v-26,2,-60,1,-88,1r0,-41r154,0r0,35r-96,110r102,-1r0,43r-167,0","w":180},"\u2032":{"d":"25,-166v-1,-35,3,-65,10,-92r54,0v-6,34,-16,64,-28,92r-36,0","w":86},"\u2033":{"d":"25,-166v-1,-35,3,-65,10,-92r54,0v-6,34,-16,64,-28,92r-36,0xm104,-166v-1,-35,3,-65,10,-92r54,0v-6,34,-16,64,-28,92r-36,0","w":172}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2008 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":400,"font-style":"italic","font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 4 2 2 2 9 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-44 -311 382 77.1171","underline-thickness":"26.3672","underline-position":"-24.9609","slope":"-12","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"A":13}},"\u00a0":{"w":100},"!":{"d":"40,-65r20,-140r11,-53r38,0v-13,68,-32,129,-49,193r-20,0xm20,0r8,-36r36,0r-8,36r-36,0","w":100},"\"":{"d":"49,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0xm107,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":127},"#":{"d":"31,4r15,-74r-29,0r0,-27r35,0r13,-63r-48,0r0,-27r53,0r15,-75r27,0r-16,75r56,0r15,-75r27,0r-16,75r31,0r0,27r-36,0r-13,63r49,0r0,27r-54,0r-16,74r-26,0r15,-74r-55,0r-16,74r-26,0xm78,-97r55,0r13,-63r-55,0"},"$":{"d":"190,-74v0,48,-40,83,-93,78r-6,30r-18,0r7,-32v-34,-7,-60,-38,-62,-77r32,-1v2,26,14,45,35,52r21,-97v-33,-15,-57,-30,-57,-70v0,-41,39,-74,86,-70r3,-14r17,0r-3,16v32,9,49,29,54,64r-30,1v-4,-20,-12,-33,-30,-39r-18,89v38,17,62,29,62,70xm130,-236v-38,-4,-63,35,-43,66v4,6,13,13,25,19xm102,-21v38,4,71,-39,49,-74v-5,-7,-14,-13,-29,-19"},"%":{"d":"50,9r213,-271r29,0r-212,271r-30,0xm82,-124v-32,0,-49,-19,-47,-54v2,-42,20,-82,64,-82v34,0,51,17,51,50v0,42,-21,87,-68,86xm100,-239v-26,0,-37,39,-38,66v-1,17,6,26,20,27v31,1,38,-40,40,-68v1,-15,-9,-25,-22,-25xm307,-77v0,42,-20,88,-68,86v-32,-1,-49,-19,-47,-54v3,-41,19,-81,65,-81v33,1,50,17,50,49xm258,-105v-28,0,-37,39,-39,66v0,17,7,26,21,27v29,1,38,-40,39,-68v0,-15,-8,-25,-21,-25","w":320},"&":{"d":"202,-213v0,40,-27,50,-64,71v15,28,30,51,44,69v9,-10,17,-23,25,-37r27,14v-8,16,-18,32,-32,48v8,10,18,21,30,35r-24,19v-12,-10,-21,-20,-29,-31v-26,20,-37,29,-73,31v-44,2,-78,-31,-78,-73v0,-50,29,-66,68,-85v-31,-47,-5,-109,51,-110v31,-1,55,21,55,49xm147,-237v-33,0,-41,43,-21,71v24,-14,42,-21,45,-46v2,-13,-12,-25,-24,-25xm61,-71v0,53,69,64,99,21v-22,-29,-39,-54,-51,-77v-28,14,-48,25,-48,56","w":240},"'":{"d":"46,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":68},"(":{"d":"149,-262v-67,69,-116,211,-67,338r-24,0v-18,-40,-28,-82,-28,-125v0,-102,40,-150,94,-213r25,0","w":119},")":{"d":"-19,76v66,-70,117,-211,67,-338r23,0v19,40,28,82,28,124v0,103,-39,151,-93,214r-25,0","w":119},"*":{"d":"41,-210r9,-25v19,7,32,12,40,17v-2,-21,-3,-36,-3,-44r25,0v0,12,-2,27,-4,44v12,-6,26,-12,42,-17r8,25v-15,5,-30,7,-44,9v7,6,17,18,30,34r-21,15v-7,-9,-15,-22,-24,-38v-9,17,-16,29,-23,38r-21,-15v14,-17,24,-29,30,-34v-15,-3,-30,-5,-44,-9","w":140},"+":{"d":"102,-42r0,-70r-70,0r0,-30r70,0r0,-70r30,0r0,70r70,0r0,30r-70,0r0,70r-30,0","w":210},",":{"d":"20,0r7,-36r36,0v-7,40,-15,84,-54,88r3,-14v14,-4,23,-16,27,-38r-19,0","w":100},"-":{"d":"17,-77r6,-32r97,0r-6,32r-97,0","w":119},"\u00ad":{"d":"17,-77r6,-32r97,0r-6,32r-97,0","w":119},".":{"d":"21,0r7,-36r36,0r-7,36r-36,0","w":100},"\/":{"d":"-18,4r138,-266r28,0r-139,266r-27,0","w":100},"0":{"d":"94,4v-44,0,-72,-38,-69,-89v5,-84,29,-174,109,-174v45,0,72,36,70,86v-4,82,-29,177,-110,177xm135,-233v-63,0,-73,96,-79,157v-3,32,12,55,40,55v60,0,73,-102,77,-160v2,-33,-10,-52,-38,-52"},"1":{"d":"87,0r40,-195v-18,14,-42,26,-74,34r6,-29v36,-16,76,-38,95,-69r19,0r-54,259r-32,0","k":{"1":27}},"2":{"d":"202,-190v1,75,-103,101,-136,161r115,0r-6,29r-154,0v13,-85,110,-104,146,-171v16,-30,-9,-63,-40,-62v-31,2,-44,22,-51,53r-31,-5v5,-43,36,-74,82,-74v44,0,73,27,75,69"},"3":{"d":"158,-132v65,36,13,136,-58,136v-47,0,-77,-29,-80,-72r31,-3v3,32,17,49,47,50v30,0,57,-26,58,-55v0,-30,-24,-47,-58,-44r6,-26v35,5,65,-15,65,-45v1,-23,-19,-43,-42,-42v-26,1,-44,21,-48,47r-31,-6v8,-38,39,-66,82,-67v40,-1,71,29,71,67v-1,32,-19,48,-43,60"},"4":{"d":"108,0r13,-66r-105,0r7,-31r144,-161r26,0r-34,164r36,0r-6,28r-36,0r-14,66r-31,0xm127,-94r23,-107r-96,107r73,0"},"5":{"d":"98,4v-46,0,-74,-31,-73,-78r32,-3v-1,31,14,56,43,56v39,0,63,-39,65,-78v3,-55,-75,-60,-96,-21r-28,-2r39,-132r126,0r-6,29r-98,0r-19,66v43,-36,118,-7,113,57v-4,60,-38,106,-98,106"},"6":{"d":"175,-192v-1,-38,-36,-51,-64,-29v-18,13,-32,49,-39,72v40,-43,121,-20,121,51v0,51,-36,102,-88,102v-47,0,-78,-38,-75,-90v5,-80,30,-173,112,-173v38,0,59,27,62,64xm119,-146v-60,-3,-84,119,-14,125v60,1,84,-122,14,-125"},"7":{"d":"52,0v18,-86,66,-172,120,-225r-128,0r6,-29r164,0r-6,29v-56,46,-105,146,-123,225r-33,0"},"8":{"d":"27,-66v0,-39,23,-67,54,-76v-58,-30,-16,-117,49,-117v42,0,73,24,73,63v-1,31,-17,48,-43,58v64,37,16,143,-59,143v-42,0,-74,-29,-74,-71xm133,-233v-28,1,-49,18,-49,46v-1,23,17,37,40,37v54,0,69,-85,9,-83xm116,-127v-33,0,-59,28,-57,64v0,26,19,40,45,42v54,4,81,-107,12,-106"},"9":{"d":"198,-168v-4,83,-31,169,-111,172v-38,1,-61,-25,-63,-63r30,-3v1,41,44,52,69,24v14,-16,26,-38,33,-67v-42,44,-120,17,-120,-52v0,-51,36,-103,88,-102v46,1,76,39,74,91xm124,-233v-63,-2,-80,121,-14,125v61,2,84,-120,14,-125"},":":{"d":"52,-151r8,-36r35,0r-7,36r-36,0xm21,0r7,-36r36,0r-8,36r-35,0","w":100},";":{"d":"51,-151r8,-36r35,0r-7,36r-36,0xm20,0r7,-36r36,0v-7,40,-15,84,-54,88r3,-14v14,-4,23,-16,27,-38r-19,0","w":100},"\u037e":{"d":"51,-151r8,-36r35,0r-7,36r-36,0xm20,0r7,-36r36,0v-7,40,-15,84,-54,88r3,-14v14,-4,23,-16,27,-38r-19,0","w":100},"<":{"d":"32,-113r0,-29r171,-72r0,31r-135,56r135,56r0,31","w":210},"=":{"d":"202,-152r-170,0r0,-29r170,0r0,29xm202,-73r-170,0r0,-30r170,0r0,30","w":210},">":{"d":"203,-113r-171,73r0,-31r136,-56r-136,-56r0,-31r171,72r0,29","w":210},"?":{"d":"202,-199v1,62,-89,74,-97,134r-30,0v1,-66,88,-76,95,-136v3,-20,-20,-37,-42,-36v-31,2,-46,20,-50,55r-32,-5v9,-45,34,-75,82,-75v40,0,73,24,74,63xm60,0r7,-36r36,0r-7,36r-36,0"},"@":{"d":"238,1v-22,0,-33,-7,-34,-30v-13,16,-30,30,-54,30v-108,0,-62,-192,28,-192v25,0,42,14,53,33r6,-27r31,0r-30,145v0,7,5,11,12,11v38,-8,68,-51,68,-97v0,-70,-56,-111,-126,-111v-89,0,-145,64,-146,152v-1,91,61,134,151,135v57,0,101,-22,124,-53r31,0v-26,46,-78,80,-155,79v-107,-1,-177,-53,-177,-158v0,-107,64,-180,174,-180v88,0,146,52,150,137v3,58,-51,127,-106,126xm180,-164v-61,-1,-88,129,-23,139v41,-6,61,-45,64,-89v1,-28,-16,-50,-41,-50","w":365},"A":{"d":"-7,0r146,-258r40,0r43,258r-33,0r-13,-74r-104,0r-41,74r-38,0xm87,-101r85,0r-17,-129v-17,41,-47,89,-68,129","w":240,"k":{"\u2019":13,"y":3,"w":7,"v":7,"Y":27,"W":7,"V":20,"T":27," ":13}},"B":{"d":"230,-82v0,49,-39,82,-90,82r-124,0r54,-258v76,1,166,-13,166,61v-1,33,-20,53,-48,63v25,8,42,23,42,52xm204,-194v0,-46,-60,-32,-106,-34r-17,80v56,0,123,7,123,-46xm195,-81v1,-51,-71,-34,-120,-37r-19,89v0,0,137,9,139,-52","w":240},"C":{"d":"137,-24v43,0,69,-31,80,-67r34,5v-18,52,-55,89,-116,90v-65,1,-102,-41,-102,-110v0,-108,111,-201,201,-134v18,14,26,34,29,59r-32,3v-5,-35,-25,-55,-62,-56v-62,-2,-102,62,-102,128v0,49,25,82,70,82","w":259},"D":{"d":"147,-258v121,-16,131,138,75,207v-27,33,-55,51,-113,51r-93,0r54,-258r77,0xm221,-154v2,-73,-49,-78,-123,-74r-41,199v106,9,161,-30,164,-125","w":259},"E":{"d":"16,0r54,-258r186,0r-6,30r-152,0r-16,80r147,0r-6,29r-148,0r-18,90r162,0r-6,29r-197,0","w":240},"F":{"d":"16,0r54,-258r168,0r-6,30r-134,0r-17,82r136,0r-6,29r-136,0r-24,117r-35,0","w":219,"k":{"A":27,".":46,",":46," ":7}},"G":{"d":"70,-103v-3,84,84,97,144,57r12,-56r-79,0r7,-29r112,0r-21,105v-25,16,-63,30,-103,30v-67,0,-107,-41,-107,-107v0,-107,85,-189,191,-149v31,12,43,34,50,70r-34,3v-8,-34,-28,-54,-67,-54v-69,0,-103,57,-105,130","w":280},"H":{"d":"15,0r54,-258r34,0r-22,107r134,0r22,-107r34,0r-53,258r-35,0r25,-121r-133,0r-25,121r-35,0","w":259},"I":{"d":"21,0r54,-258r34,0r-54,258r-34,0","w":100},"J":{"d":"126,-13v-43,38,-139,12,-111,-62r32,-2v-21,49,44,72,65,32v18,-66,31,-144,47,-213r34,0r-39,189v-6,26,-15,45,-28,56","w":180},"K":{"d":"16,0r54,-258r34,0r-26,124r140,-124r49,0r-120,105r88,153r-39,0r-74,-131r-54,47r-18,84r-34,0","w":240},"L":{"d":"14,0r54,-258r35,0r-48,229r134,0r-6,29r-169,0","k":{"\u2019":20,"y":7,"Y":33,"W":13,"V":20,"T":27," ":7}},"M":{"d":"16,0r54,-258r42,0r26,167v3,22,6,43,7,63v33,-70,88,-159,126,-230r43,0r-54,258r-34,0r27,-125v6,-29,15,-62,27,-98v-36,76,-84,150,-124,223r-33,0r-26,-165v-2,-15,-4,-33,-5,-53v-10,83,-28,142,-43,218r-33,0","w":299},"N":{"d":"18,0r54,-258r33,0v30,75,66,137,90,219r44,-219r33,0r-53,258r-34,0r-91,-218v-10,72,-29,148,-43,218r-33,0","w":259},"O":{"d":"141,4v-67,2,-107,-47,-108,-112v-3,-85,58,-153,136,-154v65,-1,111,48,109,115v-3,86,-51,149,-137,151xm169,-233v-59,1,-104,59,-102,127v1,48,30,82,76,82v66,0,98,-58,101,-125v2,-48,-30,-84,-75,-84","w":280},"P":{"d":"251,-194v-3,87,-85,94,-179,89r-22,105r-35,0r54,-258v80,3,185,-20,182,64xm217,-194v1,-52,-70,-32,-119,-36r-20,96v70,2,138,4,139,-60","w":240,"k":{"A":27,".":46,",":46," ":13}},"Q":{"d":"278,-147v-1,56,-26,101,-60,126v9,10,20,20,35,30r-16,21v-16,-10,-30,-23,-42,-38v-80,38,-166,-14,-162,-104v4,-85,50,-148,137,-150v65,-1,109,48,108,115xm153,-75v20,8,27,17,44,32v26,-20,47,-62,47,-106v0,-48,-30,-84,-74,-84v-64,0,-101,57,-103,123v-2,58,49,102,107,80v-11,-10,-22,-17,-33,-23","w":280},"R":{"d":"263,-195v-2,50,-35,73,-87,79v36,28,48,72,67,116r-39,0v-23,-45,-21,-115,-89,-114r-40,0r-24,114r-34,0r54,-258v81,4,195,-23,192,63xm230,-195v2,-54,-81,-28,-131,-34r-18,87v71,0,147,10,149,-53","w":259,"k":{"Y":13,"W":7,"V":7,"T":7}},"S":{"d":"195,-124v63,46,9,135,-70,128v-60,-5,-101,-23,-100,-87r34,-3v-3,44,25,62,67,62v43,0,82,-34,55,-67v-26,-32,-128,-39,-124,-102v2,-47,39,-69,90,-69v56,0,94,26,95,77r-34,3v0,-38,-25,-47,-62,-51v-49,-5,-77,49,-33,70v8,5,71,31,82,39","w":240},"T":{"d":"82,0r47,-228r-84,0r6,-30r203,0r-6,30r-84,0r-48,228r-34,0","w":219,"k":{"y":27,"w":27,"u":27,"s":33,"r":27,"o":33,"i":3,"e":33,"c":33,"a":33,"O":7,"A":27,";":27,":":27,".":33,"-":33,",":33}},"U":{"d":"219,-45v-31,68,-189,70,-184,-25v3,-58,26,-130,36,-188r35,0r-37,188v0,60,103,56,121,10v21,-52,31,-137,47,-198r35,0v-17,69,-27,155,-53,213","w":259},"V":{"d":"94,0r-49,-258r33,0r30,154v6,28,8,50,10,67r119,-221r35,0r-141,258r-37,0","w":240,"k":{"y":7,"u":7,"r":7,"o":13,"i":7,"e":13,"a":13,"A":20,";":7,":":7,".":27,"-":13,",":27}},"W":{"d":"61,0r-16,-258r35,0r8,211r109,-211r36,0r10,213r104,-213r35,0r-131,258r-37,0r-10,-205v-34,75,-72,134,-108,205r-35,0","w":339,"k":{"i":3,"e":7,"a":7,"A":7,".":13,"-":7,",":13}},"X":{"d":"-11,0r123,-130r-73,-128r38,0r58,106v24,-31,68,-74,97,-106r45,0r-125,133r71,125r-38,0r-56,-104v-28,36,-64,70,-95,104r-45,0","w":240},"Y":{"d":"101,0r20,-100r-79,-158r37,0r62,128v25,-43,65,-88,96,-128r41,0r-123,161r-20,97r-34,0","w":240,"k":{"v":13,"u":13,"q":20,"p":20,"o":20,"i":7,"e":20,"a":27,"A":20,";":13,":":13,".":33,"-":27,",":33," ":7}},"Z":{"d":"9,0r3,-26r172,-204r-139,2r7,-30r177,0r-3,27r-170,203v48,-3,100,0,150,-1r-6,29r-191,0","w":219},"[":{"d":"2,70r68,-328r71,0r-5,25r-39,0r-58,279r39,0r-5,24r-71,0","w":100},"\\":{"d":"74,4r-43,-266r24,0r43,266r-24,0","w":100},"]":{"d":"49,70r-70,0r5,-24r39,0r58,-279r-38,0r5,-25r70,0","w":100},"^":{"d":"58,-121r-33,0r62,-141r26,0r62,141r-32,0r-43,-105","w":168},"_":{"d":"-23,72r0,-23r210,0r0,23r-210,0"},"`":{"d":"87,-209r-35,-49r39,0r20,49r-24,0","w":119},"a":{"d":"119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"b":{"d":"168,-35v-20,43,-106,56,-121,0r-7,35r-28,0r54,-258r32,0r-20,92v39,-46,115,-22,115,51v0,33,-11,62,-25,80xm122,-165v-42,0,-62,50,-63,94v-2,29,15,49,40,49v43,0,59,-53,62,-94v2,-28,-15,-49,-39,-49"},"c":{"d":"52,-68v0,75,80,49,89,0r32,3v-13,40,-39,68,-85,69v-42,1,-68,-29,-68,-74v0,-83,76,-156,146,-104v13,10,18,26,18,45r-31,2v0,-22,-15,-38,-37,-38v-48,0,-64,51,-64,97","w":180},"d":{"d":"19,-72v0,-86,94,-165,144,-85r21,-101r31,0r-53,258r-30,0r6,-27v-41,57,-119,31,-119,-45xm112,-165v-42,0,-57,47,-61,87v-3,35,10,56,39,57v57,2,98,-144,22,-144"},"e":{"d":"92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0"},"f":{"d":"16,0r34,-162r-28,0r5,-25r28,0v9,-37,9,-77,57,-75v8,0,20,2,35,5r-6,28v-28,-7,-47,-8,-50,22r-4,20r36,0r-5,25r-36,0r-34,162r-32,0","w":100,"k":{"\u2019":-13}},"g":{"d":"149,40v-22,50,-152,50,-139,-23r32,3v-5,41,61,32,76,14v6,-8,15,-38,19,-59v-45,52,-119,17,-119,-55v0,-84,101,-155,150,-76r6,-31r29,0v-19,74,-27,164,-54,227xm112,-165v-63,0,-91,139,-22,139v41,0,65,-45,66,-89v0,-28,-16,-50,-44,-50"},"h":{"d":"154,-113v21,-49,-20,-62,-53,-43v-43,24,-43,100,-57,156r-32,0r54,-258r32,0r-21,99v20,-18,35,-32,65,-32v90,0,25,129,20,191r-32,0"},"i":{"d":"57,-222r8,-36r31,0r-7,36r-32,0xm11,0r39,-187r32,0r-39,187r-32,0","w":79},"j":{"d":"57,-222r8,-36r31,0r-7,36r-32,0xm-44,70r6,-27v34,8,40,-4,48,-41r39,-189r32,0r-40,195v-8,52,-31,78,-85,62","w":79},"k":{"d":"12,0r54,-258r32,0r-33,160r92,-89r42,0r-79,70r48,117r-35,0r-37,-96r-39,34r-13,62r-32,0","w":180},"l":{"d":"9,0r54,-258r32,0r-54,258r-32,0","w":79},"m":{"d":"148,-126v13,-37,-19,-46,-46,-30v-44,26,-43,100,-58,156r-32,0r39,-187r32,0r-7,31v21,-21,31,-34,62,-35v25,-1,41,14,45,35v19,-37,109,-56,109,7v0,49,-20,101,-29,149r-31,0r29,-145v-7,-40,-67,-9,-75,11v-14,34,-23,92,-33,134r-32,0","w":299},"n":{"d":"155,-118v6,-26,5,-47,-22,-47v-74,0,-72,100,-89,165r-32,0r39,-187r29,0r-7,33v21,-21,37,-37,69,-37v90,0,24,129,20,191r-32,0"},"o":{"d":"94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"p":{"d":"193,-116v-5,64,-32,120,-92,120v-22,0,-40,-11,-52,-34r-21,102r-32,0r54,-259r30,0r-6,26v36,-52,125,-30,119,45xm121,-165v-43,0,-59,48,-62,89v-3,37,12,52,41,54v56,4,94,-143,21,-143"},"q":{"d":"111,-191v27,0,43,16,53,39r7,-35r28,0r-54,259r-32,0r20,-93v-45,50,-118,19,-115,-51v3,-63,34,-119,93,-119xm112,-165v-42,2,-59,48,-62,89v-2,32,14,54,40,54v41,0,61,-51,62,-94v2,-27,-16,-49,-40,-49"},"r":{"d":"71,-149v19,-27,42,-55,80,-35r-13,29v-74,-24,-80,89,-96,155r-30,0r39,-187r28,0","w":119,"k":{"\u2019":-13,".":13,"-":7,",":20}},"s":{"d":"152,-88v38,40,-4,96,-61,92v-44,-3,-79,-21,-76,-68r32,-2v-2,31,19,45,46,46v23,1,41,-10,42,-29v-8,-45,-94,-32,-94,-88v0,-53,84,-70,120,-38v12,11,20,25,20,43r-32,2v5,-40,-78,-50,-78,-12v0,28,74,39,81,54","w":180},"t":{"d":"58,-59v-11,31,0,39,28,33r-5,26v-40,11,-76,-8,-56,-54r22,-108r-25,0r5,-25r26,0r9,-46r37,-22r-15,68r32,0r-6,25r-31,0","w":100},"u":{"d":"58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"v":{"d":"59,0r-31,-187r31,0r23,158r86,-158r33,0r-107,187r-35,0","w":180,"k":{".":27,",":27}},"w":{"d":"47,0r-19,-187r31,0r12,153v16,-54,45,-103,66,-153r34,0r8,150v16,-41,49,-106,69,-150r32,0r-92,187r-33,0r-8,-149r-66,149r-34,0","w":259,"k":{".":20,",":20}},"x":{"d":"-1,0r82,-95r-47,-92r35,0r32,69r54,-69r39,0r-79,95r47,92r-35,0r-32,-68r-56,68r-40,0","w":180},"y":{"d":"0,72r2,-30v38,13,49,-17,62,-41r-31,-188r31,0r21,151r84,-151r33,0r-119,212v-20,37,-37,59,-83,47","w":180,"k":{".":27,",":27}},"z":{"d":"7,0r5,-25r100,-113v7,-8,15,-15,24,-24v-38,4,-64,1,-102,2r6,-27r144,0r-4,20r-127,141v43,-3,68,-2,110,-2r-6,28r-150,0","w":180},"{":{"d":"87,76v-85,12,-44,-77,-40,-126v2,-18,-10,-29,-28,-29r6,-29v86,-5,12,-165,135,-154r-6,28v-68,-7,-35,93,-76,124v-7,5,-15,12,-27,17v44,14,16,85,11,124v1,16,10,17,31,17","w":120},"|":{"d":"33,76r0,-338r28,0r0,338r-28,0","w":93},"}":{"d":"79,-93v-44,-16,-14,-84,-11,-125v1,-16,-12,-17,-31,-16r6,-28v36,-3,54,6,55,36v2,38,-43,116,13,118r-6,29v-86,10,-20,171,-135,155r6,-28v55,12,44,-67,58,-95v11,-23,22,-37,45,-46","w":120},"~":{"d":"75,-122v-23,0,-30,10,-46,24r0,-36v34,-41,91,-8,134,3v19,0,36,-14,46,-25r0,38v-14,12,-26,19,-49,20v-28,1,-59,-24,-85,-24","w":210},"\u00c4":{"d":"108,-274r8,-36r33,0r-7,36r-34,0xm173,-274r8,-36r33,0r-7,36r-34,0xm-7,0r146,-258r40,0r43,258r-33,0r-13,-74r-104,0r-41,74r-38,0xm87,-101r85,0r-17,-129v-17,41,-47,89,-68,129","w":240},"\u00c5":{"d":"164,-247v-18,0,-33,-14,-32,-32v0,-18,15,-32,32,-32v17,0,32,14,32,32v1,18,-14,32,-32,32xm164,-298v-9,0,-19,10,-19,19v0,9,9,20,19,19v10,1,19,-10,19,-19v0,-9,-10,-19,-19,-19xm-7,0r146,-258r40,0r43,258r-33,0r-13,-74r-104,0r-41,74r-38,0xm87,-101r85,0r-17,-129v-17,41,-47,89,-68,129","w":240},"\u00d6":{"d":"120,-274r8,-36r33,0r-8,36r-33,0xm185,-274r8,-36r33,0r-8,36r-33,0xm141,4v-67,2,-107,-47,-108,-112v-3,-85,58,-153,136,-154v65,-1,111,48,109,115v-3,86,-51,149,-137,151xm169,-233v-59,1,-104,59,-102,127v1,48,30,82,76,82v66,0,98,-58,101,-125v2,-48,-30,-84,-75,-84","w":280},"\u00dc":{"d":"124,-274r7,-36r33,0r-7,36r-33,0xm188,-274r8,-36r33,0r-7,36r-34,0xm219,-45v-31,68,-189,70,-184,-25v3,-58,26,-130,36,-188r35,0r-37,188v0,60,103,56,121,10v21,-52,31,-137,47,-198r35,0v-17,69,-27,155,-53,213","w":259},"\u00e1":{"d":"98,-209r33,-49r40,0r-47,49r-26,0xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e0":{"d":"119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44xm135,-209r-35,-49r39,0r20,49r-24,0"},"\u00e4":{"d":"78,-216r8,-36r33,0r-7,36r-34,0xm143,-216r8,-36r33,0r-8,36r-33,0xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e5":{"d":"128,-200v-18,1,-32,-14,-32,-32v0,-18,14,-33,32,-32v18,0,32,15,32,32v0,17,-14,32,-32,32xm128,-251v-9,0,-19,10,-19,19v0,9,10,19,19,19v9,0,19,-10,19,-19v0,-9,-10,-19,-19,-19xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e7":{"d":"91,38v-1,-13,-13,-15,-29,-15r7,-28r25,0r-4,16v18,1,30,13,31,29v0,36,-55,34,-90,29r4,-19v21,-1,53,4,56,-12xm52,-68v0,75,80,49,89,0r32,3v-13,40,-39,68,-85,69v-42,1,-68,-29,-68,-74v0,-83,76,-156,146,-104v13,10,18,26,18,45r-31,2v0,-22,-15,-38,-37,-38v-48,0,-64,51,-64,97","w":180},"\u00e9":{"d":"101,-209r33,-49r40,0r-47,49r-26,0xm92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0"},"\u00e8":{"d":"92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0xm135,-209r-35,-49r39,0r20,49r-24,0"},"\u00ed":{"d":"22,0r39,-187r32,0r-39,187r-32,0xm53,-209r33,-49r40,0r-47,49r-26,0","w":100},"\u00ee":{"d":"27,-209r46,-49r35,0r22,49r-28,0r-14,-32r-29,32r-32,0xm22,0r39,-187r32,0r-39,187r-32,0","w":100},"\u00ef":{"d":"22,0r39,-187r32,0r-39,187r-32,0xm31,-216r7,-36r33,0r-7,36r-33,0xm95,-216r8,-36r33,0r-7,36r-34,0","w":100},"\u00f1":{"d":"157,-215v-25,0,-56,-33,-62,0r-22,0v7,-26,12,-36,35,-39v22,-3,55,34,62,1r22,0v-1,21,-15,38,-35,38xm155,-118v6,-26,5,-47,-22,-47v-74,0,-72,100,-89,165r-32,0r39,-187r29,0r-7,33v21,-21,37,-37,69,-37v90,0,24,129,20,191r-32,0"},"\u00f3":{"d":"94,-209r33,-49r40,0r-46,49r-27,0xm94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"\u00f6":{"d":"75,-216r8,-36r33,0r-8,36r-33,0xm140,-216r7,-36r34,0r-8,36r-33,0xm94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"\u00f9":{"d":"58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0xm136,-209r-35,-49r39,0r20,49r-24,0"},"\u00fb":{"d":"75,-209r46,-49r36,0r21,49r-27,0r-14,-32r-29,32r-33,0xm58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"\u00fc":{"d":"79,-216r8,-36r33,0r-7,36r-34,0xm144,-216r8,-36r33,0r-7,36r-34,0xm58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"\u00a3":{"d":"15,4r-4,-31v27,-18,58,-44,54,-87r-39,0r6,-27r30,0v-27,-91,63,-153,132,-104v15,10,22,28,25,51r-29,3v-3,-27,-19,-46,-46,-46v-44,0,-62,47,-49,96r51,0r-6,27r-44,0v1,37,-13,59,-37,77v49,-8,81,27,122,0r9,28v-60,39,-120,-33,-175,13"},"\u00df":{"d":"166,-218v-11,-40,-73,-11,-79,18r-42,200r-32,0v19,-74,26,-164,55,-227v20,-41,130,-52,130,6v0,33,-39,56,-44,84v5,30,53,45,50,80v-3,35,-31,61,-69,61v-25,0,-46,-13,-63,-41r27,-14v11,41,72,33,73,-7v1,-26,-51,-44,-51,-75v0,-28,42,-59,45,-85","w":219},"\u2122":{"d":"96,-114r0,-122r-47,0r0,-22r117,0r0,22r-46,0r0,122r-24,0xm182,-114r0,-144r35,0r37,115r35,-115r34,0r0,144r-22,0r0,-121r-37,121r-21,0r-39,-122r0,122r-22,0","w":360},"\u00ab":{"d":"62,-93r27,80r-23,0r-38,-84r71,-75r25,0xm131,-93r27,80r-25,0r-35,-84r68,-75r27,0"},"\u00bb":{"d":"79,-92r-26,-80r25,0r34,85r-69,74r-28,0xm148,-90r-26,-82r24,0r36,85r-72,74r-25,0"},"\u2026":{"d":"52,0r7,-36r36,0r-7,36r-36,0xm172,0r7,-36r37,0r-8,36r-36,0xm292,0r8,-36r36,0r-8,36r-36,0","w":360},"\u2013":{"d":"-1,-81r0,-25r201,0r0,25r-201,0"},"\u2014":{"d":"0,-81r0,-25r360,0r0,25r-360,0","w":360},"\u201c":{"d":"138,-210r-8,36r-36,0v9,-39,15,-85,55,-88r-3,14v-14,4,-23,16,-28,38r20,0xm82,-210r-8,36r-36,0v9,-39,15,-85,55,-88r-3,14v-14,4,-23,16,-28,38r20,0","w":119},"\u201d":{"d":"49,-221r7,-36r36,0v-6,41,-16,84,-54,89r3,-14v14,-4,22,-17,27,-39r-19,0xm107,-221r7,-36r36,0v-6,41,-16,84,-54,89r2,-14v14,-4,23,-17,28,-39r-19,0","w":119},"\u2018":{"d":"90,-210r-7,36r-37,0v9,-39,15,-85,55,-88r-3,14v-14,4,-23,16,-28,38r20,0","w":79,"k":{"\u2018":13}},"\u2019":{"d":"56,-221r7,-36r37,0v-8,40,-15,85,-55,89r3,-14v14,-4,23,-17,28,-39r-20,0","w":79,"k":{"\u2019":13,"s":7," ":20}},"\u00ff":{"d":"72,-216r7,-36r33,0r-7,36r-33,0xm137,-216r7,-36r33,0r-7,36r-33,0xm0,72r2,-30v38,13,49,-17,62,-41r-31,-188r31,0r21,151r84,-151r33,0r-119,212v-20,37,-37,59,-83,47","w":180},"\u20ac":{"d":"68,-94v-1,61,72,91,118,53r-8,37v-73,27,-146,-14,-145,-90r-19,0r5,-24r14,0v0,-8,2,-15,3,-23r-22,0r5,-23r22,0v17,-71,119,-132,191,-77r-14,30v-42,-52,-129,-8,-140,47r110,0r-5,23r-113,0v-2,8,-2,15,-3,23r111,0r-5,24r-105,0"},"\u0142":{"d":"33,-110r-26,15r5,-28r27,-14r25,-121r32,0r-21,102r28,-15r-6,28r-28,15r-27,128r-31,0","w":79},"\u00d7":{"d":"46,-72r55,-55r-55,-55r22,-22r55,55r55,-55r21,22r-55,55r55,55r-21,21r-55,-55r-56,55","w":210},"\u0107":{"d":"103,-209r33,-49r40,0r-47,49r-26,0xm52,-68v0,75,80,49,89,0r32,3v-13,40,-39,68,-85,69v-42,1,-68,-29,-68,-74v0,-83,76,-156,146,-104v13,10,18,26,18,45r-31,2v0,-22,-15,-38,-37,-38v-48,0,-64,51,-64,97","w":180},"\u0105":{"d":"141,76v-54,-5,-22,-63,5,-76r23,0v-18,10,-27,21,-29,38v-2,15,20,16,31,9r-5,22v-9,4,-17,7,-25,7xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u0119":{"d":"91,76v-53,-5,-22,-62,4,-76r23,0v-17,11,-27,19,-28,38v-1,15,20,16,31,9r-5,22v-9,4,-17,7,-25,7xm92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0"},"\u015b":{"d":"88,-209r33,-49r40,0r-47,49r-26,0xm152,-88v38,40,-4,96,-61,92v-44,-3,-79,-21,-76,-68r32,-2v-2,31,19,45,46,46v23,1,41,-10,42,-29v-8,-45,-94,-32,-94,-88v0,-53,84,-70,120,-38v12,11,20,25,20,43r-32,2v5,-40,-78,-50,-78,-12v0,28,74,39,81,54","w":180},"\u017a":{"d":"86,-209r33,-49r40,0r-47,49r-26,0xm7,0r5,-25r100,-113v7,-8,15,-15,24,-24v-38,4,-64,1,-102,2r6,-27r144,0r-4,20r-127,141v43,-3,68,-2,110,-2r-6,28r-150,0","w":180},"\u017c":{"d":"91,-213r8,-39r39,0r-8,39r-39,0xm7,0r5,-25r100,-113v7,-8,15,-15,24,-24v-38,4,-64,1,-102,2r6,-27r144,0r-4,20r-127,141v43,-3,68,-2,110,-2r-6,28r-150,0","w":180},"\u2032":{"d":"46,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":67},"\u2033":{"d":"49,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0xm107,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":127}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2008 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":700,"font-style":"italic","font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 4 2 2 2 9 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-39 -315 384 77.5779","underline-thickness":"37.793","underline-position":"-19.3359","slope":"-12","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"A":13}},"\u00a0":{"w":100},"!":{"d":"73,-66r-27,0r16,-131r12,-61r53,0v-11,71,-34,130,-54,192xm32,-49r50,0r-10,49r-50,0","w":119},"\"":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0xm118,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":170},"#":{"d":"41,-64r-24,0r0,-39r32,0r10,-52r-42,0r0,-39r50,0r14,-68r40,0r-14,68r39,0r13,-68r41,0r-14,68r24,0r0,39r-32,0r-11,52r43,0r0,39r-51,0r-13,68r-40,0r14,-68r-39,0r-14,68r-40,0xm99,-155r-10,52r39,0r10,-52r-39,0"},"$":{"d":"191,-76v2,46,-42,83,-91,81r-6,31r-26,0r7,-34v-33,-9,-57,-37,-59,-77r44,-2v2,20,11,33,24,39r16,-77v-31,-13,-54,-37,-54,-73v0,-46,37,-76,85,-74r3,-15r25,0r-4,18v30,8,48,29,52,63r-43,2v-2,-13,-8,-22,-17,-27r-14,70v35,13,57,36,58,75xm123,-225v-38,-1,-48,50,-13,64xm108,-34v29,-1,52,-28,37,-55v-3,-5,-11,-10,-22,-16"},"%":{"d":"81,-127v-30,0,-49,-20,-48,-51v0,-42,24,-86,68,-84v31,0,50,20,49,53v-2,43,-23,82,-69,82xm99,-232v-25,1,-43,69,-15,76v18,-1,30,-38,30,-60v0,-10,-6,-16,-15,-16xm85,11r-40,0r214,-273r41,0xm242,11v-29,0,-49,-20,-48,-51v0,-42,25,-86,68,-85v31,0,50,20,49,53v-2,44,-24,83,-69,83xm260,-95v-22,0,-27,39,-29,59v-1,11,4,17,14,17v18,0,30,-37,30,-59v0,-10,-6,-18,-15,-17","w":320},"&":{"d":"217,-213v0,34,-28,56,-60,72r39,58v6,-6,14,-16,22,-29r36,22v-6,12,-18,31,-28,39v7,7,15,15,25,24r-31,33v-9,-4,-24,-18,-31,-25v-46,41,-165,26,-159,-50v4,-48,28,-67,66,-86v-29,-54,2,-107,61,-107v33,0,60,20,60,49xm156,-229v-26,0,-31,31,-17,53v19,-11,32,-17,35,-37v0,-10,-7,-17,-18,-16xm80,-73v0,41,51,45,81,22v-18,-22,-34,-44,-47,-68v-23,12,-34,27,-34,46","w":259},"'":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":85},"(":{"d":"157,-262v-74,73,-111,210,-71,338r-34,0v-16,-37,-28,-84,-28,-131v0,-97,41,-146,94,-207r39,0","w":119},")":{"d":"-28,76v73,-74,112,-211,70,-338r35,0v16,37,28,84,28,131v0,96,-42,146,-95,207r-38,0","w":119},"*":{"d":"73,-139r-26,-21r33,-34r-45,-11r11,-31v15,6,29,13,41,21v-3,-19,-4,-35,-4,-47r31,0v0,9,-2,24,-5,47r44,-19r10,32v-13,3,-28,5,-45,8r31,36r-27,18r-24,-40v-7,13,-16,27,-25,41","w":140},"+":{"d":"97,-37r0,-67r-68,0r0,-46r68,0r0,-67r45,0r0,67r67,0r0,46r-67,0r0,67r-45,0","w":210},",":{"d":"26,-49r50,0v-9,50,-16,106,-72,105r5,-23v16,-5,25,-14,29,-33r-23,0","w":100},"-":{"d":"24,-117r98,0r-10,48r-98,0","w":119},"\u00ad":{"d":"24,-117r98,0r-10,48r-98,0","w":119},".":{"d":"26,-49r50,0r-10,49r-50,0","w":100},"\/":{"d":"-16,4r128,-266r35,0r-127,266r-36,0","w":100},"0":{"d":"95,4v-46,0,-73,-37,-72,-88v4,-82,34,-175,111,-175v47,0,74,37,72,89v-3,78,-33,174,-111,174xm132,-218v-46,0,-56,95,-59,144v-2,23,5,38,24,38v48,0,53,-98,59,-146v3,-22,-6,-36,-24,-36"},"1":{"d":"43,-148r9,-45v43,-19,77,-41,101,-66r31,0r-54,259r-51,0r37,-179v-18,12,-49,27,-73,31","k":{"1":27}},"2":{"d":"130,-219v-22,0,-30,17,-35,42r-49,-8v6,-43,35,-71,82,-74v75,-4,99,85,50,132v-20,20,-59,54,-79,81r89,0r-10,46r-156,0v13,-82,91,-108,130,-172v12,-21,1,-47,-22,-47"},"3":{"d":"158,-132v67,36,11,142,-60,136v-46,-4,-75,-28,-80,-71r49,-6v3,24,9,34,31,36v22,1,40,-18,40,-41v0,-24,-16,-36,-42,-34r9,-42v26,4,50,-12,47,-37v-4,-43,-57,-29,-60,8r-46,-9v12,-40,39,-64,83,-67v80,-6,97,109,29,127"},"4":{"d":"111,-53r-101,0r9,-42r139,-163r44,0r-34,163r31,0r-9,42r-31,0r-11,53r-48,0xm120,-95r17,-81r-68,81r51,0"},"5":{"d":"198,-102v0,81,-93,140,-154,85v-15,-13,-21,-33,-21,-57r49,-4v-1,24,8,39,29,41v44,3,72,-101,17,-101v-17,0,-27,9,-37,19r-42,-4r39,-131r130,0r-10,46r-85,0r-12,40v48,-22,97,13,97,66"},"6":{"d":"29,-93v-4,-97,69,-207,157,-150v11,11,18,26,21,48r-47,4v1,-29,-30,-34,-46,-17v-9,10,-17,25,-23,47v48,-31,106,8,103,65v-3,56,-35,101,-90,101v-52,0,-72,-40,-75,-98xm118,-139v-42,-1,-60,97,-12,103v42,1,58,-97,12,-103"},"7":{"d":"37,-208r10,-46r170,0r-8,36v-52,47,-99,140,-117,218r-48,0v18,-79,56,-153,103,-208r-110,0"},"8":{"d":"24,-67v0,-37,23,-66,53,-75v-55,-34,-15,-117,54,-117v43,0,74,25,73,64v-1,30,-19,47,-44,57v68,37,14,150,-61,143v-43,-4,-75,-29,-75,-72xm130,-220v-18,0,-33,16,-33,35v0,16,10,27,26,27v17,0,34,-17,34,-34v0,-17,-10,-28,-27,-28xm114,-119v-40,-5,-60,82,-12,84v41,5,61,-83,12,-84"},"9":{"d":"201,-161v0,97,-72,208,-158,149v-13,-9,-19,-27,-20,-47r47,-4v-1,29,30,34,46,17v10,-10,17,-25,23,-47v-48,31,-103,-8,-103,-65v0,-51,38,-102,90,-101v51,1,75,43,75,98xm112,-116v42,3,60,-98,12,-102v-41,-2,-58,97,-12,102"},":":{"d":"64,-187r50,0r-10,49r-50,0xm36,-49r49,0r-10,49r-50,0","w":119},";":{"d":"65,-187r50,0r-10,49r-50,0xm37,-49r50,0v-9,50,-16,106,-72,105r5,-23v16,-5,25,-14,29,-33r-23,0","w":119},"\u037e":{"d":"65,-187r50,0r-10,49r-50,0xm37,-49r50,0v-9,50,-16,106,-72,105r5,-23v16,-5,25,-14,29,-33r-23,0","w":119},"<":{"d":"207,-29r-176,-77r0,-43r176,-76r0,50r-123,47r123,49r0,50","w":210},"=":{"d":"29,-143r0,-46r180,0r0,46r-180,0xm29,-65r0,-46r180,0r0,46r-180,0","w":210},">":{"d":"31,-29r0,-50r123,-48r-123,-48r0,-50r177,77r0,42","w":210},"?":{"d":"223,-197v1,57,-89,77,-100,133r-45,0v-1,-63,84,-85,97,-136v0,-17,-15,-26,-35,-25v-30,1,-42,17,-49,45r-47,-8v11,-43,46,-73,97,-74v47,-1,81,26,82,65xm72,-49r50,0r-10,49r-50,0","w":219},"@":{"d":"204,43v56,1,96,-15,121,-46r37,0v-25,51,-80,79,-155,79v-111,0,-184,-56,-184,-161v0,-106,70,-177,181,-177v88,1,147,50,149,135v1,66,-53,129,-116,127v-19,0,-28,-5,-32,-20v-43,44,-116,10,-116,-54v0,-75,87,-160,142,-93r4,-19r47,0r-29,141v0,6,2,9,7,9v35,-9,62,-50,62,-92v0,-62,-51,-102,-119,-102v-93,0,-148,60,-148,148v0,83,62,125,149,125xm189,-159v-37,0,-52,47,-54,83v0,26,10,44,31,44v39,0,53,-45,55,-86v1,-23,-12,-41,-32,-41","w":351},"A":{"d":"184,-57r-103,0r-31,57r-54,0r146,-258r59,0r41,258r-50,0xm177,-100r-15,-104r-62,104r77,0","w":259,"k":{"\u2019":20,"Y":27,"W":20,"V":27,"T":27," ":13}},"B":{"d":"249,-83v0,58,-44,83,-113,83r-122,0r54,-258v82,3,188,-18,188,63v0,33,-20,52,-49,61v24,6,42,24,42,51xm203,-189v0,-37,-53,-23,-91,-26r-13,61v46,-1,103,8,104,-35xm195,-79v0,-41,-63,-28,-105,-30r-14,68v52,-1,119,10,119,-38","w":259},"C":{"d":"138,-40v34,0,54,-24,63,-53r54,8v-17,52,-57,90,-120,90v-66,0,-101,-43,-101,-112v0,-113,112,-198,204,-133v19,13,27,35,30,61r-50,5v-6,-27,-20,-42,-49,-42v-56,0,-80,57,-83,111v-1,38,19,65,52,65","w":259},"D":{"d":"139,-258v149,-25,144,170,66,232v-38,30,-118,25,-189,26r54,-258r69,0xm208,-152v3,-59,-33,-67,-94,-63r-37,174v93,10,127,-33,131,-111","w":259},"E":{"d":"15,0r54,-258r191,0r-9,43r-138,0r-13,59r134,0r-9,43r-134,0r-16,70r150,0r-9,43r-201,0","w":240},"F":{"d":"14,0r54,-258r180,0r-9,43r-127,0r-13,62r125,0r-9,43r-125,0r-23,110r-53,0","w":219,"k":{"A":20,".":40,",":40}},"G":{"d":"83,-104v-5,73,75,73,124,48r8,-39r-66,0r9,-43r116,0r-24,111v-26,17,-68,31,-110,31v-72,0,-108,-41,-108,-107v0,-90,53,-158,143,-159v61,-1,96,30,108,81r-50,6v-7,-27,-25,-44,-57,-44v-62,0,-89,52,-93,115","w":280},"H":{"d":"192,-115r-99,0r-24,115r-53,0r54,-258r53,0r-21,100r99,0r21,-100r53,0r-54,258r-53,0","w":259},"I":{"d":"12,0r54,-258r53,0r-53,258r-54,0","w":100},"J":{"d":"60,-78v-14,39,39,49,57,26v18,-52,32,-145,47,-206r52,0v-19,75,-27,193,-67,240v-37,43,-158,26,-138,-55"},"K":{"d":"14,0r54,-258r53,0r-23,110r119,-110r71,0r-115,101r85,157r-60,0r-64,-123r-50,44r-16,79r-54,0","w":259},"L":{"d":"16,0r54,-258r53,0r-45,215r131,0r-9,43r-184,0","w":219,"k":{"\u2019":27,"Y":27,"W":20,"V":20,"T":27," ":7}},"M":{"d":"163,0r-50,0r-10,-215r-41,215r-47,0r53,-258r76,0r8,181r88,-181r76,0r-54,258r-48,0r51,-214","w":299},"N":{"d":"221,0r-50,0r-69,-173r-36,173r-50,0r54,-258r50,0r69,173r36,-173r50,0","w":259},"O":{"d":"137,5v-66,0,-106,-44,-106,-106v0,-91,50,-159,145,-161v62,-1,108,44,106,108v-3,88,-55,159,-145,159xm171,-218v-53,-1,-87,63,-87,116v0,35,24,63,59,62v54,-2,83,-59,86,-113v1,-37,-23,-64,-58,-65","w":280},"P":{"d":"253,-193v-3,84,-66,101,-165,95r-20,98r-53,0r54,-258v81,2,187,-19,184,65xm200,-189v2,-37,-50,-23,-87,-26r-16,74v60,2,100,-1,103,-48","w":240,"k":{"A":27,".":46,",":46," ":13}},"Q":{"d":"282,-154v-1,54,-25,103,-58,128v11,11,24,20,36,27r-25,33v-16,-8,-32,-21,-46,-39v-77,32,-162,-15,-158,-97v5,-86,54,-160,145,-160v62,-1,108,44,106,108xm162,-42v-2,-12,-20,-19,-29,-23r20,-30v16,8,29,20,41,33v41,-33,57,-159,-23,-156v-59,2,-84,54,-87,113v-2,43,32,74,78,63","w":280},"R":{"d":"267,-190v-2,48,-30,75,-79,80v27,30,36,59,58,110r-57,0v-15,-23,-23,-113,-76,-107r-22,0r-22,107r-53,0r54,-258v86,4,201,-23,197,68xm214,-189v1,-37,-62,-23,-100,-26r-15,70v59,0,113,5,115,-44","w":259,"k":{"Y":7,"W":7,"T":7}},"S":{"d":"208,-123v48,55,-9,132,-84,127v-60,-4,-103,-25,-101,-87r50,-3v2,36,15,43,51,46v38,3,66,-29,40,-51v-32,-27,-110,-33,-110,-96v0,-76,112,-95,162,-54v17,14,25,33,27,57r-50,2v5,-43,-85,-54,-88,-11v4,26,19,25,47,39v29,14,48,23,56,31","w":240},"T":{"d":"127,0r-53,0r45,-215r-76,0r9,-43r203,0r-9,43r-74,0","w":219,"k":{"y":13,"w":13,"u":7,"s":13,"r":7,"o":13,"i":7,"e":13,"c":13,"a":13,"O":7,"A":27,";":27,":":27,".":27,"-":20,",":27}},"U":{"d":"225,-49v-33,80,-215,69,-191,-41r35,-168r53,0r-37,183v-3,34,49,45,75,28v23,-15,25,-32,33,-70r30,-141r52,0v-16,66,-28,154,-50,209","w":259},"V":{"d":"144,0r-57,0r-46,-258r53,0r32,195r107,-195r53,0","w":240,"k":{"y":7,"u":7,"r":7,"o":13,"i":13,"e":13,"a":13,"A":27,";":13,":":13,".":33,"-":13,",":33}},"W":{"d":"260,0r-54,0r-6,-188r-93,188r-55,0r-10,-258r52,0r2,181r89,-181r57,0r6,179r85,-179r51,0","w":339,"k":{"y":7,"u":7,"r":7,"o":7,"i":3,"e":7,"a":7,"A":20,";":13,":":13,".":27,"-":13,",":27}},"X":{"d":"58,0r-69,0r114,-130r-64,-128r55,0r45,89r77,-89r66,0r-118,136r64,122r-60,0r-40,-83v-10,15,-51,62,-70,83","w":240},"Y":{"d":"144,0r-53,0r21,-100r-71,-158r57,0r47,111v23,-38,52,-73,76,-111r61,0r-118,163","w":240,"k":{"v":13,"u":13,"q":13,"p":13,"o":13,"i":13,"e":13,"a":13,"A":27,";":20,":":20,".":33,"-":27,",":33," ":7}},"Z":{"d":"9,0r8,-41r149,-174r-120,0r9,-43r185,0r-7,41r-150,175r135,-1r-9,43r-200,0","w":219},"[":{"d":"97,33r-8,38r-85,0r68,-329r86,0r-8,40r-39,0r-52,251r38,0","w":119},"\\":{"d":"68,4r-40,-266r35,0r40,266r-35,0","w":100},"]":{"d":"41,-220r8,-38r86,0r-69,329r-86,0r8,-39r39,0r53,-252r-39,0","w":119},"^":{"d":"38,-122r66,-140r39,0r64,140r-49,0r-35,-86r-35,86r-50,0","w":210},"_":{"d":"-3,71r0,-32r205,0r0,32r-205,0"},"`":{"d":"48,-263r49,0r22,52r-34,0","w":119},"a":{"d":"143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"b":{"d":"217,-114v-6,63,-31,118,-93,118v-27,0,-46,-12,-59,-35r-6,31r-46,0r54,-258r50,0r-18,86v44,-40,125,-14,118,58xm133,-155v-52,-1,-78,121,-16,121v35,0,49,-41,51,-78v0,-23,-13,-43,-35,-43","w":219},"c":{"d":"72,-70v0,55,62,35,69,0r49,8v-14,39,-44,65,-91,66v-48,1,-77,-31,-77,-79v0,-88,90,-148,159,-99v14,10,20,27,22,46r-48,5v-1,-19,-12,-31,-30,-31v-37,0,-53,44,-53,84"},"d":{"d":"21,-74v0,-56,37,-119,93,-117v25,0,43,10,56,30r20,-97r51,0r-54,258r-48,0r4,-20v-39,46,-122,23,-122,-54xm121,-154v-49,0,-77,116,-16,121v54,1,75,-114,16,-121","w":219},"e":{"d":"125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0"},"f":{"d":"144,-187r-7,37r-36,0r-31,150r-51,0r32,-150r-29,0r8,-37r28,0v8,-43,15,-75,63,-75v15,0,31,2,48,8r-9,36v-25,-8,-47,-13,-48,18r-3,13r35,0","w":119,"k":{"\u2019":-7,"f":7}},"g":{"d":"166,48v-32,46,-171,42,-154,-38r53,8v0,34,59,24,65,0r9,-39v-46,45,-120,17,-117,-54v3,-63,32,-116,90,-116v28,0,48,17,58,37r7,-33r47,0r-32,156v-9,39,-11,57,-26,79xm120,-155v-47,0,-74,112,-15,118v53,1,74,-112,15,-118","w":219},"h":{"d":"158,-111v16,-38,-16,-54,-42,-35v-36,25,-36,94,-50,146r-51,0r54,-258r51,0r-20,92v30,-32,116,-38,113,22v-3,46,-20,99,-28,144r-51,0","w":219},"i":{"d":"68,-258r51,0r-10,46r-50,0xm53,-187r51,0r-39,187r-51,0","w":100},"j":{"d":"69,-258r50,0r-9,46r-51,0xm54,-187r50,0v-16,69,-33,190,-57,240v-12,26,-56,28,-86,17r8,-42v45,9,41,-8,52,-60","w":100},"k":{"d":"14,0r54,-258r50,0r-28,134r66,-63r65,0r-75,68r40,119r-50,0r-26,-86r-34,30r-12,56r-50,0"},"l":{"d":"14,0r54,-258r50,0r-53,258r-51,0","w":100},"m":{"d":"147,-113v21,-46,-30,-52,-48,-24v-21,32,-25,93,-36,137r-50,0r39,-187r47,0r-4,23v30,-35,93,-39,105,6v18,-37,117,-51,113,11v-3,47,-20,101,-29,147r-51,0r29,-138v-4,-28,-39,-17,-52,3v-18,28,-27,94,-37,135r-50,0","w":320},"n":{"d":"157,-106v18,-44,-12,-60,-42,-40v-36,24,-34,96,-49,146r-51,0r39,-187r48,0r-5,25v29,-35,119,-45,116,19v-2,43,-20,99,-28,143r-50,0","w":219},"o":{"d":"109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"p":{"d":"218,-111v10,82,-96,159,-149,85r-20,97r-51,0r54,-258r48,0r-4,19v43,-44,132,-21,122,57xm133,-155v-54,-1,-74,116,-15,121v51,1,77,-118,15,-121","w":219},"q":{"d":"21,-73v6,-60,32,-117,93,-118v27,0,46,12,58,34r7,-30r46,0r-54,258r-50,0r18,-87v-41,41,-125,15,-118,-57xm121,-154v-51,-1,-76,116,-16,121v54,1,76,-115,16,-121","w":219},"r":{"d":"51,-187r47,0r-8,37v25,-34,43,-50,81,-36r-20,42v-72,-15,-74,81,-89,144r-50,0","w":140,"k":{"\u2019":-13,".":20,",":20}},"s":{"d":"168,-96v46,42,-6,100,-68,100v-52,0,-81,-19,-92,-56r49,-8v8,19,17,27,42,28v20,1,44,-12,31,-29v-37,-23,-94,-21,-94,-70v0,-76,153,-82,163,-11r-47,8v-4,-25,-69,-32,-69,-5v0,25,76,26,85,43"},"t":{"d":"107,2v-38,6,-81,1,-78,-36v2,-28,17,-83,23,-115r-25,0r8,-38r24,0r7,-30r57,-34r-13,64r31,0r-8,38r-31,0r-21,102v3,15,15,14,34,11","w":119},"u":{"d":"142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"v":{"d":"108,0r-44,0r-37,-187r49,0r20,126r72,-126r55,0","k":{".":20,",":20}},"w":{"d":"210,0r-48,0r-9,-119r-57,119r-47,0r-23,-187r45,0r13,125r58,-125r46,0r6,125r58,-125r51,0","w":280,"k":{".":13,",":13}},"x":{"d":"100,-52r-46,52r-62,0r86,-96r-47,-91r54,0r27,54r47,-54r61,0r-86,97r47,90r-54,0"},"y":{"d":"30,-187r50,0r18,144v18,-49,48,-99,72,-144r53,0r-137,241v-15,22,-52,28,-84,16r5,-37v29,7,42,-4,56,-33","k":{".":13,",":13}},"z":{"d":"6,0r7,-34r102,-113r-83,0r8,-40r147,0r-6,30r-104,116r90,0r-8,41r-153,0","w":180},"{":{"d":"33,35v0,-32,37,-109,-18,-107r9,-42v91,-6,13,-166,152,-148r-8,42v-38,0,-37,2,-45,36v-14,56,-15,66,-52,91v34,14,13,86,9,112v3,14,11,15,32,15r-9,42v-41,1,-70,-3,-70,-41","w":140},"|":{"d":"31,76r0,-338r39,0r0,338r-39,0","w":100},"}":{"d":"113,-222v1,32,-38,110,18,108r-9,42v-90,5,-13,166,-153,148r10,-42v35,-2,36,-4,44,-36v12,-57,16,-68,52,-91v-35,-20,-14,-74,-10,-113v-2,-16,-10,-14,-32,-14r10,-42v40,-1,69,3,70,40","w":140},"~":{"d":"159,-91v-27,0,-64,-26,-87,-25v-16,0,-32,9,-48,25r0,-46v14,-15,27,-24,53,-24v46,0,98,49,134,-1r0,47v-10,10,-33,24,-52,24","w":210},"\u00c4":{"d":"128,-315r43,0r-9,43r-43,0xm202,-315r43,0r-9,43r-43,0xm184,-57r-103,0r-31,57r-54,0r146,-258r59,0r41,258r-50,0xm177,-100r-15,-104r-62,104r77,0","w":259},"\u00c5":{"d":"171,-240v-17,0,-34,-17,-34,-34v0,-17,16,-33,34,-33v18,0,34,16,34,33v0,17,-17,34,-34,34xm171,-288v-8,0,-15,7,-15,14v0,7,7,15,15,15v8,0,15,-7,15,-15v0,-8,-7,-14,-15,-14xm184,-54r-103,0r-31,57r-54,0r146,-258r59,0r41,258r-50,0xm177,-97r-15,-104r-62,104r77,0","w":259},"\u00d6":{"d":"125,-315r43,0r-9,43r-43,0xm199,-315r43,0r-9,43r-43,0xm137,5v-66,0,-106,-44,-106,-106v0,-91,50,-159,145,-161v62,-1,108,44,106,108v-3,88,-55,159,-145,159xm171,-218v-53,-1,-87,63,-87,116v0,35,24,63,59,62v54,-2,83,-59,86,-113v1,-37,-23,-64,-58,-65","w":280},"\u00dc":{"d":"122,-315r43,0r-9,43r-43,0xm196,-315r43,0r-9,43r-43,0xm225,-49v-33,80,-215,69,-191,-41r35,-168r53,0r-37,183v-3,34,49,45,75,28v23,-15,25,-32,33,-70r30,-141r52,0v-16,66,-28,154,-50,209","w":259},"\u00e1":{"d":"150,-263r54,0r-57,53r-33,0xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e0":{"d":"143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33xm91,-263r49,0r22,52r-34,0"},"\u00e4":{"d":"82,-258r43,0r-9,43r-43,0xm156,-258r43,0r-9,43r-43,0xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e5":{"d":"128,-204v-18,0,-33,-16,-33,-33v0,-17,16,-34,33,-34v17,0,34,17,34,34v0,17,-16,33,-34,33xm128,-252v-8,0,-14,7,-14,15v0,7,7,14,14,14v8,0,15,-6,15,-14v0,-8,-7,-15,-15,-15xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e7":{"d":"142,32v0,36,-49,42,-94,41v6,-8,3,-24,19,-21v17,-1,41,-2,43,-18v-2,-13,-20,-14,-36,-10r6,-18v28,-8,62,0,62,26xm72,-70v0,55,62,35,69,0r49,8v-14,39,-44,65,-91,66v-48,1,-77,-31,-77,-79v0,-88,90,-148,159,-99v14,10,20,27,22,46r-48,5v-1,-19,-12,-31,-30,-31v-37,0,-53,44,-53,84"},"\u00e9":{"d":"149,-263r53,0r-57,53r-33,0xm125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0"},"\u00e8":{"d":"125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0xm89,-263r49,0r22,52r-34,0"},"\u00ed":{"d":"53,-187r51,0r-39,187r-51,0xm95,-263r54,0r-57,53r-34,0","w":100},"\u00ee":{"d":"92,-242r-31,32r-41,0r52,-53r47,0r21,53r-35,0xm53,-187r51,0r-39,187r-51,0","w":100},"\u00ef":{"d":"53,-187r51,0r-39,187r-51,0xm33,-258r43,0r-9,43r-43,0xm107,-258r43,0r-9,43r-43,0","w":100},"\u00f1":{"d":"170,-214v-17,2,-59,-33,-63,1r-22,0v5,-25,13,-40,34,-43v6,-1,41,14,52,14v8,0,9,-5,12,-14r22,0v-2,23,-14,41,-35,42xm157,-106v18,-44,-12,-60,-42,-40v-36,24,-34,96,-49,146r-51,0r39,-187r48,0r-5,25v29,-35,119,-45,116,19v-2,43,-20,99,-28,143r-50,0","w":219},"\u00f3":{"d":"139,-263r54,0r-57,53r-34,0xm109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"\u00f6":{"d":"84,-258r43,0r-9,43r-43,0xm158,-258r43,0r-9,43r-43,0xm109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"\u00f9":{"d":"142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0xm104,-263r49,0r22,52r-34,0","w":219},"\u00fb":{"d":"149,-242r-31,32r-41,0r52,-53r47,0r21,53r-34,0xm142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"\u00fc":{"d":"94,-258r44,0r-9,43r-44,0xm168,-258r44,0r-9,43r-44,0xm142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"\u00a3":{"d":"192,-6v-57,32,-127,-28,-179,13r-6,-46v28,-13,51,-34,56,-69r-41,0r8,-40r29,0v-27,-87,73,-148,138,-95v15,12,21,30,23,51r-45,4v-3,-22,-12,-35,-33,-35v-33,0,-47,37,-37,75r44,0r-8,40r-34,0v-4,34,-15,47,-38,69v34,-16,74,11,107,-10"},"\u00df":{"d":"156,-208v-2,-23,-36,-20,-44,-1v-23,53,-33,145,-49,209r-50,0v17,-71,30,-158,51,-220v17,-48,144,-64,145,7v1,32,-35,48,-39,74v4,26,39,47,39,80v0,70,-100,81,-129,29r36,-20v8,19,45,16,43,-8v-3,-30,-40,-47,-40,-77v0,-28,32,-45,37,-73","w":219},"\u2122":{"d":"97,-114r0,-119r-45,0r0,-25r117,0r0,25r-43,0r0,119r-29,0xm186,-114r0,-144r46,0r26,99r26,-99r46,0r0,144r-28,0r0,-115r-31,115r-26,0r-31,-115r0,115r-28,0","w":360},"\u00ab":{"d":"101,-97r69,-75r43,0r-63,79r23,81r-36,0xm30,-97r72,-75r42,0r-63,78r23,82r-35,0"},"\u00bb":{"d":"119,-87r-68,75r-43,0r62,-79r-22,-81r36,0xm191,-87r-72,75r-43,0r64,-79r-23,-81r35,0"},"\u2026":{"d":"44,-49r50,0r-11,49r-50,0xm160,-49r50,0r-10,49r-50,0xm277,-49r50,0r-11,49r-49,0","w":360},"\u2013":{"d":"-1,-75r0,-37r201,0r0,37r-201,0"},"\u2014":{"d":"0,-75r0,-37r360,0r0,37r-360,0","w":360},"\u201c":{"d":"181,-156r-51,0v10,-50,16,-107,73,-105r-5,24v-17,4,-27,13,-30,32r23,0xm96,-156r-51,0v10,-50,17,-106,73,-105r-5,24v-17,4,-27,13,-30,32r23,0","w":180},"\u201d":{"d":"68,-258r51,0v-9,51,-17,106,-73,105r5,-23v18,-4,27,-13,30,-33r-23,0xm153,-258r51,0v-11,49,-16,106,-73,105r5,-23v17,-4,26,-14,30,-33r-23,0","w":180},"\u2018":{"d":"90,-156r-51,0v11,-49,16,-106,73,-105r-5,24v-17,4,-26,14,-30,32r23,0","w":100,"k":{"\u2018":13}},"\u2019":{"d":"66,-258r51,0v-9,50,-16,106,-73,105r5,-23v18,-4,27,-13,30,-33r-23,0","w":100,"k":{"\u2019":13,"t":-7,"s":7," ":13}},"\u00ff":{"d":"79,-258r43,0r-9,43r-43,0xm153,-258r43,0r-9,43r-43,0xm30,-187r50,0r18,144v18,-49,48,-99,72,-144r53,0r-137,241v-15,22,-52,28,-84,16r5,-37v29,7,42,-4,56,-33"},"\u20ac":{"d":"44,-168v16,-68,112,-122,186,-78r-19,48v-32,-35,-95,-17,-111,30r87,0r-5,27r-91,0v-1,4,-1,11,-3,23r90,0r-6,28r-86,0v2,49,71,65,106,33r-11,53v-73,28,-145,-13,-147,-86r-24,0r5,-28r20,0v0,-6,1,-13,2,-23r-27,0r5,-27r29,0"},"\u0142":{"d":"43,-135r26,-123r50,0r-19,94r19,-10r-7,34r-20,10r-27,130r-50,0r21,-102r-25,14r7,-34","w":100},"\u00d7":{"d":"34,-74r53,-53r-54,-53r33,-33r53,53r53,-53r32,32r-53,53r54,54r-33,33r-54,-54r-53,53","w":210},"\u0107":{"d":"134,-263r54,0r-57,53r-34,0xm72,-70v0,55,62,35,69,0r49,8v-14,39,-44,65,-91,66v-48,1,-77,-31,-77,-79v0,-88,90,-148,159,-99v14,10,20,27,22,46r-48,5v-1,-19,-12,-31,-30,-31v-37,0,-53,44,-53,84"},"\u0105":{"d":"166,0v-10,6,-35,37,-10,41r15,-3r-6,29v-25,13,-61,9,-61,-19v0,-19,19,-38,33,-48r29,0xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u0119":{"d":"133,0v-10,6,-35,37,-10,41r15,-3r-6,29v-24,12,-59,10,-60,-19v0,-19,18,-38,32,-48r29,0xm125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0"},"\u015b":{"d":"129,-263r54,0r-57,53r-34,0xm168,-96v46,42,-6,100,-68,100v-52,0,-81,-19,-92,-56r49,-8v8,19,17,27,42,28v20,1,44,-12,31,-29v-37,-23,-94,-21,-94,-70v0,-76,153,-82,163,-11r-47,8v-4,-25,-69,-32,-69,-5v0,25,76,26,85,43"},"\u017a":{"d":"118,-263r54,0r-57,53r-34,0xm6,0r7,-34r102,-113r-83,0r8,-40r147,0r-6,30r-104,116r90,0r-8,41r-153,0","w":180},"\u017c":{"d":"96,-262r51,0r-10,46r-51,0xm6,0r7,-34r102,-113r-83,0r8,-40r147,0r-6,30r-104,116r90,0r-8,41r-153,0","w":180},"\u2032":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":86},"\u2033":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0xm118,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":172}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2007 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Description:
 * Monotype Drawing Office 1982. A contemporary sans serif design, Arial contains
 * more humanist characteristics than many of its predecessors and as such is more
 * in tune with the mood of the last decades of the twentieth century. The overall
 * treatment of curves is softer and fuller than in most industrial-style sans
 * serif faces. Terminal strokes are cut on the diagonal which helps to give the
 * face a less mechanical appearance. Arial is an extremely versatile family of
 * typefaces which can be used with equal success for text setting in reports,
 * presentations, magazines etc, and for display use in newspapers, advertising and
 * promotions.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Robin Nicholas, Patricia Saunders
 */
Cufon.registerFont({"w":164,"face":{"font-family":"Arial Narrow","font-weight":400,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 6 6 2 2 2 3 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-14 -332 295 76.2352","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":82,"k":{"Y":5,"T":5,"A":16}},"\u00a0":{"w":82},"!":{"d":"34,-64r-8,-137r0,-57r32,0v1,68,-4,130,-7,194r-17,0xm27,0r0,-36r30,0r0,36r-30,0","w":82},"\"":{"d":"21,-166v-5,-28,-10,-57,-8,-92r30,0v1,34,-2,64,-7,92r-15,0xm68,-166v-4,-29,-9,-57,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":104},"#":{"d":"14,4r13,-74r-24,0r0,-27r28,0r11,-63r-39,0r0,-27r43,0r13,-75r22,0r-13,75r45,0r13,-75r22,0r-13,75r25,0r0,27r-29,0r-11,63r40,0r0,27r-44,0r-13,74r-22,0r13,-74r-45,0r-13,74r-22,0xm53,-97r45,0r11,-63r-45,0"},"$":{"d":"150,-73v1,42,-26,75,-62,78r0,32r-15,0r0,-32v-44,-5,-58,-33,-63,-77r26,-6v3,30,14,52,37,57r0,-101v-31,-8,-60,-30,-58,-73v1,-41,19,-67,58,-71r0,-15r15,0r0,15v36,4,51,28,57,63r-27,5v-3,-24,-13,-38,-30,-42r0,92v41,10,59,29,62,75xm73,-240v-42,6,-45,78,0,88r0,-88xm88,-21v29,-2,45,-51,28,-78v-5,-7,-15,-14,-28,-19r0,97"},"%":{"d":"61,-126v-30,0,-44,-31,-44,-70v0,-37,15,-66,44,-66v31,0,46,29,46,68v0,37,-15,68,-46,68xm62,-148v31,0,32,-91,0,-92v-32,0,-32,92,0,92xm62,9r115,-271r21,0r-115,271r-21,0xm198,9v-30,0,-45,-31,-45,-69v0,-36,15,-67,44,-67v31,0,47,29,47,68v0,36,-15,68,-46,68xm199,-12v31,0,32,-95,-1,-93v-19,1,-22,20,-22,46v0,27,3,47,23,47","w":262},"&":{"d":"92,-262v29,0,50,25,49,55v0,24,-13,46,-40,63r38,59v4,-10,7,-22,10,-36r27,7v-5,22,-11,40,-19,55v9,15,21,29,33,40r-17,25v-10,-8,-22,-20,-33,-36v-17,23,-37,34,-60,34v-40,0,-67,-38,-67,-75v0,-32,16,-58,50,-77v-14,-21,-23,-31,-24,-57v-1,-30,23,-57,53,-57xm91,-236v-39,3,-23,56,-3,71v29,-11,38,-64,3,-71xm41,-73v-2,32,32,66,63,41v8,-6,15,-13,20,-23r-47,-72v-21,15,-35,27,-36,54","w":196},"'":{"d":"19,-166v-5,-28,-8,-58,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":56},"(":{"d":"88,-262v-56,100,-59,230,0,338r-19,0v-59,-87,-73,-238,0,-338r19,0","w":98},")":{"d":"29,-262v73,101,62,248,0,338r-18,0v59,-108,54,-238,0,-338r18,0","w":98},"*":{"d":"9,-210r6,-25v15,7,27,12,34,17v-2,-22,-3,-36,-3,-44r21,0v0,11,-2,26,-4,44v10,-6,21,-12,34,-17r7,25v-12,5,-24,7,-36,9v6,6,14,18,25,34r-17,15v-5,-9,-12,-22,-20,-38v-7,17,-14,29,-19,38r-17,-15v11,-16,19,-28,24,-34v-13,-3,-24,-5,-35,-9","w":114},"+":{"d":"74,-42r0,-70r-58,0r0,-30r58,0r0,-70r24,0r0,70r58,0r0,30r-58,0r0,70r-24,0","w":172},",":{"d":"27,0r0,-36r29,0v0,37,3,76,-24,87r-7,-14v12,-6,17,-17,16,-37r-14,0","w":82},"-":{"d":"9,-77r0,-32r80,0r0,32r-80,0","w":98},"\u00ad":{"d":"9,-77r0,-32r80,0r0,32r-80,0","w":98},".":{"d":"27,0r0,-36r30,0r0,36r-30,0","w":82},"\/":{"d":"0,4r61,-266r21,0r-61,266r-21,0","w":82},"0":{"d":"81,4v-56,0,-70,-56,-69,-131v0,-71,12,-132,69,-132v57,0,69,60,69,132v0,70,-12,131,-69,131xm80,-233v-38,9,-42,45,-42,106v0,63,3,97,43,105v38,-8,42,-44,42,-105v0,-63,-3,-97,-43,-106"},"1":{"d":"32,-194v25,-13,51,-40,61,-65r17,0r0,259r-27,0r0,-202v-11,14,-35,31,-51,39r0,-31","k":{"1":22}},"2":{"d":"148,-187v0,70,-77,106,-103,157r104,0r0,30r-140,0v2,-80,108,-114,113,-188v1,-24,-18,-45,-40,-45v-26,0,-43,22,-42,52r-26,-3v3,-46,25,-73,69,-75v42,-2,65,34,65,72"},"3":{"d":"150,-76v4,64,-73,108,-117,61v-13,-13,-19,-31,-21,-53r26,-4v4,74,85,57,85,-4v0,-34,-27,-60,-60,-46r3,-28v27,5,47,-17,47,-43v0,-22,-14,-40,-34,-40v-24,0,-36,21,-39,47r-25,-6v5,-38,25,-64,63,-67v61,-4,84,94,33,119v26,7,37,31,39,64"},"4":{"d":"95,0r0,-62r-92,0r0,-29r97,-167r21,0r0,167r29,0r0,29r-29,0r0,62r-26,0xm95,-91r0,-116r-66,116r66,0"},"5":{"d":"152,-87v0,67,-68,121,-119,72v-13,-13,-19,-31,-21,-53r27,-2v3,27,15,48,40,48v28,0,47,-29,45,-63v9,-56,-63,-77,-83,-33r-25,-4r21,-132r105,0r0,30r-84,0r-12,69v48,-42,106,6,106,68"},"6":{"d":"11,-121v0,-80,16,-138,75,-138v35,0,58,27,60,64r-25,3v-3,-45,-55,-56,-73,-13v-7,16,-12,40,-12,72v10,-18,28,-34,52,-34v83,0,83,174,-4,171v-56,-2,-73,-52,-73,-125xm82,-139v-59,1,-52,117,2,117v54,-1,53,-119,-2,-117"},"7":{"d":"43,0v3,-85,36,-172,74,-224r-103,0r0,-30r136,0r0,24v-38,50,-76,147,-80,230r-27,0"},"8":{"d":"81,4v-74,8,-95,-126,-29,-144v-55,-20,-33,-126,29,-119v61,-7,84,98,30,119v65,20,46,152,-30,144xm81,-233v-18,0,-34,20,-34,40v0,22,13,41,34,41v19,0,35,-17,35,-40v0,-21,-16,-41,-35,-41xm81,-126v-26,0,-43,25,-43,52v0,28,17,52,43,52v26,-1,43,-22,43,-51v0,-28,-17,-53,-43,-53"},"9":{"d":"151,-134v-1,76,-12,138,-76,138v-36,0,-57,-27,-59,-64r25,-2v4,27,16,40,35,40v42,0,47,-53,49,-99v-8,17,-28,34,-50,34v-39,0,-63,-39,-63,-85v0,-47,25,-87,66,-87v58,0,74,54,73,125xm81,-115v26,0,41,-26,41,-58v0,-31,-15,-60,-41,-60v-53,1,-60,118,0,118"},":":{"d":"27,-151r0,-36r30,0r0,36r-30,0xm27,0r0,-36r30,0r0,36r-30,0","w":82},";":{"d":"27,-151r0,-36r29,0r0,36r-29,0xm27,0r0,-36r29,0v0,37,3,76,-24,87r-7,-14v12,-6,17,-17,16,-37r-14,0","w":82},"\u037e":{"d":"27,-151r0,-36r29,0r0,36r-29,0xm27,0r0,-36r29,0v0,37,3,76,-24,87r-7,-14v12,-6,17,-17,16,-37r-14,0","w":82},"<":{"d":"16,-113r0,-29r140,-72r0,31r-111,56r111,56r0,31","w":172},"=":{"d":"156,-152r-140,0r0,-29r140,0r0,29xm156,-73r-140,0r0,-30r140,0r0,30","w":172},">":{"d":"156,-113r-140,73r0,-31r111,-56r-111,-56r0,-31r140,72r0,29","w":172},"?":{"d":"149,-192v0,59,-62,64,-57,129r-24,0v-12,-65,49,-76,54,-127v2,-24,-17,-47,-40,-46v-27,1,-40,22,-43,52r-27,-4v5,-44,25,-74,69,-74v38,0,68,31,68,70xm66,0r0,-36r29,0r0,36r-29,0"},"@":{"d":"195,1v-21,0,-26,-10,-28,-30v-11,15,-25,28,-44,30v-87,-15,-56,-192,23,-192v20,0,34,15,43,33r5,-27r26,0r-25,145v0,6,4,11,10,11v33,-8,55,-55,55,-97v0,-65,-40,-111,-102,-111v-80,0,-121,69,-121,152v0,85,43,133,125,135v46,0,84,-23,101,-53r26,0v-22,43,-62,79,-127,79v-96,-2,-146,-61,-146,-158v0,-98,45,-180,143,-180v78,0,120,59,123,136v2,55,-37,124,-87,127xm147,-164v-50,0,-73,125,-19,139v34,-5,52,-49,53,-89v1,-27,-12,-50,-34,-50","w":299},"A":{"d":"0,0r81,-258r30,0r86,258r-32,0r-24,-78r-88,0r-24,78r-29,0xm61,-106r71,0r-37,-125v-7,45,-22,84,-34,125","w":196,"k":{"\u2019":22,"y":5,"w":5,"v":5,"Y":22,"W":11,"V":22,"T":22," ":16}},"B":{"d":"181,-75v-2,50,-26,75,-79,75r-80,0r0,-258r79,0v73,-9,90,92,41,121v23,8,40,30,39,62xm144,-188v0,-46,-47,-39,-94,-39r0,78v45,-1,94,8,94,-39xm152,-75v0,-51,-52,-44,-102,-44r0,89v50,0,102,7,102,-45","w":196},"C":{"d":"111,-25v37,0,56,-28,62,-65r28,8v-10,50,-37,86,-89,86v-73,0,-93,-61,-98,-135v-6,-95,78,-167,152,-112v16,12,25,31,31,56r-27,8v-9,-36,-29,-54,-57,-54v-52,0,-69,45,-70,102v0,59,18,106,68,106","w":213},"D":{"d":"197,-130v0,75,-24,130,-99,130r-76,0r0,-258r73,0v80,-2,102,53,102,128xm168,-131v0,-59,-13,-98,-74,-96r-44,0r0,197r45,0v61,2,73,-44,73,-101","w":213},"E":{"d":"23,0r0,-258r153,0r0,31r-125,0r0,79r117,0r0,30r-117,0r0,88r130,0r0,30r-158,0","w":196},"F":{"d":"25,0r0,-258r142,0r0,31r-114,0r0,80r99,0r0,30r-99,0r0,117r-28,0","w":180,"k":{"A":16,".":33,",":33}},"G":{"d":"123,-26v23,0,50,-14,61,-27r0,-48r-62,0r0,-30r90,0r0,95v-23,21,-50,40,-88,40v-73,0,-107,-55,-108,-132v-2,-89,59,-160,147,-125v26,11,39,33,45,67r-25,9v-7,-37,-23,-56,-61,-56v-55,0,-76,44,-77,103v0,60,25,102,78,104","w":229},"H":{"d":"23,0r0,-258r28,0r0,106r109,0r0,-106r28,0r0,258r-28,0r0,-121r-109,0r0,121r-28,0","w":213},"I":{"d":"28,0r0,-258r28,0r0,258r-28,0","w":82},"J":{"d":"124,-82v0,55,-13,86,-59,86v-43,0,-56,-31,-57,-77r25,-4v2,33,6,48,32,51v26,-3,31,-23,31,-54r0,-178r28,0r0,176","w":147},"K":{"d":"22,0r0,-258r28,0r0,128r105,-128r38,0r-89,105r93,153r-37,0r-76,-130r-34,41r0,89r-28,0","w":196},"L":{"d":"21,0r0,-258r28,0r0,228r104,0r0,30r-132,0","k":{"\u2019":16,"y":11,"Y":22,"W":22,"V":22,"T":22," ":11}},"M":{"d":"22,0r0,-258r42,0r60,221r62,-221r38,0r0,258r-27,0r0,-216r-62,216r-25,0r-61,-219r0,219r-27,0","w":245},"N":{"d":"22,0r0,-258r29,0r111,203r0,-203r26,0r0,258r-28,0r-111,-202r0,202r-27,0","w":213},"O":{"d":"116,4v-63,0,-101,-64,-101,-130v0,-76,35,-136,101,-136v68,0,100,58,101,133v1,71,-36,133,-101,133xm116,-233v-51,0,-72,46,-72,108v0,54,26,100,72,100v49,0,72,-47,72,-104v0,-56,-20,-104,-72,-104","w":229},"P":{"d":"184,-184v0,49,-24,81,-79,79r-54,0r0,105r-28,0r0,-258r79,0v58,-2,82,23,82,74xm155,-182v0,-53,-51,-46,-104,-45r0,92v51,1,104,7,104,-47","w":196,"k":{"A":22,".":38,",":38," ":5}},"Q":{"d":"115,-262v108,-4,126,167,69,234v13,11,25,19,36,24r-9,24v-15,-7,-30,-18,-45,-32v-79,51,-157,-26,-153,-117v4,-74,32,-130,102,-133xm42,-129v0,68,39,123,101,97v-9,-7,-18,-11,-28,-14r7,-25v16,5,29,13,40,24v42,-48,33,-188,-47,-186v-49,1,-73,46,-73,104","w":229},"R":{"d":"192,-188v0,40,-23,66,-60,71v40,26,52,77,77,117r-35,0r-28,-54v-23,-45,-29,-65,-95,-60r0,114r-28,0r0,-258r93,0v53,-1,76,23,76,70xm163,-187v0,-52,-62,-41,-112,-42r0,85v51,0,112,10,112,-43","w":213,"k":{"Y":5,"W":5,"V":5,"T":5}},"S":{"d":"143,-137v67,33,39,142,-43,142v-52,0,-86,-36,-87,-88r27,-3v-9,69,115,83,115,16v0,-71,-134,-27,-134,-121v0,-75,113,-95,144,-35v7,12,10,25,10,41r-27,2v-2,-32,-19,-47,-51,-49v-39,-2,-63,35,-40,62v9,12,73,26,86,33","w":196},"T":{"d":"77,0r0,-227r-70,0r0,-31r168,0r0,31r-70,0r0,227r-28,0","w":180,"k":{"\u0119":33,"\u0105":33,"y":16,"w":16,"u":11,"s":25,"r":11,"o":33,"i":7,"e":33,"c":33,"a":33,"O":5,"A":22,";":33,":":33,".":33,"-":16,",":33," ":5}},"U":{"d":"104,-26v48,0,57,-26,57,-83r0,-149r28,0v-7,109,33,262,-83,262v-115,0,-76,-155,-83,-262r28,0r0,149v-2,54,9,83,53,83","w":213},"V":{"d":"83,0r-82,-258r31,0r66,230r68,-230r29,0r-83,258r-29,0","w":196,"k":{"\u0119":16,"\u0105":22,"y":11,"u":11,"r":11,"o":16,"i":5,"e":16,"a":22,"A":22,";":11,":":11,".":27,"-":16,",":27}},"W":{"d":"60,0r-56,-258r29,0r41,222r50,-222r33,0r31,131v7,32,12,62,16,91r44,-222r28,0r-58,258r-27,0r-51,-227r-51,227r-29,0","w":278,"k":{"\u0119":5,"\u0105":11,"y":2,"u":5,"r":5,"o":5,"e":5,"a":11,"A":11,";":5,":":5,".":16,"-":5,",":16}},"X":{"d":"1,0r82,-134r-72,-124r33,0r56,98v17,-34,40,-66,59,-98r30,0r-74,122r80,136r-34,0r-63,-109r-63,109r-34,0","w":196},"Y":{"d":"82,0r0,-109r-81,-149r34,0r63,122r64,-122r33,0r-85,149r0,109r-28,0","w":196,"k":{"\u0119":27,"\u0105":22,"v":16,"u":16,"q":27,"p":22,"o":27,"i":11,"e":27,"a":22,"A":22,";":19,":":16,".":38,"-":27,",":38," ":5}},"Z":{"d":"6,0r0,-32r131,-195r-119,0r0,-31r152,0r0,31r-132,197r135,0r0,30r-167,0","w":180},"[":{"d":"21,72r0,-330r57,0r0,26r-32,0r0,277r32,0r0,27r-57,0","w":82},"\\":{"d":"61,4r-61,-266r21,0r61,266r-21,0","w":82},"]":{"d":"64,72r-58,0r0,-27r32,0r0,-277r-32,0r0,-26r58,0r0,330","w":82},"^":{"d":"34,-121r-26,0r51,-141r21,0r51,141r-26,0r-36,-105","w":138},"_":{"d":"-2,27r168,0r0,18r-168,0r0,-18"},"`":{"d":"67,-210r-21,0r-33,-49r35,0","w":98},"a":{"d":"84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"b":{"d":"152,-95v6,75,-71,134,-109,72r0,23r-24,0r0,-258r26,0r0,92v10,-15,20,-25,42,-25v46,0,61,44,65,96xm84,-165v-54,1,-60,143,0,143v55,-1,57,-142,0,-143"},"c":{"d":"81,-22v24,0,35,-20,38,-46r26,4v-4,38,-26,68,-65,68v-47,0,-69,-43,-69,-98v0,-98,114,-137,131,-38r-25,5v-4,-22,-14,-38,-35,-38v-32,0,-44,30,-44,71v0,42,10,72,43,72","w":147},"d":{"d":"75,-191v20,0,33,13,42,26r0,-93r26,0r0,258r-25,0r0,-24v-9,15,-20,28,-42,28v-43,-1,-66,-45,-66,-97v0,-54,18,-98,65,-98xm76,-165v-56,0,-54,143,2,143v28,0,41,-30,41,-68v0,-42,-11,-75,-43,-75"},"e":{"d":"37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0"},"f":{"d":"89,-231v-30,-9,-41,10,-37,44r30,0r0,25r-30,0r0,162r-26,0r0,-162r-23,0r0,-25r23,0v-6,-54,15,-86,67,-72","w":82,"k":{"\u2019":-5,"f":5}},"g":{"d":"144,-25v2,67,-14,97,-69,101v-39,3,-61,-23,-61,-61r25,5v0,31,43,38,63,21v16,-14,15,-28,16,-65v-10,14,-22,24,-43,24v-88,-1,-90,-191,0,-191v22,0,34,11,45,27r0,-23r24,0r0,162xm76,-165v-55,2,-55,140,2,139v58,-1,57,-140,-2,-139"},"h":{"d":"85,-164v-59,0,-35,103,-40,164r-26,0r0,-258r26,0r0,93v10,-16,25,-26,46,-26v77,-1,47,117,53,191r-26,0r0,-118v0,-28,-9,-46,-33,-46"},"i":{"d":"19,-221r0,-37r26,0r0,37r-26,0xm19,0r0,-187r26,0r0,187r-26,0","w":65},"j":{"d":"19,-221r0,-37r26,0r0,37r-26,0xm45,10v3,50,-17,75,-59,62r5,-26v25,6,29,-6,28,-37r0,-196r26,0r0,197","w":65},"k":{"d":"20,0r0,-258r26,0r0,147r61,-76r34,0r-59,70r64,117r-31,0r-51,-95r-18,21r0,74r-26,0","w":147},"l":{"d":"18,0r0,-258r26,0r0,258r-26,0","w":65},"m":{"d":"83,-163v-59,0,-32,104,-38,163r-26,0r0,-187r24,0r0,27v8,-18,23,-30,46,-31v24,0,37,14,43,33v10,-19,23,-33,47,-33v75,0,41,120,48,191r-26,0r0,-118v0,-28,-4,-45,-27,-45v-59,0,-32,104,-38,163r-26,0r0,-121v1,-26,-6,-42,-27,-42","w":245},"n":{"d":"86,-163v-63,0,-35,103,-41,163r-26,0r0,-187r23,0r0,27v11,-18,24,-31,49,-31v78,0,45,116,52,191r-26,0r0,-114v1,-32,-5,-49,-31,-49"},"o":{"d":"81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"p":{"d":"152,-95v5,73,-64,131,-107,76r0,91r-26,0r0,-259r24,0r0,25v10,-18,21,-29,44,-29v47,0,61,44,65,96xm84,-166v-54,2,-60,143,0,144v55,0,57,-143,0,-144"},"q":{"d":"75,-191v22,0,35,12,44,29r0,-25r23,0r0,259r-25,0r0,-92v-45,57,-111,-2,-107,-75v3,-48,19,-96,65,-96xm76,-166v-55,0,-55,144,3,144v27,0,41,-31,40,-68v-1,-42,-12,-76,-43,-76"},"r":{"d":"93,-151v-32,-24,-48,18,-48,53r0,98r-26,0r0,-187r23,0r0,29v11,-29,33,-43,60,-23","w":98,"k":{"\u2019":-11,".":16,",":16}},"s":{"d":"116,-97v41,31,14,101,-43,101v-37,0,-58,-20,-64,-60r26,-5v-4,47,73,53,75,10v3,-32,-63,-30,-75,-44v-40,-23,-20,-102,36,-96v35,4,56,17,59,52r-25,5v3,-39,-64,-41,-67,-7v-3,30,66,30,78,44","w":147},"t":{"d":"51,-53v-2,24,6,28,26,25r3,28v-41,7,-55,-6,-55,-55r0,-107r-19,0r0,-25r19,0r0,-46r26,-19r0,65r26,0r0,25r-26,0r0,109","w":82},"u":{"d":"76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"v":{"d":"62,0r-58,-187r27,0r43,150v11,-50,29,-102,43,-150r27,0r-58,187r-24,0","w":147,"k":{".":22,",":22}},"w":{"d":"47,0r-47,-187r27,0r33,148r33,-148r27,0r30,144r35,-144r25,0r-48,187r-26,0r-31,-144r-31,144r-27,0","w":213,"k":{".":16,",":16}},"x":{"d":"2,0r56,-97r-52,-90r33,0r34,65r37,-65r31,0r-53,88r57,99r-31,0r-40,-74r-40,74r-32,0","w":147},"y":{"d":"18,72r-3,-30v37,7,38,-4,48,-42r-58,-187r28,0r43,152v11,-54,29,-101,43,-152r26,0r-58,190v-16,46,-19,80,-69,69","w":147,"k":{".":22,",":22}},"z":{"d":"6,0r0,-26r97,-136v-31,2,-59,0,-91,1r0,-26r125,0r0,21r-99,140v35,-2,68,-1,103,-1r0,27r-135,0","w":147},"{":{"d":"38,-11v-1,-42,1,-63,-30,-68r0,-29v31,-5,30,-26,30,-68v0,-57,1,-87,54,-86r0,28v-27,-1,-30,7,-30,36v-1,64,2,83,-30,105v25,14,30,34,30,79v0,48,-8,59,30,62r0,28v-54,1,-54,-29,-54,-87","w":98},"|":{"d":"27,76r0,-338r23,0r0,338r-23,0","w":76},"}":{"d":"60,-176v1,42,-1,63,30,68r0,29v-31,5,-30,26,-30,68v0,57,0,88,-53,87r0,-28v27,0,29,-7,29,-36v0,-63,-2,-84,30,-105v-25,-16,-29,-34,-30,-79v-1,-48,9,-60,-29,-62r0,-28v53,-1,53,29,53,86","w":98},"~":{"d":"50,-122v-18,2,-25,9,-37,24r0,-36v26,-42,77,-7,110,3v18,-1,28,-13,37,-25r0,38v-29,41,-76,4,-110,-4","w":172},"\u00c4":{"d":"54,-289r0,-36r28,0r0,36r-28,0xm108,-289r0,-36r27,0r0,36r-27,0xm0,0r81,-258r30,0r86,258r-32,0r-24,-78r-88,0r-24,78r-29,0xm61,-106r71,0r-37,-125v-7,45,-22,84,-34,125","w":196},"\u00c5":{"d":"99,-268v-15,0,-26,-15,-26,-32v0,-16,11,-32,26,-32v15,0,26,16,26,32v0,16,-11,32,-26,32xm99,-319v-9,0,-15,10,-15,19v0,10,6,19,15,19v9,0,15,-9,15,-19v0,-10,-6,-19,-15,-19xm0,0r81,-258r30,0r86,258r-32,0r-24,-78r-88,0r-24,78r-29,0xm61,-106r71,0r-37,-125v-7,45,-22,84,-34,125","w":196},"\u00d6":{"d":"72,-289r0,-36r27,0r0,36r-27,0xm126,-289r0,-36r27,0r0,36r-27,0xm116,4v-63,0,-101,-64,-101,-130v0,-76,35,-136,101,-136v68,0,100,58,101,133v1,71,-36,133,-101,133xm116,-233v-51,0,-72,46,-72,108v0,54,26,100,72,100v49,0,72,-47,72,-104v0,-56,-20,-104,-72,-104","w":229},"\u00dc":{"d":"64,-289r0,-36r27,0r0,36r-27,0xm117,-289r0,-36r27,0r0,36r-27,0xm104,-26v48,0,57,-26,57,-83r0,-149r28,0v-7,109,33,262,-83,262v-115,0,-76,-155,-83,-262r28,0r0,149v-2,54,9,83,53,83","w":213},"\u00e1":{"d":"62,-210r19,-49r34,0r-32,49r-21,0xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e0":{"d":"84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29xm100,-210r-21,0r-33,-49r35,0"},"\u00e4":{"d":"39,-223r0,-36r27,0r0,36r-27,0xm93,-223r0,-36r27,0r0,36r-27,0xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e5":{"d":"79,-210v-16,0,-26,-16,-26,-33v0,-16,11,-31,26,-31v15,0,26,16,26,32v0,16,-11,32,-26,32xm80,-262v-20,0,-21,38,-1,39v20,0,21,-38,1,-39xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e7":{"d":"88,39v-1,-11,-8,-12,-23,-12r7,-31r20,0r-5,19v15,2,25,12,25,26v1,28,-34,38,-63,31r2,-21v17,2,35,2,37,-12xm81,-22v24,0,35,-20,38,-46r26,4v-4,38,-26,68,-65,68v-47,0,-69,-43,-69,-98v0,-98,114,-137,131,-38r-25,5v-4,-22,-14,-38,-35,-38v-32,0,-44,30,-44,71v0,42,10,72,43,72","w":147},"\u00e9":{"d":"62,-210r20,-49r33,0r-31,49r-22,0xm37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0"},"\u00e8":{"d":"37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0xm103,-210r-21,0r-33,-49r35,0"},"\u00ed":{"d":"29,0r0,-187r26,0r0,187r-26,0xm23,-210r19,-49r34,0r-32,49r-21,0","w":82},"\u00ee":{"d":"43,-240r-16,30r-29,0r31,-49r27,0r33,49r-30,0xm29,0r0,-187r26,0r0,187r-26,0","w":82},"\u00ef":{"d":"29,0r0,-187r26,0r0,187r-26,0xm1,-223r0,-36r27,0r0,36r-27,0xm54,-223r0,-36r28,0r0,36r-28,0","w":82},"\u00f1":{"d":"105,-211v-14,3,-49,-36,-49,1r-19,0v-1,-23,10,-40,29,-40v13,-3,48,35,48,-1r19,0v0,22,-9,40,-28,40xm86,-163v-63,0,-35,103,-41,163r-26,0r0,-187r23,0r0,27v11,-18,24,-31,49,-31v78,0,45,116,52,191r-26,0r0,-114v1,-32,-5,-49,-31,-49"},"\u00f3":{"d":"62,-210r19,-49r34,0r-32,49r-21,0xm81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"\u00f6":{"d":"39,-223r0,-36r27,0r0,36r-27,0xm93,-223r0,-36r27,0r0,36r-27,0xm81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"\u00f9":{"d":"76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164xm92,-210r-21,0r-33,-49r35,0"},"\u00fb":{"d":"82,-240r-16,30r-30,0r31,-49r28,0r32,49r-29,0xm76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"\u00fc":{"d":"41,-223r0,-36r27,0r0,36r-27,0xm95,-223r0,-36r27,0r0,36r-27,0xm76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"\u00a3":{"d":"86,-236v-42,0,-43,51,-29,94r45,0r0,26r-41,0v9,32,-6,60,-23,82v41,-15,77,26,109,-2r9,29v-48,37,-97,-34,-142,12r-10,-30v24,-15,40,-52,30,-91r-28,0r0,-26r22,0v-19,-63,0,-120,58,-120v38,0,60,28,64,67r-26,4v-2,-24,-16,-45,-38,-45"},"\u00df":{"d":"83,-236v-30,0,-35,22,-35,62r0,174r-26,0r0,-176v-1,-54,16,-83,62,-86v30,-2,53,21,53,50v0,24,-21,56,-21,72v8,35,56,41,56,85v0,44,-48,77,-84,48v-9,-7,-16,-18,-21,-31r22,-13v9,19,18,29,29,29v16,1,27,-14,27,-30v-2,-39,-56,-44,-56,-83v0,-22,23,-57,23,-74v0,-16,-13,-27,-29,-27","w":180},"\u2122":{"d":"71,-114r0,-122r-38,0r0,-22r95,0r0,22r-38,0r0,122r-19,0xm142,-114r0,-144r29,0r29,115r29,-115r28,0r0,144r-18,0r0,-121r-30,121r-18,0r-31,-122r0,122r-18,0","w":295},"\u00ab":{"d":"49,-93r37,80r-21,0r-46,-80r46,-80r21,0xm104,-93r38,80r-22,0r-45,-80r45,-80r22,0"},"\u00bb":{"d":"114,-93r-38,-80r21,0r46,80r-46,80r-21,0xm58,-93r-38,-80r21,0r46,80r-46,80r-21,0"},"\u2026":{"d":"34,0r0,-36r30,0r0,36r-30,0xm133,0r0,-36r29,0r0,36r-29,0xm231,0r0,-36r30,0r0,36r-30,0","w":295},"\u2013":{"d":"-1,-81r0,-25r164,0r0,25r-164,0"},"\u2014":{"d":"0,-81r0,-25r295,0r0,25r-295,0","w":295},"\u201c":{"d":"85,-210r0,37r-28,0v0,-38,-2,-73,23,-85r7,13v-12,6,-17,15,-16,35r14,0xm40,-210r0,37r-28,0v-1,-38,-1,-74,24,-85r6,13v-11,6,-16,16,-16,35r14,0","w":98},"\u201d":{"d":"12,-221r0,-37r28,0v0,38,2,73,-23,85r-7,-13v10,-5,16,-17,16,-35r-14,0xm57,-221r0,-37r28,0v1,38,1,74,-24,85r-6,-13v11,-6,16,-17,16,-35r-14,0","w":98},"\u2018":{"d":"46,-210r0,37r-28,0v-1,-38,-1,-74,24,-85r6,13v-11,6,-16,16,-16,35r14,0","w":65,"k":{"\u2018":5}},"\u2019":{"d":"17,-221r0,-37r28,0v1,38,1,74,-24,85r-6,-13v10,-5,16,-17,16,-35r-14,0","w":65,"k":{"\u2019":5,"s":5," ":11}},"\u00ff":{"d":"33,-223r0,-36r27,0r0,36r-27,0xm86,-223r0,-36r28,0r0,36r-28,0xm18,72r-3,-30v37,7,38,-4,48,-42r-58,-187r28,0r43,152v11,-54,29,-101,43,-152r26,0r-58,190v-16,46,-19,80,-69,69","w":147},"\u20ac":{"d":"17,-165v4,-70,79,-123,143,-83r-6,33v-44,-43,-108,1,-108,50r98,0r-4,24r-96,0r0,23r92,0r-3,24r-86,0v0,56,67,92,107,52r0,36v-68,29,-125,-6,-136,-88r-22,0r4,-24r15,0r0,-23r-19,0r4,-24r17,0"},"\u0142":{"d":"18,-101r-18,19r0,-27r18,-20r0,-129r26,0r0,103r20,-21r0,28r-20,20r0,128r-26,0r0,-101","w":65},"\u00d7":{"d":"23,-72r45,-55r-45,-55r18,-22r45,55r45,-55r17,22r-45,55r46,55r-18,21r-45,-55r-46,55","w":172},"\u0107":{"d":"57,-210r19,-49r34,0r-32,49r-21,0xm81,-22v24,0,35,-20,38,-46r26,4v-4,38,-26,68,-65,68v-47,0,-69,-43,-69,-98v0,-98,114,-137,131,-38r-25,5v-4,-22,-14,-38,-35,-38v-32,0,-44,30,-44,71v0,42,10,72,43,72","w":147},"\u0105":{"d":"187,64v-27,20,-66,12,-63,-28v0,-10,2,-23,6,-40r17,0v-9,22,-8,54,16,55v7,0,15,-3,24,-8r0,21xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u0119":{"d":"130,64v-27,21,-66,11,-64,-28v0,-10,2,-23,6,-40r18,0v-9,21,-8,53,15,55v7,0,16,-3,25,-8r0,21xm37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0"},"\u015b":{"d":"52,-210r19,-49r34,0r-32,49r-21,0xm116,-97v41,31,14,101,-43,101v-37,0,-58,-20,-64,-60r26,-5v-4,47,73,53,75,10v3,-32,-63,-30,-75,-44v-40,-23,-20,-102,36,-96v35,4,56,17,59,52r-25,5v3,-39,-64,-41,-67,-7v-3,30,66,30,78,44","w":147},"\u017a":{"d":"50,-210r19,-49r34,0r-32,49r-21,0xm6,0r0,-26r97,-136v-31,2,-59,0,-91,1r0,-26r125,0r0,21r-99,140v35,-2,68,-1,103,-1r0,27r-135,0","w":147},"\u017c":{"d":"55,-210r0,-39r33,0r0,39r-33,0xm6,0r0,-26r97,-136v-31,2,-59,0,-91,1r0,-26r125,0r0,21r-99,140v35,-2,68,-1,103,-1r0,27r-135,0","w":147},"\u2032":{"d":"19,-166v-5,-28,-8,-58,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":56},"\u2033":{"d":"21,-166v-5,-28,-10,-57,-8,-92r30,0v1,34,-2,64,-7,92r-15,0xm68,-166v-4,-29,-9,-57,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":104}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2007 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Description:
 * Monotype Drawing Office 1982. A contemporary sans serif design, Arial contains
 * more humanist characteristics than many of its predecessors and as such is more
 * in tune with the mood of the last decades of the twentieth century. The overall
 * treatment of curves is softer and fuller than in most industrial-style sans
 * serif faces. Terminal strokes are cut on the diagonal which helps to give the
 * face a less mechanical appearance. Arial is an extremely versatile family of
 * typefaces which can be used with equal success for text setting in reports,
 * presentations, magazines etc, and for display use in newspapers, advertising and
 * promotions.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Robin Nicholas, Patricia Saunders
 */
Cufon.registerFont({"w":164,"face":{"font-family":"Arial Narrow","font-weight":700,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 7 6 2 2 2 3 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-13 -336 295 76.1149","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":82,"k":{"Y":5,"A":11}},"!":{"d":"37,-66r-11,-131r0,-61r44,0v2,69,-6,129,-10,192r-23,0xm28,0r0,-49r41,0r0,49r-41,0","w":98},"\"":{"d":"24,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0xm89,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":140},"#":{"d":"22,-64r-19,0r0,-39r26,0r8,-52r-34,0r0,-39r41,0r11,-68r32,0r-11,68r32,0r11,-68r33,0r-11,68r20,0r0,39r-27,0r-8,52r35,0r0,39r-42,0r-11,68r-32,0r11,-68r-32,0r-12,68r-32,0xm70,-155r-9,52r32,0r9,-52r-32,0"},"$":{"d":"151,-77v1,43,-24,74,-60,80r0,33r-20,0r0,-32v-35,-5,-55,-30,-61,-76r38,-5v3,17,11,33,23,39r0,-74v-72,-14,-73,-142,0,-149r0,-17r20,0r0,17v32,5,50,27,54,61r-36,6v-2,-14,-9,-23,-18,-28r0,69v41,13,58,30,60,76xm71,-223v-23,8,-26,51,0,61r0,-61xm91,-36v30,-6,35,-61,0,-68r0,68"},"%":{"d":"60,-126v-34,0,-47,-28,-47,-68v0,-41,12,-68,46,-68v34,0,47,28,47,68v0,40,-12,68,-46,68xm59,-234v-22,2,-21,78,0,80v22,-1,22,-80,0,-80xm90,10r-30,0r113,-272r29,0xm202,10v-34,0,-47,-28,-47,-68v0,-41,12,-68,47,-68v34,0,47,28,47,68v0,41,-12,68,-47,68xm202,-98v-23,1,-21,79,0,80v21,-2,20,-78,0,-80","w":262},"&":{"d":"175,-61v6,8,26,24,33,30r-24,38v-12,-7,-24,-17,-35,-30v-16,18,-31,27,-61,28v-88,2,-99,-123,-27,-155v-37,-45,-24,-112,38,-112v33,0,59,25,58,58v-2,32,-15,43,-39,62r30,47v3,-7,6,-17,9,-29r36,10v-6,25,-11,43,-18,53xm100,-227v-35,1,-16,42,-2,55v20,-10,36,-51,2,-55xm82,-118v-31,13,-41,80,4,82v12,0,25,-7,38,-20","w":213},"'":{"d":"21,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":70},"(":{"d":"89,-262v-46,105,-45,232,-1,338r-28,0v-56,-89,-59,-251,1,-338r28,0","w":98},")":{"d":"37,-262v59,87,59,249,1,338r-28,0v44,-104,45,-234,0,-338r27,0","w":98},"*":{"d":"35,-139r-21,-21r27,-34r-37,-11r8,-31v12,6,24,13,34,21v-2,-19,-3,-35,-3,-47r25,0v0,8,0,24,-3,47v11,-7,26,-15,36,-19r8,32v-11,3,-23,5,-37,8r25,36r-22,18r-20,-40v-5,12,-12,26,-20,41","w":114},"+":{"d":"68,-37r0,-67r-56,0r0,-46r56,0r0,-67r36,0r0,67r56,0r0,46r-56,0r0,67r-36,0","w":172},",":{"d":"20,-49r41,0v1,50,1,94,-36,106r-8,-20v15,-6,23,-17,23,-37r-20,0r0,-49","w":82},"-":{"d":"9,-69r0,-49r80,0r0,49r-80,0","w":98},"\u00ad":{"d":"9,-69r0,-49r80,0r0,49r-80,0","w":98},".":{"d":"21,0r0,-49r41,0r0,49r-41,0","w":82},"\/":{"d":"0,4r52,-266r30,0r-52,266r-30,0","w":82},"0":{"d":"81,4v-57,-6,-69,-54,-69,-132v-1,-76,14,-124,69,-131v56,7,69,55,69,132v0,77,-13,125,-69,131xm81,-37v41,3,25,-134,19,-165v-5,-11,-11,-16,-19,-16v-29,9,-26,37,-26,91v0,55,-3,81,26,90"},"1":{"d":"23,-194v24,-9,53,-37,60,-65r33,0r0,259r-40,0r0,-186v-15,17,-33,29,-53,37r0,-45","k":{"1":16}},"2":{"d":"149,-188v0,68,-58,98,-80,142r80,0r0,46r-142,0v1,-79,94,-112,102,-184v2,-20,-10,-34,-28,-34v-18,0,-28,13,-29,40r-40,-4v4,-47,25,-75,70,-77v42,-1,67,31,67,71"},"3":{"d":"152,-77v4,65,-73,107,-119,62v-13,-13,-20,-31,-22,-53r39,-6v1,21,11,36,30,37v39,1,40,-83,2,-83v-5,0,-12,2,-19,4r5,-40v20,0,33,-13,33,-34v0,-17,-7,-28,-23,-28v-16,1,-25,15,-26,34r-38,-7v7,-41,24,-66,65,-68v63,-3,85,95,32,120v25,6,39,31,41,62"},"4":{"d":"92,0r0,-52r-87,0r0,-43r92,-164r34,0r0,164r26,0r0,43r-26,0r0,52r-39,0xm92,-95r0,-88r-49,88r49,0"},"5":{"d":"155,-86v-2,43,-26,92,-72,90v-41,-1,-66,-29,-70,-70r41,-5v1,19,13,35,29,36v21,-2,31,-23,31,-51v0,-45,-42,-63,-63,-28r-33,-6r21,-134r107,0r0,46r-76,0r-7,44v51,-29,94,25,92,78"},"6":{"d":"13,-126v0,-77,17,-133,77,-133v36,0,55,27,60,64r-39,6v-1,-32,-31,-39,-45,-15v-6,10,-9,29,-11,58v35,-49,99,0,99,63v0,48,-26,87,-68,87v-56,0,-73,-54,-73,-130xm86,-131v-39,0,-37,95,2,94v21,-1,26,-19,26,-45v0,-27,-7,-49,-28,-49"},"7":{"d":"41,0v2,-81,29,-156,64,-208r-93,0r0,-46r139,0r0,36v-38,47,-71,134,-71,218r-39,0"},"8":{"d":"83,5v-74,0,-96,-117,-36,-144v-51,-23,-32,-128,34,-120v67,-8,83,96,34,120v59,24,42,144,-32,144xm81,-220v-16,0,-25,13,-25,31v0,18,9,31,25,31v15,0,25,-13,25,-31v0,-18,-10,-31,-25,-31xm81,-118v-39,0,-38,84,1,83v19,-1,29,-19,29,-43v0,-21,-12,-40,-30,-40"},"9":{"d":"150,-129v0,77,-17,134,-77,134v-38,0,-55,-26,-60,-65r40,-5v1,34,31,38,45,14v6,-10,9,-29,11,-58v-34,51,-100,1,-100,-62v0,-47,26,-88,68,-88v56,0,73,54,73,130xm77,-123v41,-1,36,-95,-2,-95v-37,1,-35,96,2,95"},":":{"d":"29,-137r0,-50r40,0r0,50r-40,0xm29,0r0,-49r40,0r0,49r-40,0","w":98},";":{"d":"28,-137r0,-50r40,0r0,50r-40,0xm28,-49r40,0v1,50,1,94,-36,106r-8,-20v15,-5,24,-16,23,-37r-19,0r0,-49","w":98},"\u037e":{"d":"28,-137r0,-50r40,0r0,50r-40,0xm28,-49r40,0v1,50,1,94,-36,106r-8,-20v15,-5,24,-16,23,-37r-19,0r0,-49","w":98},"<":{"d":"159,-29r-145,-77r0,-43r145,-76r0,50r-101,47r101,49r0,50","w":172},"=":{"d":"12,-143r0,-46r148,0r0,46r-148,0xm12,-65r0,-46r148,0r0,46r-148,0","w":172},">":{"d":"14,-29r0,-50r101,-48r-101,-48r0,-50r145,77r0,42","w":172},"?":{"d":"91,-260v54,0,93,55,68,105v-7,25,-58,42,-51,89r-36,0v-15,-65,51,-76,55,-122v2,-20,-16,-36,-35,-35v-22,0,-35,15,-40,44r-37,-6v1,-42,33,-75,76,-75xm72,0r0,-49r40,0r0,49r-40,0","w":180},"@":{"d":"157,43v48,0,80,-16,99,-46r31,0v-19,47,-63,79,-127,79v-100,-1,-151,-61,-151,-161v0,-99,49,-177,147,-177v79,0,121,56,123,135v2,60,-39,129,-95,127v-16,-1,-23,-6,-26,-20v-37,45,-99,6,-95,-53v4,-58,24,-118,78,-118v20,0,30,10,38,24r4,-19r38,0r-24,142v0,5,1,7,5,8v31,-9,51,-51,51,-92v0,-62,-34,-102,-97,-102v-82,0,-121,64,-121,148v0,77,42,126,122,125xm145,-159v-32,0,-44,50,-45,83v0,25,8,42,27,44v33,-4,42,-50,44,-86v1,-21,-9,-41,-26,-41","w":287},"A":{"d":"212,0r-46,0r-19,-59r-84,0r-18,59r-45,0r82,-258r45,0xm133,-102r-29,-96r-28,96r57,0","w":213,"k":{"\u2019":16,"y":11,"w":5,"v":11,"Y":27,"W":16,"V":22,"T":22," ":11}},"B":{"d":"198,-75v-4,60,-27,81,-105,75r-72,0r0,-258r85,0v86,-16,104,89,52,121v25,7,42,31,40,62xm147,-186v0,-39,-40,-27,-83,-29r0,60v41,-1,83,8,83,-31xm154,-77v0,-44,-46,-34,-90,-35r0,69v43,-1,90,10,90,-34","w":213},"C":{"d":"110,-40v29,0,41,-25,47,-55r41,16v-10,50,-35,83,-87,83v-66,0,-97,-60,-97,-131v0,-74,30,-135,99,-135v47,0,76,29,85,75r-43,13v-5,-25,-19,-44,-44,-44v-40,0,-53,38,-53,88v0,53,12,90,52,90","w":213},"D":{"d":"198,-126v0,74,-22,127,-97,126r-80,0r0,-258r78,0v81,0,99,53,99,132xm154,-128v2,-66,-17,-94,-90,-86r0,171r32,0v55,3,56,-34,58,-85","w":213},"E":{"d":"22,0r0,-258r156,0r0,44r-114,0r0,57r106,0r0,43r-106,0r0,71r118,0r0,43r-160,0","w":196},"F":{"d":"22,0r0,-258r145,0r0,44r-103,0r0,61r89,0r0,43r-89,0r0,110r-42,0","w":180,"k":{"A":16,".":33,",":33}},"G":{"d":"119,-40v20,0,39,-11,50,-22r0,-33r-49,0r0,-43r92,0r0,102v-16,20,-55,41,-91,40v-74,-2,-107,-57,-107,-133v0,-76,32,-132,105,-133v53,-1,83,29,90,76r-42,9v-6,-23,-22,-41,-48,-41v-42,0,-62,36,-61,86v0,51,16,92,61,92","w":229},"H":{"d":"22,0r0,-258r42,0r0,102r84,0r0,-102r43,0r0,258r-43,0r0,-113r-84,0r0,113r-42,0","w":213},"I":{"d":"20,0r0,-258r43,0r0,258r-43,0","w":82},"J":{"d":"72,-40v25,0,26,-17,26,-51r0,-167r42,0r0,163v1,63,-15,99,-70,99v-45,0,-65,-33,-65,-84r40,-5v0,27,7,45,27,45"},"K":{"d":"22,0r0,-258r43,0r0,115r86,-115r57,0r-79,101r84,157r-56,0r-58,-121r-34,43r0,78r-43,0","w":213},"L":{"d":"23,0r0,-256r42,0r0,213r106,0r0,43r-148,0","w":180,"k":{"\u2019":16,"y":11,"Y":27,"W":16,"V":22,"T":22," ":5}},"M":{"d":"21,0r0,-258r64,0r38,176r38,-176r64,0r0,258r-40,0r0,-203r-42,203r-41,0r-41,-203r0,203r-40,0","w":245},"N":{"d":"22,0r0,-258r41,0r87,172r0,-172r40,0r0,258r-43,0r-85,-168r0,168r-40,0","w":213},"O":{"d":"116,4v-71,0,-104,-58,-103,-131v1,-78,27,-135,102,-135v67,0,103,57,103,133v0,75,-33,132,-102,133xm116,-218v-42,0,-59,37,-59,89v0,50,18,89,59,89v41,0,58,-41,58,-90v0,-51,-17,-88,-58,-88","w":229},"P":{"d":"183,-178v3,69,-42,86,-119,81r0,97r-43,0r0,-258r69,0v72,-4,90,21,93,80xm139,-178v0,-39,-33,-37,-75,-36r0,73v42,1,75,3,75,-37","w":196,"k":{"A":22,".":38,",":38," ":5}},"Q":{"d":"116,-262v104,-5,127,157,76,229v10,9,22,16,34,22r-16,37v-23,-10,-17,-9,-47,-33v-83,37,-150,-26,-150,-122v0,-77,34,-130,103,-133xm57,-129v0,57,24,101,74,86v-9,-7,-17,-12,-26,-16r12,-29v14,6,27,14,40,26v30,-43,23,-160,-42,-156v-41,2,-58,39,-58,89","w":229},"R":{"d":"194,-186v2,41,-20,66,-55,72v34,24,50,73,72,114r-50,0r-54,-94v-9,-13,-20,-15,-43,-14r0,108r-42,0r0,-258r89,0v60,-3,81,20,83,72xm150,-182v4,-43,-45,-30,-86,-32r0,65v42,-2,91,11,86,-33","w":213,"k":{"Y":11,"W":5,"V":5}},"S":{"d":"153,-141v54,45,29,146,-56,146v-52,0,-80,-30,-86,-89r41,-5v-1,61,88,67,88,14v0,-40,-69,-36,-94,-56v-47,-38,-28,-137,50,-131v50,4,79,28,80,78r-42,2v4,-45,-75,-49,-75,-12v0,36,73,35,94,53","w":196},"T":{"d":"69,0r0,-214r-63,0r0,-44r168,0r0,44r-62,0r0,214r-43,0","w":180,"k":{"\u0119":22,"\u0105":22,"y":22,"w":22,"u":22,"s":22,"r":16,"o":22,"i":5,"e":22,"c":22,"a":22,"O":5,"A":22,";":33,":":33,".":33,"-":16,",":33}},"U":{"d":"108,4v-76,-3,-87,-37,-87,-124r0,-138r43,0r0,140v-2,53,2,73,43,78v39,-5,41,-23,40,-75r0,-143r43,0v-8,109,35,267,-82,262","w":213},"V":{"d":"75,0r-75,-258r46,0r54,191r51,-191r46,0r-76,258r-46,0","w":196,"k":{"\u0119":16,"\u0105":16,"y":11,"u":11,"r":16,"o":22,"i":5,"e":16,"a":16,"A":22,";":16,":":16,".":27,"-":16,",":27}},"W":{"d":"51,0r-50,-258r44,0r31,177r39,-177r51,0r37,180r32,-180r43,0r-51,258r-45,0r-43,-193r-41,193r-47,0","w":278,"k":{"\u0119":5,"\u0105":11,"y":5,"u":5,"r":5,"o":5,"i":2,"e":5,"a":11,"A":16,";":5,":":5,".":16,"-":6,",":16}},"X":{"d":"0,0r72,-134r-65,-124r50,0r42,83r42,-83r49,0r-66,125r73,133r-52,0r-47,-89r-47,89r-51,0","w":196},"Y":{"d":"77,0r0,-108r-77,-150r50,0r49,102r49,-102r49,0r-77,150r0,108r-43,0","w":196,"k":{"\u0119":16,"\u0105":16,"v":16,"u":16,"q":22,"p":16,"o":22,"i":11,"e":16,"a":16,"A":27,";":22,":":22,".":33,"-":16,",":33," ":5}},"Z":{"d":"3,0r0,-47r111,-167r-98,0r0,-44r154,0r0,41r-115,174r120,0r0,43r-172,0","w":180},"[":{"d":"21,73r0,-331r72,0r0,39r-34,0r0,253r34,0r0,39r-72,0","w":98},"\\":{"d":"0,-262r30,0r52,266r-30,0","w":82},"]":{"d":"77,-258r0,331r-72,0r0,-39r34,0r0,-253r-34,0r0,-39r72,0","w":98},"^":{"d":"17,-122r54,-140r32,0r53,140r-41,0r-29,-86r-28,86r-41,0","w":172},"_":{"d":"-2,27r168,0r0,18r-168,0r0,-18"},"`":{"d":"72,-210r-26,0r-40,-52r46,0","w":98},"a":{"d":"79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"b":{"d":"105,4v-22,0,-39,-14,-48,-31r0,27r-38,0r0,-258r41,0r0,93v40,-57,109,-7,109,71v0,53,-22,98,-64,98xm93,-153v-23,0,-33,25,-33,56v0,36,7,58,35,62v24,-3,33,-26,32,-58v0,-35,-7,-60,-34,-60","w":180},"c":{"d":"12,-93v0,-101,123,-138,143,-38r-40,8v-3,-20,-13,-29,-28,-29v-25,0,-33,22,-33,55v0,63,58,84,63,25r40,9v-8,45,-32,67,-71,67v-52,0,-74,-46,-74,-97"},"d":{"d":"12,-94v-10,-78,68,-129,109,-71r0,-93r41,0r0,258r-38,0r0,-27v-42,67,-121,12,-112,-67xm87,-153v-23,1,-34,25,-33,56v1,36,5,62,34,62v45,0,47,-120,-1,-118","w":180},"e":{"d":"51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0"},"f":{"d":"102,-221v-26,-9,-41,2,-36,34r31,0r0,39r-31,0r0,148r-40,0r0,-148r-22,0r0,-39r22,0v-2,-46,5,-76,47,-75v11,0,23,2,34,6","w":98,"k":{"\u2019":-5}},"g":{"d":"89,76v-46,0,-73,-18,-72,-64r47,7v1,14,7,19,23,19v38,0,35,-31,34,-68v-10,16,-24,30,-46,30v-42,0,-63,-46,-63,-94v0,-82,75,-130,112,-66r0,-27r38,0r0,168v0,64,-14,95,-73,95xm87,-153v-42,0,-47,112,-1,113v48,0,49,-113,1,-113","w":180},"h":{"d":"95,-153v-54,0,-26,99,-33,153r-41,0r0,-258r41,0r0,95v10,-15,24,-28,46,-28v77,0,46,115,52,191r-40,0r0,-99v-1,-38,2,-54,-25,-54","w":180},"i":{"d":"21,-212r0,-46r41,0r0,46r-41,0xm21,0r0,-187r41,0r0,187r-41,0","w":82},"j":{"d":"20,-212r0,-46r41,0r0,46r-41,0xm-6,28v24,5,27,-4,26,-37r0,-178r41,0r0,181v6,66,-20,94,-74,76","w":82},"k":{"d":"20,0r0,-258r40,0r0,137r48,-66r50,0r-53,69r56,118r-43,0r-39,-84r-19,24r0,60r-40,0"},"l":{"d":"21,0r0,-258r41,0r0,258r-41,0","w":82},"m":{"d":"55,-161v15,-36,79,-42,91,0v25,-50,97,-33,97,42r0,119r-40,0r0,-107v-1,-30,0,-43,-22,-46v-48,6,-24,100,-30,153r-40,0r0,-102v-2,-33,2,-49,-22,-51v-50,7,-23,99,-30,153r-41,0r0,-187r37,0r0,26","w":262},"n":{"d":"109,-191v78,0,44,117,51,191r-40,0r0,-95v1,-37,0,-53,-25,-58v-55,4,-26,98,-33,153r-41,0r0,-187r38,0r0,28v12,-19,25,-32,50,-32","w":180},"o":{"d":"91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"p":{"d":"169,-95v10,76,-67,133,-108,72r0,94r-41,0r0,-258r38,0r0,28v42,-69,120,-13,111,64xm95,-152v-24,0,-35,24,-35,55v0,34,9,62,35,62v44,0,46,-117,0,-117","w":180},"q":{"d":"78,-191v24,0,36,13,46,32r0,-28r38,0r0,258r-41,0r0,-94v-45,62,-108,4,-108,-72v0,-51,23,-96,65,-96xm88,-35v45,0,50,-117,1,-117v-25,0,-34,25,-34,59v0,34,7,58,33,58","w":180},"r":{"d":"106,-139v-44,-24,-46,26,-46,81r0,58r-40,0r0,-187r37,0r0,27v10,-29,35,-40,62,-22","w":114,"k":{"\u2019":-11,".":16,",":16}},"s":{"d":"138,-94v31,41,-1,98,-58,98v-41,0,-66,-22,-73,-57r41,-8v0,36,57,41,61,9v-1,-11,-5,-12,-16,-16v-54,-17,-74,-18,-80,-66v-6,-55,73,-71,110,-45v10,7,18,20,22,37r-38,9v0,-27,-53,-30,-57,-7v3,24,78,24,88,46"},"t":{"d":"95,-3v-44,18,-72,0,-72,-63r0,-81r-19,0r0,-40r19,0r0,-37r41,-29r0,66r27,0r0,40r-27,0r0,75v-2,33,2,40,27,31","w":98},"u":{"d":"86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"v":{"d":"63,0r-61,-187r42,0r37,127r38,-127r41,0r-60,187r-37,0","k":{".":22,",":22}},"w":{"d":"50,0r-49,-187r40,0r28,123r27,-123r39,0r25,123r30,-123r40,0r-50,187r-38,0r-27,-120r-26,120r-39,0","w":229,"k":{".":11,",":11}},"x":{"d":"2,0r55,-96r-53,-91r50,0r27,52r28,-52r48,0r-52,89r57,98r-50,0r-31,-58r-32,58r-47,0"},"y":{"d":"2,-187r43,0r37,133r35,-133r42,0v-27,80,-42,173,-78,244v-9,18,-40,23,-66,16r-3,-39v30,7,44,-5,48,-33","k":{".":22,",":22}},"z":{"d":"5,0r0,-38r78,-109v-21,2,-49,1,-72,1r0,-41r126,0r0,35r-79,110v31,-2,53,0,84,-1r0,43r-137,0","w":147},"{":{"d":"40,-4v0,-42,2,-64,-31,-68r0,-42v31,-4,31,-25,31,-63v0,-62,8,-87,67,-85r0,42v-24,0,-29,2,-29,25v0,39,1,87,-27,102v26,15,27,61,27,101v-1,24,7,24,29,26r0,42v-57,2,-67,-22,-67,-80","w":114},"|":{"d":"25,76r0,-338r33,0r0,338r-33,0","w":82},"}":{"d":"73,-183v0,42,-2,65,32,69r0,42v-31,4,-32,24,-32,62v0,64,-8,86,-66,86r0,-42v23,-1,28,-4,29,-26v1,-36,1,-88,27,-101v-28,-17,-27,-60,-27,-102v0,-23,-5,-25,-29,-25r0,-42v55,-1,66,20,66,79","w":114},"~":{"d":"120,-92v-23,1,-52,-25,-71,-24v-13,0,-26,9,-39,25r0,-46v27,-46,82,-11,113,0v17,-2,30,-12,40,-25r0,47v-9,10,-23,22,-43,23","w":172},"\u00c4":{"d":"58,-285r0,-42r34,0r0,42r-34,0xm120,-285r0,-42r35,0r0,42r-35,0xm212,0r-46,0r-19,-59r-84,0r-18,59r-45,0r82,-258r45,0xm133,-102r-29,-96r-28,96r57,0","w":213},"\u00c5":{"d":"106,-336v16,0,28,17,28,35v0,18,-12,34,-28,34v-16,0,-28,-17,-28,-34v0,-18,12,-35,28,-35xm106,-286v7,0,14,-8,13,-15v1,-9,-6,-16,-13,-16v-7,0,-14,7,-13,16v-1,7,6,15,13,15xm212,0r-46,0r-19,-59r-84,0r-18,59r-45,0r82,-258r45,0xm133,-102r-29,-96r-28,96r57,0","w":213},"\u00d6":{"d":"67,-285r0,-42r35,0r0,42r-35,0xm129,-285r0,-42r35,0r0,42r-35,0xm116,4v-71,0,-104,-58,-103,-131v1,-78,27,-135,102,-135v67,0,103,57,103,133v0,75,-33,132,-102,133xm116,-218v-42,0,-59,37,-59,89v0,50,18,89,59,89v41,0,58,-41,58,-90v0,-51,-17,-88,-58,-88","w":229},"\u00dc":{"d":"57,-285r0,-42r35,0r0,42r-35,0xm120,-285r0,-42r34,0r0,42r-34,0xm108,4v-76,-3,-87,-37,-87,-124r0,-138r43,0r0,140v-2,53,2,73,43,78v39,-5,41,-23,40,-75r0,-143r43,0v-8,109,35,267,-82,262","w":213},"\u00e1":{"d":"62,-210r20,-52r45,0r-39,52r-26,0xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e0":{"d":"79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25xm103,-210r-26,0r-40,-52r46,0"},"\u00e4":{"d":"34,-220r0,-42r35,0r0,42r-35,0xm96,-220r0,-42r35,0r0,42r-35,0xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e5":{"d":"82,-270v17,0,29,17,29,34v0,17,-13,35,-29,35v-36,0,-37,-69,0,-69xm82,-220v16,-1,17,-32,0,-32v-6,0,-14,7,-12,16v-2,8,6,16,12,16xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e7":{"d":"123,35v0,35,-46,45,-79,36r0,-21v21,2,50,6,51,-14v1,-16,-22,-18,-37,-12r4,-17v26,-12,61,-2,61,28xm12,-93v0,-101,123,-138,143,-38r-40,8v-3,-20,-13,-29,-28,-29v-25,0,-33,22,-33,55v0,63,58,84,63,25r40,9v-8,45,-32,67,-71,67v-52,0,-74,-46,-74,-97"},"\u00e9":{"d":"60,-210r20,-52r46,0r-40,52r-26,0xm51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0"},"\u00e8":{"d":"51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0xm102,-210r-26,0r-40,-52r46,0"},"\u00ed":{"d":"21,0r0,-187r41,0r0,187r-41,0xm21,-210r20,-52r45,0r-39,52r-26,0","w":82},"\u00ee":{"d":"-7,-210r30,-52r37,0r30,52r-32,0r-17,-26r-15,26r-33,0xm21,0r0,-187r41,0r0,187r-41,0","w":82},"\u00ef":{"d":"21,0r0,-187r41,0r0,187r-41,0xm-7,-220r0,-42r35,0r0,42r-35,0xm55,-220r0,-42r35,0r0,42r-35,0","w":82},"\u00f1":{"d":"69,-227v-8,1,-10,5,-10,15r-18,0v-1,-24,5,-44,26,-44v20,0,50,35,55,-1r18,0v0,26,-5,42,-25,44v-14,2,-35,-15,-46,-14xm109,-191v78,0,44,117,51,191r-40,0r0,-95v1,-37,0,-53,-25,-58v-55,4,-26,98,-33,153r-41,0r0,-187r38,0r0,28v12,-19,25,-32,50,-32","w":180},"\u00f3":{"d":"70,-210r20,-52r46,0r-40,52r-26,0xm91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"\u00f6":{"d":"42,-220r0,-42r35,0r0,42r-35,0xm104,-220r0,-42r35,0r0,42r-35,0xm91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"\u00f9":{"d":"86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154xm111,-210r-26,0r-40,-52r46,0","w":180},"\u00fb":{"d":"41,-210r30,-52r38,0r30,52r-33,0r-17,-26r-15,26r-33,0xm86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"\u00fc":{"d":"41,-220r0,-42r35,0r0,42r-35,0xm104,-220r0,-42r34,0r0,42r-34,0xm86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"\u00a3":{"d":"50,-45v31,-18,62,22,94,-5r16,42v-44,37,-104,-29,-143,12r-15,-42v19,-16,32,-38,30,-71r-30,0r0,-39r23,0v-19,-55,6,-115,61,-114v40,1,62,27,66,68r-39,7v-1,-49,-55,-44,-55,-3v0,12,2,26,7,42r45,0r0,39r-38,0v1,32,-7,41,-22,64"},"\u00df":{"d":"83,-223v-25,4,-22,22,-22,56r0,167r-41,0r0,-167v-2,-61,12,-92,63,-95v36,-2,57,21,59,53v1,15,-18,51,-18,61v0,30,50,52,46,92v7,61,-77,82,-98,27r28,-20v6,21,30,16,29,-4v1,-25,-52,-61,-48,-84v-2,-15,20,-51,19,-68v0,-9,-7,-19,-17,-18","w":180},"\u2122":{"d":"68,-114r0,-119r-37,0r0,-25r96,0r0,25r-35,0r0,119r-24,0xm141,-114r0,-144r38,0r21,99r22,-99r37,0r0,144r-23,0r0,-115r-25,115r-22,0r-25,-115r0,115r-23,0","w":295},"\u00ab":{"d":"91,-173r-37,79r37,82r-32,0r-45,-82r45,-79r32,0xm148,-173r-38,79r38,82r-32,0r-46,-82r46,-79r32,0"},"\u00bb":{"d":"72,-12r37,-80r-37,-81r32,0r45,81r-45,80r-32,0xm15,-12r38,-80r-38,-81r32,0r46,81r-46,80r-32,0"},"\u2026":{"d":"226,0r0,-49r40,0r0,49r-40,0xm127,0r0,-49r41,0r0,49r-41,0xm29,0r0,-49r41,0r0,49r-41,0","w":295},"\u2013":{"d":"-1,-75r0,-37r165,0r0,37r-165,0"},"\u2014":{"d":"0,-75r0,-37r295,0r0,37r-295,0","w":295},"\u201c":{"d":"127,-151r-40,0v-1,-51,-2,-95,36,-107r7,21v-15,6,-23,16,-22,37r19,0r0,49xm60,-151r-41,0v-1,-50,-2,-95,36,-107r8,21v-15,6,-23,17,-23,37r20,0r0,49","w":147},"\u201d":{"d":"86,-258r41,0v1,51,2,94,-36,107r-8,-20v15,-6,23,-17,23,-37r-20,0r0,-50xm18,-258r41,0v1,51,1,94,-36,107r-8,-20v15,-6,23,-17,23,-37r-20,0r0,-50","w":147},"\u2018":{"d":"63,-151r-41,0v-1,-50,-2,-95,36,-107r8,21v-15,6,-23,17,-23,37r20,0r0,49","w":82,"k":{"\u2018":11}},"\u2019":{"d":"20,-258r40,0v1,51,1,94,-36,107r-8,-20v15,-6,24,-16,23,-37r-19,0r0,-50","w":82,"k":{"\u2019":11,"s":11," ":16}},"\u00ff":{"d":"33,-220r0,-42r35,0r0,42r-35,0xm95,-220r0,-42r35,0r0,42r-35,0xm2,-187r43,0r37,133r35,-133r42,0v-27,80,-42,173,-78,244v-9,18,-40,23,-66,16r-3,-39v30,7,44,-5,48,-33"},"\u20ac":{"d":"17,-168v7,-67,71,-116,138,-83r-8,48v-30,-28,-81,-13,-86,35r79,0r-5,27r-77,0r0,23r74,0r-5,28r-65,0v6,56,62,64,92,29r0,54v-67,33,-131,-15,-137,-83r-22,0r5,-28r14,0r0,-23r-19,0r5,-27r17,0"},"\u0142":{"d":"21,-127r0,-131r41,0r0,89r20,-20r0,33r-20,21r0,135r-41,0r0,-93r-19,20r0,-33","w":82},"\u00d7":{"d":"16,-74r43,-53r-43,-53r26,-33r44,53r44,-53r26,32r-44,53r44,54r-26,33r-44,-54r-44,53","w":172},"\u0107":{"d":"68,-210r20,-52r45,0r-39,52r-26,0xm12,-93v0,-101,123,-138,143,-38r-40,8v-3,-20,-13,-29,-28,-29v-25,0,-33,22,-33,55v0,63,58,84,63,25r40,9v-8,45,-32,67,-71,67v-52,0,-74,-46,-74,-97"},"\u0105":{"d":"172,68v-29,18,-66,4,-64,-33v0,-10,2,-24,6,-40r21,0v-5,20,-6,55,18,54v6,0,12,-2,19,-5r0,24xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u0119":{"d":"134,68v-29,18,-66,4,-64,-33v0,-10,2,-24,6,-40r21,0v-5,20,-6,55,18,54v6,0,12,-2,19,-5r0,24xm51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0"},"\u015b":{"d":"55,-210r20,-52r46,0r-40,52r-26,0xm138,-94v31,41,-1,98,-58,98v-41,0,-66,-22,-73,-57r41,-8v0,36,57,41,61,9v-1,-11,-5,-12,-16,-16v-54,-17,-74,-18,-80,-66v-6,-55,73,-71,110,-45v10,7,18,20,22,37r-38,9v0,-27,-53,-30,-57,-7v3,24,78,24,88,46"},"\u017a":{"d":"50,-210r20,-52r45,0r-39,52r-26,0xm5,0r0,-38r78,-109v-21,2,-49,1,-72,1r0,-41r126,0r0,35r-79,110v31,-2,53,0,84,-1r0,43r-137,0","w":147},"\u017c":{"d":"56,-220r0,-46r40,0r0,46r-40,0xm5,0r0,-38r78,-109v-21,2,-49,1,-72,1r0,-41r126,0r0,35r-79,110v31,-2,53,0,84,-1r0,43r-137,0","w":147},"\u2032":{"d":"21,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":70},"\u2033":{"d":"24,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0xm89,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":140},"\u00a0":{"w":82,"k":{"Y":5,"A":11}}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2006 Microsoft Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Georgia is either a registered trademark or a trademark of Microsoft
 * Corporation in the United States and/or other countries.
 * 
 * Manufacturer:
 * Carter & Cone
 * 
 * Designer:
 * Matthew Carter
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":231,"face":{"font-family":"Georgia","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 4 5 2 5 4 5 2 3 3","ascent":"288","descent":"-72","x-height":"5","bbox":"-26.4684 -328 356 78.3485","underline-thickness":"17.7539","underline-position":"-23.0273","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":86},"\u00a0":{"w":86},"!":{"d":"38,-232v-2,-21,26,-32,39,-17v4,5,6,10,6,17r-16,156r-14,0xm60,-44v13,0,25,12,25,24v0,13,-12,24,-25,24v-13,0,-24,-12,-24,-24v0,-12,11,-24,24,-24","w":119},"\"":{"d":"108,-269v12,0,19,10,19,20v0,23,-9,49,-14,79r-11,0r-14,-79v1,-11,7,-20,20,-20xm41,-269v12,0,19,10,19,20v0,23,-9,49,-14,79r-11,0r-14,-79v1,-11,7,-20,20,-20","w":148},"#":{"d":"204,-131r-43,0r-13,44r46,0r0,22r-52,0r-19,65r-19,0r18,-65r-38,0r-19,65r-19,0r19,-65r-38,0r0,-22r44,0r13,-44r-46,0r0,-22r52,0r18,-63r20,0r-19,63r38,0r19,-63r19,0r-18,63r37,0r0,22xm142,-131r-39,0r-13,45r39,0"},"$":{"d":"173,-160v-23,0,-21,-20,-16,-38v-6,-10,-20,-16,-37,-16r0,82v32,15,74,21,74,68v0,39,-36,65,-74,67r0,50r-15,0r0,-50v-41,1,-77,-21,-78,-56v0,-12,5,-22,18,-21v27,-1,18,26,12,43v7,13,26,21,48,20r0,-88v-31,-12,-71,-23,-71,-68v0,-34,35,-62,71,-61r0,-40r15,0r0,40v37,1,69,16,69,49v0,11,-3,19,-16,19xm105,-214v-44,-3,-55,63,-11,73r11,5r0,-78xm120,-11v26,-1,41,-14,41,-39v-1,-27,-18,-38,-41,-46r0,85","w":219},"%":{"d":"79,-255v36,0,60,29,60,65v0,40,-23,65,-60,65v-37,0,-60,-26,-60,-65v0,-37,24,-65,60,-65xm79,-138v41,-2,41,-102,0,-104v-40,0,-43,104,0,104xm216,-124v37,0,59,28,59,65v0,40,-23,65,-60,65v-37,0,-59,-25,-59,-65v0,-37,23,-65,60,-65xm215,-7v41,0,42,-103,1,-104v-43,0,-42,102,-1,104xm263,-250r-207,250r-24,0r207,-250r24,0","w":294},"&":{"d":"192,-130v-3,-11,-16,-12,-30,-16r0,-12r94,0r0,12v-54,2,-52,61,-79,91v17,21,40,42,76,43r0,12r-72,0r-27,-30v-17,18,-35,36,-69,36v-43,0,-72,-23,-72,-67v0,-41,23,-55,55,-77v-15,-22,-30,-33,-30,-63v0,-35,25,-54,61,-54v33,0,55,17,55,49v0,34,-24,49,-49,63v20,29,41,51,63,77v12,-20,23,-39,24,-64xm97,-153v36,-9,51,-82,4,-87v-46,8,-28,64,-4,87xm75,-127v-41,22,-32,112,24,109v20,0,37,-10,46,-22","w":255},"'":{"d":"19,-249v-2,-17,25,-28,34,-14v16,24,-8,63,-9,93r-11,0","w":77},"(":{"d":"54,-104v1,75,14,134,69,147r0,15v-108,-5,-126,-194,-75,-278v18,-28,43,-45,75,-49r0,14v-54,13,-70,73,-69,151","w":135},")":{"d":"12,-269v107,5,126,193,75,278v-18,28,-43,45,-75,49r0,-15v55,-13,68,-72,69,-147v1,-78,-15,-137,-69,-151r0,-14","w":135},"*":{"d":"90,-196v25,1,58,-24,65,3v-6,26,-43,1,-65,3v11,18,30,26,37,47v0,6,-8,12,-14,12v-21,-9,-14,-32,-28,-56v-14,22,-6,48,-28,56v-6,0,-14,-5,-13,-12v5,-21,25,-28,36,-47v-23,-3,-59,23,-65,-3v7,-27,41,-1,65,-3v-12,-16,-29,-27,-36,-48v-1,-6,8,-12,13,-12v21,5,16,39,28,57v13,-20,8,-49,28,-57v5,1,14,6,14,12v-6,20,-23,26,-37,48","w":169},"+":{"d":"206,-87r-79,0r0,79r-22,0r0,-79r-80,0r0,-22r80,0r0,-80r22,0r0,80r79,0r0,22"},",":{"d":"45,-44v41,0,34,64,12,81v-8,11,-21,19,-32,25r-8,-12v20,-12,35,-25,40,-50v-20,1,-34,-5,-34,-23v0,-10,10,-21,22,-21","w":97},"-":{"d":"120,-82r-105,0r0,-27r105,0r0,27","w":134},"\u00ad":{"d":"120,-82r-105,0r0,-27r105,0r0,27","w":134},".":{"d":"49,-44v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24","w":97},"\/":{"d":"153,-268r-122,343r-22,0r121,-343r23,0","w":168},"0":{"d":"111,-194v62,0,92,40,92,100v0,62,-32,100,-93,100v-61,0,-92,-39,-92,-100v0,-61,32,-100,93,-100xm110,-6v74,0,73,-178,1,-176v-40,1,-55,40,-54,88v0,45,14,88,53,88","w":220},"1":{"d":"101,-36v-1,20,23,22,41,24r0,12r-118,0r0,-12v17,-3,43,1,43,-22r0,-123r-44,0r0,-15v29,3,54,-9,65,-22r15,0","w":154},"2":{"d":"175,-135v0,72,-88,65,-126,104r135,0r0,31r-165,0v-1,-80,117,-48,117,-137v0,-46,-58,-55,-79,-26v7,19,9,47,-17,46v-13,0,-19,-10,-19,-23v0,-35,36,-52,76,-54v43,-1,78,20,78,59","w":201},"3":{"d":"180,-12v5,82,-156,108,-169,26v-2,-12,6,-23,18,-23v25,0,24,26,17,44v32,31,104,10,95,-47v2,-41,-26,-54,-71,-50r0,-20v43,4,61,-13,61,-54v0,-47,-53,-56,-76,-27v5,17,11,49,-17,46v-12,0,-18,-11,-18,-22v0,-37,36,-54,78,-55v43,0,69,20,72,57v3,39,-27,49,-52,63v35,5,59,21,62,62","w":198},"4":{"d":"191,-16r-36,0r0,80r-34,0r0,-80r-112,0r0,-27r123,-150r23,0r0,154r36,0r0,23xm121,-39r0,-115r-95,115r95,0","w":203},"5":{"d":"47,-83v46,-34,128,-10,128,60v0,50,-40,87,-91,87v-36,0,-71,-19,-74,-48v-2,-28,39,-29,40,-5v0,6,-3,21,-5,26v40,31,101,0,92,-60v6,-57,-72,-75,-98,-34r-12,-5r15,-127r126,0r0,32r-112,0","w":190},"6":{"d":"118,-160v40,0,73,38,71,79v-2,52,-35,86,-85,87v-102,2,-105,-150,-49,-210v26,-28,59,-46,101,-52r3,16v-59,10,-92,47,-102,104v17,-15,34,-23,61,-24xm104,-8v32,0,47,-31,47,-68v0,-35,-16,-63,-48,-63v-27,0,-48,10,-48,43v0,44,13,88,49,88","w":203},"7":{"d":"152,-159v-54,4,-127,-18,-126,39r-10,0r0,-69r165,0r0,12r-125,241r-22,0","w":180},"8":{"d":"141,-132v31,15,55,28,55,66v0,44,-43,72,-92,72v-47,0,-86,-26,-86,-70v0,-36,24,-51,55,-63v-25,-14,-45,-30,-45,-62v0,-39,41,-67,83,-67v42,0,76,25,76,64v0,29,-21,49,-46,60xm129,-138v37,-20,34,-104,-21,-104v-39,0,-61,52,-30,76v10,9,26,18,51,28xm108,-8v47,0,71,-58,35,-84v-15,-10,-38,-21,-58,-29v-49,19,-40,113,23,113","w":214},"9":{"d":"100,-194v100,0,105,152,48,208v-25,24,-57,46,-100,51r-4,-16v59,-10,93,-45,103,-102v-44,46,-132,17,-132,-55v0,-47,38,-86,85,-86xm101,-50v26,0,47,-9,47,-43v0,-44,-13,-88,-49,-88v-31,0,-46,32,-46,68v0,35,16,63,48,63","w":203},":":{"d":"56,-174v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24xm56,-44v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24","w":112},";":{"d":"56,-174v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24xm53,-44v41,0,34,64,12,81v-8,11,-21,19,-32,25r-8,-12v20,-12,35,-25,40,-50v-20,1,-34,-5,-34,-23v0,-10,10,-21,22,-21","w":112},"\u037e":{"d":"56,-174v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24xm53,-44v41,0,34,64,12,81v-8,11,-21,19,-32,25r-8,-12v20,-12,35,-25,40,-50v-20,1,-34,-5,-34,-23v0,-10,10,-21,22,-21","w":112},"<":{"d":"197,-4r-163,-84r0,-20r163,-85r0,24r-136,71r136,70r0,24"},"=":{"d":"204,-120r-177,0r0,-22r177,0r0,22xm204,-55r-177,0r0,-22r177,0r0,22"},">":{"d":"198,-88r-163,84r0,-24r135,-70r-135,-71r0,-24r163,85r0,20"},"?":{"d":"79,-255v47,0,76,26,76,72v0,46,-34,73,-78,78r0,39r-16,0r0,-67v35,-3,60,-15,60,-54v0,-43,-33,-66,-67,-47v7,17,6,44,-18,41v-11,-1,-17,-10,-17,-22v2,-28,30,-40,60,-40xm69,-44v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24","w":172},"@":{"d":"175,41v39,0,66,-10,88,-29r6,9v-23,20,-54,36,-96,34v-85,-3,-143,-50,-143,-139v0,-94,62,-157,158,-157v74,0,115,43,118,115v1,52,-34,102,-83,102v-22,0,-34,-13,-39,-29v-9,15,-21,27,-41,28v-28,-1,-42,-18,-40,-48v3,-49,32,-91,82,-95v16,-2,23,11,28,22r7,-20r26,0v-11,39,-29,72,-36,114v-2,11,6,17,16,17v41,-1,66,-45,64,-93v-3,-62,-38,-98,-103,-98v-80,0,-129,56,-129,139v0,78,38,128,117,128xm133,-70v0,53,46,27,55,-1r20,-59v-3,-16,-8,-27,-24,-28v-37,6,-51,49,-51,88","w":334},"A":{"d":"51,-28v1,11,22,16,36,16r0,12r-94,0r0,-12v20,-4,34,-13,41,-31r82,-210r14,0r89,226v5,9,18,14,31,15r0,12r-104,0r0,-12v15,-3,36,-1,30,-18r-20,-56r-88,0v-7,20,-15,36,-17,58xm149,-102r-38,-97r-37,97r75,0","w":241},"B":{"d":"146,-133v38,5,73,22,73,65v0,87,-115,66,-202,68r0,-12v15,-2,34,-4,34,-22r0,-179v1,-19,-18,-22,-33,-24r0,-12v76,5,185,-23,188,54v1,40,-32,50,-60,62xm88,-139v46,3,75,-8,75,-53v0,-41,-34,-48,-75,-43r0,96xm122,-14v36,-2,54,-22,54,-60v1,-43,-40,-57,-88,-50v5,43,-20,113,34,110","w":235},"C":{"d":"227,-63v-17,44,-46,69,-100,69v-72,0,-109,-53,-113,-128v-5,-102,96,-164,180,-115v4,-7,8,-15,22,-12r1,89r-14,0v-10,-37,-23,-80,-68,-80v-58,0,-79,53,-79,115v0,61,25,111,84,111v40,0,61,-25,73,-55"},"D":{"d":"127,-249v78,4,129,44,129,126v0,81,-56,123,-136,123r-103,0r0,-12v17,0,35,-3,34,-21r0,-180v2,-19,-17,-22,-33,-24r0,-12r109,0xm126,-14v63,0,87,-44,87,-109v0,-75,-42,-121,-125,-111r0,191v0,24,14,29,38,29","w":269},"E":{"d":"131,-14v54,9,72,-26,83,-59r13,0r-5,73r-207,0r0,-12v17,-1,36,-3,36,-22r0,-179v2,-20,-20,-22,-36,-24r0,-12r193,0r0,60r-13,0v-7,-26,-28,-53,-68,-47r-39,0r0,100v42,4,69,-4,69,-41r13,0r0,97r-13,0v-1,-36,-26,-47,-69,-42v4,48,-19,120,43,108","w":235},"F":{"d":"51,-213v2,-20,-20,-22,-36,-24r0,-12r196,0r0,62r-13,0v-8,-25,-26,-49,-68,-49r-42,0r0,101v41,3,72,-2,71,-41r14,0r0,98r-14,0v1,-38,-27,-48,-71,-43r0,86v-2,19,19,21,35,23r0,12r-108,0r0,-12v16,-2,36,-2,36,-21r0,-180","w":215},"G":{"d":"14,-123v-5,-103,104,-162,189,-114v4,-7,8,-15,22,-12r1,87r-14,0v-9,-40,-26,-78,-74,-78v-61,0,-82,53,-82,116v0,63,25,112,87,114v37,1,56,-17,48,-63v3,-24,-23,-25,-42,-27r0,-12r110,0r0,12v-41,-5,-34,44,-32,84v-28,12,-56,22,-92,22v-75,0,-117,-51,-121,-129","w":261},"H":{"d":"17,-12v14,-2,34,-2,34,-21r0,-180v0,-18,-18,-22,-34,-24r0,-12r104,0r0,12v-15,2,-33,2,-33,22r0,77r117,0r0,-75v2,-19,-18,-22,-33,-24r0,-12r103,0r0,12v-15,2,-32,3,-32,22r0,180v-1,18,16,21,32,23r0,12r-103,0r0,-12v13,-2,33,-1,33,-21r0,-89r-117,0r0,87v-1,18,17,21,33,23r0,12r-104,0r0,-12","w":293},"I":{"d":"14,-12v14,-3,37,0,37,-21r0,-181v1,-19,-21,-20,-37,-23r0,-12r112,0r0,12v-18,1,-37,2,-37,22r0,180v-1,20,20,21,37,23r0,12r-112,0r0,-12","w":140},"J":{"d":"104,-213v1,-20,-20,-22,-37,-24r0,-12r110,0r0,12v-17,1,-35,2,-35,22r0,148v-3,43,-30,72,-76,73v-37,1,-64,-23,-64,-59v0,-34,47,-43,47,-9v0,18,-13,26,-18,40v6,8,17,15,33,15v37,-1,40,-35,40,-74r0,-132","w":186},"K":{"d":"18,-12v14,-2,33,-3,33,-21r0,-180v1,-19,-18,-22,-33,-24r0,-12r103,0r0,12v-15,2,-33,2,-33,22r0,86r4,0v30,-29,71,-58,85,-99v-3,-7,-15,-9,-26,-9r0,-12r94,0v5,22,-31,10,-41,27r-77,82r81,99v13,15,26,27,51,29r0,12r-70,0v-28,-42,-62,-85,-96,-122r-5,0r0,87v-1,18,17,21,33,23r0,12r-103,0r0,-12","w":249},"L":{"d":"129,-14v52,0,62,-32,76,-60r12,0r-5,74r-195,0r0,-12v16,-2,34,-3,34,-22r0,-179v1,-18,-18,-21,-34,-24r0,-12r106,0r0,12v-16,2,-35,3,-35,23r0,167v-3,31,11,33,41,33","w":217},"M":{"d":"283,-35v-2,19,18,21,34,23r0,12r-110,0r0,-12v17,-2,39,-2,39,-23r0,-182r-3,0r-85,213r-8,0r-81,-217r-3,0r0,149v-3,40,11,57,43,60r0,12r-101,0r0,-12v33,-2,41,-16,41,-58r0,-128v2,-28,-16,-37,-39,-39r0,-12r85,0r71,187r70,-187r81,0r0,12v-15,2,-34,2,-34,22r0,180","w":333},"N":{"d":"49,-194v1,-28,-22,-40,-45,-43r0,-12r71,0r141,190v-4,-55,11,-131,-11,-168v-5,-3,-25,-9,-33,-10r0,-12r101,0r0,12v-16,3,-38,4,-38,25v0,66,-1,144,-2,214r-16,0r-151,-204r0,129v1,32,1,53,28,57v8,2,14,4,17,4r0,12r-103,0r0,-12v15,-4,38,-6,39,-24v5,-44,1,-109,2,-158","w":276},"O":{"d":"134,-255v77,0,120,52,120,131v0,77,-44,130,-120,130v-76,0,-120,-52,-120,-130v0,-78,44,-131,120,-131xm134,-10v59,0,77,-52,77,-114v0,-63,-18,-116,-77,-116v-60,0,-77,54,-77,116v0,62,17,114,77,114","w":267},"P":{"d":"16,-249v81,2,192,-19,192,61v0,62,-51,83,-120,78r0,76v-2,20,19,20,36,22r0,12r-107,0r0,-12v16,-2,34,-3,34,-22r0,-180v1,-19,-18,-22,-35,-23r0,-12xm88,-125v47,3,77,-12,77,-54v1,-44,-28,-61,-77,-56r0,110","w":219},"Q":{"d":"134,-255v77,0,120,52,120,131v0,66,-34,104,-82,123v-1,37,39,60,77,47r0,14v-50,19,-120,3,-119,-54v-74,-6,-116,-54,-116,-130v0,-78,44,-131,120,-131xm134,-10v59,0,77,-52,77,-114v0,-63,-18,-116,-77,-116v-60,0,-77,54,-77,116v0,62,17,114,77,114","w":267},"R":{"d":"211,-190v1,43,-27,57,-61,67v29,35,51,79,87,106v5,3,17,4,23,5r0,12r-67,0r-79,-113r-26,0r0,79v-2,20,18,20,35,22r0,12r-106,0r0,-12v16,-2,34,-3,34,-22r0,-180v2,-19,-19,-21,-34,-23r0,-12v79,5,193,-23,194,59xm88,-128v47,5,80,-15,80,-58v0,-42,-34,-53,-80,-49r0,107","w":252},"S":{"d":"56,-203v7,78,132,44,132,132v0,70,-96,96,-147,58v-4,8,-8,16,-22,13r-2,-85r14,0v12,39,28,75,75,75v30,0,49,-13,47,-44v-4,-80,-129,-42,-129,-133v0,-67,88,-84,131,-50v3,-8,7,-15,21,-12r1,82r-14,0v-11,-35,-21,-72,-66,-73v-21,0,-43,16,-41,37","w":201},"T":{"d":"93,-236v-50,-7,-67,22,-78,54r-12,0r0,-67r217,0r0,67r-12,0v-11,-32,-28,-61,-78,-54r0,200v-1,20,23,21,40,24r0,12r-118,0r0,-12v16,-3,41,-1,41,-23r0,-201","w":222},"U":{"d":"145,-14v92,0,67,-114,64,-197v-1,-21,-23,-23,-41,-26r0,-12r101,0r0,12v-66,-2,-35,103,-40,164v-5,52,-39,79,-90,79v-52,0,-93,-23,-93,-72r0,-147v2,-19,-18,-22,-33,-24r0,-12r104,0r0,12v-16,2,-35,4,-34,22v7,81,-30,201,62,201","w":272},"V":{"d":"191,-211v6,-23,-18,-25,-36,-26r0,-12r92,0r0,12v-20,2,-32,13,-38,30r-84,210r-15,0r-80,-216v-5,-15,-19,-23,-37,-24r0,-12r104,0r0,12v-16,1,-37,0,-30,18r63,167","w":239},"W":{"d":"279,-133v6,-35,52,-105,-13,-104r0,-12r90,0r0,12v-53,10,-52,80,-66,125r-36,115r-16,0r-63,-192r-65,192r-16,0r-65,-226v-5,-8,-18,-13,-30,-14r0,-12r102,0r0,12v-16,2,-38,-1,-31,19r45,157r62,-185r18,0r62,189v13,-44,16,-42,22,-76","w":351},"X":{"d":"169,-197v20,-26,22,-40,-14,-40r0,-12r93,0r0,12v-44,1,-56,37,-75,63r-29,39r77,109v9,11,18,13,35,14r0,12r-117,0r0,-12v19,-1,41,-2,29,-21v-15,-25,-32,-50,-47,-74v-14,21,-49,65,-55,83v3,11,12,11,29,12r0,12r-93,0r0,-12v49,-7,50,-35,78,-68v19,-22,17,-23,31,-42r-71,-102v-6,-8,-22,-12,-35,-13r0,-12r115,0r0,12v-15,2,-41,0,-28,21r43,67","w":255},"Y":{"d":"177,-224v-2,-13,-20,-11,-33,-13r0,-12r87,0r0,12v-36,5,-47,39,-63,64v-23,37,-40,68,-40,136v0,21,23,22,40,25r0,12r-117,0r0,-12v16,-2,42,-1,40,-23v-2,-33,4,-66,-12,-87v-29,-38,-32,-103,-87,-115r0,-12r107,0r0,12v-21,1,-40,1,-29,19r51,93v16,-28,47,-71,56,-99","w":221},"Z":{"d":"104,-236v-46,-5,-63,28,-77,57r-12,0r7,-70r187,0r0,6r-157,229v36,-3,90,6,113,-9v15,-10,30,-38,36,-55r12,0r-8,78r-200,0r0,-6r157,-230r-58,0","w":216},"[":{"d":"123,54r-93,0r0,-321r93,0r0,16r-62,0r0,289r62,0r0,16","w":135},"\\":{"d":"160,75r-23,0r-121,-343r23,0","w":168},"]":{"d":"105,54r-93,0r0,-16r62,0r0,-289r-62,0r0,-16r93,0r0,321","w":135},"^":{"d":"198,-140r-26,0r-56,-92r-57,92r-25,0r72,-116r20,0"},"_":{"d":"232,50r-233,0r0,-18r233,0r0,18"},"`":{"d":"60,-246v-9,-15,9,-32,24,-21v19,22,26,38,46,66r-7,6","w":180},"a":{"d":"148,-77v0,27,-12,70,29,63r0,11v-24,13,-57,7,-62,-19v-20,35,-101,38,-101,-17v0,-55,68,-51,101,-72v1,-30,-3,-54,-33,-54v-9,0,-21,4,-25,8v5,16,6,39,-17,39v-12,0,-17,-10,-18,-20v5,-26,32,-38,62,-40v61,-5,64,39,64,101xm49,-43v-1,39,53,31,65,8r1,-61v-30,11,-64,15,-66,53","w":181},"b":{"d":"65,-155v45,-52,124,-5,124,68v0,71,-78,118,-136,76v-7,8,-9,25,-24,18r2,-238v1,-19,-16,-26,-34,-26r0,-11r64,-4v8,32,-4,85,4,117xm104,-8v62,0,69,-151,-3,-151v-18,1,-28,8,-38,18r0,101v6,17,18,32,41,32","w":201},"c":{"d":"163,-40v-13,24,-40,44,-70,45v-52,2,-81,-39,-80,-92v1,-53,30,-89,82,-91v31,-1,58,15,58,45v0,27,-43,30,-40,6r4,-29v-4,-8,-13,-9,-23,-9v-66,0,-60,150,7,150v27,0,39,-14,50,-33","w":163},"d":{"d":"13,-87v0,-70,66,-111,126,-80r0,-60v2,-25,-18,-29,-41,-30r0,-11r71,-4r3,3r0,233v-1,17,12,22,30,21r0,12v-20,-1,-48,8,-63,1v-1,-5,2,-13,-1,-16v-46,49,-125,7,-125,-69xm100,-14v19,0,30,-10,39,-20r0,-101v-6,-16,-17,-30,-40,-30v-66,3,-70,150,1,151","w":206},"e":{"d":"105,-15v26,0,37,-12,49,-33r13,7v-14,25,-37,46,-72,46v-55,0,-82,-37,-82,-93v0,-51,28,-90,79,-90v51,0,72,33,70,86r-114,0v0,44,14,77,57,77xm128,-107v-1,-29,-6,-58,-36,-58v-29,1,-43,26,-44,58r80,0","w":174},"f":{"d":"110,-272v32,-3,44,35,15,40v-16,-1,-22,-16,-29,-26v-26,5,-24,48,-25,85r45,0r0,17r-45,0r0,125v-1,17,17,19,33,19r0,12r-91,0r0,-12v15,1,25,-3,25,-18r0,-126r-34,0r0,-17r34,0v-4,-55,25,-95,72,-99","w":117},"g":{"d":"76,-34v50,0,101,1,100,52v-1,47,-41,58,-90,60v-44,1,-77,-9,-79,-45v-1,-28,28,-35,50,-42v-15,-5,-31,-10,-30,-31v1,-17,11,-24,26,-30r0,-3v-19,-9,-35,-23,-35,-49v-1,-45,53,-67,97,-51r60,0r0,17v-13,1,-30,-2,-41,1v34,42,-6,103,-70,89v-22,8,-12,32,12,32xm82,-78v22,0,32,-20,32,-43v0,-24,-10,-45,-32,-45v-23,0,-30,19,-30,44v0,23,10,44,30,44xm92,65v31,1,55,-11,55,-40v0,-36,-45,-23,-74,-28v-22,4,-35,13,-35,35v0,25,25,32,54,33","w":183},"h":{"d":"176,-31v0,15,10,19,25,19r0,12r-85,0r0,-12v16,1,28,-3,27,-18v-3,-48,16,-127,-30,-127v-22,0,-37,12,-45,26r0,100v-1,15,12,19,26,19r0,12r-85,0r0,-12v16,1,27,-3,26,-18r0,-201v1,-19,-16,-26,-34,-26r0,-11v21,1,50,-8,67,-1r0,120v16,-15,29,-28,59,-29v65,-1,47,85,49,147","w":209},"i":{"d":"71,-32v0,15,12,20,26,20r0,12r-84,0r0,-12v15,1,25,-3,25,-18r0,-107v1,-18,-14,-21,-30,-23r0,-12v20,1,46,-6,63,-1r0,141xm52,-266v14,0,22,11,23,22v0,13,-10,25,-23,25v-12,0,-22,-11,-22,-23v0,-12,9,-24,22,-24","w":105},"j":{"d":"43,-135v1,-20,-22,-23,-39,-26r0,-11v23,1,52,-6,72,-1v-6,100,29,242,-71,251v-32,3,-44,-37,-15,-40v17,-2,22,16,28,25v25,-4,25,-33,25,-68r0,-130xm56,-266v14,0,22,11,22,22v1,13,-9,25,-22,25v-12,0,-23,-12,-23,-23v0,-12,10,-24,23,-24","w":105},"k":{"d":"129,-152v0,-7,-15,-9,-22,-10r0,-11r76,0r0,11v-36,10,-55,32,-77,55v23,26,47,67,72,92v4,2,10,3,18,3r0,12r-52,0r-62,-87r-14,14v0,29,-7,65,26,61r0,12r-85,0r0,-12v16,1,27,-3,26,-18r0,-201v0,-18,-14,-27,-34,-26r0,-11v21,1,50,-8,67,-1r0,183v20,-22,43,-42,61,-66","w":192},"l":{"d":"68,-32v0,15,12,20,26,20r0,12r-85,0r0,-12v16,1,27,-3,26,-18r0,-200v2,-20,-17,-26,-35,-27r0,-11r66,-4v7,74,2,162,2,240","w":103},"m":{"d":"283,-31v0,16,13,18,27,19r0,12r-85,0r0,-12v15,1,26,-3,25,-18v-4,-47,17,-124,-29,-127v-23,-1,-36,12,-44,26r0,100v0,15,11,18,25,19r0,12r-82,0r0,-12v15,1,25,-3,24,-18v-4,-47,17,-124,-29,-127v-21,-1,-37,14,-44,26r0,99v-1,15,12,20,26,20r0,12r-84,0r0,-12v15,1,26,-3,25,-18r0,-107v0,-17,-13,-21,-28,-23r0,-12v19,1,44,-6,60,-1v1,8,-3,21,2,25v17,-33,92,-43,104,1v14,-15,30,-31,60,-31v64,-3,47,86,47,147","w":317},"n":{"d":"179,-31v0,15,11,18,25,19r0,12r-85,0r0,-12v16,1,28,-3,27,-18v-3,-48,16,-127,-30,-127v-22,0,-37,12,-45,26r0,100v-1,16,13,18,27,19r0,12r-85,0r0,-12v15,1,26,-3,25,-18r0,-107v0,-16,-11,-23,-27,-23r0,-12v19,0,44,-6,60,-1v1,7,-2,18,1,24v14,-15,29,-28,58,-29v67,-2,49,85,49,147","w":212},"o":{"d":"98,-178v50,-1,86,38,84,90v-2,55,-31,93,-87,93v-53,0,-82,-37,-83,-91v-1,-52,35,-92,86,-92xm98,-8v63,0,67,-157,0,-157v-38,0,-48,36,-49,76v0,43,10,81,49,81","w":194},"p":{"d":"118,-178v50,2,73,39,75,91v3,69,-67,112,-125,80r0,52v-1,19,18,20,35,21r0,12r-97,0r0,-12v16,0,30,-2,29,-19r0,-184v-2,-15,-12,-23,-29,-23r0,-12v20,1,45,-6,61,-1v1,6,-2,17,2,20v10,-12,29,-26,49,-25xm108,-8v67,0,65,-149,-2,-151v-19,-1,-30,10,-38,20r0,102v6,16,19,29,40,29","w":205},"q":{"d":"13,-89v-4,-74,84,-112,137,-71v8,-8,9,-27,25,-21v-5,71,-2,149,-3,225v0,18,15,21,31,22r0,12r-94,0r0,-12v16,-1,31,-2,30,-19v-1,-21,2,-45,-1,-64v-13,11,-25,23,-49,22v-50,-3,-73,-40,-76,-94xm49,-85v0,58,55,93,90,53r0,-104v-7,-15,-19,-29,-41,-29v-33,0,-49,39,-49,80","w":201},"r":{"d":"120,-178v27,-3,36,49,7,50v-18,1,-23,-14,-18,-30v-16,2,-30,13,-38,26r0,101v-2,18,18,18,33,19r0,12r-91,0r0,-12v15,1,26,-3,25,-18r0,-107v-1,-15,-10,-23,-27,-23r0,-12v19,0,44,-6,60,-1v1,7,-2,18,1,24v11,-14,29,-27,48,-29","w":147},"s":{"d":"121,-123v1,-38,-70,-62,-77,-17v7,53,96,21,98,90v2,54,-78,69,-111,39r-3,12r-13,0r-2,-61r12,0v8,25,23,48,55,51v41,3,46,-53,9,-59v-32,-12,-70,-17,-72,-59v-2,-45,61,-64,97,-42v1,-7,6,-11,16,-9r3,55r-12,0","w":155},"t":{"d":"67,-59v-8,37,21,47,53,39r0,12v-30,16,-86,22,-86,-30r0,-118r-32,0r0,-17r32,0r0,-54r32,0r0,54r50,0r0,17r-49,0r0,97","w":124},"u":{"d":"172,-35v0,15,10,21,26,20r0,12v-19,-1,-45,8,-59,1v-1,-7,2,-17,-1,-22v-13,15,-27,28,-57,28v-63,0,-48,-81,-48,-141v0,-17,-12,-21,-27,-23r0,-11v20,0,44,-6,61,-2r0,120v-6,51,60,43,72,13r0,-99v0,-18,-15,-21,-33,-21r0,-11v21,0,48,-6,66,-2r0,138","w":207},"v":{"d":"142,-149v-2,-8,-15,-12,-24,-13r0,-11r66,0r0,10v-33,10,-37,40,-49,70r-38,95r-13,0r-60,-145v-4,-10,-16,-17,-27,-19r0,-11r80,0r0,12v-10,0,-27,4,-19,15r42,102v12,-32,32,-65,42,-105","w":178},"w":{"d":"225,-134v8,-18,-2,-28,-20,-28r0,-11r66,0r0,11v-33,4,-36,44,-45,71r-30,92r-15,0r-47,-127r-46,127r-15,0r-48,-144v-3,-11,-15,-16,-26,-19r0,-11r77,0r0,12v-10,1,-25,3,-17,16r31,100r45,-125r17,0r45,123","w":265},"x":{"d":"66,-53v-9,13,-35,41,0,42r0,11r-64,0r0,-11v40,-14,45,-40,73,-74v-18,-24,-33,-51,-53,-73v-4,-3,-10,-4,-17,-4r0,-11r75,0r0,11v-10,0,-22,2,-12,12r29,45v10,-16,25,-28,32,-48v0,-6,-12,-7,-18,-9r0,-11r64,0r0,11v-39,8,-48,42,-70,66v20,26,34,57,58,79v4,3,10,5,17,5r0,12r-80,0r0,-12v30,1,13,-20,2,-35r-19,-28v-6,8,-12,15,-17,22","w":181},"y":{"d":"57,66v-15,17,-58,17,-58,-9v0,-34,40,-16,45,2v13,-7,33,-44,38,-60r-58,-142v-4,-10,-16,-17,-27,-19r0,-11r79,0r0,12v-10,0,-26,3,-18,15r42,103v12,-36,31,-63,41,-106v-1,-6,-16,-12,-23,-13r0,-11r64,0v4,20,-23,14,-26,31r-62,147v-12,26,-22,44,-37,61","w":177},"z":{"d":"49,-14v52,4,91,0,90,-47r11,0r0,61r-140,0r0,-9r98,-150r-48,0v-23,0,-28,18,-33,39r-11,0r0,-53r133,0r0,7","w":159},"{":{"d":"98,-35v-1,45,-2,85,45,79r0,15v-48,0,-80,-14,-78,-64r2,-44v1,-34,-22,-44,-54,-45r0,-23v30,-3,56,-11,54,-45v-3,-49,-6,-101,43,-105v10,-1,21,-3,33,-3r0,14v-26,1,-46,8,-45,38v5,62,-7,106,-61,110r0,5v38,6,62,24,61,68","w":154},"|":{"d":"79,75r-23,0r0,-343r23,0r0,343","w":135},"}":{"d":"88,-162v-2,34,24,42,54,45r0,23v-31,2,-57,10,-54,45v4,50,4,100,-43,105v-10,1,-21,3,-33,3r0,-15v46,5,47,-34,45,-79v-2,-44,23,-62,61,-68r0,-5v-53,-4,-66,-47,-61,-110v2,-30,-19,-37,-45,-38r0,-14v48,-1,80,14,78,63","w":154},"~":{"d":"160,-100v20,0,28,-16,35,-31r14,5v-11,23,-26,51,-60,52v-32,0,-48,-24,-78,-24v-20,0,-25,15,-34,31r-14,-5v10,-24,28,-52,60,-52v34,0,47,24,77,24"},"\u00c4":{"d":"162,-324v25,0,26,44,0,44v-11,0,-21,-10,-21,-22v0,-12,10,-22,21,-22xm83,-324v25,0,26,44,0,44v-11,0,-21,-10,-21,-22v0,-12,10,-22,21,-22xm51,-28v1,11,22,16,36,16r0,12r-94,0r0,-12v20,-4,34,-13,41,-31r82,-210r14,0r89,226v5,9,18,14,31,15r0,12r-104,0r0,-12v15,-3,36,-1,30,-18r-20,-56r-88,0v-7,20,-15,36,-17,58xm149,-102r-38,-97r-37,97r75,0","w":241},"\u00c5":{"d":"168,-289v0,21,-17,37,-37,38r88,224v5,9,18,14,31,15r0,12r-104,0r0,-12v15,-3,36,-1,30,-18r-20,-56r-88,0v-7,20,-15,36,-17,58v1,11,22,16,36,16r0,12r-94,0r0,-12v20,-4,34,-13,41,-31r81,-207v-21,-2,-38,-16,-38,-39v-1,-23,22,-39,46,-39v25,0,45,15,45,39xm149,-102r-38,-97r-37,97r75,0xm123,-261v16,0,23,-12,23,-28v0,-16,-7,-28,-23,-28v-16,-1,-25,12,-24,28v0,16,8,28,24,28","w":241},"\u00d6":{"d":"173,-326v11,0,21,10,21,22v0,12,-10,22,-21,22v-25,0,-26,-44,0,-44xm94,-326v11,0,21,10,21,22v0,12,-10,22,-21,22v-25,0,-26,-44,0,-44xm134,-255v77,0,120,52,120,131v0,77,-44,130,-120,130v-76,0,-120,-52,-120,-130v0,-78,44,-131,120,-131xm134,-10v59,0,77,-52,77,-114v0,-63,-18,-116,-77,-116v-60,0,-77,54,-77,116v0,62,17,114,77,114","w":267},"\u00dc":{"d":"183,-326v26,1,27,43,0,44v-11,0,-21,-10,-21,-22v0,-12,10,-22,21,-22xm104,-326v25,0,26,44,0,44v-11,0,-21,-10,-21,-22v0,-12,10,-22,21,-22xm145,-14v92,0,67,-114,64,-197v-1,-21,-23,-23,-41,-26r0,-12r101,0r0,12v-66,-2,-35,103,-40,164v-5,52,-39,79,-90,79v-52,0,-93,-23,-93,-72r0,-147v2,-19,-18,-22,-33,-24r0,-12r104,0r0,12v-16,2,-35,4,-34,22v7,81,-30,201,62,201","w":272},"\u00e1":{"d":"93,-255v8,-24,48,-14,34,9v-18,19,-43,34,-63,51r-7,-6xm148,-77v0,27,-12,70,29,63r0,11v-24,13,-57,7,-62,-19v-20,35,-101,38,-101,-17v0,-55,68,-51,101,-72v1,-30,-3,-54,-33,-54v-9,0,-21,4,-25,8v5,16,6,39,-17,39v-12,0,-17,-10,-18,-20v5,-26,32,-38,62,-40v61,-5,64,39,64,101xm49,-43v-1,39,53,31,65,8r1,-61v-30,11,-64,15,-66,53","w":181},"\u00e0":{"d":"148,-77v0,27,-12,70,29,63r0,11v-24,13,-57,7,-62,-19v-20,35,-101,38,-101,-17v0,-55,68,-51,101,-72v1,-30,-3,-54,-33,-54v-9,0,-21,4,-25,8v5,16,6,39,-17,39v-12,0,-17,-10,-18,-20v5,-26,32,-38,62,-40v61,-5,64,39,64,101xm49,-43v-1,39,53,31,65,8r1,-61v-30,11,-64,15,-66,53xm52,-246v-9,-15,9,-32,24,-21v19,22,26,38,46,66r-7,6","w":181},"\u00e4":{"d":"124,-261v12,0,21,9,21,21v0,12,-9,22,-21,22v-12,0,-20,-10,-20,-22v0,-11,9,-21,20,-21xm49,-261v12,0,21,9,21,21v0,12,-9,22,-21,22v-12,0,-21,-10,-21,-22v0,-12,9,-21,21,-21xm148,-77v0,27,-12,70,29,63r0,11v-24,13,-57,7,-62,-19v-20,35,-101,38,-101,-17v0,-55,68,-51,101,-72v1,-30,-3,-54,-33,-54v-9,0,-21,4,-25,8v5,16,6,39,-17,39v-12,0,-17,-10,-18,-20v5,-26,32,-38,62,-40v61,-5,64,39,64,101xm49,-43v-1,39,53,31,65,8r1,-61v-30,11,-64,15,-66,53","w":181},"\u00e5":{"d":"87,-274v24,0,46,15,45,39v0,24,-19,40,-45,39v-26,0,-45,-15,-46,-39v-1,-23,22,-39,46,-39xm87,-207v16,0,23,-12,23,-28v0,-16,-7,-28,-23,-28v-15,0,-24,13,-24,28v0,16,8,28,24,28xm148,-77v0,27,-12,70,29,63r0,11v-24,13,-57,7,-62,-19v-20,35,-101,38,-101,-17v0,-55,68,-51,101,-72v1,-30,-3,-54,-33,-54v-9,0,-21,4,-25,8v5,16,6,39,-17,39v-12,0,-17,-10,-18,-20v5,-26,32,-38,62,-40v61,-5,64,39,64,101xm49,-43v-1,39,53,31,65,8r1,-61v-30,11,-64,15,-66,53","w":181},"\u00e7":{"d":"81,65v29,6,40,-28,10,-28v-4,0,-7,-1,-10,-1r0,-32v-42,-6,-69,-41,-68,-91v1,-53,30,-89,82,-91v31,-1,58,15,58,45v0,27,-43,30,-40,6r4,-29v-4,-8,-13,-9,-23,-9v-66,0,-60,150,7,150v27,0,39,-14,50,-33r12,8v-13,22,-37,44,-68,45r0,12v39,-6,54,42,19,55v-13,5,-30,7,-49,6r0,-13r16,0","w":163},"\u00e9":{"d":"97,-255v8,-24,48,-14,34,9v-18,19,-42,34,-62,51r-7,-6xm105,-15v26,0,37,-12,49,-33r13,7v-14,25,-37,46,-72,46v-55,0,-82,-37,-82,-93v0,-51,28,-90,79,-90v51,0,72,33,70,86r-114,0v0,44,14,77,57,77xm128,-107v-1,-29,-6,-58,-36,-58v-29,1,-43,26,-44,58r80,0","w":174},"\u00e8":{"d":"105,-15v26,0,37,-12,49,-33r13,7v-14,25,-37,46,-72,46v-55,0,-82,-37,-82,-93v0,-51,28,-90,79,-90v51,0,72,33,70,86r-114,0v0,44,14,77,57,77xm128,-107v-1,-29,-6,-58,-36,-58v-29,1,-43,26,-44,58r80,0xm52,-246v-9,-15,9,-32,24,-21v19,22,26,38,46,66r-7,6","w":174},"\u00ed":{"d":"71,-32v0,15,12,20,26,20r0,12r-84,0r0,-12v15,1,25,-3,25,-18r0,-107v1,-18,-14,-21,-30,-23r0,-12v20,1,46,-6,63,-1r0,141xm53,-255v8,-24,48,-14,34,9v-18,19,-43,34,-63,51r-6,-6","w":105},"\u00ee":{"d":"71,-32v0,15,12,20,26,20r0,12r-84,0r0,-12v15,1,25,-3,25,-18r0,-107v1,-18,-14,-21,-30,-23r0,-12v20,1,46,-6,63,-1r0,141xm98,-202r-8,5r-43,-48r-42,48r-9,-5r41,-67v8,-5,24,-1,26,6","w":105},"\u00ef":{"d":"71,-32v0,15,12,20,26,20r0,12r-84,0r0,-12v15,1,25,-3,25,-18r0,-107v1,-18,-14,-21,-30,-23r0,-12v20,1,46,-6,63,-1r0,141xm79,-261v12,0,20,9,20,21v0,13,-8,23,-20,22v-12,0,-20,-10,-20,-22v0,-11,9,-21,20,-21xm18,-261v11,0,20,10,20,21v0,12,-8,22,-20,22v-12,0,-20,-9,-20,-22v0,-12,8,-21,20,-21","w":105},"\u00f1":{"d":"135,-238v19,1,21,-12,28,-24r10,4v-5,39,-55,56,-87,28v-19,-10,-32,7,-37,21r-10,-5v8,-19,18,-41,44,-42v26,-1,31,17,52,18xm179,-31v0,15,11,18,25,19r0,12r-85,0r0,-12v16,1,28,-3,27,-18v-3,-48,16,-127,-30,-127v-22,0,-37,12,-45,26r0,100v-1,16,13,18,27,19r0,12r-85,0r0,-12v15,1,26,-3,25,-18r0,-107v0,-16,-11,-23,-27,-23r0,-12v19,0,44,-6,60,-1v1,7,-2,18,1,24v14,-15,29,-28,58,-29v67,-2,49,85,49,147","w":212},"\u00f3":{"d":"94,-255v7,-25,49,-14,34,9v-19,18,-42,34,-63,51r-7,-6xm98,-178v50,-1,86,38,84,90v-2,55,-31,93,-87,93v-53,0,-82,-37,-83,-91v-1,-52,35,-92,86,-92xm98,-8v63,0,67,-157,0,-157v-38,0,-48,36,-49,76v0,43,10,81,49,81","w":194},"\u00f6":{"d":"136,-261v12,0,21,9,21,21v0,12,-9,22,-21,22v-12,0,-21,-10,-21,-22v0,-12,9,-21,21,-21xm60,-261v12,0,21,9,21,21v0,12,-9,22,-21,22v-12,0,-20,-10,-20,-22v0,-11,9,-21,20,-21xm98,-178v50,-1,86,38,84,90v-2,55,-31,93,-87,93v-53,0,-82,-37,-83,-91v-1,-52,35,-92,86,-92xm98,-8v63,0,67,-157,0,-157v-38,0,-48,36,-49,76v0,43,10,81,49,81","w":194},"\u00f9":{"d":"172,-35v0,15,10,21,26,20r0,12v-19,-1,-45,8,-59,1v-1,-7,2,-17,-1,-22v-13,15,-27,28,-57,28v-63,0,-48,-81,-48,-141v0,-17,-12,-21,-27,-23r0,-11v20,0,44,-6,61,-2r0,120v-6,51,60,43,72,13r0,-99v0,-18,-15,-21,-33,-21r0,-11v21,0,48,-6,66,-2r0,138xm65,-246v-9,-15,9,-32,24,-21v19,22,26,38,46,66r-7,6","w":207},"\u00fb":{"d":"158,-202r-9,5r-49,-48r-48,48r-8,-5v16,-22,29,-47,47,-67v7,-4,23,-2,25,5xm172,-35v0,15,10,21,26,20r0,12v-19,-1,-45,8,-59,1v-1,-7,2,-17,-1,-22v-13,15,-27,28,-57,28v-63,0,-48,-81,-48,-141v0,-17,-12,-21,-27,-23r0,-11v20,0,44,-6,61,-2r0,120v-6,51,60,43,72,13r0,-99v0,-18,-15,-21,-33,-21r0,-11v21,0,48,-6,66,-2r0,138","w":207},"\u00fc":{"d":"139,-261v11,0,20,10,20,21v0,12,-8,22,-20,22v-12,0,-21,-10,-21,-22v0,-12,9,-21,21,-21xm63,-261v12,0,21,9,21,21v0,12,-9,22,-21,22v-12,0,-21,-10,-21,-22v0,-12,9,-21,21,-21xm172,-35v0,15,10,21,26,20r0,12v-19,-1,-45,8,-59,1v-1,-7,2,-17,-1,-22v-13,15,-27,28,-57,28v-63,0,-48,-81,-48,-141v0,-17,-12,-21,-27,-23r0,-11v20,0,44,-6,61,-2r0,120v-6,51,60,43,72,13r0,-99v0,-18,-15,-21,-33,-21r0,-11v21,0,48,-6,66,-2r0,138","w":207},"\u00a3":{"d":"94,-109v1,38,-20,59,-41,78r152,0r0,31r-184,0r0,-26v30,-11,37,-44,38,-83r-29,0r0,-17r29,0v-13,-68,13,-131,77,-130v36,1,61,18,63,52v0,12,-5,22,-18,22v-28,1,-23,-26,-17,-45v-21,-31,-73,-10,-72,37r2,64r70,0r0,17r-70,0","w":223},"\u00df":{"d":"124,-165v31,12,60,32,60,77v0,55,-38,101,-98,88r0,-14v48,11,62,-30,61,-75v0,-37,-16,-70,-54,-68v1,-6,-4,-18,6,-15v28,0,40,-19,41,-46v0,-23,-11,-41,-32,-41v-33,0,-41,34,-40,73r0,186r-58,0r0,-12v15,1,25,-3,25,-18v0,-101,-30,-242,75,-242v38,0,61,18,61,53v0,32,-21,48,-47,54","w":197},"\u2122":{"d":"308,-147v0,9,11,7,18,9r0,9r-61,0r0,-9v10,0,20,0,20,-9v0,-25,4,-58,-2,-79r-43,93r-6,0v-16,-31,-25,-67,-44,-95v5,33,-16,92,22,90r0,9r-55,0r0,-9v36,3,18,-53,22,-86v-1,-11,-9,-16,-21,-16r0,-9r49,0r37,83v11,-28,26,-53,35,-83r47,0r0,9v-9,0,-18,0,-18,8r0,85xm65,-240v-24,-4,-36,10,-40,25r-8,0r0,-34r119,0r0,34v-20,-2,-13,-34,-48,-25r0,93v0,10,12,7,20,9r0,9r-62,0v-6,-16,20,-5,19,-17r0,-94","w":339},"\u00ab":{"d":"175,-28r-8,7r-67,-63v-7,-7,1,-20,5,-23r62,-58r8,7r-45,65xm108,-28r-8,7r-67,-63v-7,-8,0,-19,5,-23r62,-58r8,7r-45,65","w":209},"\u00bb":{"d":"171,-107v8,4,11,22,1,28r-62,58r-9,-7r45,-65r-45,-65r9,-7xm104,-107v8,3,11,23,1,28r-62,58r-9,-7r45,-65r-45,-65r9,-7","w":209},"\u2026":{"d":"243,-42v11,0,23,12,23,23v0,12,-12,23,-23,23v-11,0,-23,-11,-23,-23v0,-12,12,-23,23,-23xm146,-42v11,0,23,12,23,23v0,12,-12,23,-23,23v-11,0,-23,-11,-23,-23v0,-11,12,-23,23,-23xm49,-42v11,0,23,12,23,23v0,12,-12,23,-23,23v-11,0,-23,-11,-23,-23v0,-11,12,-23,23,-23","w":290},"\u2013":{"d":"214,-87r-196,0r0,-22r196,0r0,22"},"\u2014":{"d":"291,-87r-273,0r0,-22r273,0r0,22","w":308},"\u201c":{"d":"42,-173v-38,2,-31,-58,-11,-74v9,-7,20,-17,29,-21r6,10v-18,10,-31,20,-35,44v36,-9,42,39,11,41xm107,-173v-38,2,-31,-58,-11,-74v9,-7,20,-17,29,-21r6,10v-18,10,-31,20,-35,44v36,-9,42,39,11,41","w":147},"\u201d":{"d":"41,-269v38,0,32,59,11,74v-7,8,-21,16,-29,21r-6,-10v15,-11,34,-19,35,-43v-36,9,-43,-41,-11,-42xm106,-269v38,-2,32,59,11,74v-7,8,-21,16,-29,21r-6,-10v17,-10,33,-19,35,-43v-35,9,-43,-41,-11,-42","w":147},"\u2018":{"d":"41,-173v-38,0,-32,-58,-11,-74v10,-8,18,-15,29,-21r6,10v-18,10,-31,20,-35,44v36,-10,42,40,11,41","w":81},"\u2019":{"d":"40,-269v38,-2,32,59,11,74v-7,8,-20,17,-29,21r-6,-10v16,-11,34,-18,35,-43v-35,9,-43,-40,-11,-42","w":81},"\u00ff":{"d":"133,-261v12,0,21,9,21,21v0,12,-9,22,-21,22v-12,0,-21,-11,-21,-22v1,-11,9,-21,21,-21xm58,-261v11,0,20,10,20,21v0,12,-8,22,-20,22v-12,0,-21,-10,-21,-22v0,-12,9,-21,21,-21xm57,66v-15,17,-58,17,-58,-9v0,-34,40,-16,45,2v13,-7,33,-44,38,-60r-58,-142v-4,-10,-16,-17,-27,-19r0,-11r79,0r0,12v-10,0,-26,3,-18,15r42,103v12,-36,31,-63,41,-106v-1,-6,-16,-12,-23,-13r0,-11r64,0v4,20,-23,14,-26,31r-62,147v-12,26,-22,44,-37,61","w":177},"\u20ac":{"d":"142,-14v40,0,59,-26,71,-55r14,6v-18,43,-44,69,-98,69v-62,0,-97,-43,-107,-99r-22,0r6,-17r15,0v0,-10,-2,-23,0,-31r-21,0r6,-17r17,0v9,-73,101,-125,171,-79v4,-7,8,-15,22,-12r1,89r-14,0v-8,-46,-42,-100,-97,-72v-23,13,-39,40,-42,74r69,0r-6,17r-64,0v0,10,-2,22,0,31r52,0r-6,17r-45,0v8,43,30,79,78,79"},"\u0142":{"d":"35,-230v2,-20,-17,-26,-35,-27r0,-11r66,-4v6,39,0,92,2,135r24,-10r6,14r-30,12r0,89v-1,15,12,20,26,20r0,12r-85,0r0,-12v16,1,27,-3,26,-18r0,-78r-24,10r-6,-14r30,-13r0,-105","w":103},"\u00d7":{"d":"195,-35r-16,16r-63,-64r-64,64r-15,-16r64,-63r-64,-64r15,-15r64,63r63,-64r16,16r-64,64"},"\u0107":{"d":"90,-255v8,-24,48,-14,34,9v-18,19,-43,34,-63,51r-7,-6xm163,-40v-13,24,-40,44,-70,45v-52,2,-81,-39,-80,-92v1,-53,30,-89,82,-91v31,-1,58,15,58,45v0,27,-43,30,-40,6r4,-29v-4,-8,-13,-9,-23,-9v-66,0,-60,150,7,150v27,0,39,-14,50,-33","w":163},"\u0105":{"d":"163,78v-35,2,-67,-4,-67,-34v0,-22,15,-33,33,-45v-9,-3,-10,-12,-14,-21v-20,35,-101,38,-101,-17v0,-55,68,-51,101,-72v1,-30,-3,-54,-33,-54v-9,0,-21,4,-25,8v5,16,6,39,-17,39v-12,0,-17,-10,-18,-20v5,-26,32,-37,62,-40v78,-8,65,71,63,144v0,17,13,20,30,20r0,11v-13,5,-24,9,-39,5v-21,19,-20,72,25,63r0,13xm49,-43v-1,39,53,31,65,8r1,-61v-30,11,-64,15,-66,53","w":181},"\u0119":{"d":"82,44v0,-17,12,-30,26,-40v-65,3,-95,-32,-95,-92v0,-51,28,-90,79,-90v51,0,72,33,70,86r-114,0v0,44,14,77,57,77v26,0,37,-12,49,-33r13,7v-12,32,-57,36,-57,79v0,22,15,28,40,27r0,13v-36,2,-68,-4,-68,-34xm128,-107v-1,-29,-6,-58,-36,-58v-29,1,-43,26,-44,58r80,0","w":174},"\u015b":{"d":"85,-255v8,-24,48,-14,34,9v-18,19,-43,34,-63,51r-6,-6xm121,-123v1,-38,-70,-62,-77,-17v7,53,96,21,98,90v2,54,-78,69,-111,39r-3,12r-13,0r-2,-61r12,0v8,25,23,48,55,51v41,3,46,-53,9,-59v-32,-12,-70,-17,-72,-59v-2,-45,61,-64,97,-42v1,-7,6,-11,16,-9r3,55r-12,0","w":155},"\u017a":{"d":"92,-255v7,-25,50,-12,33,9v-16,20,-42,34,-62,51r-7,-6xm49,-14v52,4,91,0,90,-47r11,0r0,61r-140,0r0,-9r98,-150r-48,0v-23,0,-28,18,-33,39r-11,0r0,-53r133,0r0,7","w":159},"\u017c":{"d":"82,-266v13,0,22,10,22,22v1,13,-9,25,-22,25v-12,0,-23,-12,-23,-23v0,-12,10,-25,23,-24xm49,-14v52,4,91,0,90,-47r11,0r0,61r-140,0r0,-9r98,-150r-48,0v-23,0,-28,18,-33,39r-11,0r0,-53r133,0r0,7","w":159},"\u2032":{"d":"64,-250v24,-20,42,7,27,32r-44,71r-13,0v10,-33,14,-77,30,-103","w":115},"\u2033":{"d":"64,-250v24,-20,42,7,27,32r-44,71r-13,0v10,-33,14,-77,30,-103xm169,-238v-18,45,-21,40,-52,91r-12,0v10,-33,11,-78,29,-103v9,-13,37,-5,35,12","w":186}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2006 Microsoft Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Georgia is either a registered trademark or a trademark of Microsoft
 * Corporation in the United States and/or other countries.
 * 
 * Manufacturer:
 * Carter & Cone
 * 
 * Designer:
 * Matthew Carter
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":253,"face":{"font-family":"Georgia","font-weight":700,"font-stretch":"normal","units-per-em":"360","panose-1":"2 4 8 2 5 4 5 2 2 3","ascent":"288","descent":"-72","x-height":"6","bbox":"-41.2221 -328 412 78.5275","underline-thickness":"21.4453","underline-position":"-20.918","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":91},"\u00a0":{"w":91},"!":{"d":"34,-222v-3,-28,38,-43,58,-23v7,6,12,14,10,23r-27,141r-14,0v-7,-54,-22,-91,-27,-141xm68,-60v18,0,34,17,34,33v0,17,-17,32,-34,32v-17,1,-34,-14,-34,-32v0,-17,16,-33,34,-33","w":135},"\"":{"d":"133,-269v59,6,9,84,6,124r-12,0v-4,-28,-23,-73,-23,-96v0,-15,13,-30,29,-28xm50,-269v59,6,9,84,6,124r-12,0v-4,-28,-23,-73,-23,-96v0,-15,13,-30,29,-28","w":183},"#":{"d":"226,-131r-46,0r-14,45r49,0r0,28r-57,0r-18,58r-26,0r17,-58r-40,0r-18,58r-26,0r18,-58r-38,0r0,-28r46,0r14,-45r-49,0r0,-29r58,0r18,-60r26,0r-18,60r40,0r19,-60r26,0r-19,60r38,0r0,29xm154,-132r-41,0r-14,46r41,0"},"$":{"d":"47,-81v34,0,34,38,22,59v8,3,26,11,39,10r0,-79v-45,-2,-83,-21,-83,-66v0,-46,36,-69,83,-73r0,-38r18,0r0,38v39,1,78,16,80,49v0,16,-11,29,-27,29v-33,0,-32,-37,-21,-57v-7,-4,-21,-6,-32,-6r0,72v48,5,86,22,86,71v1,46,-42,72,-86,75r0,50r-18,0r0,-50v-41,1,-87,-22,-89,-55v0,-16,10,-29,28,-29xm67,-180v-1,26,18,33,41,36r0,-71v-22,2,-41,13,-41,35xm126,-12v28,-3,45,-15,45,-40v0,-25,-20,-34,-45,-37r0,77","w":230},"%":{"d":"84,-257v37,0,69,27,69,66v0,39,-30,66,-68,66v-38,0,-69,-27,-69,-66v0,-39,31,-65,68,-66xm85,-138v20,-3,21,-27,21,-53v0,-26,-1,-51,-22,-53v-20,3,-21,27,-21,52v0,27,0,53,22,54xm232,-125v38,0,69,26,69,65v0,39,-31,66,-69,66v-38,1,-68,-27,-68,-66v0,-39,30,-65,68,-65xm233,-7v31,0,30,-105,-1,-105v-21,0,-22,26,-22,51v0,27,1,54,23,54xm277,-251r-208,251r-29,0r208,-251r29,0","w":316},"&":{"d":"203,-65v25,29,40,48,86,51r0,14r-103,0r-22,-26v-37,47,-153,43,-152,-32v1,-45,31,-61,63,-77v-17,-22,-26,-33,-28,-63v-5,-67,133,-82,133,-11v0,33,-18,47,-44,62r57,70v10,-17,22,-32,22,-53v0,-12,-17,-11,-30,-15r0,-13r99,0r0,13v-55,0,-53,53,-81,80xm127,-158v28,-12,40,-78,-1,-81v-44,6,-19,61,1,81xm83,-124v-37,36,-8,119,54,96v5,-2,11,-4,17,-9","w":287},"'":{"d":"49,-269v59,7,8,83,5,124r-12,0v-4,-28,-23,-73,-23,-96v0,-16,13,-30,30,-28","w":96},"(":{"d":"80,-106v0,77,16,134,69,148r0,16v-147,-4,-172,-261,-47,-313v15,-7,31,-12,47,-14r0,16v-54,13,-69,71,-69,147","w":160},")":{"d":"12,-269v148,2,171,261,47,312v-15,7,-31,13,-47,15r0,-16v53,-13,69,-72,69,-148v0,-76,-15,-134,-69,-147r0,-16","w":160},"*":{"d":"96,-196v21,-1,63,-23,63,6v0,31,-42,4,-63,5v12,16,57,48,19,60v-21,-5,-18,-35,-28,-54v-11,16,-7,51,-28,54v-39,-13,8,-43,19,-60v0,0,-59,25,-64,-5v4,-29,41,-6,64,-6v-10,-16,-35,-27,-35,-45v0,-8,8,-15,16,-15v23,0,16,38,28,54v10,-19,7,-50,28,-54v38,13,-9,45,-19,60","w":173},"+":{"d":"224,-87r-83,0r0,83r-29,0r0,-83r-83,0r0,-28r83,0r0,-83r29,0r0,83r83,0r0,28"},",":{"d":"54,-60v46,0,52,64,23,95v-13,14,-26,25,-43,33r-8,-12v21,-12,42,-25,44,-56v-52,12,-61,-60,-16,-60","w":118},"-":{"d":"121,-76r-106,0r0,-39r106,0r0,39","w":136},"\u00ad":{"d":"121,-76r-106,0r0,-39r106,0r0,39","w":136},".":{"d":"59,-64v17,0,35,17,35,35v0,18,-17,34,-35,34v-18,0,-35,-17,-35,-34v0,-17,17,-35,35,-35","w":118},"\/":{"d":"158,-268r-122,343r-31,0r121,-343r32,0","w":169},"0":{"d":"126,-195v66,0,108,35,108,101v0,64,-41,100,-108,100v-67,0,-108,-36,-108,-100v0,-64,41,-101,108,-101xm126,-9v38,-4,42,-42,42,-85v0,-41,-3,-85,-42,-85v-39,0,-42,44,-42,85v0,42,5,81,42,85","w":252},"1":{"d":"125,-37v-2,22,24,22,41,24r0,13r-145,0r0,-13v18,-3,44,0,44,-23r0,-111r-44,0r0,-17v37,2,62,-9,74,-31r31,0","w":176},"2":{"d":"200,-135v-2,71,-101,50,-137,87r147,0r0,48r-191,0r0,-32v30,-35,90,-45,112,-86v11,-40,-15,-74,-56,-57v12,23,10,62,-25,62v-18,0,-29,-13,-29,-29v0,-70,182,-76,179,7","w":225},"3":{"d":"134,-74v38,4,73,20,73,62v0,49,-56,77,-113,77v-40,0,-84,-19,-85,-53v0,-16,11,-29,29,-29v36,0,36,39,24,62v41,13,77,-9,77,-57v0,-42,-23,-52,-66,-49r0,-21v41,4,58,-14,58,-54v0,-36,-27,-51,-59,-39v10,25,12,62,-24,62v-18,0,-29,-13,-29,-29v1,-36,47,-54,89,-53v49,0,88,16,88,58v0,40,-33,51,-62,63","w":224},"4":{"d":"222,-2r-38,0r0,67r-59,0r0,-67r-116,0r0,-32r126,-160r49,0r0,155r38,0r0,37xm125,-39r0,-113r-89,113r89,0","w":233},"5":{"d":"49,-83v52,-32,152,-17,152,60v0,55,-50,89,-107,88v-39,1,-84,-19,-84,-52v0,-16,12,-30,29,-30v35,0,37,39,24,63v47,12,70,-24,73,-69v3,-56,-72,-74,-95,-32r-14,-5r17,-129r148,0r0,48r-135,0","w":215},"6":{"d":"84,-137v45,-49,134,-19,134,56v0,51,-46,87,-99,87v-112,0,-128,-151,-57,-211v31,-26,67,-45,117,-51r5,17v-62,6,-90,45,-100,102xm119,-9v46,-3,49,-128,-1,-128v-24,0,-36,11,-36,41v0,43,7,82,37,87","w":233},"7":{"d":"165,-142v-57,5,-137,-20,-137,39r-12,0r0,-86r185,0r0,21r-128,233r-26,0","w":199},"8":{"d":"161,-140v36,13,62,31,64,70v4,96,-207,106,-207,10v0,-37,26,-52,61,-60v-28,-13,-50,-34,-51,-68v-1,-86,187,-94,187,-7v0,33,-24,46,-54,55xm149,-146v13,-30,16,-95,-27,-95v-36,0,-47,54,-18,71v12,7,32,18,45,24xm123,-9v44,0,57,-58,23,-78v-15,-9,-38,-18,-54,-27v-24,30,-20,105,31,105","w":243},"9":{"d":"114,-195v111,0,129,151,58,210v-30,25,-68,44,-118,51r-4,-17v58,-9,91,-41,99,-100v-45,45,-134,17,-134,-58v0,-52,46,-86,99,-86xm116,-52v23,0,35,-11,35,-40v0,-42,-6,-82,-36,-87v-47,3,-49,127,1,127","w":233},":":{"d":"66,-175v18,0,35,17,35,35v0,18,-17,34,-35,34v-18,0,-35,-17,-35,-34v0,-17,17,-35,35,-35xm66,-64v17,0,35,17,35,35v0,18,-17,34,-35,34v-18,0,-35,-17,-35,-34v0,-17,17,-35,35,-35","w":132},";":{"d":"66,-175v18,0,35,17,35,35v0,18,-17,34,-35,34v-18,0,-35,-17,-35,-34v0,-17,17,-35,35,-35xm62,-60v45,0,50,64,22,95v-13,14,-26,25,-43,33r-8,-12v21,-12,42,-25,44,-56v-52,12,-61,-60,-15,-60","w":132},"\u037e":{"d":"66,-175v18,0,35,17,35,35v0,18,-17,34,-35,34v-18,0,-35,-17,-35,-34v0,-17,17,-35,35,-35xm62,-60v45,0,50,64,22,95v-13,14,-26,25,-43,33r-8,-12v21,-12,42,-25,44,-56v-52,12,-61,-60,-15,-60","w":132},"<":{"d":"213,-1r-176,-88r0,-24r176,-88r0,33r-139,67r139,67r0,33"},"=":{"d":"221,-123r-188,0r0,-29r188,0r0,29xm221,-50r-188,0r0,-29r188,0r0,29"},">":{"d":"216,-89r-175,88r0,-33r138,-67r-138,-67r0,-33r175,88r0,24"},"?":{"d":"92,-255v77,0,115,84,62,130v-16,15,-37,23,-64,25r-1,24r-16,0r0,-68v58,7,76,-93,17,-97v-10,0,-17,3,-24,7v10,22,12,56,-23,56v-18,0,-29,-13,-29,-29v1,-30,42,-48,78,-48xm82,-60v18,0,33,16,33,33v0,18,-16,32,-33,32v-17,1,-34,-14,-34,-32v0,-17,16,-33,34,-33","w":197},"@":{"d":"196,-242v78,0,122,43,126,116v3,55,-37,107,-88,106v-24,0,-41,-9,-48,-24v-20,36,-93,27,-88,-27v5,-54,37,-100,90,-100v16,0,24,6,28,18r6,-16r45,0v-12,40,-30,74,-39,117v0,9,3,16,13,16v42,0,63,-45,61,-92v-2,-63,-42,-96,-107,-96v-81,0,-133,54,-133,138v0,80,42,126,120,126v42,0,71,-12,95,-30r7,11v-26,20,-58,37,-103,36v-89,-3,-153,-49,-153,-141v0,-97,68,-158,168,-158xm145,-66v-3,30,30,31,37,10r27,-78v0,-12,-7,-22,-19,-22v-33,8,-41,51,-45,90","w":348},"A":{"d":"56,-35v-3,19,16,19,36,21r0,14r-102,0r0,-14v24,-1,37,-12,45,-31r86,-208r36,0r87,216v7,13,18,23,39,23r0,14r-136,0r0,-14v10,-1,45,-2,33,-18r-21,-51r-86,0v-7,14,-15,33,-17,48xm152,-101r-36,-90r-36,90r72,0","w":272},"B":{"d":"178,-133v39,7,80,20,80,65v0,99,-149,60,-246,68r0,-14v18,-1,37,-3,37,-22r0,-176v1,-20,-22,-20,-37,-24r0,-13v86,7,232,-28,232,55v0,39,-34,49,-66,58r0,3xm111,-140v40,2,64,-14,65,-49v0,-35,-25,-48,-65,-44r0,93xm111,-32v21,34,86,9,77,-38v1,-42,-32,-58,-77,-53r0,91","w":272},"C":{"d":"12,-122v-4,-105,110,-163,202,-118v6,-6,13,-11,27,-9r1,91r-15,0v-16,-45,-29,-81,-77,-81v-52,0,-67,51,-67,111v0,62,17,110,76,110v41,0,61,-24,79,-54r15,9v-20,40,-51,70,-110,70v-80,0,-128,-49,-131,-129","w":257},"D":{"d":"144,-249v83,2,144,40,144,126v0,85,-64,123,-150,123r-126,0r0,-14v18,0,38,-2,37,-21r0,-177v0,-18,-21,-22,-37,-24r0,-13r132,0xm144,-16v59,0,73,-47,73,-107v-1,-71,-27,-118,-106,-110r0,190v1,19,12,27,33,27","w":300},"E":{"d":"49,-212v2,-20,-22,-20,-37,-24r0,-13r221,0r0,63r-13,0v-11,-38,-49,-56,-109,-48r0,97v42,4,68,-9,71,-43r14,0r0,104r-14,0v-3,-35,-26,-52,-71,-45v4,46,-19,116,41,105v56,9,72,-31,86,-62r13,0r-5,78r-234,0r0,-14v18,-1,38,-4,37,-22r0,-176","w":259},"F":{"d":"49,-212v1,-19,-22,-20,-37,-24r0,-13r224,0r0,66r-13,0v-10,-26,-31,-57,-73,-51r-39,0r0,98v43,5,67,-9,70,-43r14,0r0,105r-14,0v-3,-34,-25,-52,-70,-45r0,82v-1,20,20,21,36,23r0,14r-135,0r0,-14v17,-1,37,-2,37,-22r0,-176","w":241},"G":{"d":"12,-122v-6,-110,113,-161,208,-118v6,-6,12,-11,26,-9r2,91r-16,0v-16,-45,-30,-81,-79,-81v-52,0,-71,52,-70,111v0,62,17,115,69,117v18,0,37,-7,46,-15r0,-51v2,-21,-21,-21,-38,-24r0,-14r130,0r0,14v-42,-5,-32,41,-31,79v-22,14,-80,30,-116,29v-81,-2,-128,-48,-131,-129","w":290},"H":{"d":"182,-14v17,0,36,-3,36,-21r0,-86r-107,0r0,84v-1,19,19,21,36,23r0,14r-135,0r0,-14v17,0,37,-2,37,-21r0,-177v0,-18,-21,-22,-37,-24r0,-13r135,0r0,13v-16,2,-36,3,-36,23r0,74r107,0r0,-73v0,-18,-21,-20,-36,-24r0,-13r135,0r0,13v-16,3,-37,3,-37,23r0,176v-1,20,19,22,37,23r0,14r-135,0r0,-14","w":328},"I":{"d":"11,-14v17,-1,38,0,38,-21r0,-177v2,-20,-23,-20,-38,-24r0,-13r138,0r0,13v-17,2,-38,3,-38,23r0,176v-1,19,21,21,38,23r0,14r-138,0r0,-14","w":160},"J":{"d":"108,-212v2,-20,-22,-20,-36,-24r0,-13r133,0r0,13v-17,3,-34,2,-34,23r0,137v-3,54,-41,80,-95,83v-41,1,-73,-22,-73,-60v0,-22,13,-37,35,-37v19,0,33,13,33,31v1,21,-19,27,-26,41v29,23,63,-9,63,-53r0,-141","w":214},"K":{"d":"206,-229v-4,-6,-14,-6,-26,-7r0,-13r109,0r0,13v-64,5,-86,54,-122,85r88,109v12,14,25,27,50,28r0,14r-99,0v-30,-47,-55,-75,-86,-115r-9,0r0,78v-1,19,17,21,33,23r0,14r-132,0r0,-14v17,-1,37,-2,37,-21r0,-177v1,-19,-21,-21,-37,-24r0,-13r137,0r0,13v-17,2,-38,2,-38,23r0,84r7,0v28,-28,74,-61,88,-100","w":294},"L":{"d":"111,-49v-8,47,61,36,90,24v12,-11,26,-39,33,-55r13,0r-5,80r-230,0r0,-14v18,-1,37,-2,37,-22r0,-176v1,-19,-21,-21,-37,-24r0,-13r137,0r0,13v-17,2,-38,2,-38,23r0,164","w":246},"M":{"d":"320,-37v-2,20,19,20,35,23r0,14r-135,0r0,-14v18,-1,38,-2,38,-23r0,-186r-85,219r-23,0r-81,-222r0,152v-4,41,14,56,44,60r0,14r-107,0r0,-14v18,-2,38,-5,40,-25v5,-45,2,-106,3,-157v1,-28,-16,-39,-41,-40r0,-13r115,0r61,164r60,-164r111,0r0,13v-16,2,-35,3,-35,23r0,176","w":368},"N":{"d":"235,-81v-5,-63,20,-155,-43,-155r0,-13r107,0r0,13v-33,0,-43,19,-43,59r0,178r-31,0r-156,-192v7,68,-25,176,44,177r0,14r-107,0r0,-14v35,-1,46,-17,43,-58v-5,-64,22,-160,-44,-163r0,-14r94,0","w":302},"O":{"d":"148,-256v82,0,135,48,135,130v0,83,-51,133,-137,133v-80,0,-134,-48,-134,-129v0,-82,52,-134,136,-134xm148,-10v55,0,64,-56,64,-115v0,-56,-10,-114,-64,-114v-51,0,-66,53,-65,115v1,58,10,114,65,114","w":295},"P":{"d":"12,-249v90,7,234,-29,234,62v0,68,-63,82,-135,80r0,70v-1,20,20,20,36,23r0,14r-135,0r0,-14v18,-1,37,-2,37,-22r0,-176v1,-19,-21,-21,-37,-24r0,-13xm111,-124v42,2,66,-14,66,-54v0,-44,-20,-58,-66,-55r0,109","w":252},"Q":{"d":"148,-256v82,0,135,48,135,130v0,62,-34,106,-83,123v-1,39,32,62,72,48r0,15v-30,13,-94,23,-119,-5v-12,-13,-20,-28,-22,-49v-71,-9,-119,-52,-119,-128v0,-82,52,-134,136,-134xm148,-10v55,0,64,-56,64,-115v0,-56,-10,-114,-64,-114v-51,0,-66,53,-65,115v1,58,10,114,65,114","w":295},"R":{"d":"248,-190v0,40,-25,57,-61,67r76,94v10,12,18,13,35,15r0,14r-95,0v-17,-25,-30,-45,-41,-60v-11,-15,-25,-32,-41,-52r-10,0r0,75v-2,19,19,20,34,23r0,14r-133,0r0,-14v18,0,38,-4,37,-22r0,-176v2,-20,-23,-20,-37,-24r0,-13v90,7,236,-29,236,59xm111,-129v44,2,69,-13,68,-56v0,-39,-26,-51,-68,-48r0,104","w":287},"S":{"d":"220,-73v0,84,-119,96,-179,61v-7,6,-11,15,-27,12r-3,-90r15,0v17,36,36,75,87,79v40,3,66,-42,38,-66v-40,-35,-133,-27,-133,-104v0,-76,106,-90,161,-58v6,-6,12,-12,26,-10r1,85r-15,0v-14,-34,-28,-72,-73,-75v-34,-3,-59,40,-33,62v41,35,135,26,135,104","w":233},"T":{"d":"92,-234v-48,-7,-65,25,-76,56r-14,0r0,-71r242,0r0,71r-14,0v-12,-29,-26,-65,-76,-56r0,196v-1,20,21,22,39,24r0,14r-139,0r0,-14v16,-1,38,-1,38,-22r0,-198","w":246},"U":{"d":"236,-91v-2,-61,17,-146,-45,-145r0,-13r108,0r0,13v-63,-2,-43,91,-43,152v0,56,-44,91,-101,91v-67,0,-111,-29,-111,-91r0,-128v0,-18,-18,-22,-34,-24r0,-13r131,0r0,13v-18,1,-35,4,-35,22v0,82,-26,200,64,197v42,-2,68,-28,66,-74","w":300},"V":{"d":"208,-185v14,-26,16,-54,-27,-50r0,-14r101,0r0,14v-56,8,-62,73,-80,118r-49,120r-36,0r-86,-209v-8,-18,-20,-26,-42,-30r0,-13r135,0r0,13v-21,4,-38,2,-30,21r64,158","w":274},"W":{"d":"349,-206v9,-25,-16,-28,-37,-29r0,-14r100,0r0,14v-54,8,-54,72,-69,115r-42,123r-35,0r-66,-186r-60,186r-35,0r-71,-209v-6,-19,-20,-26,-41,-30r0,-13r133,0r0,13v-16,3,-36,-1,-29,21r48,147r57,-181r37,0r66,187","w":405},"X":{"d":"212,-224v-3,-10,-11,-10,-28,-12r0,-13r97,0r0,13v-42,4,-58,37,-80,62r-29,33r78,111v12,10,22,15,42,16r0,14r-152,0r0,-14v57,4,23,-33,9,-55r-21,-32v-32,39,-44,48,-57,75v1,11,15,10,27,12r0,14r-96,0r0,-14v47,-5,58,-36,83,-65r32,-37r-73,-103v-12,-11,-22,-16,-42,-17r0,-13r153,0r0,13v-48,-4,-30,24,-14,49r20,31v29,-36,40,-42,51,-68","w":291},"Y":{"d":"214,-223v-2,-12,-15,-11,-31,-13r0,-13r92,0r0,13v-56,14,-66,75,-97,112v-18,22,-14,48,-15,86v-1,20,21,22,39,24r0,14r-139,0r0,-14v18,-1,39,-2,38,-22v-2,-32,2,-64,-13,-84v-26,-35,-41,-82,-75,-110v-5,-3,-17,-5,-24,-6r0,-13r143,0r0,13v-20,2,-41,0,-31,17r55,96v40,-65,38,-59,58,-100","w":263},"Z":{"d":"142,-16v67,6,70,-31,90,-68r14,0r-9,84r-234,0r0,-11r161,-222r-54,0v-55,-2,-56,23,-80,60r-14,0r8,-76r217,0r0,10r-161,223r62,0","w":248},"[":{"d":"149,54r-116,0r0,-321r116,0r0,17r-61,0r0,287r61,0r0,17","w":160},"\\":{"d":"165,75r-32,0r-121,-343r32,0","w":169},"]":{"d":"128,54r-116,0r0,-17r61,0r0,-287r-61,0r0,-17r116,0r0,321","w":160},"^":{"d":"217,-134r-35,0r-55,-90r-56,90r-34,0r77,-122r25,0"},"_":{"d":"254,53r-255,0r0,-21r255,0r0,21"},"`":{"d":"53,-234v-20,-11,-18,-40,7,-38v31,1,30,20,47,41r23,31r-7,6v-30,-20,-45,-26,-70,-40","w":180},"a":{"d":"211,-17r0,13v-26,13,-81,14,-87,-16v-21,34,-110,37,-110,-18v0,-59,72,-53,110,-73v-1,-26,2,-56,-26,-54v-9,0,-15,2,-21,6v9,21,7,47,-25,47v-19,0,-29,-10,-30,-26v6,-31,43,-40,79,-41v47,0,81,10,81,58v0,40,-24,112,29,104xm75,-48v0,32,37,32,48,12r1,-59v-25,8,-49,15,-49,47","w":214},"b":{"d":"86,-155v50,-50,144,-13,134,69v7,80,-101,118,-158,72v-12,7,-20,29,-36,19v5,-72,1,-156,2,-233v-1,-18,-14,-26,-32,-27r0,-13r87,-4r3,3r0,114xm118,-9v52,0,58,-142,-2,-143v-15,0,-23,4,-30,13v5,49,-19,130,32,130","w":232},"c":{"d":"191,-44v-16,27,-39,50,-80,50v-62,0,-99,-33,-99,-94v0,-56,41,-90,102,-91v37,0,70,13,70,45v0,18,-9,28,-30,28v-33,0,-35,-30,-25,-53v-36,-22,-53,29,-53,69v0,36,19,70,50,70v28,0,40,-14,52,-33","w":191},"d":{"d":"206,-39v-2,18,14,22,31,22r0,13v-29,0,-63,7,-89,3v-1,-5,1,-13,-1,-17v-10,11,-32,25,-53,24v-49,0,-80,-44,-82,-95v-2,-66,76,-113,136,-79r0,-58v-1,-22,-19,-28,-40,-29r0,-13r95,-4r3,3r0,230xm117,-20v15,0,24,-6,31,-15v-5,-48,18,-127,-32,-127v-51,0,-60,140,1,142","w":238},"e":{"d":"134,-20v24,0,41,-17,52,-32r13,10v-17,27,-44,48,-86,48v-63,0,-101,-33,-101,-94v0,-56,37,-91,97,-91v57,0,88,27,85,86r-118,0v0,45,14,74,58,73xm132,-109v-1,-26,-1,-56,-26,-56v-25,0,-30,25,-30,57","w":205},"f":{"d":"131,-272v25,-1,45,9,45,30v-1,17,-8,28,-27,27v-26,-2,-28,-18,-39,-42v-19,10,-15,44,-16,83r49,0r0,19r-49,0r0,121v0,18,19,19,35,21r0,13r-118,0v-6,-23,26,-7,26,-32r0,-123r-36,0r0,-19r36,0v1,-60,32,-97,94,-98","w":141},"g":{"d":"15,-123v-2,-52,73,-64,124,-51r68,0r0,19r-39,0v37,42,-9,89,-66,89v-16,0,-36,-3,-36,12v5,26,57,12,84,16v31,5,57,19,57,52v0,51,-51,63,-108,64v-50,0,-94,-7,-94,-45v0,-24,24,-32,53,-33r0,-2v-18,-6,-33,-15,-34,-35v-1,-23,25,-23,37,-33v-27,-11,-45,-22,-46,-53xm98,-79v19,0,28,-19,27,-42v-1,-24,-6,-45,-27,-45v-36,0,-34,87,0,87xm108,64v28,-3,46,-10,46,-37v0,-32,-42,-21,-79,-24v-26,21,-11,65,33,61","w":207},"h":{"d":"213,-34v0,16,12,19,26,21r0,13r-106,0v-6,-22,25,-7,22,-32v-6,-43,16,-118,-26,-118v-19,0,-31,10,-38,22r0,94v-2,16,10,19,22,21r0,13r-106,0v-6,-23,26,-7,26,-32r0,-196v0,-18,-14,-26,-32,-27r0,-13r87,-4r3,3r0,121v17,-16,32,-30,65,-31v70,-3,57,78,57,145","w":244},"i":{"d":"95,-34v-1,16,13,19,26,21r0,13r-111,0r0,-13v15,0,27,-3,27,-19r0,-102v-1,-17,-14,-23,-31,-25r0,-13v29,0,64,-7,89,-2r0,140xm61,-272v18,0,35,14,35,32v0,18,-17,32,-35,32v-18,0,-35,-14,-35,-32v0,-18,17,-32,35,-32","w":127},"j":{"d":"39,-134v0,-17,-16,-24,-34,-25r0,-13v30,0,66,-7,92,-2r0,153v-2,59,-35,93,-95,99v-45,4,-62,-57,-16,-57v26,0,27,20,39,41v27,-31,14,-134,14,-196xm63,-272v18,0,35,14,35,32v0,18,-17,32,-35,32v-18,0,-35,-14,-35,-32v0,-18,17,-32,35,-32","w":124},"k":{"d":"146,-140v15,-14,1,-20,-15,-22r0,-12r89,0r0,12v-35,9,-53,22,-76,43r62,92v7,10,17,13,30,14r0,13r-83,0v-18,-33,-33,-53,-52,-80v-16,10,-20,73,14,67r0,13r-108,0v-6,-23,31,-7,26,-32r0,-196v-1,-18,-14,-26,-32,-27r0,-13r87,-4r3,3r0,181","w":227},"l":{"d":"91,-34v-1,16,12,19,26,21r0,13r-110,0r0,-13v15,0,26,-3,26,-19r0,-195v0,-19,-16,-26,-33,-28r0,-13r88,-4r3,3r0,235","w":123},"m":{"d":"334,-34v-1,16,11,19,25,21r0,13r-104,0v-6,-22,25,-7,21,-32v-7,-42,16,-115,-25,-118v-19,-2,-30,11,-37,22r0,94v0,14,9,19,21,21r0,13r-100,0v-7,-22,25,-6,21,-32v-7,-41,17,-115,-25,-118v-19,-1,-30,11,-37,22r0,94v0,14,9,19,21,21r0,13r-105,0r0,-13v16,0,27,-4,27,-19v0,-46,21,-124,-29,-127r0,-13v28,0,62,-7,86,-2v1,8,-2,19,1,25v22,-35,100,-41,118,2v16,-15,34,-32,66,-32v68,0,55,79,55,145","w":365},"n":{"d":"217,-34v0,16,11,19,25,21r0,13r-106,0v-7,-22,27,-7,23,-32v-6,-42,17,-118,-26,-118v-19,0,-31,10,-39,22r0,94v-1,15,10,19,23,21r0,13r-107,0r0,-13v16,0,29,-4,27,-19v-5,-46,21,-124,-29,-127r0,-13v28,0,62,-7,86,-2v1,8,-2,20,1,26v17,-14,32,-31,64,-31v70,0,59,78,58,145","w":248},"o":{"d":"114,-179v63,0,102,30,102,91v0,62,-40,94,-103,94v-60,0,-101,-33,-101,-93v0,-60,40,-91,102,-92xm115,-9v35,0,37,-41,37,-79v0,-34,-1,-78,-37,-77v-35,1,-38,38,-38,76v0,41,1,80,38,80","w":228},"p":{"d":"92,-154v46,-54,142,-11,132,68v5,67,-74,114,-133,79r0,49v-2,21,21,21,38,23r0,13r-127,0r0,-13v16,0,31,-3,31,-21r0,-179v-1,-17,-14,-23,-31,-24r0,-13v29,0,64,-7,89,-2v1,6,-1,15,1,20xm123,-11v51,0,56,-140,-2,-141v-15,-1,-24,6,-30,14v4,49,-17,127,32,127","w":236},"q":{"d":"206,41v-2,19,16,22,32,24r0,13r-123,0r0,-13v16,0,35,-2,33,-21v-2,-19,4,-46,-2,-61v-47,50,-134,6,-134,-72v0,-80,101,-112,164,-73v11,-7,17,-28,32,-20xm117,-21v16,0,23,-7,31,-14v-5,-49,18,-129,-33,-129v-51,0,-59,143,2,143","w":233},"r":{"d":"94,-148v19,-29,89,-48,91,6v1,17,-13,33,-30,33v-24,0,-35,-18,-28,-41v-14,0,-26,10,-33,19r0,97v-1,18,18,20,34,21r0,13r-118,0r0,-13v16,0,27,-4,27,-19r0,-102v-1,-17,-13,-23,-29,-25r0,-13v28,0,62,-7,86,-2r0,26","w":187},"s":{"d":"159,-90v39,44,-7,96,-67,96v-21,0,-47,-7,-59,-16r-5,12r-14,0r-2,-65r13,0v10,26,29,50,64,54v32,3,43,-34,19,-45v-37,-17,-90,-17,-91,-70v-2,-55,82,-66,127,-45v1,-8,6,-12,17,-10r3,60r-12,0v-6,-21,-28,-45,-54,-45v-28,0,-39,30,-17,41v20,10,65,18,78,33","w":184},"t":{"d":"90,-58v-4,35,20,42,51,35r0,15v-36,20,-109,21,-109,-39r0,-108r-32,0r0,-19r32,0r0,-53r57,0r0,53r50,0r0,19r-49,0r0,97","w":143},"u":{"d":"211,-38v0,16,12,23,29,21r0,13v-28,0,-62,7,-87,3v-1,-7,2,-18,-1,-23v-17,15,-31,29,-66,29v-66,0,-53,-76,-54,-140v-1,-16,-12,-24,-29,-24r0,-13v28,1,62,-7,87,-2r0,117v-6,45,51,40,63,15r0,-95v-1,-16,-12,-23,-30,-22r0,-13v28,0,63,-7,88,-2r0,136","w":243},"v":{"d":"163,-144v2,-15,-15,-15,-25,-18r0,-12r73,0r0,12v-34,6,-38,47,-52,73v-15,29,-30,58,-39,91r-32,0r-65,-145v-4,-11,-17,-16,-28,-19r0,-12r109,0r0,12v-10,0,-31,5,-20,17r41,92","w":204},"w":{"d":"265,-138v9,-17,-12,-22,-24,-24r0,-12r72,0r0,12v-31,5,-33,45,-46,70v-9,17,-25,64,-34,94r-34,0r-44,-120r-42,120r-34,0r-55,-145v-3,-11,-15,-16,-26,-19r0,-12r107,0r0,12v-8,0,-30,4,-20,17r32,86r39,-115r35,0r45,119","w":310},"x":{"d":"136,-127v8,-7,33,-37,0,-35r0,-12r70,0r0,12v-39,12,-48,39,-75,63v21,27,37,57,61,81v4,3,10,4,19,5r0,13r-110,0r0,-13v32,2,14,-19,3,-34v-8,-12,-8,-11,-15,-21v-12,16,-28,28,-36,47v0,8,12,7,19,8r0,13r-71,0r0,-13v42,-14,50,-40,79,-68v-20,-25,-35,-55,-59,-76v-5,-2,-11,-4,-18,-5r0,-12r107,0r0,12v-25,-1,-13,14,-3,28v7,11,8,11,16,23","w":211},"y":{"d":"159,-138v10,-17,-10,-21,-23,-24r0,-12r73,0r0,12v-39,9,-41,59,-59,89v-33,54,-39,138,-109,151v-38,7,-53,-58,-10,-57v19,0,28,13,38,25v8,-8,23,-27,27,-41r-74,-148v-5,-11,-14,-17,-27,-19r0,-12r108,0r0,12v-9,1,-27,3,-20,17r43,86","w":202},"z":{"d":"77,-16v56,6,90,-4,91,-50r13,0r0,66r-173,0r0,-12r101,-146r-38,0v-32,-4,-37,19,-44,41r-12,0r0,-57r163,0r0,11","w":189},"{":{"d":"123,-30v-2,43,3,76,45,73r0,16v-57,-1,-105,-8,-104,-67r2,-43v2,-35,-23,-39,-53,-42r0,-26v29,-3,57,-7,53,-41v-6,-58,3,-108,60,-108v13,-1,27,-2,42,-2r0,15v-41,-2,-48,30,-45,74v3,46,-27,62,-64,69r0,13v37,8,67,22,64,69","w":180},"|":{"d":"85,75r-30,0r0,-343r30,0r0,343","w":139},"}":{"d":"114,-160v-2,35,24,38,54,41r0,26v-30,3,-58,7,-54,42v6,57,-2,107,-59,107v-13,1,-28,3,-43,3r0,-16v42,3,45,-28,45,-73v0,-45,27,-61,64,-69r0,-13v-49,-6,-70,-40,-64,-103v3,-31,-18,-38,-45,-40r0,-15v58,-1,106,8,104,67","w":180},"~":{"d":"173,-102v21,0,28,-17,36,-35r19,8v-13,26,-28,58,-65,59v-36,1,-50,-30,-82,-30v-22,0,-29,16,-37,35r-19,-8v12,-26,28,-58,65,-59v37,-1,49,30,83,30"},"\u00c4":{"d":"186,-327v15,0,28,14,28,30v0,15,-13,29,-28,29v-15,0,-28,-15,-28,-29v0,-16,13,-30,28,-30xm92,-327v15,0,28,14,28,30v0,15,-13,29,-28,29v-15,0,-28,-14,-28,-29v0,-15,12,-30,28,-30xm56,-35v-3,19,16,19,36,21r0,14r-102,0r0,-14v24,-1,37,-12,45,-31r86,-208r36,0r87,216v7,13,18,23,39,23r0,14r-136,0r0,-14v10,-1,45,-2,33,-18r-21,-51r-86,0v-7,14,-15,33,-17,48xm152,-101r-36,-90r-36,90r72,0","w":272},"\u00c5":{"d":"188,-288v0,19,-13,33,-30,38r86,213v7,13,18,23,39,23r0,14r-136,0r0,-14v10,-1,45,-2,33,-18r-21,-51r-86,0v-7,16,-16,34,-17,54v2,12,18,14,36,15r0,14r-102,0r0,-14v24,-1,37,-12,45,-31r85,-204v-18,-5,-32,-17,-32,-39v0,-25,24,-40,50,-40v27,0,50,15,50,40xm152,-101r-36,-90r-36,90r72,0xm138,-258v16,0,23,-12,23,-29v0,-16,-7,-29,-23,-29v-15,0,-25,12,-24,29v0,16,8,29,24,29","w":272},"\u00d6":{"d":"195,-328v35,0,36,59,0,59v-15,1,-28,-14,-28,-30v0,-15,14,-29,28,-29xm100,-328v15,0,28,14,28,29v0,16,-13,31,-28,30v-37,0,-34,-59,0,-59xm148,-256v82,0,135,48,135,130v0,83,-51,133,-137,133v-80,0,-134,-48,-134,-129v0,-82,52,-134,136,-134xm148,-10v55,0,64,-56,64,-115v0,-56,-10,-114,-64,-114v-51,0,-66,53,-65,115v1,58,10,114,65,114","w":295},"\u00dc":{"d":"207,-328v15,0,28,14,28,29v0,16,-13,30,-28,30v-15,0,-28,-14,-28,-30v0,-15,14,-29,28,-29xm113,-328v35,0,36,59,0,59v-15,1,-29,-15,-28,-30v0,-15,12,-29,28,-29xm236,-91v-2,-61,17,-146,-45,-145r0,-13r108,0r0,13v-63,-2,-43,91,-43,152v0,56,-44,91,-101,91v-67,0,-111,-29,-111,-91r0,-128v0,-18,-18,-22,-34,-24r0,-13r131,0r0,13v-18,1,-35,4,-35,22v0,82,-26,200,64,197v42,-2,68,-28,66,-74","w":300},"\u00e1":{"d":"102,-254v8,-26,67,-23,50,10v-19,19,-56,34,-81,50r-8,-6xm211,-17r0,13v-26,13,-81,14,-87,-16v-21,34,-110,37,-110,-18v0,-59,72,-53,110,-73v-1,-26,2,-56,-26,-54v-9,0,-15,2,-21,6v9,21,7,47,-25,47v-19,0,-29,-10,-30,-26v6,-31,43,-40,79,-41v47,0,81,10,81,58v0,40,-24,112,29,104xm75,-48v0,32,37,32,48,12r1,-59v-25,8,-49,15,-49,47","w":214},"\u00e0":{"d":"211,-17r0,13v-26,13,-81,14,-87,-16v-21,34,-110,37,-110,-18v0,-59,72,-53,110,-73v-1,-26,2,-56,-26,-54v-9,0,-15,2,-21,6v9,21,7,47,-25,47v-19,0,-29,-10,-30,-26v6,-31,43,-40,79,-41v47,0,81,10,81,58v0,40,-24,112,29,104xm75,-48v0,32,37,32,48,12r1,-59v-25,8,-49,15,-49,47xm67,-234v-20,-11,-18,-40,7,-38v31,1,30,20,47,41r23,31r-7,6v-30,-20,-45,-26,-70,-40","w":214},"\u00e4":{"d":"148,-267v15,0,28,15,28,30v0,14,-13,29,-28,29v-15,0,-28,-14,-28,-29v0,-16,13,-31,28,-30xm60,-267v15,0,29,15,29,30v0,15,-13,29,-29,29v-15,0,-28,-14,-27,-29v0,-15,11,-30,27,-30xm211,-17r0,13v-26,13,-81,14,-87,-16v-21,34,-110,37,-110,-18v0,-59,72,-53,110,-73v-1,-26,2,-56,-26,-54v-9,0,-15,2,-21,6v9,21,7,47,-25,47v-19,0,-29,-10,-30,-26v6,-31,43,-40,79,-41v47,0,81,10,81,58v0,40,-24,112,29,104xm75,-48v0,32,37,32,48,12r1,-59v-25,8,-49,15,-49,47","w":214},"\u00e5":{"d":"104,-274v27,0,49,14,49,41v-1,24,-22,42,-49,41v-28,0,-49,-14,-49,-41v0,-26,22,-41,49,-41xm104,-205v17,0,23,-11,23,-28v0,-16,-7,-29,-23,-29v-15,0,-23,12,-23,29v0,16,7,28,23,28xm211,-17r0,13v-26,13,-81,14,-87,-16v-21,34,-110,37,-110,-18v0,-59,72,-53,110,-73v-1,-26,2,-56,-26,-54v-9,0,-15,2,-21,6v9,21,7,47,-25,47v-19,0,-29,-10,-30,-26v6,-31,43,-40,79,-41v47,0,81,10,81,58v0,40,-24,112,29,104xm75,-48v0,32,37,32,48,12r1,-59v-25,8,-49,15,-49,47","w":214},"\u00e7":{"d":"120,50v0,-11,-12,-10,-24,-11r0,-34v-52,-6,-84,-36,-84,-93v0,-56,41,-90,102,-91v37,0,70,13,70,45v0,18,-9,28,-30,28v-33,0,-35,-30,-25,-53v-36,-22,-53,29,-53,69v0,36,19,70,50,70v28,0,40,-14,52,-33r13,9v-15,27,-38,49,-80,49r0,12v42,-7,60,41,24,55v-16,6,-34,6,-59,6r0,-14v18,-1,44,5,44,-14","w":191},"\u00e9":{"d":"102,-254v8,-26,67,-23,50,10v-19,19,-56,34,-81,50r-8,-6xm134,-20v24,0,41,-17,52,-32r13,10v-17,27,-44,48,-86,48v-63,0,-101,-33,-101,-94v0,-56,37,-91,97,-91v57,0,88,27,85,86r-118,0v0,45,14,74,58,73xm132,-109v-1,-26,-1,-56,-26,-56v-25,0,-30,25,-30,57","w":205},"\u00e8":{"d":"134,-20v24,0,41,-17,52,-32r13,10v-17,27,-44,48,-86,48v-63,0,-101,-33,-101,-94v0,-56,37,-91,97,-91v57,0,88,27,85,86r-118,0v0,45,14,74,58,73xm132,-109v-1,-26,-1,-56,-26,-56v-25,0,-30,25,-30,57xm68,-234v-20,-11,-18,-40,7,-38v31,1,30,20,47,41r23,31r-7,6v-30,-20,-45,-26,-70,-40","w":205},"\u00ed":{"d":"95,-34v-1,16,13,19,26,21r0,13r-111,0r0,-13v15,0,27,-3,27,-19r0,-102v-1,-17,-14,-23,-31,-25r0,-13v29,0,64,-7,89,-2r0,140xm58,-254v8,-26,67,-23,50,10v-19,19,-56,34,-81,50r-8,-6","w":127},"\u00ee":{"d":"95,-34v-1,16,13,19,26,21r0,13r-111,0r0,-13v15,0,27,-3,27,-19r0,-102v-1,-17,-14,-23,-31,-25r0,-13v29,0,64,-7,89,-2r0,140xm120,-199r-9,5r-53,-45r-52,45r-9,-5v16,-23,26,-52,46,-71v53,-9,51,38,77,71","w":127},"\u00ef":{"d":"95,-34v-1,16,13,19,26,21r0,13r-111,0r0,-13v15,0,27,-3,27,-19r0,-102v-1,-17,-14,-23,-31,-25r0,-13v29,0,64,-7,89,-2r0,140xm98,-267v15,-1,28,14,28,30v0,15,-13,29,-28,29v-15,0,-28,-15,-28,-29v0,-15,13,-30,28,-30xm18,-267v15,0,28,15,28,30v0,14,-13,29,-28,29v-15,0,-28,-14,-28,-29v0,-15,12,-31,28,-30","w":127},"\u00f1":{"d":"161,-239v19,2,22,-12,28,-25r13,4v-9,24,-22,52,-53,53v-28,1,-42,-16,-65,-20v-15,1,-18,12,-26,26r-13,-5v9,-23,23,-50,52,-52v29,-2,41,17,64,19xm217,-34v0,16,11,19,25,21r0,13r-106,0v-7,-22,27,-7,23,-32v-6,-42,17,-118,-26,-118v-19,0,-31,10,-39,22r0,94v-1,15,10,19,23,21r0,13r-107,0r0,-13v16,0,29,-4,27,-19v-5,-46,21,-124,-29,-127r0,-13v28,0,62,-7,86,-2v1,8,-2,20,1,26v17,-14,32,-31,64,-31v70,0,59,78,58,145","w":248},"\u00f3":{"d":"112,-254v8,-19,48,-26,54,-3v-4,25,-21,27,-43,39r-42,24r-7,-6xm114,-179v63,0,102,30,102,91v0,62,-40,94,-103,94v-60,0,-101,-33,-101,-93v0,-60,40,-91,102,-92xm115,-9v35,0,37,-41,37,-79v0,-34,-1,-78,-37,-77v-35,1,-38,38,-38,76v0,41,1,80,38,80","w":228},"\u00f6":{"d":"158,-267v15,0,28,14,28,30v0,15,-13,29,-28,29v-15,0,-28,-14,-28,-29v0,-16,13,-30,28,-30xm71,-267v15,0,28,14,28,30v0,15,-13,29,-28,29v-15,0,-28,-14,-28,-29v0,-15,12,-30,28,-30xm114,-179v63,0,102,30,102,91v0,62,-40,94,-103,94v-60,0,-101,-33,-101,-93v0,-60,40,-91,102,-92xm115,-9v35,0,37,-41,37,-79v0,-34,-1,-78,-37,-77v-35,1,-38,38,-38,76v0,41,1,80,38,80","w":228},"\u00f9":{"d":"211,-38v0,16,12,23,29,21r0,13v-28,0,-62,7,-87,3v-1,-7,2,-18,-1,-23v-17,15,-31,29,-66,29v-66,0,-53,-76,-54,-140v-1,-16,-12,-24,-29,-24r0,-13v28,1,62,-7,87,-2r0,117v-6,45,51,40,63,15r0,-95v-1,-16,-12,-23,-30,-22r0,-13v28,0,63,-7,88,-2r0,136xm82,-234v-20,-11,-18,-40,7,-38v31,1,30,20,47,41r23,31r-7,6v-30,-20,-45,-26,-70,-40","w":243},"\u00fb":{"d":"184,-199r-9,5r-57,-45r-55,45r-9,-5v17,-23,29,-51,50,-70v53,-11,52,37,80,70xm211,-38v0,16,12,23,29,21r0,13v-28,0,-62,7,-87,3v-1,-7,2,-18,-1,-23v-17,15,-31,29,-66,29v-66,0,-53,-76,-54,-140v-1,-16,-12,-24,-29,-24r0,-13v28,1,62,-7,87,-2r0,117v-6,45,51,40,63,15r0,-95v-1,-16,-12,-23,-30,-22r0,-13v28,0,63,-7,88,-2r0,136","w":243},"\u00fc":{"d":"163,-267v15,0,28,15,28,30v0,14,-13,29,-28,29v-16,0,-29,-14,-29,-29v0,-15,14,-30,29,-30xm75,-267v15,0,29,15,29,30v0,15,-13,29,-29,29v-15,0,-28,-15,-28,-29v1,-15,12,-30,28,-30xm211,-38v0,16,12,23,29,21r0,13v-28,0,-62,7,-87,3v-1,-7,2,-18,-1,-23v-17,15,-31,29,-66,29v-66,0,-53,-76,-54,-140v-1,-16,-12,-24,-29,-24r0,-13v28,1,62,-7,87,-2r0,117v-6,45,51,40,63,15r0,-95v-1,-16,-12,-23,-30,-22r0,-13v28,0,63,-7,88,-2r0,136","w":243},"\u00a3":{"d":"122,-110v-4,38,-19,43,-41,63r147,0r0,47r-206,0r0,-33v33,-9,43,-33,40,-77r-34,0r0,-20r34,0v-15,-73,20,-127,90,-127v34,0,74,20,74,50v0,16,-11,29,-29,29v-36,0,-36,-38,-23,-60v-60,-18,-56,52,-52,108r69,0r0,20r-69,0","w":248},"\u00df":{"d":"159,-163v36,8,64,31,65,75v1,63,-52,103,-119,87r0,-15v42,7,56,-31,56,-73v-1,-37,-11,-68,-49,-66v1,-7,-4,-19,7,-16v43,3,51,-87,7,-87v-32,0,-34,29,-35,65r0,193r-84,0r0,-13v15,-1,26,-3,26,-19r0,-147v-2,-66,36,-93,96,-93v42,0,79,14,80,55v1,34,-27,44,-50,54","w":236},"\u2122":{"d":"311,-149v-1,10,11,8,19,10r0,10r-66,0v-5,-16,18,-5,18,-20r0,-77r-4,0r-38,93r-11,0r-37,-95r-4,0v4,34,-14,90,22,89r0,10r-57,0r0,-10v36,3,18,-52,22,-84v1,-13,-11,-15,-21,-17r0,-9r60,0r30,79r29,-79r57,0r0,9v-8,1,-18,1,-19,10r0,81xm62,-239v-24,-5,-31,13,-37,25r-8,0r0,-35r119,0r0,35v-20,0,-12,-33,-44,-25r0,90v-2,9,11,9,18,10r0,10r-66,0v-5,-16,18,-6,18,-19r0,-91","w":341},"\u00ab":{"d":"199,-25r-10,8v-27,-22,-61,-38,-83,-65v-11,-36,18,-46,41,-63r42,-30r10,8r-55,72xm121,-25r-9,8v-27,-22,-61,-38,-83,-65v-11,-36,18,-46,41,-63r42,-30r9,8r-54,72","w":219},"\u00bb":{"d":"181,-70r-74,53r-9,-8r54,-70r-54,-72r9,-8v31,29,114,54,74,105xm104,-70r-74,53r-9,-8r54,-70r-54,-72r9,-8v31,30,113,53,74,105","w":219},"\u2026":{"d":"285,-61v17,0,34,16,34,33v0,18,-17,33,-34,33v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33xm172,-61v17,0,34,16,34,33v0,18,-17,33,-34,33v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33xm59,-61v17,0,34,16,34,33v0,18,-17,33,-34,33v-17,0,-34,-15,-34,-33v0,-17,17,-33,34,-33","w":339},"\u2013":{"d":"235,-87r-217,0r0,-28r217,0r0,28"},"\u2014":{"d":"316,-87r-298,0r0,-28r298,0r0,28","w":333},"\u201c":{"d":"37,-202v52,-13,60,56,16,57v-45,1,-51,-62,-23,-91v13,-13,26,-25,43,-32r8,12v-22,11,-41,27,-44,54xm124,-202v52,-13,60,57,15,57v-45,-1,-50,-62,-22,-91v13,-13,26,-25,43,-32r8,12v-22,11,-41,27,-44,54","w":186},"\u201d":{"d":"47,-269v46,0,52,62,23,91v-13,13,-26,25,-43,32r-8,-12v22,-11,41,-27,44,-54v-52,13,-60,-56,-16,-57xm134,-269v46,0,50,62,22,91v-13,13,-26,25,-43,32r-7,-12v22,-11,41,-27,44,-54v-27,1,-46,-4,-46,-29v0,-15,14,-28,30,-28","w":186},"\u2018":{"d":"35,-202v27,-1,46,4,46,29v0,15,-14,28,-30,28v-46,0,-50,-62,-22,-91v13,-13,26,-25,43,-32r7,12v-22,11,-41,27,-44,54","w":96},"\u2019":{"d":"46,-269v45,1,50,62,22,91v-13,13,-26,25,-43,32r-8,-12v22,-11,41,-27,44,-54v-52,13,-60,-57,-15,-57","w":96},"\u00ff":{"d":"155,-267v15,0,28,15,28,30v0,14,-13,29,-28,29v-15,0,-28,-14,-28,-29v0,-16,13,-31,28,-30xm68,-267v15,0,28,15,28,30v0,14,-13,29,-28,29v-15,0,-28,-14,-28,-29v0,-15,12,-31,28,-30xm159,-138v10,-17,-10,-21,-23,-24r0,-12r73,0r0,12v-39,9,-41,59,-59,89v-33,54,-39,138,-109,151v-38,7,-53,-58,-10,-57v19,0,28,13,38,25v8,-8,23,-27,27,-41r-74,-148v-5,-11,-14,-17,-27,-19r0,-12r108,0r0,12v-9,1,-27,3,-20,17r43,86","w":202},"\u20ac":{"d":"25,-159v10,-78,113,-122,189,-81v6,-6,13,-11,27,-9r1,91r-15,0v-10,-59,-71,-110,-116,-61v-11,12,-15,33,-18,60r61,0r-8,20r-54,0v0,9,-2,19,0,27r44,0r-8,21r-34,0v6,43,22,73,67,73v39,0,59,-25,77,-54r15,9v-20,40,-50,69,-108,70v-65,1,-111,-42,-121,-98r-24,0r8,-21r14,0v0,-9,-2,-18,0,-27r-22,0r8,-20r17,0","w":257},"\u0142":{"d":"33,-126v-6,-48,21,-129,-33,-129r0,-13r88,-4r3,3r0,121r23,-10r7,17r-30,11r0,96v-1,16,12,19,26,21r0,13r-110,0r0,-13v44,4,20,-60,26,-95r-22,9r-7,-16","w":123},"\u00d7":{"d":"214,-34r-20,20r-68,-67r-67,67r-20,-20r68,-67r-68,-67r20,-21r67,68r68,-68r20,21r-68,67"},"\u0107":{"d":"101,-254v7,-20,48,-26,53,-3v-3,26,-21,27,-42,39r-42,24r-8,-6xm191,-44v-16,27,-39,50,-80,50v-62,0,-99,-33,-99,-94v0,-56,41,-90,102,-91v37,0,70,13,70,45v0,18,-9,28,-30,28v-33,0,-35,-30,-25,-53v-36,-22,-53,29,-53,69v0,36,19,70,50,70v28,0,40,-14,52,-33","w":191},"\u0105":{"d":"203,78v-38,1,-78,1,-78,-33v1,-22,14,-29,29,-41v-18,-1,-24,-12,-30,-24v-21,34,-110,37,-110,-18v0,-59,72,-53,110,-73v-1,-26,2,-56,-26,-54v-9,0,-15,2,-21,6v9,21,7,47,-25,47v-19,0,-29,-10,-30,-26v6,-31,43,-40,79,-41v47,0,82,10,81,58r-2,83v-1,18,11,23,31,21r0,13v-9,4,-22,9,-35,9v-22,22,-15,64,27,59r0,14xm75,-48v0,32,37,32,48,12r1,-59v-25,8,-49,15,-49,47","w":214},"\u0119":{"d":"178,78v-38,1,-78,1,-78,-33v0,-21,13,-30,28,-40v-70,6,-116,-28,-116,-93v0,-56,37,-91,97,-91v57,0,88,27,85,86r-118,0v0,45,14,74,58,73v24,0,41,-17,52,-32r13,10v-16,29,-61,39,-61,80v0,20,18,25,40,26r0,14xm132,-109v-1,-26,-1,-56,-26,-56v-25,0,-30,25,-30,57","w":205},"\u015b":{"d":"95,-254v8,-19,48,-26,54,-3v-4,25,-20,27,-42,39r-43,24r-7,-6xm159,-90v39,44,-7,96,-67,96v-21,0,-47,-7,-59,-16r-5,12r-14,0r-2,-65r13,0v10,26,29,50,64,54v32,3,43,-34,19,-45v-37,-17,-90,-17,-91,-70v-2,-55,82,-66,127,-45v1,-8,6,-12,17,-10r3,60r-12,0v-6,-21,-28,-45,-54,-45v-28,0,-39,30,-17,41v20,10,65,18,78,33","w":184},"\u017a":{"d":"101,-254v7,-20,48,-26,53,-3v-3,26,-21,27,-42,39r-42,24r-8,-6xm77,-16v56,6,90,-4,91,-50r13,0r0,66r-173,0r0,-12r101,-146r-38,0v-32,-4,-37,19,-44,41r-12,0r0,-57r163,0r0,11","w":189},"\u017c":{"d":"95,-267v15,-1,30,15,30,30v0,15,-14,29,-30,29v-16,0,-29,-14,-29,-29v0,-15,14,-30,29,-30xm77,-16v56,6,90,-4,91,-50r13,0r0,66r-173,0r0,-12r101,-146r-38,0v-32,-4,-37,19,-44,41r-12,0r0,-57r163,0r0,11","w":189},"\u2032":{"d":"58,-249v22,-22,63,4,40,35r-53,73r-16,0v10,-35,7,-85,29,-108","w":115},"\u2033":{"d":"137,-249v17,-15,59,-4,45,24v-16,31,-42,56,-62,84r-16,0v11,-35,13,-83,33,-108xm58,-249v21,-22,61,4,39,35r-53,73r-16,0v11,-35,8,-85,30,-108","w":191}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface © Sean Johnson 2008. Free for personal use.
 * 
 * Description:
 * This font was created using Font Creator 5.0 from High-Logic.com
 */
Cufon.registerFont({"w":317,"face":{"font-family":"Hand Of Sean","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"0 0 0 0 0 0 0 0 0 0","ascent":"288","descent":"-72","x-height":"18","cap-height":"18","bbox":"-81.7174 -412.106 516.11 177.26","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":109},"\u00a0":{"w":109},"!":{"d":"20,-83v0,-48,21,-181,13,-252v10,-12,16,-13,30,-15r13,12v1,68,-2,88,-9,215v-4,60,2,62,-30,69v-11,-2,-17,-12,-17,-29xm30,-9v15,-5,30,-1,30,17v0,12,-13,23,-33,22v-13,-6,-13,-38,3,-39","w":100},"\"":{"d":"0,-318v-2,-21,8,-31,31,-31v18,22,9,84,9,123v-8,26,-44,25,-40,-5v6,-46,5,-30,0,-87xm67,-292v0,-34,1,-55,25,-55v27,0,9,40,14,61v-2,61,2,63,-21,71v-10,0,-18,-26,-18,-77","w":108},"#":{"d":"4,-223v0,-26,28,-33,67,-30r3,-52v16,-11,29,-5,38,16r-1,36r47,2r3,-54v19,-15,41,5,37,35r0,22r45,2v18,25,-11,44,-48,38r-2,47v46,7,55,-9,55,18v0,7,-6,14,-17,22r-37,0v-1,19,7,59,-14,56v-17,1,-31,-31,-27,-58v-15,0,-33,-4,-46,-2v0,19,8,63,-13,60v-20,2,-30,-35,-29,-61v-20,-1,-61,10,-61,-13v0,-20,34,-30,63,-28v-1,-15,3,-33,0,-46v-20,1,-63,7,-63,-10xm109,-213r-2,47r46,2v0,-15,3,-34,1,-47","w":245},"$":{"d":"122,-122v-6,0,-137,-33,-122,-57r1,-19v27,-23,70,-32,119,-34v10,-33,-1,-90,40,-91v6,0,11,4,17,13r-5,72v24,6,35,8,41,20v-18,21,-15,28,-34,23v-10,7,-2,32,-3,46v34,15,127,28,156,65v-4,37,-52,68,-77,71v-11,4,-33,6,-66,9v-3,14,2,24,8,51v-14,24,-33,26,-54,9v-3,-12,-6,-33,-10,-61v-58,9,-142,-25,-100,-82v15,4,8,-11,25,-4v-5,32,33,43,70,45v3,-25,-2,-51,-6,-76xm119,-190v-27,3,-36,4,-38,9v2,-3,26,11,40,10xm181,-101v2,18,0,40,4,56v32,-1,63,-7,86,-24","w":327},"%":{"d":"93,-206v-46,0,-49,-28,-49,-59v0,-39,11,-44,33,-41v6,-10,12,-14,23,-14v13,1,54,12,52,48v-2,27,-11,53,-39,68v-8,-1,-14,-2,-20,-2xm343,-308r8,36v-106,106,-176,176,-212,206r-102,85v-16,9,-35,2,-37,-19v0,-7,15,-19,44,-39v60,-42,195,-192,258,-248v12,-10,27,-16,41,-21xm104,-276v-6,0,-30,16,-16,30v18,-4,23,-7,22,-22v0,-5,-2,-8,-6,-8xm300,-52v2,34,-14,68,-51,68v-28,0,-53,-14,-53,-44v0,-16,7,-30,7,-48v21,-20,34,-24,63,-23v22,23,34,39,34,47xm234,-50v-3,10,22,27,21,7v5,-25,-17,-22,-21,-7","w":355},"&":{"d":"112,44v-14,-9,-14,-71,-25,-76v-43,-4,-66,-14,-87,-36v-1,-30,21,-49,57,-66v-6,-1,-27,-11,-45,-33v-3,-41,39,-64,82,-71v6,-49,9,-72,30,-71v22,1,14,46,10,66v4,6,74,7,68,34v-5,24,-33,16,-67,10v-7,10,-3,20,-4,34v9,0,19,5,29,15v-1,8,-3,16,0,22v-8,-2,-14,14,-26,13v-3,11,-6,33,2,41v14,0,35,-5,64,-15v23,-2,12,-11,22,-25v5,1,10,4,14,2v30,48,-32,70,-98,81v-1,24,20,64,-7,72v-4,4,-12,6,-16,-2v-1,3,-2,5,-3,5xm63,-182v10,6,18,8,26,8v-1,-6,2,-18,-3,-19v-10,0,-17,4,-23,11xm54,-84v12,2,23,6,37,6v0,-5,1,-22,-2,-21v-19,3,-29,8,-35,15","w":240},"'":{"d":"0,-329v7,-13,16,-18,31,-18v26,0,12,30,16,54v-2,46,-7,74,-41,78v-5,-16,-1,-94,-6,-114","w":53},"(":{"d":"0,-113v0,-70,52,-189,124,-185v5,0,7,4,7,13v0,19,-15,38,-44,58v-19,13,-27,28,-27,41v-12,34,-18,48,-17,66v0,43,28,86,84,130v0,21,-8,36,-29,36v-31,0,-98,-106,-98,-159","w":134},")":{"d":"86,-100v14,-67,-25,-101,-86,-152v-1,-20,7,-35,28,-36v27,-1,103,100,103,166v0,71,-59,185,-122,178v-10,-5,-1,-49,4,-43v19,-11,39,-32,59,-60v0,-6,8,-22,14,-53","w":134},"*":{"d":"37,-243v-2,-2,-34,-7,-37,-18v0,-11,9,-21,21,-23v14,7,36,12,35,-10v-1,-22,-11,-56,19,-54v8,5,20,60,20,64v17,2,45,-19,50,3v-1,28,-13,18,-36,28v1,9,31,26,42,40v-11,45,-52,-2,-71,-16v-7,1,-35,31,-58,28v-13,-17,-4,-26,15,-42","w":153},"+":{"d":"81,-75v-41,1,-86,2,-81,-35v3,-26,57,-7,78,-11v-2,-20,0,-76,8,-72v13,-15,43,-20,41,12r-3,57v24,-2,47,-3,69,-3v14,11,21,34,8,43r-74,7r3,65v-9,16,-35,21,-44,9","w":210},",":{"d":"2,54v-5,-27,47,-75,34,-119v10,-10,35,-12,46,-1v2,48,-15,78,-51,113v-3,9,-20,12,-29,7","w":106},"-":{"d":"2,-96v0,-22,20,-31,50,-31v22,0,64,2,128,7v10,14,5,29,-9,39v-49,-1,-99,-7,-148,-3v-12,1,-21,-2,-21,-12","w":185},"\u00ad":{"d":"2,-96v0,-22,20,-31,50,-31v22,0,64,2,128,7v10,14,5,29,-9,39v-49,-1,-99,-7,-148,-3v-12,1,-21,-2,-21,-12","w":185},".":{"d":"36,9v-36,-11,-18,-57,15,-52v36,5,21,41,-8,51","w":92},"\/":{"d":"264,-299v13,-17,29,-19,43,-3v0,15,-7,32,-21,53v-10,9,-21,20,-32,35v-2,5,-51,52,-143,145v-30,31,-51,59,-65,80v-21,7,-26,17,-31,4r2,-6v-10,4,-14,-2,-17,-10v40,-84,204,-220,264,-298","w":306},"0":{"d":"112,0v-127,0,-145,-236,-63,-313v-2,-2,-3,-4,-3,-8v35,-44,95,-29,126,17v23,35,57,90,57,137v0,62,-44,167,-117,167xm117,-43v29,1,76,-81,69,-124v3,-28,-39,-112,-84,-135v0,4,-2,6,-6,6v-33,17,-51,60,-51,131v0,59,24,119,72,122","w":231},"1":{"d":"64,-351v14,-4,13,14,19,23v0,6,-7,50,-22,134v-12,64,22,170,-23,201v0,-4,-6,-7,-17,-9v-12,-35,-9,-161,-4,-205v3,-5,-14,-17,-17,-33v10,-22,32,-54,44,-101v2,-2,9,-6,20,-10","w":90},"2":{"d":"32,-208v4,-57,78,-115,141,-115v43,0,72,24,72,71v0,77,-107,144,-149,189v86,8,92,15,162,4v28,-5,18,38,12,42v-20,28,-244,12,-234,9v-47,-10,-41,-24,-23,-60v45,-27,146,-114,175,-166v-2,-6,-1,-15,-1,-22v-2,-11,-17,-11,-31,-13v-33,-5,-69,35,-83,64v-10,8,-40,5,-41,-3","w":278},"3":{"d":"198,-262v-26,-18,-66,25,-111,31v-15,2,-24,-23,-9,-35v0,-7,23,-23,69,-40v38,-14,72,-12,102,6v21,53,-12,96,-56,129v24,9,84,53,84,95v0,42,-59,76,-115,76v-49,0,-96,-17,-139,-53v-22,-19,-16,-19,-23,-45v23,-28,32,-16,73,16v51,25,108,52,147,11v-1,-31,-42,-49,-93,-60v-18,-4,-26,-15,-26,-26v0,-28,72,-38,91,-73v-3,-13,3,-22,6,-32","w":278},"4":{"d":"219,-111v-16,44,29,115,-17,134v-10,0,-21,-13,-26,-37v-2,-7,-1,-33,-3,-79v-1,-9,-3,-14,-4,-14v-57,9,-99,14,-127,14r-31,-1v-27,-33,-4,-48,37,-84r117,-102v30,-33,46,-49,50,-49v22,2,32,24,13,47v-4,0,-7,80,-9,114v14,4,105,-34,133,-7v-3,0,-8,11,-17,33v-35,14,-78,20,-116,31xm91,-156r85,-9v1,-23,7,-47,-2,-66v-12,15,-67,51,-83,75"},"5":{"d":"189,-187v-40,-29,-99,12,-159,12v-11,0,-20,-3,-29,-11v-8,-46,-1,-70,18,-115v31,-14,19,-18,48,-6v84,-18,79,-5,157,-28v-1,4,18,8,18,16v0,51,-68,55,-126,50v-67,-6,-65,1,-66,38v91,-18,188,-28,195,63v11,132,-167,245,-264,133v1,-8,3,-16,-1,-22v3,-3,32,-17,34,-15v5,0,11,6,19,18v61,33,114,-9,142,-43v24,-29,28,-59,14,-90","w":236},"6":{"d":"127,-207v60,-50,133,-35,132,49v0,41,-10,83,-37,120v-47,63,-141,66,-196,8v-54,-91,-23,-180,43,-270v27,-36,50,-55,81,-40v8,44,-7,66,-41,97v-9,-25,-22,-9,-32,11v-14,27,-27,63,-22,91r3,0v43,-44,66,-66,69,-66xm205,-174v-59,-7,-100,35,-130,93v-3,16,29,35,60,37v38,2,82,-45,82,-95v0,-23,-6,-35,-12,-35","w":261},"7":{"d":"221,-327v17,46,-19,90,-35,140v23,4,74,-11,70,16v-5,31,-38,29,-84,31v-15,9,-43,133,-60,140v-10,14,-41,14,-47,5v-3,-7,25,-71,51,-137v-28,-14,-62,11,-77,-22v8,-10,4,-26,35,-26v17,0,37,-3,60,-8v18,-30,15,-65,28,-87r-102,2v-25,0,-52,1,-81,5v-20,3,-14,-16,-21,-26v10,-7,15,-11,15,-15v25,-5,219,-20,248,-18","w":249},"8":{"d":"0,-255v0,-58,48,-68,105,-68v57,0,112,12,121,64v5,27,-50,64,-76,89v21,24,101,55,89,105v2,43,-46,83,-103,83v-42,0,-32,-20,-70,-22v-60,-37,-45,-108,2,-158v-45,-34,-68,-65,-68,-93xm53,-262v8,29,34,48,57,64v22,-15,42,-24,54,-43v-4,0,-10,-7,-17,-21v-21,-20,-72,-18,-94,0xm78,-75v0,36,39,44,76,45v19,0,35,-10,34,-33v7,-24,-53,-50,-82,-73v-19,21,-28,41,-28,61","w":243},"9":{"d":"0,-187v-3,-60,69,-147,153,-141v27,2,55,14,31,31v35,37,-8,146,-8,216v0,41,5,70,13,86v-6,15,-15,21,-27,21v-28,0,-38,-41,-36,-73r5,-121v-37,19,-42,31,-80,33v-27,1,-49,-19,-51,-52xm152,-282v-60,-13,-105,40,-101,100v49,1,87,-46,101,-100","w":197},":":{"d":"0,-139v-2,-22,9,-32,34,-34v35,5,26,44,-7,48v-14,1,-20,-4,-27,-14xm19,-62v48,-10,49,37,11,49v-16,5,-29,-3,-29,-21v0,-13,6,-22,18,-28","w":57},";":{"d":"41,-129v-33,3,-35,-43,-2,-49v18,-3,33,4,33,21v0,15,-11,26,-31,28xm0,15v20,-58,12,-82,54,-93v9,1,26,2,26,17v0,19,-14,51,-43,95v-18,12,-26,3,-37,-19","w":81},"\u037e":{"d":"41,-129v-33,3,-35,-43,-2,-49v18,-3,33,4,33,21v0,15,-11,26,-31,28xm0,15v20,-58,12,-82,54,-93v9,1,26,2,26,17v0,19,-14,51,-43,95v-18,12,-26,3,-37,-19","w":81},"<":{"d":"143,-212v15,5,21,33,7,41v-20,12,-66,34,-95,55v23,13,70,44,131,94v1,15,-8,24,-29,27v-19,-9,-95,-69,-140,-93v-26,-13,-23,-45,6,-59v17,-13,80,-45,120,-65","w":185},"=":{"d":"0,-146v-2,-22,26,-30,55,-30v24,0,69,3,137,8v9,15,3,28,-11,38v-54,-2,-108,-3,-161,-3v-14,0,-20,-5,-20,-13xm39,-98v46,-3,72,1,145,8v8,15,3,31,-12,37v-48,-2,-95,-7,-143,-3v-12,-2,-17,-5,-15,-16v3,-17,12,-26,25,-26","w":192},">":{"d":"131,-110v-8,-12,-74,-39,-101,-62v-3,-15,2,-29,14,-35v38,19,76,41,116,63v35,20,36,52,-2,67v-21,8,-88,63,-129,88v-19,-3,-29,-12,-29,-27v2,-2,26,-21,73,-56v36,-26,55,-38,58,-38","w":187},"?":{"d":"0,-310v-2,-11,11,-23,22,-31v76,-17,145,10,183,57v7,60,-75,87,-143,94v3,41,24,109,-25,111v0,0,-23,-12,-16,-27v7,-14,-40,-110,-2,-131v86,-8,133,-17,139,-28v-9,-12,-107,-60,-136,-26v-12,3,-19,-3,-22,-19xm27,21v-7,-28,39,-50,48,-21v1,22,-5,38,-28,40v-13,-2,-20,-7,-20,-19","w":204},"@":{"d":"11,-93v2,-87,34,-131,146,-131v65,0,86,62,85,118v0,31,-15,53,-49,53v-19,0,-34,-23,-47,-53v-21,35,-35,48,-55,49v-17,-3,-23,-10,-22,-26v2,-32,41,-79,88,-85v14,-2,15,72,31,72v13,10,22,-2,22,-23v0,-38,-16,-74,-55,-74v-74,0,-99,35,-103,97v-4,59,60,79,105,80v38,1,86,-22,103,-57v9,-12,39,-4,35,10v-34,109,-288,116,-284,-30xm135,-138v-24,16,-42,37,-35,53v5,2,35,-29,35,-53","w":308},"A":{"d":"86,-95v-7,2,-36,102,-77,63v-2,-18,0,-19,5,-45v0,-2,-12,-5,-35,-9v-21,-10,-6,-22,9,-29v28,-11,51,-5,67,-35v36,-65,54,-87,75,-153v19,-31,43,-19,70,7v-1,41,9,78,31,145v17,4,49,-9,52,9v3,17,-20,25,-38,27v20,51,38,87,55,104v20,20,27,50,-5,50v-29,0,-73,-106,-92,-150v-47,-3,-127,8,-117,16xm158,-220v-17,28,-35,55,-41,74v5,2,39,-8,66,-11v-11,-38,-13,-50,-25,-63","w":290},"B":{"d":"-17,-289v-12,-33,13,-24,46,-33v0,-15,12,-28,34,-28v17,0,20,12,26,23v56,6,132,1,148,43v-14,48,-66,73,-111,106v73,8,163,-18,166,35v-11,64,-104,107,-169,134v9,19,-19,47,-36,18v-29,-5,-76,19,-78,-26v0,-8,6,-15,19,-16v23,-3,36,-3,36,-5r-17,-88r-24,-10v-4,-23,-10,-28,15,-43v-4,-39,-8,-71,-9,-97v-18,3,-49,-1,-46,-13xm81,-279r4,69v15,-12,72,-39,86,-65v-28,-8,-57,-9,-90,-4xm31,-277v0,-1,-2,-2,-2,0r2,0xm84,-209v0,1,-2,2,0,2r0,-2xm232,-134v-2,1,-3,4,0,4r0,-4xm111,-54v47,-25,89,-42,116,-77v-46,-2,-85,-4,-132,5v6,24,7,52,16,72xm94,-128v-1,1,-3,1,0,1r0,-1xm123,-10v-1,0,-1,0,-1,1v1,0,1,0,1,-1","w":273},"C":{"d":"155,0v-94,1,-155,-47,-155,-134v0,-50,34,-103,110,-153v40,-26,65,-36,92,-34v23,2,34,7,33,23v0,15,-24,25,-68,38v-40,12,-116,74,-116,138v0,44,52,75,112,73v86,-3,121,-41,179,-96v22,-21,48,-39,62,-27v0,18,-11,37,-31,56v0,3,-11,17,-36,41v-52,51,-114,75,-182,75"},"D":{"d":"78,-37v-20,-82,-32,-113,-33,-187v0,-12,-106,-5,-96,-42v-2,-6,14,-16,25,-24v35,8,58,16,66,13v-5,-33,52,-49,55,-10v0,7,-1,10,-3,18v27,19,100,34,144,65v40,14,103,42,103,83v0,41,-47,76,-143,104v-20,6,-37,9,-51,14v6,16,-9,16,-29,21v-18,-7,-27,-14,-73,-13v-12,-3,-20,-7,-23,-17v5,-18,12,-24,23,-31v19,4,25,6,35,6xm126,-43v57,-17,159,-30,159,-76v0,-15,-25,-31,-73,-53v-54,-25,-93,-45,-123,-41v0,45,13,102,37,170","w":322},"E":{"d":"98,-299v22,6,85,-33,119,-15v2,36,-26,47,-88,55v-34,4,-52,6,-52,8v-6,17,-7,37,-7,60v71,-16,110,-27,157,-17v0,6,0,10,4,13v-20,38,-99,25,-157,47v10,45,21,79,36,114v47,6,152,-78,212,-51v0,25,6,22,-28,29v-52,10,-96,39,-140,69v-43,29,-76,23,-95,-35v-7,-21,-19,-57,-33,-107v-7,-1,-22,-2,-26,-12v-5,-12,18,-27,19,-45r2,-50v-18,0,-40,3,-35,-18v0,-18,17,-31,50,-38v6,-4,13,-16,29,-24v12,0,23,5,33,17","w":266},"F":{"d":"78,-306v24,6,84,-33,120,-15v2,36,-26,47,-88,55v-35,5,-52,6,-52,8v-6,17,-9,37,-8,60v71,-16,111,-27,158,-17v7,24,-11,28,-35,38v-13,5,-89,8,-119,22v-3,69,-9,114,23,147v7,18,-5,26,-28,29v-36,4,-42,-104,-43,-157v-8,-1,-20,-2,-25,-12v-3,-12,18,-25,19,-45r2,-50v-18,0,-40,3,-35,-18v0,-18,17,-32,50,-39v5,-4,13,-14,28,-23v12,0,23,5,33,17","w":178,"k":{"u":14,"r":23,"o":33,"a":23}},"G":{"d":"2,-168v-1,-87,28,-174,110,-181v38,-3,82,52,85,97v-23,35,-34,35,-54,-12v-8,-20,-16,-30,-28,-36v-50,14,-61,62,-62,124v0,62,14,119,53,158v48,49,75,1,106,-78v5,-15,9,-34,13,-59v-13,2,-41,7,-83,16v4,-12,-20,-12,-20,-23v-6,-32,92,-44,136,-43v18,0,11,15,14,29v-5,54,-44,217,-133,218v-25,0,-54,-9,-75,-34v-45,-52,-62,-114,-62,-176","w":261},"H":{"d":"38,-89v-24,3,-53,1,-55,-17v-4,-40,29,-16,53,-27r-13,-202v5,-39,4,-51,26,-51v36,0,25,25,25,53v0,22,4,118,11,198v33,0,62,-2,86,-6r-9,-222v1,-20,6,-32,25,-32v38,0,28,48,28,80v0,15,0,67,3,155v0,13,3,19,5,19v47,0,72,16,76,30v0,13,-10,19,-26,18v-33,0,-46,-5,-48,-4r12,163v-6,12,-44,14,-47,1v-3,-14,-8,-115,-15,-160v-28,-2,-58,2,-87,2v2,35,4,58,4,67v3,46,-11,37,-42,38v-6,0,-7,-17,-7,-51v0,-34,-3,-50,-5,-52","w":275},"I":{"d":"1,-244v0,-19,-18,-118,25,-104v46,3,16,58,20,102v-4,32,27,171,33,261v-5,14,-43,14,-45,3v-23,-133,-33,-221,-33,-262","w":83},"J":{"d":"150,49v-81,0,-150,-146,-150,-209v0,-21,5,-26,21,-26v21,0,52,27,32,51v21,57,48,103,93,134v47,-65,22,-201,5,-315v-4,-30,22,-35,42,-19r21,147v3,30,5,54,5,70v-1,73,-10,167,-69,167","w":220},"K":{"d":"262,0v-43,13,-133,-63,-181,-87v-5,15,6,55,7,101v-5,13,-38,11,-40,0v-8,-38,-9,-116,-22,-141v-1,-7,-44,-22,-38,-48v0,-4,10,-11,32,-19v14,-5,12,-19,11,-39v0,-24,5,-53,14,-86v16,-7,46,-5,37,21v1,2,-8,49,-10,78v46,-19,102,-50,144,-84v24,3,33,5,33,20v0,11,-20,25,-57,46v-24,14,-71,47,-120,66v-4,21,5,27,25,40v69,47,101,82,164,99v37,2,36,1,40,24v-14,7,-26,9,-39,9","w":265},"L":{"d":"59,-26v33,-7,185,-87,220,-75v14,0,25,2,33,5v-2,25,8,27,-29,31v-92,10,-137,75,-227,86v-24,-2,-37,-4,-37,-9v-16,-98,-24,-197,-18,-304v1,-20,55,-24,51,6v-12,94,-4,120,7,260","w":269},"M":{"d":"25,-158v10,-8,29,-148,69,-138v22,0,39,31,57,90v5,16,11,52,24,99v22,-46,38,-215,54,-241r29,-1v34,50,39,104,69,189v34,98,60,143,84,196v-4,14,-10,18,-24,18v-20,0,-35,-22,-54,-63v-14,-29,-50,-136,-85,-219v-7,29,-13,77,-25,141v-12,64,-22,104,-22,123v-12,9,-6,16,-38,17v-20,-10,-14,-32,-22,-71v-13,-66,-22,-150,-50,-197v-12,16,-25,153,-45,187v-8,9,-35,12,-38,-1v-7,-41,1,-63,-8,-110v-3,-13,11,-22,25,-19","w":380},"N":{"d":"24,13v-28,1,-22,-27,-24,-50v-2,-28,19,-122,19,-194v0,-33,5,-43,40,-40v24,41,69,200,117,234r5,-304v17,-16,46,-8,48,17v-15,54,-6,124,-9,186v-3,47,9,91,9,138v0,30,-5,34,-27,33v-24,0,-46,-21,-71,-60v-6,-10,-41,-79,-66,-109v-10,15,-13,109,-19,143v-6,4,-13,6,-22,6","w":228},"O":{"d":"119,16v-127,2,-150,-227,-87,-322v15,-23,47,-19,75,-24v71,-13,151,221,82,309v-20,26,-45,37,-70,37xm174,-114v0,-60,-25,-159,-73,-174v-8,0,-14,8,-19,23r-14,-3v-12,11,-25,73,-23,100v6,82,17,133,77,141v28,4,52,-47,52,-87","w":209},"P":{"d":"83,-327v61,17,169,40,169,113v0,76,-90,118,-155,141v10,43,15,65,14,90v0,19,-5,30,-15,34v-19,0,-31,-25,-35,-74v-11,-37,-2,-35,-28,-41v-8,-13,-15,-25,7,-39v-9,-22,-15,-115,-19,-173v-24,-12,-35,-11,-33,-23v6,-31,14,-22,35,-30v6,-24,45,-29,53,-5v0,4,2,7,7,7xm85,-117v58,-21,110,-37,119,-98v4,-25,-47,-50,-136,-67v5,96,10,151,17,165","w":250},"Q":{"d":"217,-3v-91,51,-212,2,-212,-114v0,-50,16,-106,49,-168v36,-25,51,-34,76,-34v51,0,136,151,136,208v0,22,-5,44,-17,67v17,22,26,35,59,38v12,11,12,55,-12,48v-26,4,-56,-29,-79,-45xm187,-33v-11,-27,-97,-75,-101,-110v3,-16,10,-25,25,-23v29,5,64,57,103,90v4,0,6,-10,7,-32v0,-38,-19,-83,-64,-142v-14,-18,-29,-25,-42,-25v1,16,8,40,-5,48v-2,2,-13,-16,-22,-16v-15,0,-23,41,-34,121v-10,76,68,125,133,89","w":281},"R":{"d":"374,24v-40,15,-191,-79,-269,-95v-6,13,35,100,-19,94v-23,-15,-27,-68,-35,-102v-20,0,-55,3,-55,-14v0,-17,18,-27,45,-37v-5,-19,-6,-82,-6,-124v-20,-1,-56,14,-56,-13v0,-15,25,-25,66,-27v5,-22,50,-25,49,3v17,0,74,12,171,42v20,6,29,14,29,24v0,40,-27,70,-82,92v-21,9,-39,18,-52,26v31,21,201,76,249,103v0,16,-12,25,-35,28xm84,-248v-4,38,-3,81,7,117v79,-19,120,-31,151,-77v-100,-32,-90,-34,-158,-40","w":339},"S":{"d":"0,-216v0,-49,76,-101,142,-98v41,2,69,7,77,32v-8,19,-63,11,-92,11v-23,0,-60,25,-73,49v35,51,249,55,249,137v0,36,-46,67,-138,89v-60,14,-153,17,-157,-39v-1,-23,23,-52,54,-53v5,15,-1,32,-2,48v65,16,124,5,174,-26v8,-5,12,-11,16,-16v-46,-44,-66,-38,-165,-68v-57,-18,-85,-40,-85,-66","w":304},"T":{"d":"-26,-278v86,-11,189,-20,288,-20v19,0,32,3,33,18v1,17,-36,29,-103,36r-36,0v-12,84,1,155,1,242v0,22,-29,19,-39,21v-21,-64,-18,-171,-16,-255v-31,-9,-77,-2,-115,-2v-45,0,-35,-25,-13,-40","w":226},"U":{"d":"111,-31v81,-31,52,-243,24,-312v-1,-15,21,-16,38,-15v50,102,74,370,-71,370v-112,0,-117,-223,-81,-329v6,-3,46,-8,40,14v-22,87,-20,256,50,272","w":217},"V":{"d":"232,-365v23,-22,29,-26,50,-10v0,10,-16,43,-47,99v-11,21,-22,70,-43,143v-15,54,-28,88,-28,104v0,44,-24,66,-50,47v-20,-27,-30,-90,-46,-117v-32,-56,-60,-92,-63,-161v4,-11,41,-19,47,0v18,57,48,106,74,156v28,-74,81,-237,106,-261","w":252},"W":{"d":"132,-166v-20,30,-8,156,-34,203v-14,1,-39,3,-37,-10v-40,-111,-59,-186,-59,-263v0,-41,20,-72,52,-48v1,60,-5,136,14,174v20,-55,17,-116,32,-152v12,-30,23,-25,50,-12v31,105,59,183,91,234v25,-110,20,-207,8,-340v1,-5,23,-7,30,-14v9,10,15,21,20,33v8,124,15,258,-13,367v-5,22,-16,33,-40,33v-68,-61,-67,-103,-114,-205","w":313},"X":{"d":"85,-118v-4,-21,-130,-116,-64,-152v19,3,29,7,29,12v15,31,38,73,67,99v30,-36,88,-108,117,-128v56,9,32,36,2,64v-47,44,-65,74,-83,101v8,14,53,66,88,66r18,20v2,14,-17,20,-26,29v-41,-6,-71,-32,-108,-71v-39,35,-57,61,-76,103v-12,11,-49,24,-49,-12v0,-25,83,-116,85,-131","w":259},"Y":{"d":"115,-288v-4,42,-50,102,-31,153v55,-25,94,-123,103,-212v11,-8,15,-14,34,-9v9,0,13,4,13,13v0,72,41,247,41,348v0,68,-43,165,-120,165v-67,0,-150,-89,-150,-178v0,-23,9,-41,29,-48v21,2,22,99,38,111v29,51,55,77,79,77v52,-12,79,-83,77,-160v-5,-113,-15,-72,-24,-174v-1,0,-7,12,-22,38v-28,50,-64,75,-104,75v-38,0,-54,-21,-54,-63v0,-32,10,-73,34,-124v13,-28,39,-34,57,-12xm84,-326v0,0,-2,0,-2,1v1,1,2,2,2,-1","w":275},"Z":{"d":"270,-295v76,-8,110,-20,156,-20v20,0,19,11,19,27v0,23,-25,47,-75,73v-96,90,-100,81,-210,165v98,7,234,4,344,5v17,19,19,58,-13,56r-114,-6v-24,0,-70,3,-138,3v-78,0,-157,-2,-217,15v-13,1,-20,-12,-20,-28v0,-17,18,-30,49,-45v99,-49,178,-107,273,-197v-29,1,-147,21,-226,28v-21,-12,-18,-51,5,-60v60,3,74,-6,167,-16","w":514},"[":{"d":"0,-225v12,-49,-11,-128,56,-124r82,5v9,21,5,23,-7,49v-60,1,-90,3,-90,7v-16,83,0,112,3,249v-8,21,22,24,53,25v30,1,70,-6,63,26v0,9,-2,13,-7,13v-32,20,-92,13,-138,5v-11,-79,-16,-164,-15,-255","w":164},"\\":{"d":"17,-295v-2,-4,-4,-13,3,-12v4,1,14,4,28,11v15,39,233,244,209,229v11,14,22,24,30,31v14,21,20,39,20,53v-26,22,-39,4,-62,-29v-18,-26,-213,-204,-233,-252v-1,-1,-10,-10,-12,-23v4,-3,7,-12,17,-8","w":304},"]":{"d":"113,-349v69,-13,48,73,60,124v1,91,-4,176,-16,255v-49,8,-114,15,-148,-5v-13,-13,-11,-49,30,-39v36,-1,97,4,88,-25v1,-82,17,-172,2,-249v0,-4,-32,-6,-96,-7v-12,-26,-17,-28,-7,-49","w":177},"^":{"d":"143,-240v-24,18,-44,-39,-61,-50v-28,22,-45,40,-45,54v0,4,-8,7,-24,7v-10,1,-8,-11,-9,-18v0,-24,48,-56,62,-91v8,-8,15,-10,28,-9v6,16,36,54,58,92v-6,7,2,23,-9,15","w":155},"_":{"d":"320,71v-12,23,-55,23,-95,22v-9,2,-155,-15,-200,-1v-7,-5,-28,-15,-14,-22v-8,-8,-5,-8,-4,-18v0,-5,20,-10,61,-14v48,-5,145,5,230,5v15,0,22,10,22,28","w":333},"`":{"d":"21,-347v24,1,34,42,45,48v29,32,45,40,31,70v-14,1,-30,-2,-28,-7v-2,-14,-17,-32,-45,-54v-9,-4,-15,-16,-19,-36","w":119},"a":{"d":"135,-83v-30,43,-44,81,-97,85v-22,2,-37,-15,-38,-42v0,-27,17,-59,51,-98v28,-20,61,-45,101,-54v9,0,16,9,18,24v2,20,21,123,45,141v9,15,12,19,12,32v0,10,-22,12,-24,14v-39,-17,-42,-53,-68,-102xm117,-137v-18,2,-75,56,-66,91v24,-1,69,-74,66,-91","w":201},"b":{"d":"189,-167v36,89,-47,173,-136,179v-16,0,-31,-7,-45,-21v-12,-53,-8,-117,-8,-180v0,-23,2,-69,14,-133v4,-20,16,-28,34,-27v8,0,15,5,15,17v-11,52,-30,135,-13,194v28,-41,88,-42,139,-29xm58,-36v62,-11,93,-35,87,-84v-59,-16,-82,25,-87,84","w":186},"c":{"d":"1,-40v-8,-62,20,-118,79,-127v11,1,31,2,25,16v19,29,-41,31,-49,49v-12,27,-11,59,26,56v16,5,87,-32,116,-37v20,22,11,17,-9,42v-5,6,-6,9,-10,9v-43,26,-80,39,-111,39v-33,0,-56,-16,-67,-47","w":172},"d":{"d":"195,6v-42,8,-39,-37,-61,-57v-13,36,-67,64,-120,62v-23,-13,-21,-22,-21,-43v0,-13,12,-37,43,-65v26,-25,49,-36,66,-38v6,-2,8,-6,8,-12r-7,-130v12,-7,17,-21,38,-20v0,4,3,7,9,9v11,10,8,92,8,126v0,37,27,105,49,142v1,11,-3,11,-12,26xm59,-56v-8,16,-18,23,-5,24v22,2,44,-29,54,-60v-22,7,-40,19,-49,36","w":191},"e":{"d":"-7,-124v-7,-47,34,-61,65,-63v27,-3,62,31,64,71v1,25,-20,42,-54,58v33,46,69,19,106,-27v14,-18,25,-30,36,-23v-2,12,4,16,10,5v3,10,-21,34,-26,54v-7,1,-10,4,-10,8v-17,26,-42,48,-86,48v-34,0,-70,-25,-102,-76xm49,-89v6,1,27,-10,27,-26v0,-16,-8,-29,-25,-31v-22,2,-16,48,-2,57","w":180},"f":{"d":"-33,-158v9,-3,39,-15,49,-14v0,-64,10,-107,32,-131v70,-20,120,25,132,94v-3,15,-22,15,-40,16v-7,-35,-26,-74,-52,-74v-28,0,-25,61,-27,93v8,4,93,1,121,12v-1,2,2,5,4,9v-15,30,-84,16,-124,24v6,84,12,139,19,167v-4,2,-6,1,-10,-2v-3,13,-10,18,-26,5v-6,0,-8,-4,-8,-11v-7,-5,-8,-104,-18,-154v-22,-6,-60,3,-52,-34","w":165,"k":{"u":28,"o":30,"f":39,"a":9}},"g":{"d":"49,1v-30,0,-53,-29,-49,-67v-10,-68,100,-132,162,-83v10,2,-1,11,-2,12v4,102,11,197,-11,251v-23,55,-87,54,-119,12v5,-18,-42,-47,-21,-73v5,-1,16,9,23,11v7,22,27,36,54,54v53,-19,30,-120,35,-188v-7,4,-43,78,-72,71xm106,-125v-28,-11,-76,40,-60,82v25,-10,47,-66,60,-82","w":173},"h":{"d":"96,-96v-10,9,-37,94,-60,110v-13,3,-17,-11,-30,-15v-10,-21,-5,-189,7,-269v6,0,12,-2,13,-9v7,3,10,5,13,-1v8,4,12,7,12,9v-9,57,-13,123,-10,189v8,-6,18,-29,33,-69v10,-26,40,-41,51,-11v12,31,20,136,55,158v-25,41,-66,-7,-73,-39","w":161},"i":{"d":"6,-244v-4,-17,13,-25,31,-24v16,0,23,5,24,18v1,9,-14,19,-34,19v-14,0,-21,-6,-21,-13xm14,-167v-4,-28,24,-37,34,-22v12,58,9,128,7,195v-12,3,-27,21,-34,2v0,3,-1,5,-2,5v-23,-44,4,-116,-5,-180","w":67},"j":{"d":"61,-253v16,-1,27,3,28,17v1,12,-14,20,-35,20v-14,0,-21,-7,-21,-17v0,-11,9,-19,28,-20xm6,98v60,-23,30,-134,39,-208v3,-29,-9,-84,19,-83v10,0,15,3,15,10v0,57,13,238,-6,273v-17,31,-34,50,-62,49v-26,-1,-62,-10,-66,-44v-20,-32,-38,-43,-18,-65v3,-2,11,10,21,9v8,27,31,42,58,59","w":94},"k":{"d":"58,-75v-12,30,10,93,-17,101v-4,13,-32,9,-21,-6v-6,-1,0,8,-6,9v-14,-30,-2,-86,-6,-126v-27,-14,-36,-43,3,-61v3,0,6,-55,6,-165v0,-44,23,-40,41,-31v6,53,5,115,-2,171v39,-8,86,-42,127,-21v0,5,-4,14,-1,19v-25,26,-100,24,-125,54v5,16,61,25,73,40v31,7,97,42,93,48v-3,2,-2,28,-19,22r-10,3v-72,-33,-88,-42,-136,-57","w":196},"l":{"d":"8,-380v12,-11,36,-17,38,2v12,130,-11,229,17,368v-1,24,-9,17,-29,24v-3,-3,-8,-6,-14,-10v-20,-135,-27,-208,-10,-330v-2,0,-3,-7,-4,-19v-12,-6,2,-6,2,-35","w":65},"m":{"d":"120,-103v15,-7,9,-53,33,-50v4,-13,37,-1,35,3v18,29,36,105,55,143v1,1,-6,10,-11,13v-46,9,-50,-74,-66,-92v-28,65,-29,93,-54,93v-18,0,-27,-18,-30,-55v-3,-29,-5,-43,-7,-43v-18,11,-26,131,-71,90v1,-6,-1,-9,-4,-12v8,-25,0,-57,4,-86v13,-2,-2,-22,18,-23v3,-8,8,-1,13,0v3,0,10,-12,25,-26v26,-24,50,13,60,45","w":246},"n":{"d":"54,-144v17,-5,39,-66,61,-61v15,3,22,7,22,8v24,53,32,166,43,197v0,9,-6,12,-17,12v-15,0,-22,-2,-22,-8v-20,-36,-21,-100,-33,-146v-18,14,-51,106,-74,146v-2,-6,-25,2,-24,-9r-8,-15v7,-24,10,-65,10,-124v15,-8,13,-8,18,-14v21,5,30,2,24,14","w":181},"o":{"d":"61,18v-57,6,-71,-85,-50,-138v7,-6,22,-9,30,-25v8,-5,22,-7,41,-7v32,-1,54,34,54,76v0,44,-31,90,-75,94xm76,-115v-23,0,-32,30,-29,60v2,19,6,28,13,28v28,-9,44,-65,16,-88","w":139},"p":{"d":"148,-146v54,55,-30,123,-88,126v-1,86,5,138,6,160v-6,0,-13,-1,-14,4v-20,-5,-30,-10,-30,-17v-20,-54,-2,-184,-11,-254v-3,4,-6,7,-7,-4v-1,-3,5,-11,6,-15v-3,-1,-4,7,-5,4v-3,-13,21,-23,29,-34v52,0,92,8,114,30xm60,-60v27,0,61,-24,57,-60v-21,-15,-38,-26,-53,-14","w":167},"q":{"d":"22,-112v15,-50,89,-84,136,-58v16,17,24,27,24,31v-15,39,-21,139,-18,223v59,-50,65,-41,111,-55v0,3,3,4,11,5v15,-2,2,6,14,10v-25,32,-67,29,-88,57v-24,33,-38,45,-52,74v-5,-11,-15,12,-18,-3v-4,4,-24,2,-22,-2v-11,-14,-7,-47,-7,-72v0,-56,2,-106,8,-151v-33,33,-60,49,-82,49v-34,0,-45,-70,-24,-101v5,0,7,-2,7,-7xm130,-138v-44,-17,-91,58,-77,92v37,-20,64,-50,77,-92","w":190},"r":{"d":"49,-115v18,-11,57,-71,95,-71v28,0,20,15,30,26v-55,25,-99,91,-104,164v-14,7,-24,10,-29,10v0,-6,-5,-11,-17,-16v4,-5,-26,-95,-24,-141v10,-23,53,-14,49,21r0,7","w":163},"s":{"d":"0,-105v-4,-39,47,-68,92,-68v27,0,30,16,33,28v-5,15,-80,18,-73,26v32,34,137,21,137,79v0,32,-54,56,-100,52v-61,-5,-72,-1,-72,-35v0,-9,4,-17,14,-25v38,17,68,29,95,5v-17,-13,-133,-29,-126,-62","w":179},"t":{"d":"-30,-117v4,-33,63,-9,66,-29v7,2,6,-4,5,-9v0,-42,5,-95,13,-159v12,-17,43,-17,50,5v-11,75,-15,109,-14,167v29,5,57,-10,90,-10v11,0,17,6,17,16v0,15,-10,24,-31,27v-5,4,-49,2,-76,11v0,20,9,45,0,62v8,7,6,48,0,50v-11,0,-21,-5,-26,4v-13,-5,-19,-26,-19,-62v0,-65,5,-54,-50,-54v-12,0,-21,-7,-25,-19","w":165,"k":{"t":42}},"u":{"d":"41,-53v31,-5,37,-129,82,-75v4,44,11,80,20,107v10,11,14,25,6,37v-33,6,-41,-26,-58,-58v-25,23,-32,46,-53,42v-14,7,-41,14,-41,-26v0,-46,2,-98,37,-112v6,0,14,5,21,14v2,8,-15,45,-14,71","w":148},"v":{"d":"82,-66v28,-1,26,-115,70,-109v7,0,14,5,19,15v-4,13,-8,16,-4,25v-18,0,-36,156,-77,147v-15,0,-31,-20,-52,-58v-25,-45,-39,-57,-38,-77v0,-15,12,-21,37,-21v15,26,27,55,45,78","w":176},"w":{"d":"101,-117v14,-4,67,62,71,58v8,-35,0,-71,-2,-108v-3,-39,40,-31,46,-4v-6,42,5,71,10,131v3,41,-12,37,-34,43v-20,6,-63,-46,-89,-63v-23,55,-25,71,-63,81v-34,-24,-62,-142,-21,-177v52,-17,17,57,32,88v11,0,19,-35,24,-37v13,-5,22,-9,26,-12","w":225},"x":{"d":"16,-118v31,-24,34,17,57,34v6,0,27,-14,60,-45v18,-16,47,-15,50,12v-30,33,-44,41,-74,61v13,11,31,26,54,43v-1,5,-1,11,0,16v-33,29,-55,-10,-90,-28v-13,-2,-48,43,-68,40v-2,5,-1,6,-5,6v-30,-20,21,-53,33,-76v-7,-8,-41,-45,-17,-63","w":181},"y":{"d":"41,-65v36,-5,78,-121,76,-128v2,-6,3,-14,3,-24v7,-13,31,-26,46,-8r7,193v8,89,26,203,-71,208v-32,3,-91,-35,-102,-81v22,-24,29,6,59,11v15,7,26,23,47,23v30,0,33,-53,33,-96v0,-39,-5,-83,-14,-129v-8,9,-20,27,-36,54v-28,27,-26,26,-64,29v-14,1,-25,-40,-25,-64v0,-29,5,-66,17,-104v7,-22,29,-23,41,-5v3,16,-23,83,-17,121","w":180},"z":{"d":"89,-40v6,9,95,1,118,16v-7,47,-61,23,-104,29v-29,4,-47,-5,-71,-5v-33,0,-42,-15,-21,-40v24,-28,95,-52,121,-81v-21,2,-54,4,-99,6v-19,-10,-12,-44,12,-46v36,6,59,-4,147,-10v15,3,22,11,22,22v9,34,-93,87,-125,109","w":213},"{":{"d":"43,-183v-22,-55,-14,-141,58,-135v6,0,13,-1,21,-2v7,11,8,17,8,27v4,13,-72,16,-62,52v-2,15,16,39,28,63v0,15,-20,37,-37,39v2,4,40,25,39,37v2,6,-30,51,-30,78v-8,26,46,34,60,42v2,18,1,25,-22,24v-82,-4,-90,-51,-58,-124r1,-9v-43,-15,-76,-65,-13,-87","w":132},"|":{"d":"26,-348v23,5,30,43,28,70v15,104,-6,237,16,337v-8,22,-12,34,-23,19v-7,14,-18,10,-23,-11v-23,-103,-19,-268,-19,-389v0,-14,7,-23,21,-26","w":76},"}":{"d":"11,15v92,-17,46,-55,25,-118v-1,-9,24,-23,39,-36v-21,-6,-35,-19,-37,-39v-2,-2,27,-43,27,-64v0,-48,-96,-25,-52,-78v11,2,21,3,34,2v48,-4,67,90,44,136v71,28,43,65,-7,91v0,3,7,25,19,64v16,53,-48,79,-97,64v-4,-7,-1,-24,5,-22","w":134},"~":{"d":"134,-130v-27,-10,-29,52,-59,53v-24,0,-45,-7,-64,-22v-5,-17,-9,-42,9,-43v5,-3,32,14,52,15v12,-20,28,-53,58,-49v10,-4,45,28,68,26v2,0,3,4,4,11v1,21,-11,9,-11,25v-34,0,-59,-4,-57,-16","w":210},"\u00c4":{"d":"106,-95v-7,1,-37,102,-78,63v-2,-18,0,-19,5,-45v0,-2,-12,-5,-35,-9v-19,-10,-5,-22,9,-29v28,-11,51,-5,67,-35v36,-65,54,-87,75,-153v19,-31,43,-19,70,7v-1,41,10,78,32,145v14,4,46,-9,49,7v11,14,-16,28,-35,29v20,51,37,87,54,104v20,19,28,50,-5,50v-29,0,-72,-107,-91,-150v-47,-3,-127,8,-117,16xm177,-220v-17,28,-35,55,-41,74v5,2,39,-8,66,-11v-11,-38,-13,-50,-25,-63xm144,-348v-26,-8,-12,-40,11,-36v24,4,14,28,-6,35xm192,-359v-8,-25,35,-33,38,-13v4,14,-30,37,-38,13"},"\u00c5":{"d":"106,-95v-7,1,-37,102,-78,63v-2,-18,0,-19,5,-45v0,-2,-12,-5,-35,-9v-19,-10,-5,-22,9,-29v28,-11,51,-5,67,-35v36,-65,54,-87,75,-153v19,-31,43,-19,70,7v-1,41,10,78,32,145v14,4,46,-9,49,7v11,14,-16,28,-35,29v20,51,37,87,54,104v20,19,28,50,-5,50v-29,0,-72,-107,-91,-150v-47,-3,-127,8,-117,16xm177,-220v-17,28,-35,55,-41,74v5,2,39,-8,66,-11v-11,-38,-13,-50,-25,-63xm177,-316v-41,-2,-52,-29,-39,-76v16,-15,29,-21,50,-20v6,3,35,31,30,45v1,22,-14,52,-41,51xm162,-364v0,19,25,31,27,10v-3,-21,2,-24,-13,-24v-10,0,-14,5,-14,14"},"\u00d6":{"d":"119,16v-127,2,-150,-227,-87,-322v15,-23,47,-19,75,-24v71,-13,151,221,82,309v-20,26,-45,37,-70,37xm174,-114v0,-60,-25,-159,-73,-174v-8,0,-14,8,-19,23r-14,-3v-12,11,-25,73,-23,100v6,82,17,133,77,141v28,4,52,-47,52,-87xm79,-374v4,18,-35,37,-39,10v-2,-15,10,-21,25,-22v9,2,14,6,14,12xm121,-350v-22,4,-25,-28,-7,-34v11,-4,27,0,27,11v0,9,-7,17,-20,23","w":220},"\u00dc":{"d":"111,-31v81,-31,52,-243,24,-312v-1,-15,21,-16,38,-15v50,102,74,370,-71,370v-112,0,-117,-223,-81,-329v6,-3,46,-8,40,14v-22,87,-20,256,50,272xm37,-350v-12,1,-19,-3,-19,-17v-1,-12,10,-19,24,-19v24,6,15,28,-5,36xm118,-374v4,17,-35,37,-39,10v-2,-15,10,-21,25,-22v9,2,14,6,14,12","w":217},"\u00e1":{"d":"135,-83v-30,43,-44,81,-97,85v-22,2,-37,-15,-38,-42v0,-27,17,-59,51,-98v28,-20,61,-45,101,-54v9,0,16,9,18,24v2,20,21,123,45,141v9,15,12,19,12,32v0,10,-22,12,-24,14v-39,-17,-42,-53,-68,-102xm117,-137v-18,2,-75,56,-66,91v24,-1,69,-74,66,-91xm140,-294r15,21v-4,20,-9,32,-18,36v-28,22,-45,40,-45,54v0,4,-9,7,-25,7v-9,-1,-8,-11,-9,-18v0,-24,49,-56,63,-91v6,-6,12,-9,19,-9","w":227},"\u00e0":{"d":"135,-83v-30,43,-44,81,-97,85v-22,2,-37,-15,-38,-42v0,-27,17,-59,51,-98v28,-20,61,-45,101,-54v9,0,16,9,18,24v2,20,21,123,45,141v9,15,12,19,12,32v0,10,-22,12,-24,14v-39,-17,-42,-53,-68,-102xm117,-137v-18,2,-75,56,-66,91v24,-1,69,-74,66,-91xm81,-300v22,0,34,32,45,36v29,24,45,29,31,53v-14,0,-31,-2,-29,-5v-2,-10,-17,-24,-45,-41v-9,-3,-14,-12,-18,-27","w":227},"\u00e4":{"d":"135,-83v-30,43,-44,81,-97,85v-22,2,-37,-15,-38,-42v0,-27,17,-59,51,-98v28,-20,61,-45,101,-54v9,0,16,9,18,24v2,20,21,123,45,141v9,15,12,19,12,32v0,10,-22,12,-24,14v-39,-17,-42,-53,-68,-102xm117,-137v-18,2,-75,56,-66,91v24,-1,69,-74,66,-91xm72,-211v-25,-8,-13,-39,10,-36v25,4,16,28,-5,36r-5,0xm120,-222v-8,-25,35,-33,38,-13v4,15,-30,37,-38,13","w":227},"\u00e5":{"d":"135,-83v-30,43,-44,81,-97,85v-22,2,-37,-15,-38,-42v0,-27,17,-59,51,-98v28,-20,61,-45,101,-54v9,0,16,9,18,24v2,20,21,123,45,141v9,15,12,19,12,32v0,10,-22,12,-24,14v-39,-17,-42,-53,-68,-102xm117,-137v-18,2,-75,56,-66,91v24,-1,69,-74,66,-91xm112,-207v-41,-2,-52,-29,-39,-76v16,-15,29,-21,50,-20v6,3,35,31,30,45v1,22,-14,52,-41,51xm97,-255v0,19,25,30,27,10v-3,-20,1,-24,-13,-24v-10,0,-14,5,-14,14","w":227},"\u00e7":{"d":"1,-40v-8,-62,20,-118,79,-127v11,1,31,2,25,16v19,29,-41,31,-49,49v-12,27,-11,59,26,56v16,5,87,-32,116,-37v20,22,11,17,-9,42v-5,6,-6,9,-10,9v-43,26,-80,39,-111,39v-33,0,-56,-16,-67,-47xm100,89v-28,0,-29,-8,-10,-26r1,-7v-15,-7,-48,-11,-47,-29v-4,-6,27,-21,26,-35v0,-1,3,-2,10,-2v18,0,10,3,24,8v1,19,-8,25,-16,28v0,6,13,12,38,18v9,4,14,4,13,10v2,15,-16,35,-39,35","w":208},"\u00e9":{"d":"0,-124v-7,-47,34,-61,65,-63v27,-3,62,31,64,71v1,25,-20,42,-54,58v33,46,69,19,106,-27v14,-18,25,-30,36,-23v-2,12,4,16,10,5v3,10,-21,34,-26,54v-7,1,-10,4,-10,8v-17,26,-42,48,-86,48v-34,0,-69,-25,-101,-76xm56,-89v6,1,27,-10,27,-26v0,-16,-8,-29,-25,-31v-22,2,-16,48,-2,57xm94,-282r15,16v-4,15,-9,24,-18,27v-28,17,-43,30,-45,40v0,3,-9,5,-25,5v-7,3,-9,-7,-9,-13v0,-18,49,-41,63,-68v6,-5,12,-7,19,-7","w":180},"\u00e8":{"d":"0,-124v-7,-47,34,-61,65,-63v27,-3,62,31,64,71v1,25,-20,42,-54,58v33,46,69,19,106,-27v14,-18,25,-30,36,-23v-2,12,4,16,10,5v3,10,-21,34,-26,54v-7,1,-10,4,-10,8v-17,26,-42,48,-86,48v-34,0,-69,-25,-101,-76xm56,-89v6,1,27,-10,27,-26v0,-16,-8,-29,-25,-31v-22,2,-16,48,-2,57xm30,-284v22,0,34,31,45,36v29,24,45,29,31,53v-10,-2,-32,-1,-29,-5v-2,-10,-17,-24,-45,-41v-9,-3,-14,-12,-18,-27","w":180},"\u00ed":{"d":"10,-167v-5,-27,25,-37,35,-22v12,58,7,128,7,195v-12,3,-28,21,-35,2v0,3,0,5,-1,5v-25,-43,4,-116,-6,-180xm68,-289r15,16v-4,15,-9,24,-18,27v-28,17,-43,30,-45,40v0,3,-9,5,-25,5v-7,3,-9,-7,-9,-13v0,-19,48,-42,63,-68v6,-5,12,-7,19,-7","w":67},"\u00ee":{"d":"19,-167v-4,-28,24,-37,34,-22v12,58,9,128,7,195v-11,4,-27,21,-34,2v0,3,0,5,-1,5v-25,-43,3,-115,-6,-180xm91,-208v-19,12,-37,-31,-49,-40v-22,18,-36,32,-36,43v0,3,-7,5,-20,5v-7,-1,-7,-9,-7,-14v0,-20,39,-45,50,-73v7,-7,11,-7,22,-7v5,14,31,41,46,74v-4,6,2,18,-6,12","w":84},"\u00ef":{"d":"10,-167v-5,-27,25,-37,35,-22v12,58,7,128,7,195v-12,3,-28,21,-35,2v0,3,0,5,-1,5v-25,-43,4,-116,-6,-180xm-12,-229v-8,-25,35,-33,38,-13v4,15,-30,37,-38,13xm63,-218v-26,-8,-12,-40,11,-36v25,4,14,28,-6,36r-5,0","w":67},"\u00f1":{"d":"61,-144v17,-5,39,-66,61,-61v15,3,22,7,22,8v24,53,32,166,43,197v0,8,-6,12,-16,12v-15,0,-23,-2,-23,-8v-20,-36,-21,-100,-33,-146v-18,14,-51,106,-74,146v-2,-6,-25,2,-24,-9r-8,-15v7,-24,10,-65,10,-124v15,-8,13,-8,18,-14v21,5,30,2,24,14xm113,-257v-20,-6,-23,31,-44,32v-18,0,-34,-4,-49,-13v-3,-11,-6,-28,8,-26v4,-1,24,9,39,9v9,-13,21,-33,43,-30v8,-2,35,17,52,16v1,0,2,2,3,6v-2,13,-7,9,-11,16v-27,0,-41,-3,-41,-10","w":181},"\u00f3":{"d":"61,18v-57,6,-71,-85,-50,-138v7,-6,22,-9,30,-25v8,-5,22,-7,41,-7v32,-1,54,34,54,76v0,44,-31,90,-75,94xm76,-115v-23,0,-32,30,-29,60v2,19,6,28,13,28v28,-9,44,-65,16,-88xm101,-265r15,16v-4,15,-9,24,-18,27v-28,17,-43,31,-45,41v0,3,-9,5,-25,5v-8,0,-9,-7,-9,-13v0,-18,48,-42,63,-69v6,-5,12,-7,19,-7","w":139},"\u00f6":{"d":"61,18v-57,6,-71,-85,-50,-138v7,-6,22,-9,30,-25v8,-5,22,-7,41,-7v32,-1,54,34,54,76v0,44,-31,90,-75,94xm76,-115v-23,0,-32,30,-29,60v2,19,6,28,13,28v28,-9,44,-65,16,-88xm35,-173v-10,3,-19,-3,-19,-16v0,-11,9,-22,24,-19v24,4,15,27,-5,35xm116,-196v0,18,-36,36,-39,9v-1,-13,9,-23,25,-21v9,1,14,6,14,12","w":139},"\u00f9":{"d":"50,-53v30,-7,36,-129,82,-75v4,44,11,80,20,107v10,11,14,25,6,37v-33,6,-41,-26,-58,-58v-25,23,-33,46,-53,42v-14,7,-41,14,-41,-26v0,-46,2,-98,37,-112v6,0,14,5,21,14v2,8,-15,45,-14,71xm110,-258r15,16v-4,15,-9,24,-18,27v-28,17,-43,31,-45,41v0,3,-9,5,-25,5v-8,0,-9,-7,-9,-13v0,-18,48,-42,63,-69v6,-5,12,-7,19,-7","w":167},"\u00fb":{"d":"51,-53v31,-6,36,-130,83,-75v4,44,11,80,20,107v10,11,14,25,6,37v-34,6,-41,-26,-58,-58v-25,23,-33,46,-53,42v-14,7,-41,14,-41,-26v0,-46,2,-98,37,-112v6,0,13,5,20,14v2,8,-15,45,-14,71xm145,-176v-24,16,-44,-40,-61,-50v-28,22,-45,40,-45,54v0,4,-9,6,-25,6v-8,2,-9,-11,-9,-18v0,-23,49,-56,63,-90v8,-8,14,-10,27,-9v6,16,39,53,59,92v-6,6,2,21,-9,15","w":167},"\u00fc":{"d":"50,-53v30,-7,36,-129,82,-75v4,44,11,80,20,107v10,11,14,25,6,37v-33,6,-41,-26,-58,-58v-25,23,-33,46,-53,42v-14,7,-41,14,-41,-26v0,-46,2,-98,37,-112v6,0,14,5,21,14v2,8,-15,45,-14,71xm49,-171v-22,5,-25,-28,-7,-34v35,-7,33,24,7,34xm130,-194v4,16,-35,36,-39,9v-1,-14,10,-22,25,-22v9,2,14,7,14,13","w":167},"\u00a3":{"d":"347,-83v-55,73,-216,138,-252,9v-15,0,-40,2,-77,6v-3,-11,-15,-12,-14,-23v22,-17,43,-26,63,-26v22,0,31,-7,30,-22r-83,8v-14,-15,-21,-25,5,-41v0,-7,82,-14,91,-31v20,-36,7,-106,56,-106v11,0,18,10,18,27v4,9,-19,45,-22,70r108,-19v12,0,16,6,15,18v11,40,-108,43,-132,56v-7,2,-7,11,-7,21v63,-12,100,-17,111,-17v16,33,-8,47,-58,55r-53,9v14,55,102,40,150,7v24,-17,32,-35,46,-23v-1,10,-3,17,5,22","w":341},"\u00df":{"d":"88,-269v-72,49,-61,198,-22,284v4,20,-16,18,-34,18v-16,-8,-39,-112,-35,-183v6,-98,26,-155,107,-159v22,-2,47,24,47,57v0,19,-16,45,-47,77v-2,5,-5,9,-5,16v-10,16,88,56,80,101v1,21,-23,40,-53,44v-29,3,-83,-33,-45,-58v22,15,39,23,51,23v11,0,13,-9,12,-20v0,-6,-18,-21,-52,-50v-22,-18,-31,-34,-31,-45v-15,-8,96,-87,27,-105","w":178},"\u2122":{"d":"115,-274v14,3,20,32,25,58v12,-16,2,-77,26,-74v13,29,30,97,47,118v-9,13,-16,3,-24,-14v-4,-9,-17,-40,-26,-67v-6,27,-8,59,-17,84v-13,6,-13,-1,-16,-19v-3,-21,-7,-46,-16,-61v-7,5,-1,72,-25,57v-3,-13,2,-19,-2,-33v0,-4,2,-6,7,-6v4,-2,8,-46,21,-43xm-9,-256v12,-22,58,-8,94,-15v6,0,10,0,10,5v1,5,-12,9,-32,11r-10,0v-6,27,4,54,-2,79v-4,1,-7,2,-10,2v-6,-19,-7,-53,-5,-78v-10,-6,-36,4,-45,-4","w":182},"\u00ab":{"d":"101,-84v3,3,79,76,72,75v-1,19,-13,27,-29,8v-24,-29,-43,-47,-57,-56v-19,-13,-23,-37,-2,-53v22,-18,43,-34,64,-49v8,5,10,17,8,28v-12,17,-52,40,-56,47xm30,-89v3,-1,80,78,72,75v-1,17,-14,26,-29,8v-24,-29,-44,-48,-58,-57v-19,-12,-21,-37,-1,-52v22,-18,43,-34,64,-49v8,5,9,17,8,28v-14,16,-52,41,-56,47","w":174},"\u00bb":{"d":"72,-83v-3,-13,-80,-42,-48,-76v23,23,78,36,78,77v0,11,-5,19,-15,25v-12,7,-49,48,-71,68v-11,-2,-16,-9,-16,-21v1,-2,14,-16,40,-43v20,-20,30,-30,32,-30xm143,-89v-5,-7,-40,-31,-55,-47v-3,-10,-1,-24,7,-28v23,23,78,36,78,77v0,11,-5,18,-15,24v-13,8,-46,47,-71,68v-11,-2,-16,-8,-16,-20v1,-2,14,-17,40,-44v20,-20,30,-30,32,-30","w":174},"\u201c":{"d":"0,-318v-2,-21,8,-31,31,-31v18,22,9,84,9,123v-8,26,-44,25,-40,-5v6,-46,5,-30,0,-87xm67,-292v0,-34,1,-55,25,-55v27,0,9,40,14,61v-2,61,2,63,-21,71v-10,0,-18,-26,-18,-77","w":108},"\u201d":{"d":"0,-318v-2,-21,8,-31,31,-31v18,22,9,84,9,123v-8,26,-44,25,-40,-5v6,-46,5,-30,0,-87xm67,-292v0,-34,1,-55,25,-55v27,0,9,40,14,61v-2,61,2,63,-21,71v-10,0,-18,-26,-18,-77","w":108},"\u2018":{"d":"0,-329v7,-13,16,-18,31,-18v26,0,12,30,16,54v-2,46,-7,74,-41,78v-5,-16,-1,-94,-6,-114","w":53},"\u2019":{"d":"0,-329v7,-13,16,-18,31,-18v26,0,12,30,16,54v-2,46,-7,74,-41,78v-5,-16,-1,-94,-6,-114","w":53},"\u20ac":{"d":"137,-1v-54,4,-107,-37,-119,-83v-18,2,-35,1,-35,-17v0,-10,13,-20,37,-28v27,-60,85,-110,171,-109v21,1,39,7,43,28v2,13,-33,19,-52,14v-39,0,-76,16,-103,50v24,3,115,-35,146,-10v-17,48,-121,40,-155,56v8,36,45,51,86,51v15,4,55,-26,84,-27v18,38,-48,71,-103,75","w":244}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2006 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Impact is a trademark of Stephenson Blake (Holdings) Ltd.
 * 
 * Description:
 * 1965. Designed for the Stephenson Blake type foundry. A very heavy, narrow,
 * sans serif face intended for use in newspapers, for headlines and in
 * advertisements. Aptly named, this face has a very large "x" height with short
 * ascenders and descenders.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Geoffrey Lee
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":188,"face":{"font-family":"Impact","font-weight":400,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 8 6 3 9 2 5 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-19 -363.042 362 64.3894","underline-thickness":"17.9297","underline-position":"-27.0703","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":63},"!":{"d":"91,-285r-12,215r-55,0r-11,-215r78,0xm85,-57r0,57r-67,0r0,-57r67,0","w":97},"\"":{"d":"16,-193v-7,-27,-12,-56,-10,-92r54,0v2,35,-2,64,-8,92r-36,0xm82,-193v-6,-28,-11,-56,-9,-92r54,0v2,35,-3,65,-9,92r-36,0","w":133},"#":{"d":"6,-187r54,0r15,-67r33,0r-14,67r62,0r15,-67r33,0r-15,67r30,0r0,34r-36,0r-11,53r47,0r0,33r-53,0r-15,67r-33,0r14,-67r-63,0r-13,67r-34,0r14,-67r-30,0r0,-33r37,0r11,-53r-48,0r0,-34xm87,-153r-11,53r63,0r11,-53r-63,0","w":225},"$":{"d":"114,-286v45,5,71,33,65,84r-71,0v-1,-20,5,-42,-13,-42v-19,0,-14,37,-6,44v28,28,98,44,98,115v0,52,-25,80,-73,86r0,27r-32,0r0,-28v-48,-6,-76,-38,-71,-102r71,0v3,28,-8,59,12,60v23,2,14,-42,11,-53v-30,-43,-99,-48,-96,-119v1,-45,28,-67,73,-72r0,-23r32,0r0,23","w":197},"%":{"d":"194,-290r-111,295r-27,0r111,-295r27,0xm58,-290v57,-3,53,46,53,103v0,38,-15,49,-50,52v-60,5,-55,-45,-55,-101v0,-39,16,-52,52,-54xm59,-160v9,0,6,-5,7,-16r0,-73v0,-12,1,-15,-7,-16v-8,1,-7,5,-8,16r0,72v1,12,-3,17,8,17xm190,-153v57,0,53,46,53,103v0,39,-15,53,-50,53v-37,0,-55,-12,-55,-50v0,-56,-5,-106,52,-106xm191,-22v8,-1,7,-5,7,-16r0,-73v0,-12,1,-16,-7,-17v-8,1,-7,6,-8,17r0,72v1,12,0,16,8,17","w":249},"&":{"d":"93,-243v64,0,90,75,46,115r25,45r38,-25r0,48r-20,13r25,47r-65,0r-9,-16v-51,43,-127,20,-127,-48v0,-33,15,-48,40,-58v-54,-35,-24,-121,47,-121xm92,-204v-21,4,-11,35,1,46v13,-15,19,-40,-1,-46xm86,-86v-16,12,-20,44,3,46v6,0,12,-3,20,-8","w":207},"'":{"d":"16,-193v-7,-27,-12,-56,-10,-92r54,0v2,35,-2,64,-8,92r-36,0","w":66},"(":{"d":"15,-215v-8,-71,28,-70,91,-70r0,37v-28,1,-27,3,-27,33r0,146v1,29,0,31,27,32r0,37v-62,-1,-91,3,-91,-70r0,-145","w":112,"k":{"\u00c5":-9,"\u00c4":-9,"A":-9}},")":{"d":"34,-215v0,-31,0,-32,-28,-33r0,-37v62,0,92,-1,92,70r0,145v7,72,-28,70,-92,70r0,-37v28,0,28,-3,28,-32r0,-146","w":112},"*":{"d":"62,-285r0,29r26,-9r8,20r-26,11r16,24r-17,13r-18,-24r-18,24r-18,-13r16,-24r-26,-11r8,-20r27,9r0,-29r22,0","w":101},"+":{"d":"11,-163r63,0r0,-64r43,0r0,64r64,0r0,42r-64,0r0,63r-43,0r0,-63r-63,0r0,-42","w":191},",":{"d":"54,-56v4,50,-8,86,-48,92r0,-20v7,-4,11,-9,12,-16r-12,0r0,-56r48,0","w":60},"-":{"d":"100,-141r0,49r-94,0r0,-49r94,0","w":105},"\u00ad":{"d":"100,-141r0,49r-94,0r0,-49r94,0","w":105},".":{"d":"60,-58r0,58r-54,0r0,-58r54,0","w":66},"\/":{"d":"140,-290r-84,295r-54,0r85,-295r53,0","w":142},"0":{"d":"95,-290v62,0,85,30,85,102r0,95v4,68,-21,98,-80,98v-64,0,-87,-27,-87,-94r0,-99v-4,-71,21,-102,82,-102xm96,-38v15,-2,13,-11,13,-33r0,-141v-2,-22,4,-33,-12,-34v-15,2,-13,11,-13,34r0,139v1,25,-4,32,12,35","w":193},"1":{"d":"51,-153v4,-54,-4,-51,-49,-53r0,-33v34,-7,60,-23,78,-46r42,0r0,285r-71,0r0,-153","w":137},"2":{"d":"172,-216v0,77,-30,78,-84,167r78,0r0,49r-157,0r0,-41v59,-106,80,-112,96,-182v0,-14,-4,-23,-16,-23v-22,-1,-15,35,-16,58r-64,0v-3,-65,18,-101,77,-102v52,-1,86,28,86,74","w":180,"k":{"4":7}},"3":{"d":"175,-215v0,34,-7,41,-29,54v30,13,31,25,32,76v1,63,-23,91,-83,91v-72,0,-90,-38,-84,-119r71,0v4,26,-10,75,12,75v20,0,13,-32,13,-59v0,-31,-8,-38,-42,-37r0,-41v44,4,42,-11,42,-47v0,-16,0,-24,-13,-24v-19,-1,-10,30,-12,49r-71,0v-4,-65,12,-95,77,-93v62,2,87,20,87,75","w":190,"k":{"7":4}},"4":{"d":"158,-285r0,186r20,0r0,49r-20,0r0,50r-72,0r0,-50r-84,0r0,-49r61,-186r95,0xm86,-99r0,-121r-31,121r31,0","w":179,"k":{"7":7,"1":8}},"5":{"d":"96,-166v-12,2,-14,8,-13,25r-71,0r3,-144r153,0r0,46r-88,0r0,48v11,-13,25,-19,42,-19v63,0,60,56,60,120v0,68,-22,94,-84,95v-67,0,-92,-36,-86,-112r71,0v3,31,-8,66,15,69v26,-4,8,-65,13,-101v-1,-17,-1,-26,-15,-27","w":193,"k":{"7":11,"2":7,"1":11}},"6":{"d":"13,-120v0,-99,-7,-170,85,-170v56,0,86,24,85,81r-71,0v0,-17,3,-39,-15,-37v-25,2,-8,50,-13,78v30,-47,115,-15,99,53v7,78,-12,122,-82,120v-77,-2,-88,-36,-88,-125xm98,-38v23,-4,14,-55,14,-82v0,-17,-1,-26,-14,-27v-25,4,-14,52,-14,78v0,20,-1,29,14,31","w":194,"k":{"7":5,"2":4}},"7":{"d":"138,-285r0,62r-46,223r-70,0r50,-233r-70,0r0,-52r136,0","w":140,"k":{"7":-7,"4":7,"3":-4,"1":-8}},"8":{"d":"178,-215v0,34,-7,40,-30,54v28,14,32,25,33,78v1,65,-23,88,-85,88v-62,0,-86,-23,-84,-91v1,-37,1,-61,28,-75v-19,-9,-25,-29,-26,-56v-1,-51,29,-73,81,-73v59,0,83,22,83,75xm96,-178v18,2,12,-27,12,-45v0,-16,1,-22,-12,-23v-19,-1,-12,27,-12,45v0,15,1,22,12,23xm97,-38v21,0,13,-42,13,-66v0,-17,-1,-27,-14,-27v-22,0,-13,41,-13,64v0,19,0,29,14,29","w":192},"9":{"d":"183,-125v19,114,-49,150,-135,121v-26,-9,-35,-36,-35,-72r71,0v0,18,-2,38,15,38v25,-5,9,-51,13,-79v-30,47,-115,15,-99,-53v-7,-78,12,-120,82,-120v92,0,92,66,88,165xm98,-246v-24,3,-12,55,-14,82v-2,18,2,25,14,26v26,-3,9,-53,14,-78v-1,-20,0,-28,-14,-30","w":194},":":{"d":"66,-185r0,58r-53,0r0,-58r53,0xm66,-58r0,58r-53,0r0,-58r53,0","w":72},";":{"d":"66,-185r0,58r-53,0r0,-58r53,0xm63,-56v4,49,-6,85,-47,92r0,-20v7,-4,11,-9,12,-16r-12,0r0,-56r47,0","w":72},"\u037e":{"d":"66,-185r0,58r-53,0r0,-58r53,0xm63,-56v4,49,-6,85,-47,92r0,-20v7,-4,11,-9,12,-16r-12,0r0,-56r47,0","w":72},"<":{"d":"181,-57r-170,-70r0,-36r170,-71r0,47r-105,42r105,41r0,47","w":191},"=":{"d":"11,-197r170,0r0,43r-170,0r0,-43xm11,-130r170,0r0,43r-170,0r0,-43","w":191},">":{"d":"11,-234r170,71r0,35r-170,71r0,-46r105,-42r-105,-42r0,-47","w":191},"?":{"d":"98,-249v-19,1,-10,31,-12,56r-71,0v-3,-70,22,-98,83,-98v74,0,90,53,84,135v12,64,-62,97,-96,54r0,30r-66,0r0,-78r64,0v0,11,4,16,12,16v25,-1,8,-57,13,-89v-1,-15,2,-26,-11,-26xm86,-57r0,57r-66,0r0,-57r66,0"},"@":{"d":"56,-123v-9,-69,70,-154,116,-87r3,-20r35,0r-23,145v0,5,2,7,6,7v34,-6,54,-43,54,-86v1,-59,-40,-101,-98,-100v-70,0,-117,54,-117,128v0,72,47,123,115,123v38,0,67,-14,89,-33r36,0v-25,34,-72,58,-125,59v-81,1,-141,-63,-141,-147v0,-87,55,-159,143,-157v80,2,119,49,124,127v4,60,-42,114,-90,116v-15,0,-25,-7,-28,-21v-35,46,-108,8,-99,-54xm137,-208v-32,1,-45,58,-45,95v-1,19,9,40,26,40v37,-2,44,-62,44,-99v0,-19,-7,-36,-25,-36","w":278},"A":{"d":"143,-285r42,285r-76,0r-4,-51r-26,0r-4,51r-77,0r38,-285r107,0xm103,-102v-4,-32,-7,-72,-11,-119v-8,54,-12,94,-14,119r25,0","w":182,"k":{"\u2026":-9,"\u00c5":-9,"\u00c4":-9,"}":-9,"z":-9,"x":-9,"]":-9,"Z":-9,"Y":22,"X":-9,"W":7,"V":8,"T":20,"J":-9,"A":-9,"\/":-9,".":-9,",":-9,")":-9}},"B":{"d":"187,-93v2,71,-6,93,-87,93r-85,0r0,-285v85,1,174,-15,167,81v-3,36,-9,42,-39,50v33,9,43,21,44,61xm89,-173v33,8,24,-30,22,-55v-5,-8,-8,-7,-22,-8r0,63xm89,-49v37,7,24,-48,20,-75v-3,-3,-9,-4,-20,-4r0,79","w":198},"C":{"d":"99,-291v76,0,95,47,89,131r-74,0v-4,-28,11,-82,-13,-82v-17,0,-13,11,-14,34r0,132v1,22,-2,31,13,34v23,-1,11,-45,14,-72r74,0v4,81,-17,120,-87,120v-67,0,-88,-32,-88,-107r0,-83v-6,-74,23,-107,86,-107","w":199},"D":{"d":"186,-85v4,72,-14,85,-78,85r-93,0r0,-285r55,0v93,0,116,8,116,101r0,99xm89,-49v28,-1,23,-9,23,-41r-1,-135v-3,-9,-8,-11,-22,-11r0,187","w":198},"E":{"d":"15,-285r123,0r0,57r-49,0r0,54r46,0r0,54r-46,0r0,63r54,0r0,57r-128,0r0,-285","w":149,"k":{"T":5}},"F":{"d":"15,-285r125,0r0,57r-51,0r0,54r45,0r0,54r-45,0r0,120r-74,0r0,-285","w":143,"k":{"\u2026":19,"\u00c5":7,"\u00c4":7,"Y":-8,"W":-7,"V":-8,"A":7,".":19,",":19}},"G":{"d":"96,-291v66,0,94,37,89,111r-74,0v-3,-26,7,-62,-13,-62v-14,0,-11,11,-11,32r0,137v0,20,-2,29,12,31v22,-1,11,-43,14,-68r-15,0r0,-43r87,0r0,153r-47,0r-7,-20v-9,16,-24,26,-46,26v-54,0,-72,-38,-72,-104r0,-84v-6,-76,20,-109,83,-109","w":198},"H":{"d":"185,-285r0,285r-74,0r0,-120r-22,0r0,120r-74,0r0,-285r74,0r0,102r22,0r0,-102r74,0","w":199},"I":{"d":"89,-285r0,285r-74,0r0,-285r74,0","w":103},"J":{"d":"3,-50v23,6,28,-9,28,-34r0,-201r74,0r0,191v3,72,-2,94,-65,94r-37,0r0,-50","w":119},"K":{"d":"191,-285r-42,129r46,156r-76,0r-30,-122r0,122r-74,0r0,-285r74,0r0,111r33,-111r69,0","w":193,"k":{"\u2026":-8,"\u00d6":7,"\u00c5":-7,"\u00c4":-7,"}":-5,"]":-5,"Z":-7,"S":5,"Q":7,"O":7,"J":-5,"C":7,"A":-7,".":-8,",":-8,")":-5}},"L":{"d":"89,-285r0,228r45,0r0,57r-119,0r0,-285r74,0","w":136,"k":{"\u2026":-10,"\u00d6":5,"\u00c5":-9,"\u00c4":-9,"y":9,"Z":-5,"Y":23,"X":-5,"W":13,"V":15,"T":26,"S":2,"Q":5,"O":5,"G":5,"C":5,"A":-9,".":-10,",":-10}},"M":{"d":"243,-285r0,285r-65,0r0,-192r-25,192r-46,0r-28,-188r0,188r-64,0r0,-285r96,0r19,133r17,-133r96,0","w":258},"N":{"d":"180,-285r0,285r-65,0r-38,-129r0,129r-62,0r0,-285r62,0r41,129r0,-129r62,0","w":194},"O":{"d":"98,-291v90,-3,86,75,86,173v0,85,-15,121,-86,124v-91,4,-85,-77,-85,-173v0,-85,14,-121,85,-124xm98,-42v16,-4,12,-13,12,-39r0,-130v-2,-19,4,-31,-11,-31v-14,0,-12,9,-12,31r0,132v2,25,-4,34,11,37","w":196},"P":{"d":"174,-205v7,70,-15,97,-85,90r0,115r-74,0r0,-285v83,1,172,-15,159,80xm89,-163v34,7,24,-45,19,-69v-3,-3,-9,-4,-19,-4r0,73","w":180,"k":{"\u2026":46,"\u00c5":9,"\u00c4":9,"J":14,"A":9,"\/":27,".":46,",":46}},"Q":{"d":"138,-14v-3,22,27,11,46,14r0,34v-41,-5,-105,17,-98,-34v-56,-4,-73,-34,-73,-102r0,-89v-4,-67,24,-100,82,-100v61,0,93,30,89,99v-5,72,21,172,-46,178xm98,-42v16,-4,12,-13,12,-39r0,-130v-2,-19,4,-31,-11,-31v-14,0,-12,9,-12,31r0,132v2,25,-4,34,11,37","w":196},"R":{"d":"139,-149v38,13,42,20,41,74r0,75r-69,0v-1,-38,3,-92,-3,-123v-2,-4,-9,-5,-19,-5r0,128r-74,0r0,-285r52,0v84,-2,113,5,113,78v0,42,-5,54,-41,58xm89,-173v31,8,24,-40,17,-59v-3,-3,-8,-4,-17,-4r0,63","w":193},"S":{"d":"89,-291v59,0,90,23,83,93r-69,0v-1,-17,5,-44,-12,-44v-17,0,-15,32,-9,43v43,43,96,44,96,126v0,60,-31,78,-82,79v-65,2,-92,-34,-85,-108r69,0v3,21,-8,59,13,60v22,1,15,-49,8,-56v-29,-30,-92,-45,-92,-113v0,-60,27,-80,80,-80","w":186},"T":{"d":"164,-285r0,57r-44,0r0,228r-74,0r0,-228r-44,0r0,-57r162,0","w":165,"k":{"\u2026":30,"\u00e7":15,"\u00c5":14,"\u00c4":14,"y":-7,"w":-7,"v":-7,"e":15,"c":15,"a":15,"Z":2,"Y":-9,"W":-8,"V":-9,"J":16,"A":14,"\/":27,".":30,"-":24,",":30}},"U":{"d":"98,-42v14,-2,11,-12,11,-33r0,-210r74,0r0,191v5,71,-22,100,-82,100v-72,0,-87,-32,-87,-122r0,-169r74,0r0,214v1,18,-2,27,10,29","w":196},"V":{"d":"191,-285r-38,285r-112,0r-43,-285r78,0v9,78,15,145,19,199r17,-199r79,0","k":{"\u2026":14,"\u00c5":5,"\u00c4":5,"y":-7,"Y":-9,"J":10,"A":5,"\/":13,".":14,",":14}},"W":{"d":"293,-285r-33,285r-92,0v-8,-44,-16,-93,-22,-149v-3,24,-10,73,-21,149r-92,0r-33,-285r72,0r15,196v3,-50,10,-115,21,-196r77,0r16,202v4,-69,10,-136,20,-202r72,0","w":293,"k":{"\u2026":12,"\u00c5":4,"\u00c4":4,"y":-5,"Y":-7,"J":10,"A":4,"\/":15,".":12,",":12}},"X":{"d":"165,-285r-26,126r39,159r-69,0v-8,-28,-15,-63,-22,-104r-15,104r-72,0r27,-159r-27,-126r72,0v1,17,11,58,15,78r16,-78r62,0","w":173,"k":{"\u2026":-13,"\u00c5":-9,"\u00c4":-9,"J":-7,"A":-9,".":-13,",":-13}},"Y":{"d":"172,-285r-54,182r0,103r-68,0r0,-103r-52,-182r68,0v11,55,17,93,18,112v4,-30,10,-68,20,-112r68,0","w":170,"k":{"\u2026":31,"\u00e7":16,"\u00c5":18,"\u00c4":18,"s":12,"q":11,"o":16,"g":12,"e":16,"d":11,"c":16,"a":16,"J":16,"A":18,"\/":30,".":31,",":31}},"Z":{"d":"139,-285r0,57r-56,171r56,0r0,57r-137,0r0,-41r57,-187r-50,0r0,-57r130,0","w":142,"k":{"\u2026":-8,"\u00c5":-7,"\u00c4":-7,"y":-9,"A":-7,".":-8,",":-8}},"[":{"d":"95,-285r0,44r-16,0r0,197r16,0r0,44r-80,0r0,-285r80,0","w":101,"k":{"\u00c5":-9,"\u00c4":-9,"A":-9}},"\\":{"d":"2,-290r53,0r85,295r-53,0","w":142},"]":{"d":"6,0r0,-44r16,0r0,-197r-16,0r0,-44r81,0r0,285r-81,0","w":101},"^":{"d":"2,-144r66,-141r39,0r65,141r-50,0r-35,-86r-35,86r-50,0","w":174},"_":{"d":"-2,27r203,0r0,18r-203,0r0,-18","w":198},"`":{"d":"0,-311r63,0r31,47r-36,0","w":120},"a":{"d":"87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"b":{"d":"176,-65v11,69,-63,88,-92,47r-5,18r-66,0r0,-285r71,0r0,68v10,-13,23,-19,43,-20v77,-5,38,104,49,172xm95,-37v13,-3,10,-12,10,-32r0,-98v0,-18,2,-28,-11,-29v-13,2,-10,10,-10,29r0,101v1,19,-2,27,11,29","w":187},"c":{"d":"11,-154v-19,-95,124,-108,152,-42v5,12,7,29,7,51r-67,0v-2,-19,6,-51,-11,-51v-12,0,-10,9,-10,24r0,110v0,13,1,25,12,25v20,0,10,-37,12,-59r64,0v3,67,-19,97,-80,100v-86,5,-81,-74,-79,-158","w":178},"d":{"d":"11,-171v-14,-68,61,-82,92,-47r0,-67r71,0r0,285r-71,0r0,-17v-30,37,-106,23,-92,-45r0,-109xm92,-37v14,-2,10,-10,11,-30r0,-108v-1,-14,1,-21,-11,-21v-11,0,-10,7,-10,21r0,115v1,15,-1,21,10,23","w":187},"e":{"d":"89,-237v72,-1,90,46,84,125r-91,0v4,24,-10,71,11,75v20,-1,11,-38,13,-60r67,0v5,66,-18,101,-79,101v-58,-1,-83,-26,-83,-89r0,-68v-3,-57,26,-83,78,-84xm92,-196v-18,-1,-7,25,-10,46r20,0v-2,-19,5,-45,-10,-46","w":184},"f":{"d":"15,-228v-7,-60,34,-57,88,-57r0,36v-27,1,-30,-3,-30,21r30,0r0,37r-17,0r0,191r-71,0r0,-191r-14,0r0,-37r14,0","w":104,"k":{"y":-9,"w":-7,"v":-8}},"g":{"d":"11,-175v-12,-66,64,-78,92,-41r5,-17r66,0r0,179v6,76,-24,92,-88,94v-45,1,-75,-12,-75,-57r68,0v0,10,4,16,12,16v18,0,12,-24,13,-42v-34,31,-93,17,-93,-47r0,-85xm92,-68v14,-2,11,-11,11,-31r0,-72v-1,-17,2,-24,-10,-25v-11,1,-11,9,-11,25r0,78v0,17,-2,24,10,25","w":186},"h":{"d":"95,-196v-12,2,-11,12,-11,30r0,166r-71,0r0,-285r71,0r0,64v40,-33,109,-13,93,60r0,161r-71,0r0,-164v-2,-21,3,-29,-11,-32"},"i":{"d":"86,-285r0,37r-73,0r0,-37r73,0xm86,-233r0,233r-73,0r0,-233r73,0","w":98},"j":{"d":"88,-285r0,37r-73,0r0,-37r73,0xm-1,-5v26,1,16,-5,16,-38r0,-190r73,0r0,184v8,74,-21,85,-89,82r0,-38","w":100},"k":{"d":"166,-233r-29,93r37,140r-68,0r-22,-102r0,102r-71,0r0,-285r71,0r0,120r22,-68r60,0","w":172},"l":{"d":"86,-285r0,285r-73,0r0,-285r73,0","w":98},"m":{"d":"94,-196v-15,0,-12,19,-12,34r0,162r-69,0r0,-233r70,0r-1,22v15,-33,72,-36,90,0v10,-16,23,-26,45,-26v41,0,50,25,49,71r0,166r-69,0r0,-152v-2,-28,5,-40,-12,-44v-16,4,-12,16,-12,44r0,152r-68,0r0,-148v-3,-32,5,-43,-11,-48","w":277},"n":{"d":"95,-196v-15,3,-11,12,-11,38r0,158r-71,0r0,-233r72,0r-1,21v10,-16,21,-25,44,-25v42,0,48,25,48,74r0,163r-71,0r0,-162v-2,-23,5,-32,-10,-34"},"o":{"d":"90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27","w":184},"p":{"d":"129,4v-21,0,-35,-10,-45,-24r0,53r-71,0r0,-266r72,0r-1,20v10,-14,25,-23,46,-24v70,-1,41,101,46,167v3,48,-7,74,-47,74xm95,-37v13,-2,10,-10,10,-28r0,-100v-2,-21,5,-31,-10,-31v-15,0,-11,12,-11,31r0,96v2,20,-4,31,11,32","w":186},"q":{"d":"11,-173v-10,-68,67,-81,92,-40r1,-20r70,0r0,266r-71,0r0,-52v-12,17,-17,22,-41,23v-75,1,-41,-106,-51,-177xm92,-37v13,-2,11,-9,11,-28r0,-105v-1,-15,0,-25,-11,-26v-12,2,-10,9,-10,26r0,104v1,20,-2,26,10,29","w":186},"r":{"d":"126,-155v-42,1,-43,13,-42,63r0,92r-71,0r0,-233r71,0r-3,30v10,-22,25,-33,45,-34r0,82","w":128,"k":{"\u2026":25,"y":-7,"w":-7,"v":-7,"t":-7,"f":-7,".":25,",":25}},"s":{"d":"81,-237v53,3,83,19,77,78r-63,0v-2,-18,5,-38,-11,-37v-18,1,-16,36,-2,42v28,22,81,30,81,85v0,54,-26,72,-74,73v-57,1,-85,-24,-80,-86r63,0v1,20,-4,43,12,45v20,3,15,-34,10,-41v-4,-6,-79,-41,-80,-57v-22,-55,5,-106,67,-102","w":169},"t":{"d":"110,0v-65,1,-94,4,-94,-72r0,-119r-15,0r0,-37r15,0r0,-36r72,0r0,36r19,0r0,37r-19,0r0,125v1,28,-6,28,22,28r0,38","w":109,"k":{"\u2026":-11,"z":-8,"y":-7,"v":-7,".":-11,",":-11}},"u":{"d":"93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38"},"v":{"d":"81,-63r15,-170r63,0r-33,233r-92,0r-36,-233r63,0","w":157,"k":{"\u2026":7,"z":-4,"y":-11,"t":-10,"f":-10,".":7,",":7}},"w":{"d":"242,-233r-28,233r-77,0v-4,-28,-9,-65,-15,-112r-16,112r-77,0r-30,-233r61,0v0,6,6,50,16,133v1,-8,5,-52,15,-133r59,0r15,133v2,-39,7,-83,16,-133r61,0","w":240,"k":{"z":-2,"y":-9,"f":-8}},"x":{"d":"153,-233r-28,111r34,122r-69,0v-7,-31,-11,-57,-15,-79v-5,28,-10,54,-16,79r-59,0r31,-122r-31,-111r59,0v9,48,15,75,16,81v7,-40,11,-67,15,-81r63,0","w":156,"k":{"\u2026":-8,"y":-5,".":-8,",":-8}},"y":{"d":"15,-5v30,1,29,-2,22,-33r-39,-195r64,0r24,157r11,-157r64,0r-28,223v-6,48,-61,44,-118,43r0,-38","w":161,"k":{"\u2026":7,"z":-2,"x":-7,"v":-7,"t":-7,"f":-7,".":7,",":7}},"z":{"d":"123,-233r0,51r-52,135r52,0r0,47r-121,0r0,-49r54,-138r-48,0r0,-46r115,0","w":126,"k":{"\u2026":-8,"z":-7,"y":-8,"w":-7,"v":-9,"t":-5,"f":-5,".":-8,",":-8}},"{":{"d":"45,-21v0,-50,2,-69,-39,-74r0,-42v35,-3,39,-17,39,-61v0,-68,18,-89,82,-87r0,42v-30,1,-35,1,-36,26v-3,61,1,75,-33,101v33,16,32,64,33,112v5,13,12,15,35,15r0,42v-59,2,-81,-13,-81,-74","w":133,"k":{"\u00c5":-9,"\u00c4":-9,"A":-9}},"|":{"d":"30,-285r38,0r0,332r-38,0r0,-332","w":97},"}":{"d":"88,-210v0,51,-3,68,39,73r0,42v-34,3,-39,19,-39,62v0,67,-16,89,-81,86r0,-42v29,-1,34,-1,35,-26v3,-61,0,-76,33,-101v-29,-20,-29,-33,-32,-81v-2,-42,5,-43,-37,-46r0,-42v59,-1,82,14,82,75","w":133},"~":{"d":"131,-158v23,-2,26,-11,48,-29r0,49v-41,42,-74,13,-120,0v-13,0,-29,9,-49,28r0,-48v17,-15,34,-23,51,-23v14,0,56,24,70,23"},"\u00c4":{"d":"74,-339r0,45r-46,0r0,-45r46,0xm150,-339r0,45r-45,0r0,-45r45,0xm143,-285r42,285r-76,0r-4,-51r-26,0r-4,51r-77,0r38,-285r107,0xm103,-102v-4,-32,-7,-72,-11,-119v-8,54,-12,94,-14,119r25,0","w":182,"k":{"\u2026":-9,"\u00c5":-9,"\u00c4":-9,"}":-9,"z":-9,"x":-9,"]":-9,"Z":-9,"Y":22,"X":-9,"W":7,"V":8,"T":20,"J":-9,"A":-9,"\/":-9,".":-9,",":-9,")":-9}},"\u00c5":{"d":"52,-326v0,-20,17,-37,37,-37v21,-1,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37xm103,-325v0,-8,-6,-15,-14,-15v-8,0,-15,8,-15,15v0,7,7,14,15,14v7,1,14,-7,14,-14xm143,-285r42,285r-76,0r-4,-51r-26,0r-4,51r-77,0r38,-285r107,0xm103,-102v-4,-32,-7,-72,-11,-119v-8,54,-12,94,-14,119r25,0","w":182,"k":{"\u2026":-9,"\u00c5":-9,"\u00c4":-9,"}":-9,"z":-9,"x":-9,"]":-9,"Z":-9,"Y":22,"X":-9,"W":7,"V":8,"T":20,"J":-9,"A":-9,"\/":-9,".":-9,",":-9,")":-9}},"\u00d6":{"d":"83,-339r0,45r-46,0r0,-45r46,0xm160,-339r0,45r-46,0r0,-45r46,0xm98,-291v90,-3,86,75,86,173v0,85,-15,121,-86,124v-91,4,-85,-77,-85,-173v0,-85,14,-121,85,-124xm98,-42v16,-4,12,-13,12,-39r0,-130v-2,-19,4,-31,-11,-31v-14,0,-12,9,-12,31r0,132v2,25,-4,34,11,37","w":196},"\u00dc":{"d":"83,-339r0,45r-46,0r0,-45r46,0xm160,-339r0,45r-46,0r0,-45r46,0xm98,-42v14,-2,11,-12,11,-33r0,-210r74,0r0,191v5,71,-22,100,-82,100v-72,0,-87,-32,-87,-122r0,-169r74,0r0,214v1,18,-2,27,10,29","w":196},"\u00e1":{"d":"151,-297r-58,48r-36,0r31,-48r63,0xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e0":{"d":"87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29xm31,-296r63,0r31,47r-36,0","w":181},"\u00e4":{"d":"75,-295r0,46r-46,0r0,-46r46,0xm152,-295r0,46r-46,0r0,-46r46,0xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e5":{"d":"54,-286v0,-20,17,-37,37,-37v20,0,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-16,-37,-37xm105,-285v0,-8,-8,-15,-15,-15v-7,0,-14,7,-14,15v-1,7,7,14,14,14v8,0,15,-6,15,-14xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e7":{"d":"170,-96v2,64,-17,96,-74,100r0,5v13,0,26,10,25,23v0,37,-66,47,-72,5r26,0v3,12,21,10,20,-3v-1,-10,-9,-11,-20,-11r0,-20v-74,-3,-64,-80,-64,-157v0,-97,124,-108,152,-42v5,12,7,29,7,51r-67,0v-2,-19,6,-51,-11,-51v-12,0,-10,9,-10,24r0,110v0,13,1,25,12,25v20,0,10,-37,12,-59r64,0","w":178},"\u00e9":{"d":"152,-297r-58,48r-35,0r30,-48r63,0xm89,-237v72,-1,90,46,84,125r-91,0v4,24,-10,71,11,75v20,-1,11,-38,13,-60r67,0v5,66,-18,101,-79,101v-58,-1,-83,-26,-83,-89r0,-68v-3,-57,26,-83,78,-84xm92,-196v-18,-1,-7,25,-10,46r20,0v-2,-19,5,-45,-10,-46","w":184},"\u00e8":{"d":"89,-237v72,-1,90,46,84,125r-91,0v4,24,-10,71,11,75v20,-1,11,-38,13,-60r67,0v5,66,-18,101,-79,101v-58,-1,-83,-26,-83,-89r0,-68v-3,-57,26,-83,78,-84xm92,-196v-18,-1,-7,25,-10,46r20,0v-2,-19,5,-45,-10,-46xm32,-296r63,0r31,47r-36,0","w":184},"\u00ed":{"d":"86,-233r0,233r-73,0r0,-233r73,0xm110,-297r-58,48r-36,0r31,-48r63,0","w":98},"\u00ee":{"d":"51,-272r-20,23r-50,0r46,-49r49,0r42,49r-47,0xm86,-233r0,233r-73,0r0,-233r73,0","w":98},"\u00ef":{"d":"86,-233r0,233r-73,0r0,-233r73,0xm34,-295r0,46r-45,0r0,-46r45,0xm111,-295r0,46r-46,0r0,-46r46,0","w":98},"\u00f1":{"d":"168,-282v-14,43,-64,30,-99,16v-9,0,-15,5,-21,17r-28,-18v21,-49,61,-32,101,-20v10,0,16,-5,19,-16xm95,-196v-15,3,-11,12,-11,38r0,158r-71,0r0,-233r72,0r-1,21v10,-16,21,-25,44,-25v42,0,48,25,48,74r0,163r-71,0r0,-162v-2,-23,5,-32,-10,-34"},"\u00f3":{"d":"152,-297r-58,48r-35,0r30,-48r63,0xm90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27","w":184},"\u00f6":{"d":"76,-295r0,46r-45,0r0,-46r45,0xm153,-295r0,46r-46,0r0,-46r46,0xm90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27","w":184},"\u00f9":{"d":"93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38xm34,-296r63,0r31,47r-36,0"},"\u00fb":{"d":"95,-272r-20,23r-50,0r46,-49r49,0r43,49r-48,0xm93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38"},"\u00fc":{"d":"79,-295r0,46r-46,0r0,-46r46,0xm155,-295r0,46r-45,0r0,-46r45,0xm93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38"},"\u00a3":{"d":"96,-290v56,2,89,36,80,97r-64,0v-3,-21,8,-57,-14,-60v-38,4,3,72,0,91r45,0r0,49r-41,0v0,32,-12,56,-34,72v28,-6,68,14,56,-39r60,0v3,53,-3,88,-53,85v-33,-2,-90,-25,-118,0r0,-41v19,-12,25,-47,25,-77r-25,0r0,-49r17,0v-36,-59,-4,-131,66,-128","w":192},"\u00df":{"d":"94,-291v73,-7,119,68,65,111v28,11,27,49,27,95v0,66,-30,87,-93,85r0,-43v24,0,22,-1,22,-28r0,-70v0,-16,-1,-19,-14,-21r0,-44v10,-1,11,-3,11,-16v0,-15,-2,-27,-14,-27v-15,0,-14,10,-14,29r0,220r-71,0r0,-190v-5,-75,17,-95,81,-101","w":198},"\u2122":{"d":"47,-141r0,-119r-45,0r0,-25r117,0r0,25r-43,0r0,119r-29,0xm130,-141r0,-144r45,0r26,100r27,-100r45,0r0,144r-27,0r0,-114r-32,114r-26,0r-31,-114r0,114r-27,0","w":281},"\u00ab":{"d":"21,-218r42,0r-15,96r15,100r-42,0r-15,-100xm86,-218r41,0r-15,96r15,100r-41,0r-15,-100","w":133},"\u00bb":{"d":"112,-218r15,96r-15,100r-41,0r15,-100r-15,-96r41,0xm48,-218r15,96r-15,100r-42,0r15,-100r-15,-96r42,0","w":133},"\u2026":{"d":"60,-58r0,58r-54,0r0,-58r54,0xm193,-58r0,58r-54,0r0,-58r54,0xm126,-58r0,58r-53,0r0,-58r53,0","w":199},"\u2013":{"d":"-2,-139r184,0r0,44r-184,0r0,-44","w":180},"\u2014":{"d":"-2,-139r364,0r0,44r-364,0r0,-44","w":360},"\u201c":{"d":"70,-192v-4,-50,8,-87,48,-93r0,21v-7,4,-11,9,-12,16r12,0r0,56r-48,0xm6,-192v-4,-50,8,-86,48,-93r0,21v-7,4,-11,9,-12,16r12,0r0,56r-48,0","w":124},"\u201d":{"d":"118,-285v4,51,-9,85,-48,93r0,-21v7,-4,11,-9,12,-16r-12,0r0,-56r48,0xm54,-285v4,50,-9,86,-48,93r0,-21v7,-4,11,-9,12,-16r-12,0r0,-56r48,0","w":124},"\u2018":{"d":"6,-192v-4,-50,8,-86,48,-93r0,21v-7,4,-11,9,-12,16r12,0r0,56r-48,0","w":60},"\u2019":{"d":"54,-285v4,50,-9,86,-48,93r0,-21v7,-4,11,-9,12,-16r-12,0r0,-56r48,0","w":60},"\u00ff":{"d":"68,-295r0,46r-46,0r0,-46r46,0xm144,-295r0,46r-45,0r0,-46r45,0xm15,-5v30,1,29,-2,22,-33r-39,-195r64,0r24,157r11,-157r64,0r-28,223v-6,48,-61,44,-118,43r0,-38","w":161},"\u20ac":{"d":"99,-242v-27,0,-17,34,-19,60r20,0r0,30r-20,0r0,14r20,0r0,30r-20,0v2,26,-8,65,17,66v26,0,15,-37,17,-63r65,0v4,73,-17,111,-82,111v-65,0,-90,-38,-84,-114r-17,0r0,-30r17,0r0,-14r-17,0r0,-30r17,0v-6,-73,22,-109,86,-109v59,0,84,34,80,104r-65,0v-3,-22,8,-55,-15,-55","w":191},"\u0142":{"d":"88,-184r12,-3r0,30r-12,4r0,153r-73,0r0,-131r-13,4r0,-31r13,-3r0,-124r73,0r0,101","w":102},"\u00d7":{"d":"13,-197r30,-30r53,52r53,-52r30,30r-53,53r53,52r-31,30r-52,-52r-52,52r-30,-30r52,-52","w":191},"\u0107":{"d":"150,-297r-58,48r-36,0r31,-48r63,0xm11,-154v-19,-95,124,-108,152,-42v5,12,7,29,7,51r-67,0v-2,-19,6,-51,-11,-51v-12,0,-10,9,-10,24r0,110v0,13,1,25,12,25v20,0,10,-37,12,-59r64,0v3,67,-19,97,-80,100v-86,5,-81,-74,-79,-158","w":178},"\u0105":{"d":"90,-232v119,0,71,130,80,232r-23,0v-10,10,-15,18,-15,24v1,16,20,11,33,6r7,18v-25,14,-64,10,-65,-20v0,-10,4,-19,14,-28r-20,0r0,-21v-8,16,-19,18,-42,21v-59,8,-56,-67,-42,-106v5,-12,69,-32,74,-37v10,-5,14,-53,-3,-53v-21,0,-9,35,-12,53r-66,0v-4,-64,16,-89,80,-89xm76,-62v-2,26,23,35,23,10r0,-59v-19,16,-20,16,-23,49","w":181},"\u0119":{"d":"92,-37v23,0,11,-39,14,-61r67,0v4,58,-11,95,-65,98v-10,10,-15,18,-15,24v1,17,20,11,33,6r7,18v-26,14,-64,10,-66,-20v0,-10,5,-19,15,-28v-50,-4,-72,-28,-72,-85r0,-68v-2,-55,24,-80,79,-80v75,0,89,44,84,121r-92,0v3,24,-9,71,11,75xm92,-196v-17,1,-9,29,-11,46r21,0v-2,-20,7,-46,-10,-46","w":184},"\u015b":{"d":"143,-297r-58,48r-36,0r31,-48r63,0xm81,-237v53,3,83,19,77,78r-63,0v-2,-18,5,-38,-11,-37v-18,1,-16,36,-2,42v28,22,81,30,81,85v0,54,-26,72,-74,73v-57,1,-85,-24,-80,-86r63,0v1,20,-4,43,12,45v20,3,15,-34,10,-41v-4,-6,-79,-41,-80,-57v-22,-55,5,-106,67,-102","w":169},"\u017a":{"d":"120,-297r-58,48r-35,0r31,-48r62,0xm123,-233r0,51r-52,135r52,0r0,47r-121,0r0,-49r54,-138r-48,0r0,-46r115,0","w":126},"\u017c":{"d":"86,-295r0,46r-45,0r0,-46r45,0xm123,-233r0,51r-52,135r52,0r0,47r-121,0r0,-49r54,-138r-48,0r0,-46r115,0","w":126},"\u2032":{"d":"52,-193r-36,0r-2,-92r54,0","w":66},"\u2033":{"d":"52,-193r-36,0r-2,-92r54,0xm124,-193r-36,0r-2,-92r54,0","w":139},"\u00a0":{"w":63}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2006 Microsoft Corporation. All rights reserved.
 * 
 * Trademark:
 * Tahoma is either a registered trademark or a trademark of Microsoft Corporation
 * in the United States and/or other countries.
 * 
 * Manufacturer:
 * Microsoft Corporation
 * 
 * Designer:
 * Matthew Carter
 * 
 * Vendor URL:
 * http://www.microsoft.com/typography
 */
Cufon.registerFont({"w":196,"face":{"font-family":"Tahoma","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 4 3 5 4 4 2 4","ascent":"288","descent":"-72","x-height":"5","bbox":"-16 -349 333 74.5539","underline-thickness":"22.8516","underline-position":"-18.457","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":112},"\u00a0":{"w":112},"!":{"d":"79,-262r-4,190r-30,0r-5,-190r39,0xm78,0r-36,0r0,-37r36,0r0,37","w":119,"k":{"\u2019":17,"\u201d":17}},"\"":{"d":"124,-274r-7,102r-23,0r-8,-102r38,0xm58,-274r-7,102r-23,0r-8,-102r38,0","w":144},"#":{"d":"237,-164r-52,0r-16,66r47,0r0,24r-53,0r-18,74r-23,0r18,-74r-47,0r-18,74r-23,0r18,-74r-45,0r0,-24r51,0r17,-66r-47,0r0,-24r53,0r18,-74r23,0r-19,74r48,0r18,-74r23,0r-18,74r45,0r0,24xm163,-164r-48,0r-16,67r48,0","w":261},"$":{"d":"110,-128v38,6,70,19,70,61v0,37,-34,64,-70,67r0,63r-20,0r0,-62v-25,0,-54,-7,-71,-16v2,-11,-3,-28,2,-35v18,13,42,22,69,25r0,-76v-36,-9,-70,-20,-70,-63v0,-38,33,-63,70,-65r0,-48r20,0r0,47v21,0,47,8,62,14r0,34v-19,-8,-37,-20,-62,-22r0,76xm90,-204v-31,-1,-48,36,-29,59v5,6,15,11,29,14r0,-73xm110,-26v34,3,48,-40,28,-61v-5,-6,-15,-9,-28,-12r0,73"},"%":{"d":"80,-267v44,0,62,30,62,78v1,48,-19,78,-62,78v-44,0,-62,-30,-62,-78v-1,-48,18,-78,62,-78xm259,-262r-137,262r-29,0r137,-262r29,0xm272,-150v44,0,61,29,61,77v0,48,-17,78,-61,78v-45,0,-62,-29,-62,-77v0,-48,18,-78,62,-78xm80,-135v28,0,31,-23,31,-54v0,-31,-3,-54,-31,-54v-28,0,-31,23,-31,54v0,32,2,54,31,54xm272,-18v28,0,30,-24,30,-55v0,-31,-2,-54,-30,-54v-28,0,-31,23,-31,55v0,32,2,54,31,54","w":351},"&":{"d":"210,-160v1,37,-5,69,-19,95r63,65r-45,0r-36,-37v-21,25,-40,41,-79,42v-47,1,-82,-31,-82,-77v0,-41,23,-61,48,-76v-21,-14,-35,-28,-35,-59v0,-38,29,-59,69,-60v36,-1,66,20,66,54v-1,37,-21,54,-50,65r62,64v5,-22,3,-50,3,-76r35,0xm77,-136v-43,21,-38,117,26,113v27,-2,43,-13,55,-30xm93,-245v-37,0,-45,56,-16,72v4,4,10,9,17,13v38,-6,46,-85,-1,-85","w":242},"'":{"d":"57,-274r-7,102r-24,0r-8,-102r39,0","w":75,"k":{"A":17}},"(":{"d":"50,-101v-1,81,36,132,75,173r-40,0v-37,-46,-66,-92,-66,-173v0,-80,28,-127,66,-173v12,2,32,-4,40,2v-41,39,-74,93,-75,171","w":137,"k":{"j":-9,"T":-4}},")":{"d":"53,-274v36,46,66,94,66,173v0,79,-28,127,-66,173v-13,-1,-29,2,-40,-1v41,-39,75,-94,75,-172v0,-79,-37,-131,-75,-173r40,0","w":137},"*":{"d":"177,-156r-11,19r-58,-38r1,64r-22,0r1,-64r-57,39r-11,-20r62,-36r-62,-37r11,-19r58,39r-2,-65r22,0r-1,65r58,-39r11,20r-62,36"},"+":{"d":"234,-101r-88,0r0,89r-30,0r0,-89r-88,0r0,-28r88,0r0,-88r30,0r0,88r88,0r0,28","w":261},",":{"d":"88,-50r-49,115r-26,0r31,-115r44,0","w":108,"k":{"\u2019":35,"\u201d":35,"}":16,"]":16,"7":9,")":16}},"-":{"d":"115,-99r-99,0r0,-31r99,0r0,31","w":130,"k":{"z":7,"y":7,"x":8,"w":3,"v":7,"a":3,"Z":5,"Y":23,"X":13,"W":8,"V":8,"T":25,"S":3,"J":17,"I":5,"A":8}},"\u00ad":{"d":"115,-99r-99,0r0,-31r99,0r0,31","w":130},".":{"d":"75,0r-42,0r0,-50r42,0r0,50","w":108,"k":{"\u2019":35,"\u201d":35,"\u2014":20,"\u2013":20,"}":18,"]":18,"7":9,"-":28,",":23,")":18}},"\/":{"d":"128,-274r-103,331r-29,0r102,-331r30,0","w":137},"0":{"d":"98,-267v68,0,84,59,84,136v0,80,-17,136,-84,136v-69,0,-82,-57,-83,-136v0,-80,16,-136,83,-136xm98,-24v50,0,48,-55,48,-107v0,-53,1,-107,-48,-107v-49,0,-48,56,-48,107v0,53,-1,107,48,107"},"1":{"d":"40,-226v35,-1,50,-7,54,-37r27,0r0,236r46,0r0,27r-127,0r0,-27r47,0r0,-175r-47,0r0,-24"},"2":{"d":"25,-251v61,-37,172,-8,141,84v-20,59,-78,97,-114,137r129,0r0,30r-162,0r0,-37v17,-17,19,-15,33,-31v33,-37,80,-69,82,-125v2,-62,-80,-44,-109,-21r0,-37"},"3":{"d":"136,-200v0,-57,-85,-34,-112,-14r0,-37v48,-25,147,-26,147,47v0,31,-27,52,-48,61v31,7,53,26,53,65v0,83,-99,100,-159,67r0,-37v18,7,42,24,69,23v34,-2,54,-19,54,-55v0,-41,-28,-49,-70,-47r0,-29v37,3,66,-11,66,-44"},"4":{"d":"188,-90r-32,0r0,90r-33,0r0,-90r-116,0r0,-37r117,-135r32,0r0,144r32,0r0,28xm123,-118r0,-102r-89,102r89,0","k":{".":4,",":4}},"5":{"d":"66,-161v64,-8,112,13,112,78v0,83,-90,106,-156,74v2,-12,-3,-30,2,-38v36,29,118,35,118,-36v0,-57,-63,-55,-109,-44r0,-135r143,0r0,31r-110,0r0,70"},"6":{"d":"51,-149v50,-38,141,-12,134,64v-5,52,-30,90,-83,90v-66,0,-86,-51,-87,-120v-2,-98,48,-166,147,-148v-2,10,3,27,-2,34v-58,-24,-110,18,-109,80xm102,-23v31,0,47,-24,47,-60v0,-59,-62,-67,-98,-41v-3,51,6,101,51,101"},"7":{"d":"184,-223r-114,223r-37,0r120,-231r-136,0r0,-31r167,0r0,39","k":{".":26,",":26}},"8":{"d":"116,-148v37,-19,38,-94,-18,-94v-46,0,-59,61,-19,77v8,4,26,15,37,17xm99,-20v40,0,60,-43,42,-75v-9,-16,-40,-28,-63,-36v-44,21,-37,111,21,111xm184,-73v0,44,-40,80,-86,79v-51,-1,-82,-29,-85,-78v-1,-34,22,-55,44,-69v-23,-14,-38,-27,-38,-58v0,-40,37,-69,79,-69v45,0,78,26,79,67v0,30,-20,51,-40,63v27,13,46,28,47,65"},"9":{"d":"47,-178v0,59,65,67,99,40v1,-52,-4,-100,-51,-100v-31,0,-48,24,-48,60xm145,-113v-50,40,-139,13,-133,-64v4,-54,30,-90,83,-90v66,0,86,51,87,120v1,96,-46,169,-148,148v2,-10,-3,-27,2,-33v58,24,111,-18,109,-81"},":":{"d":"85,-146r-42,0r0,-50r42,0r0,50xm85,0r-42,0r0,-50r42,0r0,50","w":127,"k":{"\u2014":23}},";":{"d":"85,-146r-42,0r0,-50r42,0r0,50xm96,-50r-49,115r-26,0r31,-115r44,0","w":127},"\u037e":{"d":"85,-146r-42,0r0,-50r42,0r0,50xm96,-50r-49,115r-26,0r31,-115r44,0","w":127},"<":{"d":"224,-14r-189,-90r0,-21r189,-90r0,31r-146,69r146,70r0,31","w":261},"=":{"d":"228,-137r-194,0r0,-29r194,0r0,29xm228,-64r-194,0r0,-28r194,0r0,28","w":261},">":{"d":"227,-104r-189,90r0,-31r146,-70r-146,-69r0,-31r189,90r0,21","w":261},"?":{"d":"19,-255v54,-23,145,-15,141,55v-3,51,-36,69,-68,90r0,40r-31,0r0,-54v28,-19,62,-31,63,-74v1,-55,-77,-40,-105,-21r0,-36xm95,0r-36,0r0,-37r36,0r0,37","w":170},"@":{"d":"168,-267v122,0,172,148,112,239r-74,0r-5,-20v-41,46,-120,11,-110,-63v-5,-65,57,-108,110,-76r0,-8r28,0r0,148r40,0v34,-84,-1,-196,-101,-196v-69,0,-120,61,-120,130v0,97,84,154,179,121r0,25v-112,31,-204,-38,-204,-147v0,-82,65,-153,145,-153xm160,-53v16,0,30,-10,41,-19r0,-91v-39,-22,-80,-2,-80,52v0,34,9,58,39,58","w":327},"A":{"d":"-2,0r88,-262r43,0r89,262r-37,0r-24,-73r-100,0r-24,73r-35,0xm147,-103r-40,-123r-40,123r80,0","w":215,"k":{"\u2019":20,"\u2018":8,"\u201d":20,"\u201c":8,"\u2014":8,"\u2013":8,"y":5,"w":2,"v":5,"u":2,"t":2,"Y":13,"W":8,"V":10,"U":2,"T":20,"S":1,"-":8}},"B":{"d":"155,-145v29,8,49,29,49,65v-1,85,-89,82,-177,80r0,-262v75,1,163,-14,165,59v1,29,-21,44,-37,58xm61,-155v48,1,97,5,95,-43v-1,-42,-51,-33,-95,-34r0,77xm61,-30v54,1,107,3,107,-49v0,-55,-54,-47,-107,-47r0,96","w":212,"k":{"\u2014":-2,"\u2013":-2,"\u2026":3,"w":-2,"u":-2,"r":-2,"o":-2,"l":-2,"j":-2,"i":-2,"h":-2,"e":-2,"a":-2,"T":10,"Q":-2,"O":-2,"G":-2,"C":-2,".":3,"-":-2,",":3}},"C":{"d":"210,-18v-23,11,-45,23,-81,23v-79,0,-117,-53,-117,-136v1,-82,38,-132,117,-135v36,-1,59,10,81,22r0,42v-22,-14,-43,-36,-81,-35v-57,2,-80,46,-81,106v0,62,25,103,81,106v37,2,60,-19,81,-34r0,41","w":216,"k":{"\u2014":8,"\u2013":8,"-":8}},"D":{"d":"27,-262v123,-8,209,18,206,131v-2,85,-51,135,-146,131r-60,0r0,-262xm61,-30v84,5,136,-20,136,-101v0,-79,-51,-107,-136,-101r0,202","w":244,"k":{"\u2026":8,"Z":3,"Y":3,"X":2,"W":3,"T":8,"J":4,".":8,",":8}},"E":{"d":"27,0r0,-262r163,0r0,31r-129,0r0,72r120,0r0,31r-120,0r0,97r129,0r0,31r-163,0","w":201},"F":{"d":"183,-231r-122,0r0,74r117,0r0,31r-117,0r0,126r-34,0r0,-262r156,0r0,31","w":187,"k":{"\u2026":50,"o":8,"e":8,"a":17,"T":-5,"J":10,"A":17,"?":-10,";":10,":":10,".":50,",":50}},"G":{"d":"223,-17v-26,9,-52,22,-87,22v-84,-1,-124,-51,-124,-136v0,-84,42,-133,124,-135v36,-2,62,11,86,22r0,42v-25,-15,-47,-34,-90,-34v-53,0,-84,46,-84,104v0,86,63,125,141,99r0,-68r-61,0r0,-31r95,0r0,115","w":240},"H":{"d":"217,0r-35,0r0,-128r-121,0r0,128r-34,0r0,-262r34,0r0,103r121,0r0,-103r35,0r0,262","w":243},"I":{"d":"118,0r-102,0r0,-27r34,0r0,-208r-34,0r0,-27r102,0r0,27r-33,0r0,208r33,0r0,27","w":134,"k":{"\u2014":5,"\u2013":5,"v":5,"s":4,"r":2,"p":2,"o":4,"n":2,"m":2,"g":4,"e":4,"d":4,"c":4,"a":4,"-":5}},"J":{"d":"2,-35v40,16,88,14,88,-46r0,-153r-55,0r0,-28r90,0r0,194v2,65,-61,81,-123,67r0,-34","w":149,"k":{"\u2026":3,"A":2,".":3,",":3}},"K":{"d":"217,0r-45,0r-95,-122r-16,17r0,105r-34,0r0,-262r34,0r0,121r108,-121r42,0r-108,117","w":211,"k":{"\u2014":18,"\u2013":18,"y":10,"w":10,"v":10,"u":7,"o":10,"e":10,"a":8,"O":3,"-":18}},"L":{"d":"178,0r-151,0r0,-262r34,0r0,231r117,0r0,31","w":179,"k":{"\u2019":27,"\u201d":27,"\u2014":27,"\u2013":27,"y":18,"v":18,"Y":27,"W":17,"V":18,"T":28,"Q":3,"O":3,"J":-17,"G":3,"C":3,"A":7,"-":27,"'":20}},"M":{"d":"251,0r-35,0r0,-226r-68,154r-21,0r-68,-154r0,226r-32,0r0,-262r47,0r65,146r63,-146r49,0r0,262","w":277},"N":{"d":"214,0r-39,0r-116,-226r0,226r-32,0r0,-262r49,0r105,208r0,-208r33,0r0,262","w":240},"O":{"d":"127,-267v80,0,116,54,116,136v0,81,-36,136,-116,136v-80,0,-115,-55,-115,-136v0,-82,35,-136,115,-136xm127,-25v55,0,80,-45,80,-106v-1,-60,-22,-106,-80,-106v-59,0,-78,45,-79,106v-1,61,24,106,79,106","w":254,"k":{"\u2026":5,"Z":3,"Y":3,"X":2,"T":8,"J":1,".":5,",":5}},"P":{"d":"27,-262v84,-3,167,-2,165,79v-2,68,-53,91,-131,85r0,98r-34,0r0,-262xm61,-127v53,3,95,-5,95,-55v0,-48,-43,-53,-95,-50r0,105","w":198,"k":{"\u2026":50,"o":8,"e":8,"a":8,"Y":-3,"J":12,"A":8,".":50,",":50}},"Q":{"d":"244,64v-52,16,-110,-4,-109,-59v-86,2,-123,-52,-123,-136v0,-82,35,-136,115,-136v80,0,115,54,116,136v0,65,-27,112,-74,129v-3,43,40,45,75,34r0,32xm127,-24v54,0,80,-46,80,-107v-1,-60,-22,-106,-80,-106v-59,0,-78,45,-79,106v-1,62,25,107,79,107","w":254,"k":{"\u2026":5,".":5,",":5}},"R":{"d":"190,-191v1,41,-23,66,-54,77r93,114r-45,0r-83,-104r-40,0r0,104r-34,0r0,-262v80,-1,164,-8,163,71xm61,-133v53,3,93,-4,93,-55v0,-46,-46,-46,-93,-44r0,99","w":223,"k":{"\u2019":12,"\u201d":12,"\u2014":17,"\u2013":17,"y":8,"u":2,"o":7,"e":7,"a":3,"Y":3,"T":10,"-":17}},"S":{"d":"140,-141v89,27,51,146,-41,146v-38,0,-60,-9,-85,-21v2,-13,-4,-34,2,-43v27,35,139,57,139,-10v0,-78,-140,-19,-140,-123v0,-75,108,-90,166,-58v-2,13,4,33,-2,42v-25,-31,-124,-46,-127,13v-2,46,54,44,88,54","w":200,"k":{"\u2026":3,"y":5,"w":3,"v":5,"q":-1,"o":-1,"e":-1,"c":-1,"S":4,"A":2,".":3,",":3}},"T":{"d":"88,0r0,-231r-88,0r0,-31r210,0r0,31r-87,0r0,231r-35,0","w":210,"k":{"\u2014":25,"\u2013":25,"\u2026":49,"}":-4,"z":28,"y":33,"w":33,"v":33,"u":33,"s":30,"r":33,"o":37,"g":35,"e":37,"c":37,"a":40,"]":-4,"Y":12,"T":18,"S":2,"O":8,"J":10,"G":7,"C":7,"A":20,"?":-10,";":33,":":33,".":49,"-":25,",":49,")":-4}},"U":{"d":"213,-262v-6,115,33,273,-95,267v-65,-3,-96,-35,-95,-103r0,-164r35,0r0,164v-2,47,16,74,60,74v43,0,60,-27,60,-74r0,-164r35,0","w":236,"k":{"\u2026":3,"A":2,".":3,",":3}},"V":{"d":"216,-262r-90,262r-37,0r-90,-262r37,0r72,218r73,-218r35,0","w":214,"k":{"\u2014":8,"\u2013":8,"\u2026":49,"y":11,"u":10,"o":17,"e":17,"a":17,"A":10,";":13,":":13,".":49,"-":8,",":49}},"W":{"d":"320,-262r-66,262r-39,0r-53,-217r-52,217r-38,0r-67,-262r35,0r53,218r52,-218r36,0r53,220r52,-220r34,0","w":324,"k":{"\u2014":8,"\u2013":8,"\u2026":37,"y":9,"u":7,"r":7,"o":13,"e":13,"a":13,"A":8,";":13,":":13,".":37,"-":8,",":49}},"X":{"d":"208,0r-40,0r-64,-105r-65,105r-38,0r84,-131r-81,-131r40,0r62,103r64,-103r37,0r-81,129","w":209,"k":{"\u2014":13,"\u2013":13,"y":12,"u":5,"o":8,"e":8,"a":7,"O":2,"G":2,"C":2,"-":13}},"Y":{"d":"210,-262r-89,146r0,116r-35,0r0,-112r-88,-150r39,0r67,116r69,-116r37,0","w":207,"k":{"\u2014":23,"\u2013":23,"\u2026":49,"v":17,"u":18,"s":18,"r":17,"q":22,"p":17,"o":22,"n":17,"m":17,"g":22,"e":22,"d":20,"a":23,"O":3,"J":10,"A":13,";":33,":":33,".":49,"-":23,",":49}},"Z":{"d":"193,0r-182,0r0,-32r140,-199r-134,0r0,-31r173,0r0,32r-142,199r145,0r0,31","w":201,"k":{"\u2014":8,"\u2013":8,"y":11,"w":7,"o":10,"e":10,"a":8,"Z":2,"O":3,"G":3,"C":3,"-":10}},"[":{"d":"121,69r-92,0r0,-343r92,0r0,26r-61,0r0,292r61,0r0,25","w":137,"k":{"j":-9,"T":-4}},"\\":{"d":"141,57r-29,0r-103,-331r30,0","w":137},"]":{"d":"109,69r-92,0r0,-25r61,0r0,-292r-61,0r0,-26r92,0r0,343","w":137},"^":{"d":"239,-120r-35,0r-73,-110r-73,110r-35,0r97,-142r22,0","w":261},"_":{"d":"199,53r-202,0r0,-23r202,0r0,23"},"`":{"d":"118,-229r-26,0r-48,-66r42,0"},"a":{"d":"44,-59v0,49,71,36,90,11r0,-55v-38,5,-89,3,-90,44xm26,-192v56,-17,140,-17,140,58r0,134r-32,0r0,-21v-19,12,-31,27,-64,26v-37,-1,-60,-25,-60,-62v0,-63,62,-69,124,-72v5,-60,-69,-43,-108,-30r0,-33","w":188,"k":{"y":2,"w":2,"v":2}},"b":{"d":"57,-36v47,28,103,3,98,-63v-3,-41,-9,-70,-46,-71v-21,0,-39,11,-52,22r0,112xm117,-202v49,0,72,47,72,101v0,78,-69,133,-132,92r-2,9r-31,0r0,-274r33,0r0,98v15,-14,34,-26,60,-26","w":198,"k":{"\u2026":3,"y":1,".":3,",":5}},"c":{"d":"101,-24v26,0,42,-14,59,-24r0,37v-19,6,-33,16,-58,15v-62,-1,-89,-39,-92,-102v-5,-87,81,-125,150,-88v-2,11,3,29,-2,37v-14,-11,-32,-23,-57,-23v-38,0,-56,31,-56,74v0,42,18,73,56,74","w":166,"k":{"\u2014":3,"\u2013":3,"\u00e7":1,"c":1,"T":17,"-":3}},"d":{"d":"10,-97v-4,-78,67,-131,132,-91r0,-86r33,0r0,274r-33,0r0,-20v-16,13,-30,26,-59,25v-54,-2,-70,-46,-73,-102xm91,-26v21,0,38,-11,51,-22r0,-113v-48,-27,-103,1,-98,64v3,40,10,71,47,71","w":198},"e":{"d":"176,-12v-18,8,-40,17,-67,17v-63,0,-99,-39,-99,-102v0,-59,35,-104,91,-105v61,0,82,42,79,107r-136,0v-8,80,90,83,132,47r0,36xm148,-120v9,-63,-82,-72,-99,-22v-3,6,-4,14,-5,22r104,0","w":189,"k":{"T":23}},"f":{"d":"27,-196v-5,-65,40,-89,100,-76v-1,9,2,23,-1,30v-35,-10,-76,-3,-67,46r55,0r0,27r-54,0r0,169r-33,0r0,-169r-22,0r0,-27r22,0","w":114,"k":{"\u2019":-12,"\u201d":-12,"\u2014":12,"\u2013":12,"\u2026":20,"\u00ee":-21,"\u00e9":4,"}":-18,"y":4,"u":4,"s":4,"r":2,"q":2,"p":2,"o":4,"n":2,"m":2,"j":4,"g":2,"f":2,"e":4,"c":4,"a":4,"]":-18,"\\":-17,"?":-20,".":26,"-":12,",":26,"*":-12,")":-18,"'":-15,"\"":-15}},"g":{"d":"91,-34v20,0,39,-8,51,-19r0,-108v-45,-27,-103,-2,-98,60v3,40,10,67,47,67xm175,-22v8,88,-71,111,-146,88v2,-11,-3,-28,2,-35v38,20,121,25,111,-40r0,-17v-17,14,-30,22,-58,23v-50,0,-74,-42,-74,-97v0,-77,68,-126,132,-88r2,-8r31,0r0,174","w":198,"k":{"j":-2}},"h":{"d":"117,-202v85,-1,56,120,61,202r-33,0r0,-112v0,-33,-2,-61,-37,-58v-20,1,-38,12,-51,23r0,147r-33,0r0,-274r33,0r0,99v17,-15,33,-26,60,-27","w":200,"k":{"y":3,"w":2,"v":3}},"i":{"d":"58,0r-33,0r0,-196r33,0r0,196xm60,-229r-38,0r0,-34r38,0r0,34","w":82,"k":{"t":-1,"f":-1}},"j":{"d":"-16,43v41,8,60,-7,60,-51r0,-161r-35,0r0,-27r69,0r0,202v2,52,-39,77,-94,66r0,-29xm78,-229r-38,0r0,-34r38,0r0,34","w":101},"k":{"d":"187,0r-44,0r-73,-95r-13,13r0,82r-33,0r0,-274r33,0r0,161r78,-83r41,0r-81,82","w":179,"k":{"\u2014":17,"\u2013":17,"o":3,"e":3,"-":17}},"l":{"d":"58,0r-33,0r0,-274r33,0r0,274","w":82,"k":{"\u00ef":-2,"\u00ee":-2,"t":-1,"l":-1}},"m":{"d":"222,-202v85,0,52,122,58,202r-33,0r0,-114v0,-31,-1,-58,-33,-56v-19,1,-33,12,-46,24r0,146r-33,0r0,-114v0,-31,0,-59,-33,-56v-18,1,-34,12,-45,23r0,147r-33,0r0,-196r33,0r0,21v23,-33,92,-39,105,7v18,-18,31,-34,60,-34","w":302,"k":{"y":3,"w":2,"v":3}},"n":{"d":"117,-202v85,-1,56,120,61,202r-33,0r0,-112v0,-33,-2,-61,-37,-58v-20,1,-38,12,-51,23r0,147r-33,0r0,-196r33,0r0,21v17,-15,33,-26,60,-27","w":200,"k":{"y":3,"w":2,"v":3}},"o":{"d":"98,-202v56,0,87,42,87,104v0,62,-31,103,-87,103v-57,1,-88,-43,-88,-103v0,-61,32,-104,88,-104xm98,-23v39,0,53,-31,53,-75v0,-44,-13,-75,-53,-75v-40,0,-54,30,-54,75v0,44,15,75,54,75","w":195,"k":{"\u2026":3,"y":2,"x":3,"v":2,".":3,",":5}},"p":{"d":"117,-202v48,0,72,45,72,99v0,79,-68,134,-132,93r0,82r-33,0r0,-268r33,0r0,20v15,-13,34,-26,60,-26xm57,-37v47,28,102,0,98,-63v-3,-39,-9,-69,-46,-70v-21,0,-39,10,-52,22r0,111","w":198,"k":{"\u2026":3,"y":1,".":3,",":5}},"q":{"d":"10,-98v0,-78,67,-128,132,-90r2,-8r31,0r0,268r-33,0r0,-93v-17,15,-31,25,-59,25v-50,0,-73,-46,-73,-102xm91,-28v20,0,39,-11,51,-21r0,-112v-46,-28,-102,-1,-98,62v3,40,11,70,47,71","w":198},"r":{"d":"57,-167v21,-19,37,-32,71,-28v-2,17,10,41,-20,33v-23,0,-38,10,-51,23r0,139r-33,0r0,-196r33,0r0,29","w":129,"k":{"\u2019":-5,"\u201d":-5,"\u2014":3,"\u2013":3,"\u2026":49,"\u00e9":2,"\u00e7":2,"q":2,"o":2,"g":2,"e":2,"d":2,"c":2,"a":6,".":49,"-":4,",":49}},"s":{"d":"143,-91v30,44,-8,96,-66,96v-25,0,-48,-10,-65,-17r0,-37v18,11,37,24,66,26v30,2,54,-22,36,-47v-33,-20,-101,-12,-101,-71v0,-62,88,-72,134,-46v-2,11,3,28,-2,35v-24,-30,-124,-28,-92,25v21,16,75,14,90,36","w":160},"t":{"d":"120,-2v-48,16,-94,-1,-94,-58r0,-109r-22,0r0,-27r22,0r0,-57r33,0r0,57r61,0r0,27r-61,0r1,116v-2,32,36,31,60,22r0,29","w":120,"k":{"\u2019":-3,"\u201d":-3,"\u2014":7,"\u2013":7,"y":4,"v":4,"t":3,"-":7}},"u":{"d":"93,-26v20,0,38,-13,51,-24r0,-146r33,0r0,196r-33,0r0,-22v-36,46,-122,32,-122,-47r0,-127r34,0r0,111v-1,35,3,59,37,59","w":200},"v":{"d":"178,-196r-74,196r-29,0r-74,-196r36,0r54,151r53,-151r34,0","w":179,"k":{"\u2019":-5,"\u2014":7,"\u2013":7,"\u2026":30,"o":3,"e":3,"a":7,".":30,"-":7,",":30}},"w":{"d":"262,-196r-50,196r-30,0r-48,-151r-48,151r-30,0r-51,-196r35,0r34,152r47,-152r27,0r48,152r33,-152r33,0","w":267,"k":{"\u2019":-4,"\u2014":3,"\u2013":3,"\u2026":12,"a":3,".":12,"-":3,",":12}},"x":{"d":"176,0r-40,0r-48,-74r-49,74r-37,0r68,-97r-68,-99r41,0r47,73r49,-73r37,0r-67,96","w":178,"k":{"\u2014":8,"\u2013":8,"\u00e7":3,"o":4,"g":2,"e":4,"d":2,"c":3,"-":8}},"y":{"d":"178,-196r-105,268r-36,0r35,-81r-71,-187r36,0r53,145r54,-145r34,0","w":179,"k":{"\u2019":-5,"\u2014":7,"\u2013":7,"\u2026":30,"\u00e7":3,"q":2,"o":3,"g":2,"e":3,"d":2,"c":3,"a":7,".":32,"-":7,",":32}},"z":{"d":"153,0r-144,0r0,-24r102,-145r-98,0r0,-27r138,0r0,23r-103,145r105,0r0,28","w":159,"k":{"\u2014":3,"\u2013":3,"\u00e7":2,"q":2,"o":2,"g":2,"e":2,"d":2,"c":2,"-":3}},"{":{"d":"100,-33v0,49,2,86,56,78r0,24v-66,6,-93,-26,-88,-94v3,-40,-16,-65,-57,-64r0,-27v52,3,59,-37,57,-89v-2,-51,33,-74,88,-69r0,25v-52,-7,-56,25,-56,77v0,38,-22,55,-48,68r0,4v27,12,48,30,48,67","w":172,"k":{"j":-9,"T":-4}},"|":{"d":"83,69r-29,0r0,-343r29,0r0,343","w":137},"}":{"d":"105,-205v-2,52,4,93,57,89r0,27v-51,-2,-59,37,-57,90v2,51,-33,73,-88,68r0,-24v52,7,56,-25,56,-78v0,-38,20,-56,48,-67r0,-4v-35,-14,-53,-44,-48,-98v3,-38,-18,-50,-56,-47r0,-25v55,-5,89,18,88,69","w":172},"~":{"d":"177,-98v29,-2,30,-34,32,-65r29,0v-1,49,-13,91,-60,93v-54,2,-51,-55,-93,-65v-29,2,-30,35,-32,66r-29,0v1,-49,13,-93,60,-94v52,-2,51,55,93,65","w":261},"\u00c4":{"d":"160,-291r-35,0r0,-35r35,0r0,35xm88,-291r-35,0r0,-35r35,0r0,35xm-2,0r88,-262r43,0r89,262r-37,0r-24,-73r-100,0r-24,73r-35,0xm147,-103r-40,-123r-40,123r80,0","w":215},"\u00c5":{"d":"108,-349v56,0,72,81,25,99r85,250r-37,0r-24,-73r-100,0r-24,73r-35,0r84,-250v-45,-19,-30,-99,26,-99xm147,-103r-40,-124r-40,124r80,0xm108,-266v17,0,28,-13,28,-30v0,-16,-12,-30,-28,-30v-16,0,-28,14,-28,30v0,17,11,30,28,30","w":215},"\u00d6":{"d":"181,-295r-36,0r0,-34r36,0r0,34xm108,-295r-35,0r0,-34r35,0r0,34xm127,-267v80,0,116,54,116,136v0,81,-36,136,-116,136v-80,0,-115,-55,-115,-136v0,-82,35,-136,115,-136xm127,-25v55,0,80,-45,80,-106v-1,-60,-22,-106,-80,-106v-59,0,-78,45,-79,106v-1,61,24,106,79,106","w":254},"\u00dc":{"d":"176,-295r-35,0r0,-34r35,0r0,34xm104,-295r-35,0r0,-34r35,0r0,34xm213,-262v-6,115,33,273,-95,267v-65,-3,-96,-35,-95,-103r0,-164r35,0r0,164v-2,47,16,74,60,74v43,0,60,-27,60,-74r0,-164r35,0","w":236},"\u00e1":{"d":"147,-295r-48,66r-26,0r31,-66r43,0xm44,-59v0,49,71,36,90,11r0,-55v-38,5,-89,3,-90,44xm26,-192v56,-17,140,-17,140,58r0,134r-32,0r0,-21v-19,12,-31,27,-64,26v-37,-1,-60,-25,-60,-62v0,-63,62,-69,124,-72v5,-60,-69,-43,-108,-30r0,-33","w":188},"\u00e0":{"d":"44,-59v0,49,71,36,90,11r0,-55v-38,5,-89,3,-90,44xm26,-192v56,-17,140,-17,140,58r0,134r-32,0r0,-21v-19,12,-31,27,-64,26v-37,-1,-60,-25,-60,-62v0,-63,62,-69,124,-72v5,-60,-69,-43,-108,-30r0,-33xm118,-229r-26,0r-48,-66r42,0","w":188},"\u00e4":{"d":"147,-229r-36,0r0,-34r36,0r0,34xm74,-229r-35,0r0,-34r35,0r0,34xm44,-59v0,49,71,36,90,11r0,-55v-38,5,-89,3,-90,44xm26,-192v56,-17,140,-17,140,58r0,134r-32,0r0,-21v-19,12,-31,27,-64,26v-37,-1,-60,-25,-60,-62v0,-63,62,-69,124,-72v5,-60,-69,-43,-108,-30r0,-33","w":188},"\u00e5":{"d":"44,-59v0,49,71,36,90,11r0,-55v-38,5,-89,3,-90,44xm108,-199v37,5,58,22,58,65r0,134r-32,0r0,-21v-19,12,-31,27,-64,26v-37,-1,-60,-25,-60,-62v0,-63,62,-69,124,-72v6,-60,-72,-43,-108,-30r0,-33v14,-4,31,-7,49,-8v-19,-7,-36,-26,-36,-50v-1,-30,24,-53,53,-53v30,-1,54,23,54,53v0,26,-18,44,-38,51xm92,-219v16,0,28,-14,28,-31v1,-17,-11,-29,-28,-29v-16,0,-27,12,-27,29v0,17,11,31,27,31","w":188},"\u00e7":{"d":"52,42v29,13,69,5,58,-38v-68,2,-96,-36,-100,-102v-5,-87,81,-125,150,-88v-2,11,3,29,-2,37v-14,-11,-32,-23,-57,-23v-38,0,-56,31,-56,74v0,42,18,73,56,74v26,0,42,-14,59,-24r0,37v-11,6,-25,4,-23,27v5,46,-40,68,-85,54r0,-28","w":166,"k":{"\u2014":3,"\u2013":3,"-":3}},"\u00e9":{"d":"156,-295r-48,66r-26,0r32,-66r42,0xm176,-12v-18,8,-40,17,-67,17v-63,0,-99,-39,-99,-102v0,-59,35,-104,91,-105v61,0,82,42,79,107r-136,0v-8,80,90,83,132,47r0,36xm148,-120v9,-63,-82,-72,-99,-22v-3,6,-4,14,-5,22r104,0","w":189},"\u00e8":{"d":"176,-12v-18,8,-40,17,-67,17v-63,0,-99,-39,-99,-102v0,-59,35,-104,91,-105v61,0,82,42,79,107r-136,0v-8,80,90,83,132,47r0,36xm148,-120v9,-63,-82,-72,-99,-22v-3,6,-4,14,-5,22r104,0xm121,-229r-26,0r-48,-66r42,0","w":189},"\u00ed":{"d":"58,0r-33,0r0,-196r33,0r0,196xm95,-295r-48,66r-26,0r32,-66r42,0","w":82,"k":{"\u2019":-4}},"\u00ee":{"d":"58,0r-33,0r0,-196r33,0r0,196xm92,-228r-27,0r-24,-46r-25,46r-25,0r30,-67r40,0","w":82,"k":{"l":-2}},"\u00ef":{"d":"58,0r-33,0r0,-196r33,0r0,196xm89,-229r-33,0r0,-34r33,0r0,34xm27,-229r-34,0r0,-34r34,0r0,34","w":82,"k":{"l":-2,"f":-2}},"\u00f1":{"d":"131,-258v13,0,16,-15,16,-29r25,0v-1,32,-14,54,-43,55v-28,2,-34,-26,-57,-29v-14,1,-15,15,-16,30r-25,0v1,-31,16,-54,44,-55v26,-1,34,28,56,28xm117,-202v85,-1,56,120,61,202r-33,0r0,-112v0,-33,-2,-61,-37,-58v-20,1,-38,12,-51,23r0,147r-33,0r0,-196r33,0r0,21v17,-15,33,-26,60,-27","w":200},"\u00f3":{"d":"153,-295r-48,66r-27,0r32,-66r43,0xm98,-202v56,0,87,42,87,104v0,62,-31,103,-87,103v-57,1,-88,-43,-88,-103v0,-61,32,-104,88,-104xm98,-23v39,0,53,-31,53,-75v0,-44,-13,-75,-53,-75v-40,0,-54,30,-54,75v0,44,15,75,54,75","w":195},"\u00f6":{"d":"152,-229r-35,0r0,-34r35,0r0,34xm79,-229r-35,0r0,-34r35,0r0,34xm98,-202v56,0,87,42,87,104v0,62,-31,103,-87,103v-57,1,-88,-43,-88,-103v0,-61,32,-104,88,-104xm98,-23v39,0,53,-31,53,-75v0,-44,-13,-75,-53,-75v-40,0,-54,30,-54,75v0,44,15,75,54,75","w":195},"\u00f9":{"d":"93,-26v20,0,38,-13,51,-24r0,-146r33,0r0,196r-33,0r0,-22v-36,46,-122,32,-122,-47r0,-127r34,0r0,111v-1,35,3,59,37,59xm121,-229r-26,0r-48,-66r42,0","w":200},"\u00fb":{"d":"160,-228r-28,0r-33,-45r-32,45r-27,0r40,-67r40,0xm93,-26v20,0,38,-13,51,-24r0,-146r33,0r0,196r-33,0r0,-22v-36,46,-122,32,-122,-47r0,-127r34,0r0,111v-1,35,3,59,37,59","w":200},"\u00fc":{"d":"155,-229r-36,0r0,-34r36,0r0,34xm82,-229r-35,0r0,-34r35,0r0,34xm93,-26v20,0,38,-13,51,-24r0,-146r33,0r0,196r-33,0r0,-22v-36,46,-122,32,-122,-47r0,-127r34,0r0,111v-1,35,3,59,37,59","w":200},"\u00a3":{"d":"85,-108v4,41,-18,60,-39,78r135,0r0,30r-165,0r0,-36v29,-10,34,-32,35,-72r-28,0r0,-24r28,0v-6,-73,8,-135,73,-135v21,0,37,5,52,9v-2,11,3,29,-2,36v-31,-25,-96,-19,-89,37r0,53r64,0r0,24r-64,0"},"\u00df":{"d":"126,-160v36,8,62,34,62,75v1,57,-45,100,-107,87v1,-9,-3,-24,2,-29v42,12,72,-13,70,-59v-2,-43,-26,-58,-71,-58r0,-27v34,0,56,-11,55,-44v0,-23,-12,-34,-35,-34v-35,-1,-45,24,-45,58r0,191r-33,0r0,-190v0,-54,27,-84,78,-85v38,-1,69,20,69,57v0,31,-25,47,-45,58","w":197},"\u2122":{"d":"287,-138r-22,0r0,-108r-3,0r-36,79r-15,0r-36,-81r-4,0r0,110r-22,0r0,-124r42,0r28,67r28,-67r40,0r0,124xm122,-241r-41,0r0,103r-22,0r0,-103r-40,0r0,-21r103,0r0,21","w":315},"\u00ab":{"d":"183,-34r-85,-73r0,-15r85,-74r0,33r-55,48r55,48r0,33xm108,-28r-90,-79r0,-16r90,-78r0,35r-58,51r58,52r0,35","w":206},"\u00bb":{"d":"188,-107r-89,79r0,-35r58,-52r-58,-51r0,-35r89,78r0,16xm109,-107r-86,73r0,-33r56,-48r-56,-48r0,-33r86,74r0,15","w":206},"\u2026":{"d":"263,0r-36,0r0,-39r36,0r0,39xm165,0r-36,0r0,-39r36,0r0,39xm67,0r-36,0r0,-39r36,0r0,39","w":294,"k":{"\u2019":35,"\u201d":35}},"\u2013":{"d":"197,-101r-198,0r0,-28r198,0r0,28","k":{"z":7,"y":7,"x":8,"w":3,"v":7,"a":3,"Z":2,"Y":23,"X":13,"W":8,"V":8,"T":25,"S":3,"J":17,"I":5,"A":8}},"\u2014":{"d":"328,-101r-329,0r0,-28r329,0r0,28","w":327,"k":{"z":7,"y":7,"x":8,"w":3,"v":7,"a":3,"Z":2,"Y":23,"X":13,"W":8,"V":8,"T":25,"S":3,"J":17,"I":5,"A":8}},"\u201c":{"d":"127,-175r-23,0r-46,-99r42,0xm58,-175r-23,0r-46,-99r42,0","w":144,"k":{"\u2018":-7,"A":17}},"\u201d":{"d":"158,-274r-46,99r-24,0r28,-99r42,0xm88,-274r-46,99r-23,0r27,-99r42,0","w":144,"k":{"\u2019":-7,"\u2026":35,"t":-7,"s":12,"Y":-18,"W":-10,"V":-17,"T":-18,"A":17,".":35,",":35}},"\u2018":{"d":"59,-175r-24,0r-46,-99r42,0","w":75,"k":{"\u201c":-7,"A":17}},"\u2019":{"d":"87,-274r-46,99r-24,0r28,-99r42,0","w":75,"k":{"\u2018":-32,"\u201d":-7,"\u201c":-32,"\u2026":35,"\u00ef":-28,"\u00ee":-28,"t":-7,"s":12,"l":-7,"i":-7,"h":-7,"Y":-18,"W":-10,"V":-17,"T":-18,"S":-4,"A":17,"9":-4,"8":-4,"7":-7,"5":-2,"4":12,"3":-4,"2":-4,".":35,",":35}},"\u00ff":{"d":"146,-229r-36,0r0,-34r36,0r0,34xm73,-229r-35,0r0,-34r35,0r0,34xm178,-196r-105,268r-36,0r35,-81r-71,-187r36,0r53,145r54,-145r34,0","w":179},"\u20ac":{"d":"15,-165v7,-80,92,-124,173,-89v-2,10,3,27,-2,34v-56,-39,-131,-4,-135,55r125,0r-5,24r-123,0r0,25r118,0r-5,24r-109,0v9,61,83,85,136,51r0,33v-79,36,-164,-7,-173,-84r-20,0r5,-24r12,0r0,-25r-17,0r5,-24r15,0"},"\u0142":{"d":"95,-150r-29,23r0,127r-33,0r0,-104r-29,24r0,-28r29,-23r0,-143r33,0r0,119r29,-23r0,28","w":98},"\u00d7":{"d":"225,-40r-19,20r-75,-76r-75,76r-19,-20r75,-75r-75,-74r19,-20r75,76r75,-76r19,20r-75,74","w":261},"\u0107":{"d":"143,-295r-48,66r-27,0r32,-66r43,0xm101,-24v26,0,42,-14,59,-24r0,37v-19,6,-33,16,-58,15v-62,-1,-89,-39,-92,-102v-5,-87,81,-125,150,-88v-2,11,3,29,-2,37v-14,-11,-32,-23,-57,-23v-38,0,-56,31,-56,74v0,42,18,73,56,74","w":166},"\u0105":{"d":"150,73v-44,2,-37,-55,-14,-73r27,0v-8,7,-20,19,-20,33v0,14,17,15,28,11r0,25v-5,2,-14,4,-21,4xm44,-59v0,49,71,36,90,11r0,-55v-38,5,-89,3,-90,44xm26,-192v56,-17,140,-17,140,58r0,134r-32,0r0,-21v-19,12,-31,27,-64,26v-37,-1,-60,-25,-60,-62v0,-63,62,-69,124,-72v5,-60,-69,-43,-108,-30r0,-33","w":188},"\u0119":{"d":"165,69v-23,10,-56,0,-54,-27v0,-13,5,-25,16,-38v-72,8,-117,-32,-117,-101v0,-59,35,-104,91,-105v61,0,82,42,79,107r-136,0v-8,80,90,83,132,47v-2,17,7,41,-14,42v-12,11,-22,20,-24,39v-1,15,16,14,27,11r0,25xm148,-120v9,-63,-82,-72,-99,-22v-3,6,-4,14,-5,22r104,0","w":189},"\u015b":{"d":"130,-295r-48,66r-26,0r31,-66r43,0xm143,-91v30,44,-8,96,-66,96v-25,0,-48,-10,-65,-17r0,-37v18,11,37,24,66,26v30,2,54,-22,36,-47v-33,-20,-101,-12,-101,-71v0,-62,88,-72,134,-46v-2,11,3,28,-2,35v-24,-30,-124,-28,-92,25v21,16,75,14,90,36","w":160},"\u017a":{"d":"129,-295r-48,66r-26,0r31,-66r43,0xm153,0r-144,0r0,-24r102,-145r-98,0r0,-27r138,0r0,23r-103,145r105,0r0,28","w":159},"\u017c":{"d":"98,-229r-38,0r0,-34r38,0r0,34xm153,0r-144,0r0,-24r102,-145r-98,0r0,-27r138,0r0,23r-103,145r105,0r0,28","w":159},"\u2032":{"d":"100,-262r-52,109r-24,0r34,-109r42,0","w":105},"\u2033":{"d":"100,-262r-53,109r-23,0r34,-109r42,0xm169,-262r-52,109r-24,0r34,-109r42,0","w":170}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * © 2006 Microsoft Corporation. All rights reserved.
 * 
 * Trademark:
 * Tahoma is either a registered trademark or a trademark of Microsoft Corporation
 * in the United States and/or other countries.
 * 
 * Manufacturer:
 * Microsoft Corporation
 * 
 * Designer:
 * Matthew Carter
 * 
 * Vendor URL:
 * http://www.microsoft.com/typography
 */
Cufon.registerFont({"w":229,"face":{"font-family":"Tahoma","font-weight":700,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 8 4 3 5 4 4 2 4","ascent":"288","descent":"-72","x-height":"6","bbox":"-15 -340 412 74.6356","underline-thickness":"35.332","underline-position":"-7.73438","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":105},"\u00a0":{"w":105},"!":{"d":"97,-262r-8,187r-55,0r-7,-187r70,0xm96,0r-69,0r0,-46r69,0r0,46","w":123},"\"":{"d":"154,-274r-11,104r-36,0r-11,-104r58,0xm80,-274r-11,104r-36,0r-11,-104r58,0","w":176},"#":{"d":"273,-160r-54,0r-14,57r47,0r0,41r-58,0r-15,62r-41,0r15,-62r-44,0r-16,62r-41,0r16,-62r-46,0r0,-41r56,0r14,-57r-49,0r0,-41r59,0r15,-61r42,0r-15,61r44,0r15,-61r42,0r-16,61r44,0r0,41xm179,-161r-46,0r-15,59r46,0","w":294},"$":{"d":"129,-236v20,-1,55,7,68,13r0,51v-24,-6,-38,-19,-69,-18r0,44v45,11,90,20,88,71v-2,48,-39,70,-87,75r0,63r-29,0r0,-62v-25,0,-62,-7,-79,-16r0,-51v21,4,52,21,80,20r0,-49v-43,-10,-84,-21,-84,-74v1,-42,39,-63,83,-67r0,-41r29,0r0,41xm102,-190v-29,0,-33,39,0,41r0,-41xm127,-46v20,1,35,-22,20,-37v-4,-4,-11,-6,-20,-8r0,45"},"%":{"d":"95,-267v52,0,76,31,76,85v0,56,-23,86,-76,86v-52,0,-76,-30,-76,-85v0,-56,23,-86,76,-86xm307,-262r-137,262r-46,0r137,-262r46,0xm337,-165v51,0,75,30,75,84v0,55,-23,86,-75,86v-53,0,-78,-29,-77,-85v0,-55,25,-84,77,-85xm95,-133v24,0,26,-23,26,-49v0,-24,-2,-47,-26,-47v-31,0,-25,38,-25,68v0,15,9,28,25,28xm337,-32v25,0,25,-23,25,-48v0,-24,-1,-48,-25,-48v-32,0,-26,42,-25,69v1,14,7,27,25,27","w":431},"&":{"d":"253,-153v2,40,-5,71,-24,91r62,58r0,4r-78,0r-23,-22v-51,49,-175,31,-175,-53v0,-39,22,-58,46,-72v-18,-13,-33,-28,-34,-58v-2,-80,171,-86,171,-6v0,39,-25,55,-56,66r50,49r0,-57r61,0xm118,-167v22,-12,25,-70,-11,-62v-16,3,-22,30,-9,43v5,6,12,12,20,19xm91,-118v-33,43,23,105,70,66","w":281},"'":{"d":"78,-274r-10,104r-37,0r-10,-104r57,0","w":99},"(":{"d":"75,-101v0,79,34,130,74,168r0,5r-64,0v-37,-43,-66,-94,-66,-173v0,-79,30,-129,66,-173r64,0r0,6v-40,38,-74,89,-74,167","w":163},")":{"d":"78,-274v37,44,66,93,66,173v0,78,-29,130,-66,173r-64,0r0,-5v41,-38,75,-90,75,-168v0,-77,-34,-129,-75,-167r0,-6r64,0","w":163},"*":{"d":"199,-151r-18,26r-55,-37r2,61r-35,0r1,-59r-54,36r-18,-28r61,-35r-60,-36r17,-27r54,36r-1,-60r35,0r-1,60r54,-36r18,27r-61,36"},"+":{"d":"261,-93r-90,0r0,89r-47,0r0,-89r-90,0r0,-45r90,0r0,-89r47,0r0,89r90,0r0,45","w":294},",":{"d":"98,-69r-61,134r-38,0r35,-134r64,0","w":112},"-":{"d":"136,-91r-117,0r0,-49r117,0r0,49","w":155},"\u00ad":{"d":"136,-91r-117,0r0,-49r117,0r0,49","w":155},".":{"d":"87,0r-62,0r0,-69r62,0r0,69","w":112},"\/":{"d":"175,-274r-104,331r-50,0r103,-331r51,0","w":207},"0":{"d":"115,-267v80,0,101,57,101,136v0,80,-20,136,-101,136v-80,0,-101,-56,-101,-136v0,-82,23,-135,101,-136xm115,-43v36,-5,35,-39,35,-88v0,-50,1,-82,-35,-88v-36,6,-35,38,-35,88v0,50,-1,82,35,88"},"1":{"d":"34,-227v33,1,61,-5,62,-35r57,0r0,216r54,0r0,46r-173,0r0,-46r55,0r0,-138r-55,0r0,-43"},"2":{"d":"207,-188v0,68,-62,106,-99,139r111,0r0,49r-192,0r0,-43r43,-36v30,-29,68,-52,71,-100v3,-55,-81,-38,-103,-14r-5,0r0,-57v60,-29,174,-25,174,62"},"3":{"d":"159,-138v32,4,51,23,53,59v5,94,-125,97,-194,68r0,-57v24,6,47,24,76,23v28,-1,52,-6,52,-38v0,-35,-37,-31,-71,-31r0,-46v32,0,69,1,65,-31v-5,-46,-86,-20,-109,-4r-5,0r0,-56v55,-23,179,-32,179,49v0,31,-20,55,-46,61r0,3"},"4":{"d":"222,-61r-35,0r0,62r-64,0r0,-62r-115,0r0,-49r113,-152r66,0r0,154r35,0r0,47xm123,-108r0,-89r-66,89r66,0"},"5":{"d":"147,-86v0,-50,-76,-35,-115,-29r0,-147r174,0r0,50r-112,0r0,43v67,-5,121,14,119,80v-2,63,-40,94,-107,94v-34,0,-63,-6,-85,-15r0,-58v34,17,126,47,126,-18"},"6":{"d":"139,-174v54,0,77,31,78,85v1,56,-39,95,-98,94v-74,-1,-100,-48,-102,-122v-3,-108,68,-167,178,-145r0,51v-26,-8,-72,-14,-91,8v-10,12,-18,27,-21,47v16,-11,32,-18,56,-18xm119,-39v23,-3,33,-19,33,-47v0,-39,-38,-51,-69,-37v-2,40,0,82,36,84"},"7":{"d":"213,-210r-111,210r-74,0r117,-212r-124,0r0,-50r192,0r0,52"},"8":{"d":"168,-143v28,15,52,31,50,70v-2,55,-45,79,-104,79v-59,0,-103,-22,-103,-77v0,-36,22,-48,48,-63v-26,-13,-40,-30,-41,-63v-2,-93,193,-97,193,-5v0,31,-18,48,-43,59xm135,-158v20,-19,18,-65,-20,-65v-36,0,-43,45,-10,54v10,5,16,6,30,11xm117,-39v28,0,47,-27,31,-51v-8,-11,-38,-21,-55,-28v-27,21,-22,79,24,79"},"9":{"d":"111,-267v74,-1,100,48,101,121v3,109,-67,168,-179,147r0,-52v49,18,115,3,113,-54v-52,38,-140,12,-134,-67v5,-60,38,-94,99,-95xm78,-175v-3,40,38,49,68,36v2,-39,0,-84,-35,-84v-24,0,-31,22,-33,48"},":":{"d":"97,-128r-63,0r0,-69r63,0r0,69xm97,0r-63,0r0,-69r63,0r0,69","w":130},";":{"d":"97,-128r-63,0r0,-69r63,0r0,69xm107,-69r-61,134r-38,0r35,-134r64,0","w":130},"\u037e":{"d":"97,-128r-63,0r0,-69r63,0r0,69xm107,-69r-61,134r-38,0r35,-134r64,0","w":130},"<":{"d":"258,-2r-226,-94r0,-39r226,-94r0,49r-159,65r159,64r0,49","w":294},"=":{"d":"255,-136r-216,0r0,-46r216,0r0,46xm255,-49r-216,0r0,-46r216,0r0,46","w":294},">":{"d":"263,-96r-226,94r0,-49r158,-64r-158,-65r0,-49r226,94r0,39","w":294},"?":{"d":"20,-252v57,-25,172,-24,171,54v-2,52,-34,72,-72,88r0,40r-60,0r0,-59v30,-9,63,-20,65,-56v2,-51,-78,-32,-99,-14r-5,0r0,-53xm124,0r-69,0r0,-46r69,0r0,46","w":203},"@":{"d":"60,-113v-5,96,80,138,169,109r0,37v-117,28,-211,-32,-208,-147v3,-91,56,-153,145,-153v89,0,138,59,142,150v0,33,-12,72,-24,93r-86,0r-3,-14v-12,8,-23,16,-44,15v-45,-2,-60,-41,-63,-88v-4,-63,57,-113,105,-76r0,-11r39,0r0,142r26,0v29,-78,-1,-182,-92,-175v-67,4,-103,49,-106,118xm162,-57v14,0,22,-5,30,-14r0,-89v-35,-20,-66,7,-63,49v2,31,5,54,33,54","w":331},"A":{"d":"-1,0r88,-262r72,0r89,262r-68,0r-17,-53r-82,0r-16,53r-66,0xm149,-101r-27,-86r-26,86r53,0","w":246},"B":{"d":"183,-143v31,6,53,25,53,63v-1,96,-113,79,-209,80r0,-262v82,4,191,-21,192,61v1,29,-19,45,-36,58xm92,-158v33,0,60,1,60,-30v-1,-28,-29,-26,-60,-26r0,56xm92,-48v37,1,77,3,77,-33v0,-38,-38,-32,-77,-33r0,66","w":246},"C":{"d":"229,-17v-26,11,-49,22,-89,22v-81,0,-128,-53,-128,-136v0,-80,49,-137,128,-136v36,0,65,10,89,22r0,62r-7,0v-18,-15,-39,-35,-71,-35v-49,0,-67,36,-71,88v-6,81,82,110,131,61v6,-3,8,-11,18,-10r0,62","w":240},"D":{"d":"108,-262v94,-2,153,41,153,131v0,87,-59,134,-152,131r-82,0r0,-262r81,0xm93,-49v67,5,100,-21,100,-82v0,-60,-34,-87,-100,-82r0,164","w":272},"E":{"d":"27,0r0,-262r177,0r0,50r-112,0r0,46r103,0r0,50r-103,0r0,66r112,0r0,50r-177,0","w":221},"F":{"d":"202,-212r-110,0r0,50r102,0r0,50r-102,0r0,112r-65,0r0,-262r175,0r0,50","w":209},"G":{"d":"80,-132v0,64,36,93,102,89r0,-52r-51,0r0,-49r115,0r0,129v-23,10,-65,21,-99,20v-84,1,-135,-50,-135,-136v0,-82,54,-136,137,-136v45,0,65,9,96,23r0,62v-30,-11,-45,-37,-87,-36v-52,1,-77,33,-78,86","w":268},"H":{"d":"248,0r-66,0r0,-116r-89,0r0,116r-66,0r0,-262r66,0r0,96r89,0r0,-96r66,0r0,262","w":275},"I":{"d":"158,0r-141,0r0,-46r37,0r0,-170r-37,0r0,-46r141,0r0,46r-38,0r0,170r38,0r0,46","w":174},"J":{"d":"1,-54v33,10,89,18,89,-30r1,-130r-60,0r0,-48r125,0r0,185v4,78,-83,91,-155,76r0,-53","w":180},"K":{"d":"256,0r-79,0r-71,-106r-13,18r0,88r-66,0r0,-262r66,0r0,116r83,-116r77,0r-94,122","w":250},"L":{"d":"202,0r-175,0r0,-262r66,0r0,212r109,0r0,50","w":206},"M":{"d":"294,0r-65,0r0,-173r-48,111r-44,0r-48,-111r0,173r-62,0r0,-262r76,0r58,129r58,-129r75,0r0,262","w":321},"N":{"d":"251,0r-63,0r-101,-182r0,182r-60,0r0,-262r81,0r83,150r0,-150r60,0r0,262","w":277},"O":{"d":"139,-267v79,0,126,54,126,136v0,82,-47,136,-126,136v-80,0,-127,-55,-127,-136v0,-82,46,-136,127,-136xm139,-44v81,0,80,-176,0,-174v-44,1,-58,38,-59,87v-1,50,15,87,59,87","w":277},"P":{"d":"27,-262v96,-1,205,-13,202,83v-2,72,-54,99,-136,93r0,86r-66,0r0,-262xm93,-134v39,0,70,-3,68,-44v-2,-34,-32,-36,-68,-35r0,79","w":236},"Q":{"d":"192,-4v-4,44,45,33,73,26r0,47v-60,15,-137,1,-134,-64v-74,-4,-119,-56,-119,-136v0,-82,46,-136,127,-136v79,0,126,54,126,136v0,63,-28,110,-73,127xm139,-44v81,0,80,-176,0,-174v-44,1,-58,38,-59,87v-1,50,15,87,59,87","w":277},"R":{"d":"231,-190v0,42,-22,64,-50,79r88,111r-80,0r-73,-96r-24,0r0,96r-65,0r0,-262v89,3,204,-20,204,72xm92,-143v39,1,71,-1,71,-39v0,-36,-36,-32,-71,-32r0,71","w":261},"S":{"d":"208,-126v41,66,-19,131,-100,131v-39,0,-68,-9,-95,-20r0,-63r6,0v21,19,54,31,89,35v42,5,66,-44,20,-53v-55,-12,-114,-23,-114,-88v0,-84,129,-99,197,-65r0,60r-6,0v-18,-15,-47,-30,-78,-30v-30,0,-58,20,-38,43v34,17,100,19,119,50","w":227},"T":{"d":"77,0r0,-212r-77,0r0,-50r220,0r0,50r-77,0r0,212r-66,0","w":220},"U":{"d":"243,-95v-1,67,-39,100,-110,100v-69,0,-110,-33,-110,-100r0,-167r66,0r0,164v0,35,12,54,44,54v33,0,44,-19,44,-54r0,-164r66,0r0,167","w":265},"V":{"d":"246,-262r-90,262r-69,0r-90,-262r68,0r57,178r57,-178r67,0","w":242},"W":{"d":"365,-262r-67,262r-72,0r-42,-162r-40,162r-72,0r-67,-262r68,0r37,176r43,-176r66,0r41,176r38,-176r67,0","w":370},"X":{"d":"249,0r-77,0r-50,-83r-51,83r-73,0r85,-132r-82,-130r76,0r47,79r49,-79r73,0r-82,128","w":246},"Y":{"d":"245,-262r-91,153r0,109r-65,0r0,-106r-92,-156r75,0r51,94r49,-94r73,0","w":241},"Z":{"d":"217,0r-208,0r0,-49r121,-163r-114,0r0,-50r194,0r0,50r-120,162r127,0r0,50","w":224},"[":{"d":"140,69r-111,0r0,-343r111,0r0,42r-58,0r0,259r58,0r0,42","w":163},"\\":{"d":"189,57r-51,0r-104,-331r51,0","w":207},"]":{"d":"134,69r-110,0r0,-42r57,0r0,-259r-57,0r0,-42r110,0r0,343","w":163},"^":{"d":"264,-118r-55,0r-65,-95r-59,95r-55,0r93,-144r43,0","w":294},"_":{"d":"232,61r-235,0r0,-36r235,0r0,36"},"`":{"d":"142,-226r-42,0r-53,-69r59,0","w":196},"a":{"d":"71,-62v-2,35,49,28,61,10r0,-41v-28,4,-59,1,-61,31xm133,-130v-4,-49,-76,-25,-108,-16r0,-47v62,-16,169,-20,169,59r0,134r-62,0r0,-21v-31,43,-127,31,-123,-36v4,-65,62,-68,124,-73","w":215},"b":{"d":"85,-45v41,14,73,-9,69,-55v7,-52,-38,-67,-69,-44r0,99xm145,-203v52,1,69,46,72,102v4,76,-69,132,-132,91r-3,10r-58,0r0,-274r61,0r0,97v17,-14,32,-26,60,-26","w":227},"c":{"d":"72,-98v0,64,74,74,104,35r8,0r0,53v-71,35,-175,8,-175,-88v0,-96,100,-126,175,-89r0,53r-8,0v-12,-12,-29,-25,-54,-25v-33,0,-50,26,-50,61","w":189},"d":{"d":"9,-97v0,-79,68,-131,133,-92r0,-85r61,0r0,274r-61,0r0,-21v-17,12,-30,26,-59,26v-50,0,-74,-48,-74,-102xm72,-98v-7,51,38,68,70,44r0,-97v-38,-18,-74,8,-70,53","w":226},"e":{"d":"202,-11v-23,8,-43,16,-77,16v-72,0,-116,-34,-116,-103v0,-64,41,-107,106,-106v68,0,96,44,91,117r-135,0v0,63,94,54,125,25r6,0r0,51xm145,-124v5,-38,-41,-51,-63,-29v-7,7,-10,17,-11,29r74,0","w":213},"f":{"d":"28,-197v-7,-72,56,-86,122,-75r0,45v-28,-6,-69,-13,-62,30r49,0r0,42r-47,0r0,155r-62,0r0,-155r-24,0r0,-42r24,0","w":137},"g":{"d":"72,-102v-7,47,40,63,70,40r0,-90v-38,-15,-73,8,-70,50xm9,-104v0,-76,70,-123,132,-85r2,-8r60,0r0,174v8,95,-91,110,-173,89r0,-49v44,12,118,27,112,-40v-12,11,-30,21,-53,20v-57,-1,-80,-40,-80,-101","w":226},"h":{"d":"146,-203v87,-2,57,121,62,203r-61,0r0,-98v0,-28,0,-56,-30,-54v-13,1,-22,6,-32,12r0,140r-61,0r0,-274r61,0r0,98v18,-14,33,-26,61,-27","w":230},"i":{"d":"85,0r-61,0r0,-197r61,0r0,197xm87,-226r-65,0r0,-48r65,0r0,48","w":108},"j":{"d":"-15,24v35,10,61,5,61,-42r0,-137r-36,0r0,-42r97,0r0,201v4,63,-63,80,-122,66r0,-46xm107,-226r-66,0r0,-48r66,0r0,48","w":130},"k":{"d":"221,0r-73,0r-53,-86v-18,14,-7,57,-10,86r-61,0r0,-274r61,0r0,154r58,-77r73,0r-69,85","w":216},"l":{"d":"85,0r-61,0r0,-274r61,0r0,274","w":108},"m":{"d":"262,-203v85,0,53,122,59,203r-62,0r0,-123v4,-35,-40,-34,-56,-17r0,140r-62,0r0,-123v3,-34,-39,-34,-56,-17r0,140r-61,0r0,-197r61,0r0,21v26,-33,96,-38,111,7v21,-17,36,-34,66,-34","w":343},"n":{"d":"146,-203v87,-2,57,121,62,203r-61,0r0,-98v0,-28,0,-56,-30,-54v-13,1,-22,6,-32,12r0,140r-61,0r0,-197r61,0r0,21v18,-14,33,-26,61,-27","w":230},"o":{"d":"111,-204v64,0,102,41,102,105v0,63,-38,105,-102,105v-64,0,-102,-42,-102,-105v0,-64,38,-105,102,-105xm112,-38v31,0,38,-25,38,-60v0,-34,-6,-61,-39,-61v-33,0,-39,27,-39,61v0,35,7,60,40,60","w":222},"p":{"d":"145,-203v51,0,72,46,72,102v0,77,-69,132,-132,91r0,82r-61,0r0,-269r61,0r0,20v17,-14,32,-26,60,-26xm85,-45v40,14,73,-8,69,-55v7,-50,-37,-68,-69,-44r0,99","w":226},"q":{"d":"9,-97v0,-79,67,-130,132,-92r2,-8r60,0r0,269r-61,0r0,-91v-17,12,-30,24,-59,24v-50,0,-74,-48,-74,-102xm72,-98v-7,51,38,68,70,44r0,-97v-38,-18,-74,8,-70,53","w":226},"r":{"d":"85,-169v16,-15,38,-33,71,-28r0,58v-26,-4,-51,-3,-71,7r0,132r-61,0r0,-197r61,0r0,28","w":156},"s":{"d":"168,-97v33,55,-17,102,-84,102v-28,0,-57,-6,-74,-15r0,-52v24,7,41,26,74,25v30,5,48,-29,11,-34v-43,-6,-85,-18,-84,-67v0,-70,107,-77,160,-51r0,50v-22,-6,-36,-22,-65,-22v-19,0,-41,11,-28,28v25,13,76,13,90,36","w":185},"t":{"d":"89,-66v-1,32,35,29,59,21r0,43v-55,13,-121,8,-121,-60r0,-93r-23,0r0,-42r23,0r0,-57r62,0r0,57r59,0r0,42r-59,0r0,89","w":149},"u":{"d":"114,-46v10,-1,24,-5,31,-11r0,-140r62,0r0,197r-62,0r0,-22v-36,45,-123,34,-123,-47r0,-128r62,0r0,98v0,30,-1,54,30,53","w":230},"v":{"d":"208,-197r-71,197r-67,0r-70,-197r65,0r40,130r40,-130r63,0","w":208},"w":{"d":"318,-197r-58,197r-65,0r-35,-128r-35,128r-65,0r-57,-197r64,0r31,130r37,-130r54,0r36,130r29,-130r64,0","w":320},"x":{"d":"218,0r-72,0r-37,-57r-39,57r-71,0r73,-99r-71,-98r72,0r37,55r37,-55r70,0r-71,97","w":217},"y":{"d":"208,-197r-100,269r-66,0r30,-77r-73,-192r65,0r42,123r38,-123r64,0","w":207},"z":{"d":"181,0r-173,0r0,-41r95,-110r-90,0r0,-46r166,0r0,39r-94,111r96,0r0,47","w":189},"{":{"d":"136,-33v0,50,12,70,64,63r0,39v-77,6,-128,-11,-120,-94v4,-45,-22,-58,-70,-56r0,-43v58,5,73,-22,70,-81v-3,-62,53,-74,120,-69r0,39v-48,-5,-64,11,-64,63v0,37,-25,56,-53,68r0,4v29,11,53,30,53,67","w":224},"|":{"d":"139,69r-49,0r0,-343r49,0r0,343"},"}":{"d":"144,-205v-3,56,10,87,70,81r0,43v-59,-5,-73,23,-70,82v3,62,-53,73,-120,68r0,-39v50,6,69,-11,65,-63v-3,-37,24,-56,53,-67r0,-4v-34,-13,-58,-37,-53,-88v4,-39,-26,-45,-65,-43r0,-39v66,-5,123,7,120,69","w":224},"~":{"d":"187,-108v36,14,40,-32,39,-66r46,0v14,96,-79,152,-135,81v-10,-13,-19,-34,-39,-34v-30,0,-26,39,-29,68r-45,0v-6,-80,44,-140,111,-104v22,12,33,39,52,55","w":294},"\u00c4":{"d":"189,-291r-50,0r0,-48r50,0r0,48xm105,-291r-51,0r0,-48r51,0r0,48xm-1,0r88,-262r72,0r89,262r-68,0r-17,-53r-82,0r-16,53r-66,0xm149,-101r-27,-86r-26,86r53,0","w":246},"\u00c5":{"d":"123,-340v48,0,78,63,40,92r85,248r-68,0r-17,-53r-82,0r-16,53r-66,0r84,-248v-35,-29,-8,-92,40,-92xm123,-262v15,0,24,-11,24,-25v0,-15,-10,-26,-24,-26v-14,0,-25,12,-24,26v0,13,10,25,24,25xm149,-101r-27,-86r-26,86r53,0","w":246},"\u00d6":{"d":"206,-291r-50,0r0,-48r50,0r0,48xm121,-291r-50,0r0,-48r50,0r0,48xm139,-267v79,0,126,54,126,136v0,82,-47,136,-126,136v-80,0,-127,-55,-127,-136v0,-82,46,-136,127,-136xm139,-44v81,0,80,-176,0,-174v-44,1,-58,38,-59,87v-1,50,15,87,59,87","w":277},"\u00dc":{"d":"199,-291r-51,0r0,-48r51,0r0,48xm114,-291r-50,0r0,-48r50,0r0,48xm243,-95v-1,67,-39,100,-110,100v-69,0,-110,-33,-110,-100r0,-167r66,0r0,164v0,35,12,54,44,54v33,0,44,-19,44,-54r0,-164r66,0r0,167","w":265},"\u00e1":{"d":"162,-295r-52,69r-42,0r36,-69r58,0xm71,-62v-2,35,49,28,61,10r0,-41v-28,4,-59,1,-61,31xm133,-130v-4,-49,-76,-25,-108,-16r0,-47v62,-16,169,-20,169,59r0,134r-62,0r0,-21v-31,43,-127,31,-123,-36v4,-65,62,-68,124,-73","w":215},"\u00e0":{"d":"71,-62v-2,35,49,28,61,10r0,-41v-28,4,-59,1,-61,31xm133,-130v-4,-49,-76,-25,-108,-16r0,-47v62,-16,169,-20,169,59r0,134r-62,0r0,-21v-31,43,-127,31,-123,-36v4,-65,62,-68,124,-73xm143,-226r-42,0r-53,-69r59,0","w":215},"\u00e4":{"d":"170,-226r-50,0r0,-48r50,0r0,48xm85,-226r-50,0r0,-48r50,0r0,48xm71,-62v-2,35,49,28,61,10r0,-41v-28,4,-59,1,-61,31xm133,-130v-4,-49,-76,-25,-108,-16r0,-47v62,-16,169,-20,169,59r0,134r-62,0r0,-21v-31,43,-127,31,-123,-36v4,-65,62,-68,124,-73","w":215},"\u00e5":{"d":"71,-62v-2,35,49,28,61,10r0,-41v-28,4,-59,1,-61,31xm133,-130v-4,-49,-76,-25,-108,-16r0,-47v14,-5,36,-8,56,-9v-45,-21,-28,-99,28,-99v57,0,72,84,23,101v38,5,62,24,62,66r0,134r-62,0r0,-21v-31,43,-127,31,-123,-36v4,-65,62,-68,124,-73xm109,-222v14,0,23,-13,24,-26v1,-13,-11,-26,-24,-26v-13,0,-24,12,-24,26v0,14,9,26,24,26","w":215},"\u00e7":{"d":"60,35v27,9,65,9,59,-30v-69,-1,-107,-34,-110,-103v-4,-95,100,-126,175,-89r0,53r-8,0v-12,-12,-29,-25,-54,-25v-33,0,-50,26,-50,61v0,67,79,73,104,35r8,0r0,53r-28,11v10,59,-40,85,-96,69r0,-35","w":189},"\u00e9":{"d":"172,-295r-53,69r-41,0r36,-69r58,0xm202,-11v-23,8,-43,16,-77,16v-72,0,-116,-34,-116,-103v0,-64,41,-107,106,-106v68,0,96,44,91,117r-135,0v0,63,94,54,125,25r6,0r0,51xm145,-124v5,-38,-41,-51,-63,-29v-7,7,-10,17,-11,29r74,0","w":213},"\u00e8":{"d":"202,-11v-23,8,-43,16,-77,16v-72,0,-116,-34,-116,-103v0,-64,41,-107,106,-106v68,0,96,44,91,117r-135,0v0,63,94,54,125,25r6,0r0,51xm145,-124v5,-38,-41,-51,-63,-29v-7,7,-10,17,-11,29r74,0xm149,-226r-42,0r-53,-69r59,0","w":213},"\u00ed":{"d":"85,0r-61,0r0,-197r61,0r0,197xm111,-295r-52,69r-42,0r36,-69r58,0","w":108},"\u00ee":{"d":"85,0r-61,0r0,-197r61,0r0,197xm116,-226r-40,0r-22,-37r-22,37r-40,0r41,-69r42,0","w":108},"\u00ef":{"d":"85,0r-61,0r0,-197r61,0r0,197xm116,-226r-50,0r0,-48r50,0r0,48xm43,-226r-49,0r0,-48r49,0r0,48","w":108},"\u00f1":{"d":"142,-263v13,1,15,-10,16,-21r37,0v-1,36,-18,56,-51,57v-23,1,-31,-18,-51,-20v-13,-1,-15,9,-16,21r-37,0v2,-31,18,-56,50,-56v23,0,32,16,52,19xm146,-203v87,-2,57,121,62,203r-61,0r0,-98v0,-28,0,-56,-30,-54v-13,1,-22,6,-32,12r0,140r-61,0r0,-197r61,0r0,21v18,-14,33,-26,61,-27","w":230},"\u00f3":{"d":"172,-295r-53,69r-42,0r37,-69r58,0xm111,-204v64,0,102,41,102,105v0,63,-38,105,-102,105v-64,0,-102,-42,-102,-105v0,-64,38,-105,102,-105xm112,-38v31,0,38,-25,38,-60v0,-34,-6,-61,-39,-61v-33,0,-39,27,-39,61v0,35,7,60,40,60","w":222},"\u00f6":{"d":"179,-226r-51,0r0,-48r51,0r0,48xm94,-226r-50,0r0,-48r50,0r0,48xm111,-204v64,0,102,41,102,105v0,63,-38,105,-102,105v-64,0,-102,-42,-102,-105v0,-64,38,-105,102,-105xm112,-38v31,0,38,-25,38,-60v0,-34,-6,-61,-39,-61v-33,0,-39,27,-39,61v0,35,7,60,40,60","w":222},"\u00f9":{"d":"114,-46v10,-1,24,-5,31,-11r0,-140r62,0r0,197r-62,0r0,-22v-36,45,-123,34,-123,-47r0,-128r62,0r0,98v0,30,-1,54,30,53xm153,-226r-42,0r-53,-69r59,0","w":230},"\u00fb":{"d":"188,-226r-46,0r-29,-37r-29,37r-44,0r52,-69r43,0xm114,-46v10,-1,24,-5,31,-11r0,-140r62,0r0,197r-62,0r0,-22v-36,45,-123,34,-123,-47r0,-128r62,0r0,98v0,30,-1,54,30,53","w":230},"\u00fc":{"d":"181,-226r-50,0r0,-48r50,0r0,48xm97,-226r-51,0r0,-48r51,0r0,48xm114,-46v10,-1,24,-5,31,-11r0,-140r62,0r0,197r-62,0r0,-22v-36,45,-123,34,-123,-47r0,-128r62,0r0,98v0,30,-1,54,30,53","w":230},"\u00a3":{"d":"118,-106v-2,26,-13,44,-28,57r122,0r0,49r-191,0r0,-49v26,-8,34,-23,35,-57r-29,0r0,-37r29,0v-9,-76,19,-125,87,-124v24,0,44,4,59,9r0,53v-17,-2,-28,-14,-49,-14v-36,0,-37,38,-35,76r65,0r0,37r-65,0"},"\u00df":{"d":"156,-151v38,5,66,29,67,69v2,65,-54,92,-118,82r0,-48v31,9,57,-4,55,-38v-1,-29,-19,-37,-50,-37r0,-46v22,0,34,-13,34,-36v0,-18,-9,-28,-27,-28v-24,0,-32,17,-32,42r0,191r-61,0r0,-186v-1,-56,36,-90,93,-89v49,1,85,17,88,62v2,33,-25,54,-49,62","w":232},"\u2122":{"d":"291,-138r-31,0r0,-96r-4,0r-30,67r-22,0r-31,-68r-4,0r0,97r-31,0r0,-124r53,0r24,61r26,-61r50,0r0,124xm118,-234r-35,0r0,96r-33,0r0,-96r-35,0r0,-28r103,0r0,28","w":309},"\u00ab":{"d":"221,-26r-98,-78r0,-23r98,-78r0,52r-49,37r49,38r0,52xm121,-26r-99,-78r0,-23r99,-78r0,52r-49,37r49,38r0,52","w":253},"\u00bb":{"d":"231,-104r-99,78r0,-52r50,-38r-50,-37r0,-52r99,78r0,23xm130,-104r-98,78r0,-52r49,-38r-49,-37r0,-52r98,78r0,23","w":253},"\u2026":{"d":"330,0r-60,0r0,-69r60,0r0,69xm210,0r-60,0r0,-69r60,0r0,69xm90,0r-60,0r0,-69r60,0r0,69","w":360},"\u2013":{"d":"230,-93r-231,0r0,-45r231,0r0,45"},"\u2014":{"d":"328,-93r-329,0r0,-45r329,0r0,45","w":327},"\u201c":{"d":"159,-170r-39,0r-48,-104r60,0xm82,-170r-39,0r-48,-104r60,0","w":176},"\u201d":{"d":"181,-274r-48,104r-39,0r27,-104r60,0xm104,-274r-48,104r-39,0r27,-104r60,0","w":176},"\u2018":{"d":"82,-170r-39,0r-48,-104r60,0","w":99},"\u2019":{"d":"104,-274r-48,104r-39,0r27,-104r60,0","w":99},"\u00ff":{"d":"172,-226r-50,0r0,-48r50,0r0,48xm88,-226r-51,0r0,-48r51,0r0,48xm208,-197r-100,269r-66,0r30,-77r-73,-192r65,0r42,123r38,-123r64,0","w":207},"\u20ac":{"d":"17,-174v14,-82,117,-116,201,-76r0,58r-7,0v-43,-39,-103,-35,-124,18r91,0r-7,33r-91,0r0,25r86,0r-6,33r-71,0v23,49,80,50,122,13r7,0r0,59v-82,37,-186,9,-200,-72r-25,0r7,-33r12,0r0,-25r-19,0r7,-33r17,0"},"\u0142":{"d":"118,-139r-27,16r0,123r-61,0r0,-90r-27,16r0,-41r27,-15r0,-144r61,0r0,111r27,-17r0,41","w":120},"\u00d7":{"d":"253,-41r-31,31r-74,-74r-74,73r-31,-31r73,-73r-74,-75r31,-31r75,74r73,-73r32,31r-74,74","w":294},"\u0107":{"d":"169,-295r-53,69r-42,0r36,-69r59,0xm72,-98v0,64,74,74,104,35r8,0r0,53v-71,35,-175,8,-175,-88v0,-96,100,-126,175,-89r0,53r-8,0v-12,-12,-29,-25,-54,-25v-33,0,-50,26,-50,61","w":189},"\u0105":{"d":"162,73v-45,4,-43,-57,-17,-73r37,0v-9,6,-20,24,-7,32v5,3,13,-1,19,-1r0,36v-8,3,-23,5,-32,6xm71,-62v-2,35,49,28,61,10r0,-41v-28,4,-59,1,-61,31xm133,-130v-4,-49,-76,-25,-108,-16r0,-47v62,-16,169,-20,169,59r0,134r-62,0r0,-21v-31,43,-127,31,-123,-36v4,-65,62,-68,124,-73","w":215},"\u0119":{"d":"198,67v-27,11,-70,7,-69,-25v0,-14,5,-27,16,-38v-80,8,-136,-27,-136,-102v0,-64,41,-107,106,-106v68,0,96,44,91,117r-135,0v0,63,94,54,125,25r6,0r0,51v-15,6,-28,13,-29,32v-1,14,14,12,25,10r0,36xm145,-124v5,-38,-41,-51,-63,-29v-7,7,-10,17,-11,29r74,0","w":213},"\u015b":{"d":"158,-295r-53,69r-42,0r37,-69r58,0xm168,-97v33,55,-17,102,-84,102v-28,0,-57,-6,-74,-15r0,-52v24,7,41,26,74,25v30,5,48,-29,11,-34v-43,-6,-85,-18,-84,-67v0,-70,107,-77,160,-51r0,50v-22,-6,-36,-22,-65,-22v-19,0,-41,11,-28,28v25,13,76,13,90,36","w":185},"\u017a":{"d":"162,-295r-53,69r-42,0r36,-69r59,0xm181,0r-173,0r0,-41r95,-110r-90,0r0,-46r166,0r0,39r-94,111r96,0r0,47","w":189},"\u017c":{"d":"130,-226r-63,0r0,-48r63,0r0,48xm181,0r-173,0r0,-41r95,-110r-90,0r0,-46r166,0r0,39r-94,111r96,0r0,47","w":189},"\u2032":{"d":"116,-262r-62,113r-40,0r40,-113r62,0","w":112},"\u2033":{"d":"116,-262r-62,113r-40,0r40,-113r62,0xm199,-262r-62,113r-40,0r39,-113r63,0","w":195}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * (C) 2009 dot colon.
 * 
 * Full name:
 * Vegur-Light
 * 
 * Designer:
 * arro
 */
Cufon.registerFont({"w":184,"face":{"font-family":"Vegur","font-weight":300,"font-stretch":"normal","units-per-em":"360","panose-1":"0 0 0 0 0 0 0 0 0 0","ascent":"277","descent":"-83","x-height":"4","bbox":"-15 -270 307 90","underline-thickness":"18","underline-position":"-18","unicode-range":"U+0020-U+201D"},"glyphs":{" ":{"w":85},"A":{"d":"180,0r-29,-86r-98,0r-29,86r-15,0r86,-244r15,0r85,244r-15,0xm58,-99r89,0r-45,-127","w":207,"k":{"y":9,"Y":28,"w":10,"W":22,"V":24,"v":12,"T":27}},"a":{"d":"36,-168v44,-19,103,-8,103,48r0,120r-13,0v-1,-10,1,-25,-2,-33v-19,55,-107,45,-107,-18v0,-50,57,-67,108,-56v8,-57,-44,-69,-88,-49xm75,-8v36,1,55,-39,50,-87v-41,-9,-92,1,-92,42v0,28,18,45,42,45","w":167},"@":{"d":"179,-209v58,0,103,53,103,103v0,53,-29,88,-66,88v-15,0,-26,-10,-32,-29v-21,46,-87,43,-89,-16v-2,-66,52,-106,116,-87v-2,35,-32,121,9,121v27,0,49,-27,49,-71v0,-54,-38,-98,-97,-98v-75,0,-133,56,-133,127v0,94,99,132,172,87r1,10v-76,49,-185,4,-185,-90v0,-89,68,-145,152,-145xm140,-26v46,0,51,-71,58,-116v-53,-11,-92,23,-91,75v0,27,16,41,33,41","w":316},"`":{"d":"15,-253v7,1,17,-2,19,4v7,14,16,29,24,42r-14,0v-8,-12,-21,-31,-29,-46","w":88},"B":{"d":"113,-129v30,11,54,29,54,60v0,61,-70,81,-136,67r0,-240v59,-12,130,3,130,54v0,30,-24,52,-48,59xm45,-131v52,3,95,-3,100,-54v4,-41,-53,-55,-100,-45r0,99xm151,-67v0,-43,-51,-57,-106,-52r0,105v52,11,106,-7,106,-53","w":185},"b":{"d":"45,-139v38,-66,137,-39,137,49v0,89,-101,126,-137,57r-1,33r-13,0r0,-259r14,0r0,120xm104,-164v-48,0,-59,42,-59,95v0,36,27,60,59,60v35,0,62,-29,62,-78v0,-46,-22,-77,-62,-77","w":199},"C":{"d":"16,-121v0,-101,94,-151,180,-116r-2,13v-80,-32,-162,8,-162,102v0,95,79,135,158,101r2,13v-86,34,-176,-6,-176,-113","w":208},"c":{"d":"33,-89v0,70,57,96,115,70r2,13v-62,27,-133,-3,-133,-79v0,-80,75,-108,135,-81r-2,12v-50,-24,-117,-5,-117,65","w":164},"D":{"d":"31,-242v103,-19,195,21,192,113v-4,99,-86,146,-192,128r0,-241xm45,-230r0,217v91,14,159,-28,162,-113v3,-80,-71,-120,-162,-104","w":238},"d":{"d":"154,-33v-39,67,-137,37,-137,-50v0,-89,101,-125,137,-56r0,-120r14,0r0,259r-13,0xm95,-9v48,0,59,-41,59,-94v0,-36,-27,-61,-59,-61v-35,0,-62,29,-62,78v0,46,22,77,62,77","w":199},"#":{"d":"168,-147r-37,0r-9,57r38,0r0,11r-40,0r-11,66r-11,0r10,-66r-42,0r-11,66r-11,0r10,-66r-35,0r0,-11r37,0r10,-57r-39,0r0,-11r40,0r11,-66r12,0r-11,66r42,0r11,-66r12,0r-11,66r35,0r0,11xm110,-90r10,-57r-43,0r-9,57r42,0","w":187},"\"":{"d":"36,-180r-12,0r-1,-66v-1,-9,8,-7,16,-7xm67,-180r-11,0r-2,-66v0,-8,9,-7,17,-7","w":90},"!":{"d":"54,-8v0,17,-23,14,-23,0v0,-6,5,-11,11,-11v6,0,12,5,12,11xm49,-50r-13,0r-2,-194r17,0","w":84},"E":{"d":"45,-13r109,0r0,13r-123,0r0,-244r120,0r0,13r-106,0r0,99r94,0r0,12r-94,0r0,107","w":174},"e":{"d":"97,-177v46,0,66,43,60,91r-125,0v-3,67,55,92,110,68r1,12v-60,25,-127,3,-126,-79v0,-49,32,-92,80,-92xm33,-98r111,0v0,-39,-16,-67,-50,-67v-36,0,-59,32,-61,67","w":176},"F":{"d":"45,0r-14,0r0,-244r120,0r0,13r-106,0r0,102r94,0r0,13r-94,0r0,116","w":160},"f":{"d":"41,-173v-5,-65,31,-105,82,-85r-2,12v-43,-17,-72,16,-65,73r46,0r0,13r-46,0r0,160r-15,0r0,-160r-28,0r0,-13r28,0","w":112},"G":{"d":"16,-120v0,-105,96,-151,179,-116r-2,14v-75,-35,-161,4,-161,100v0,94,76,130,156,102r0,-83r-61,0r0,-13r75,0r0,106v-90,32,-186,2,-186,-110","w":224},"g":{"d":"167,-173r0,149v2,98,-70,114,-136,86r2,-13v62,34,135,2,119,-85v-37,69,-135,36,-135,-49v0,-89,101,-121,136,-54r1,-34r13,0xm94,-164v-35,0,-61,30,-61,77v0,46,23,76,62,76v46,0,58,-40,58,-92v0,-36,-27,-61,-59,-61","w":198},"H":{"d":"193,-244r15,0r0,244r-15,0r0,-120r-148,0r0,120r-14,0r0,-244r14,0r0,112r148,0r0,-112","w":238},"h":{"d":"45,-259r1,121v13,-25,36,-39,62,-39v76,1,48,106,53,177r-14,0v-6,-62,24,-164,-44,-164v-33,0,-58,28,-58,62r0,102r-14,0r0,-259r14,0","w":188},"I":{"d":"45,0r-14,0r0,-244r14,0r0,244","w":76},"i":{"d":"31,0r0,-173r14,0r0,173r-14,0xm38,-220v-6,0,-11,-5,-11,-11v0,-6,5,-11,11,-11v6,0,11,5,11,11v0,6,-5,11,-11,11","w":76},"J":{"d":"103,-78v1,70,-46,93,-101,77r2,-13v46,14,85,0,84,-63r0,-167r15,0r0,166","w":131},"j":{"d":"50,-173v-7,95,29,240,-63,247r-2,-13v31,-6,50,-22,50,-73r0,-161r15,0xm42,-220v-6,0,-10,-5,-10,-11v0,-6,4,-11,10,-11v6,0,11,5,11,11v0,6,-5,11,-11,11","w":80},"K":{"d":"185,-244r-104,117r112,127r-20,0r-102,-117r-26,30r0,87r-14,0r0,-244r14,0v2,45,-4,98,2,139r120,-139r18,0","w":189},"k":{"d":"156,-173r-71,71r80,102r-18,0r-72,-91r-30,31r0,60r-14,0r0,-259r14,0r1,183v17,-20,91,-97,91,-97r19,0","w":164},"L":{"d":"31,-244r14,0r0,231r113,0r0,13r-127,0r0,-244","w":167},"l":{"d":"45,0r-14,0r0,-259r14,0r0,259","w":76},"M":{"d":"232,-244r18,0r8,244r-14,0r-7,-225r-87,218r-14,0r-87,-218r-6,225r-13,0r9,-244r18,0r87,220","w":289},"m":{"d":"103,-176v28,0,39,24,49,44v23,-66,109,-58,109,19r0,113r-15,0v-6,-59,22,-163,-40,-163v-64,1,-53,95,-53,163r-14,0v-5,-60,21,-162,-41,-163v-64,0,-53,95,-53,163r-14,0r0,-173r13,0v1,11,-1,26,2,35v12,-24,30,-38,57,-38","w":288},"N":{"d":"213,-244r0,244r-19,0r-152,-230r1,230r-13,0r0,-244r20,0r151,230r-1,-230r13,0","w":243},"O":{"d":"126,4v-66,0,-110,-60,-110,-126v0,-66,44,-126,110,-126v66,0,111,60,111,126v0,66,-45,126,-111,126xm126,-9v58,0,95,-54,95,-113v0,-59,-37,-113,-95,-113v-58,0,-94,54,-94,113v0,59,36,113,94,113","w":252},"o":{"d":"17,-86v0,-55,34,-90,79,-90v45,0,79,35,79,90v0,55,-34,90,-79,90v-45,0,-79,-35,-79,-90xm33,-86v0,46,24,77,63,77v39,0,63,-31,63,-77v0,-46,-24,-78,-63,-78v-39,0,-63,32,-63,78","w":191},"P":{"d":"45,-231r0,114v53,9,103,-10,103,-60v0,-50,-51,-62,-103,-54xm31,0r0,-241v62,-15,136,3,133,60v-3,62,-57,86,-119,77r0,104r-14,0","w":177,"k":{"q":8,"o":8,"J":22,"g":8,"e":8,"d":8,"c":8,"a":9}},"p":{"d":"45,-139v38,-66,137,-39,137,49v0,89,-101,126,-137,57r0,104r-14,0r0,-244r13,0xm104,-164v-48,0,-59,42,-59,95v0,36,27,60,59,60v35,0,62,-29,62,-78v0,-46,-22,-77,-62,-77","w":199},"q":{"d":"154,-33v-39,67,-137,37,-137,-50v0,-89,101,-125,137,-56r1,-34r13,0r0,244r-14,0r0,-104xm95,-9v48,0,59,-41,59,-94v0,-36,-27,-61,-59,-61v-35,0,-62,29,-62,78v0,46,22,77,62,77","w":199},"Q":{"d":"237,-122v0,53,-29,102,-75,119r13,51r-14,4r-12,-51v-79,17,-133,-50,-133,-123v0,-66,44,-126,110,-126v66,0,111,60,111,126xm126,-9v58,0,95,-54,95,-113v0,-59,-37,-113,-95,-113v-58,0,-94,54,-94,113v0,59,36,113,94,113","w":252},"R":{"d":"45,-123v56,4,105,-5,105,-57v0,-48,-56,-61,-105,-49r0,106xm155,0v-15,-44,-9,-112,-66,-111r-44,0r0,111r-14,0r0,-240v61,-16,135,-1,135,56v0,36,-28,57,-52,66v46,10,40,76,58,118r-17,0","w":183},"r":{"d":"93,-177r-1,17v-58,5,-46,93,-47,160r-14,0r0,-174r13,0v1,14,-1,33,2,45v9,-28,26,-46,47,-48","w":97,"k":{"y":-4,"v":-4,"t":-8}},"s":{"d":"104,-42v7,-38,-87,-43,-78,-89v-3,-44,56,-54,87,-37r-1,12v-22,-13,-71,-12,-71,22v0,46,90,48,79,88v3,49,-65,61,-102,40r1,-12v30,15,86,14,85,-24","w":140},"S":{"d":"137,-60v0,-62,-109,-60,-109,-126v0,-59,72,-74,116,-53r-2,13v-33,-18,-102,-9,-98,37v-8,63,118,61,109,125v5,60,-79,82,-135,59r2,-14v43,19,117,13,117,-41","w":176},"T":{"d":"165,-244r0,13r-72,0r0,231r-15,0r0,-231r-73,0r0,-13r160,0","w":170,"k":{"n":28,"z":28,"y":19,"x":26,"w":21,"v":23,"u":28,"s":28,"r":28,"q":26,"o":26,"m":28,"J":31,"g":26,"e":26,"d":26,"c":26,"a":29,"A":27}},"t":{"d":"88,-173r0,13r-40,0r0,119v0,34,22,37,45,28r1,12v-27,11,-60,5,-60,-35r0,-124r-26,0r0,-13r26,0r0,-36r14,0r0,36r40,0","w":109},"U":{"d":"185,-82v0,55,-34,86,-79,86v-45,0,-78,-34,-78,-81r0,-167r14,0r0,163v0,46,28,72,65,72v95,0,56,-145,64,-235r14,0r0,162","w":211},"u":{"d":"143,-35v-14,26,-37,39,-62,39v-77,-1,-47,-106,-53,-177r14,0v6,62,-23,164,44,164v32,0,57,-28,57,-62r0,-102r15,0r0,173r-14,0","w":188},"v":{"d":"146,-173r14,0r-69,173r-15,0r-69,-173r15,0r62,157","w":165},"V":{"d":"91,0r-85,-244r15,0r78,226r78,-226r15,0r-86,244r-15,0","w":195,"k":{"z":17,"s":22,"q":14,"o":14,"J":22,"e":14,"d":14,"c":14,"a":19,"A":24}},"W":{"d":"293,-244r14,0r-75,244r-14,0r-61,-224r-61,224r-15,0r-74,-244r15,0r67,225r61,-225r15,0r61,225","w":312,"k":{"z":15,"s":21,"q":12,"o":12,"J":21,"g":12,"e":12,"d":12,"c":12,"a":17,"A":22}},"w":{"d":"242,-173r14,0r-60,173r-15,0r-49,-154r-48,154r-16,0r-60,-173r16,0r53,155r49,-155r15,0r49,155","w":263},"x":{"d":"147,-173r-60,84r65,89r-18,0r-56,-77r-56,77r-16,0r64,-89r-61,-84r18,0v19,23,32,52,53,73r51,-73r16,0","w":159},"X":{"d":"167,-244r-72,119r77,125r-17,0r-68,-113r-66,113r-16,0r76,-125r-73,-119r16,0r65,107r63,-107r15,0","w":174},"Y":{"d":"163,-244r16,0r-79,137r0,107r-14,0r0,-105r-80,-139r17,0r71,125","w":183,"k":{"n":27,"z":27,"u":27,"s":28,"r":27,"q":24,"o":24,"m":27,"J":27,"g":24,"d":24,"c":24,"a":26,"A":28}},"y":{"d":"91,1v-19,46,-40,66,-74,73r-1,-13v27,-5,49,-25,61,-61r-70,-173r15,0r63,157r62,-157r14,0","w":163},"z":{"d":"128,-160r-95,147r100,0r0,13r-116,0r0,-13r95,-147r-87,0r0,-13r103,0r0,13","w":149},"Z":{"d":"179,-13r0,13r-163,0r0,-13r141,-218r-130,0r0,-13r146,0r0,13r-141,218r147,0","w":195},"{":{"d":"29,-105r0,-11v45,0,20,-49,20,-81v0,-44,18,-59,53,-59r0,11v-61,-2,-39,57,-35,99v2,24,-6,28,-20,36v57,15,-34,138,55,134r0,11v-35,0,-53,-15,-53,-59v0,-32,25,-81,-20,-81","w":118},"|":{"d":"49,90r-12,0r0,-360r12,0r0,360","w":85},"}":{"d":"89,-105v-45,0,-20,49,-20,81v0,44,-18,59,-53,59r0,-11v61,2,40,-56,36,-99v-3,-24,6,-28,20,-36v-57,-15,34,-138,-56,-134r0,-11v35,0,53,15,53,59v0,32,-25,81,20,81r0,11","w":118},"~":{"d":"190,-107v-4,75,-103,7,-135,7v-13,0,-19,7,-19,23r-10,0v3,-75,104,-7,134,-7v13,0,19,-7,19,-23r11,0","w":215},"_":{"d":"172,31r-163,0r0,-11r163,0r0,11","w":181},"^":{"d":"103,-235r65,140r-12,0r-60,-129r-59,129r-13,0r66,-140r13,0","w":192},"]":{"d":"17,-241r0,-11r53,0r0,283r-53,0r0,-10r42,0r0,-262r-42,0","w":106},"\\":{"d":"11,-252r112,265r-12,0r-113,-265r13,0","w":121},"[":{"d":"90,-241r-42,0r0,262r42,0r0,10r-53,0r0,-283r53,0r0,11","w":106},";":{"d":"49,-166v0,15,-23,13,-23,0v0,-6,5,-12,11,-12v6,0,12,6,12,12xm26,-10v1,-8,11,-6,19,-6v-8,25,-18,53,-27,73r-14,2v8,-23,18,-52,22,-69","w":72},":":{"d":"47,-166v0,15,-23,13,-23,0v0,-6,5,-12,11,-12v6,0,12,6,12,12xm35,-19v6,0,12,5,12,11v0,17,-23,14,-23,0v0,-6,5,-11,11,-11","w":70},"9":{"d":"91,-240v40,0,73,35,73,96v0,79,-55,143,-114,148r-1,-13v55,-8,95,-61,99,-122v-25,62,-128,43,-128,-30v0,-48,31,-79,71,-79xm91,-106v32,0,56,-22,56,-52v0,-37,-26,-70,-57,-70v-28,0,-54,24,-54,65v0,33,22,57,55,57"},"8":{"d":"163,-62v2,87,-142,86,-142,5v0,-36,26,-53,56,-69v-24,-11,-46,-29,-46,-59v0,-32,28,-55,64,-55v33,0,63,23,63,53v0,30,-24,49,-49,60v34,16,54,34,54,65xm46,-185v0,28,21,43,48,53v56,-9,68,-94,1,-96v-29,0,-49,19,-49,43xm92,-9v29,0,56,-18,56,-50v0,-31,-23,-49,-57,-62v-33,13,-55,31,-55,60v0,31,25,52,56,52"},"7":{"d":"163,-237r0,13r-94,224r-15,0r94,-224r-122,0r0,-13r137,0"},"6":{"d":"93,4v-41,0,-72,-36,-72,-97v0,-79,54,-142,113,-147r2,12v-54,7,-99,63,-99,122v25,-63,128,-42,128,30v0,48,-32,80,-72,80xm94,-131v-32,0,-56,23,-56,52v0,38,25,70,56,70v28,0,55,-23,55,-64v0,-33,-22,-58,-55,-58"},"5":{"d":"48,-132v50,-22,112,3,112,59v0,65,-77,95,-134,66r1,-13v49,25,115,6,117,-49v2,-55,-56,-70,-96,-49r-13,-1r3,-118r110,0r0,13r-97,0"},"4":{"d":"144,-76r32,0r0,13r-32,0r0,63r-14,0r0,-63r-115,0r0,-12r114,-162r15,0r0,161xm130,-76r0,-140r-98,140r98,0"},"3":{"d":"159,-65v0,65,-79,84,-136,57r2,-13v45,23,117,14,118,-41v0,-31,-22,-50,-68,-52r0,-14v31,-2,63,-25,63,-56v0,-46,-61,-54,-100,-32r-2,-13v42,-23,117,-10,117,40v0,33,-29,53,-55,64v32,6,61,27,61,60"},"2":{"d":"157,-13r0,13r-133,0r0,-11v29,-40,127,-151,114,-169v4,-48,-64,-60,-101,-34r-2,-13v48,-29,122,-9,118,45v13,23,-72,120,-110,169r114,0"},"1":{"d":"44,-210v23,-8,40,-23,68,-27r0,237r-15,0r0,-218r-51,20"},"0":{"d":"93,-240v45,0,76,45,76,122v0,77,-31,122,-76,122v-45,0,-77,-45,-77,-122v0,-77,32,-122,77,-122xm93,-9v33,0,60,-39,60,-109v0,-70,-27,-110,-60,-110v-33,0,-61,40,-61,110v0,70,28,109,61,109"},"\/":{"d":"111,-252r12,0r-112,265r-13,0","w":121},".":{"d":"35,-19v6,0,12,5,12,11v0,17,-23,14,-23,0v0,-6,5,-11,11,-11","w":70},"-":{"d":"101,-98r0,11r-73,0r0,-11r73,0","w":129},",":{"d":"26,-10v1,-8,11,-6,19,-6v-8,25,-18,53,-27,73r-14,2v8,-23,18,-52,22,-69","w":69},"+":{"d":"116,-98r80,0r0,11r-80,0r0,87r-12,0r0,-87r-80,0r0,-11r80,0r0,-86r12,0r0,86","w":219},"*":{"d":"73,-243r14,0v0,17,-4,37,-2,52r47,-19r4,13v-16,5,-36,7,-50,14r33,39r-11,8r-28,-43r-28,43r-11,-8v10,-14,23,-25,32,-40r-49,-13r4,-13r48,19","w":159},")":{"d":"74,-111v0,59,-21,114,-43,145r-11,0v53,-68,54,-221,0,-289r11,0v22,31,43,85,43,144","w":105},"'":{"d":"45,-180r-11,0r-2,-66v0,-8,9,-7,17,-7","w":68},"%":{"d":"272,-58v0,34,-19,62,-50,62v-31,0,-50,-28,-50,-62v0,-34,19,-61,50,-61v31,0,50,27,50,61xm260,-58v0,-32,-16,-50,-38,-50v-22,0,-37,18,-37,50v0,32,15,51,37,51v22,0,38,-19,38,-51xm125,-179v0,34,-19,61,-50,61v-31,0,-49,-27,-49,-61v0,-34,18,-61,49,-61v31,0,50,27,50,61xm113,-179v0,-32,-16,-51,-38,-51v-22,0,-37,19,-37,51v0,32,15,50,37,50v22,0,38,-18,38,-50xm225,-248r13,0r-165,255r-14,0","w":297},"$":{"d":"53,-176v-10,48,110,59,97,107v0,31,-22,53,-54,57r0,34r-11,0r0,-33v-19,0,-36,-4,-52,-10r3,-13v35,17,101,16,99,-30v11,-48,-98,-56,-98,-109v0,-30,21,-47,48,-51r0,-35r12,0r0,34v18,0,31,4,42,9r-2,13v-28,-15,-87,-13,-84,27"},"&":{"d":"220,0r-20,0v-8,-8,-13,-18,-22,-25v-41,44,-157,41,-158,-35v-1,-37,27,-55,62,-80v-17,-20,-32,-37,-32,-59v0,-32,28,-49,51,-49v30,0,48,21,48,47v1,29,-21,43,-47,64r79,92v14,-18,22,-45,23,-76r14,0v-2,37,-13,66,-29,85xm100,-235v-46,0,-42,61,-6,88v25,-17,39,-28,39,-52v0,-21,-14,-36,-33,-36xm36,-62v-2,60,101,67,134,27r-80,-95v-34,22,-54,38,-54,68","w":231},"(":{"d":"32,-111v0,-59,21,-113,43,-144r11,0v-53,68,-54,221,0,289r-11,0v-22,-31,-43,-86,-43,-145","w":105},"<":{"d":"152,-29r0,13r-134,-73r0,-13r134,-72r0,13r-123,66","w":178},"=":{"d":"195,-49r-163,0r0,-11r163,0r0,11xm195,-124r-163,0r0,-11r163,0r0,11","w":226},">":{"d":"150,-95r-124,-66r0,-13r134,72r0,13r-134,73r0,-13","w":178},"?":{"d":"46,-50v-9,-65,52,-101,56,-151v3,-35,-54,-47,-84,-26r-1,-13v39,-21,101,-9,101,38v0,40,-71,93,-58,152r-14,0xm53,4v17,0,14,-23,0,-23v-6,0,-11,5,-11,11v0,6,5,12,11,12","w":138},"\u2019":{"d":"42,-248v2,-8,12,-4,20,-5v-8,25,-18,52,-27,72r-14,3v8,-23,17,-53,21,-70","w":85},"\u2018":{"d":"43,-184v-2,8,-11,6,-20,6v8,-25,18,-53,27,-73r14,-2v-8,23,-17,52,-21,69","w":85},"\u201c":{"d":"78,-184v-2,8,-11,6,-20,6v8,-25,18,-53,27,-73r14,-2v-8,23,-17,52,-21,69xm43,-184v-2,8,-11,6,-20,6v8,-25,18,-53,27,-73r14,-2v-8,23,-17,52,-21,69","w":120},"\u201d":{"d":"42,-248v2,-8,12,-4,20,-5v-8,25,-18,52,-27,72r-14,3v8,-23,17,-53,21,-70xm77,-248v2,-8,12,-4,20,-5v-8,25,-18,52,-27,72r-14,3v8,-23,17,-53,21,-70","w":120},"n":{"d":"44,-174v1,11,-1,27,2,36v13,-25,36,-39,62,-39v76,1,48,106,53,177r-14,0v-6,-62,24,-164,-44,-164v-33,0,-58,28,-58,62r0,102r-14,0r0,-174r13,0","w":188},"\u00a0":{"w":85}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * (C) 2009 dot colon.
 * 
 * Full name:
 * Vegur-Bold
 * 
 * Designer:
 * arro
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Vegur","font-weight":700,"font-stretch":"normal","units-per-em":"360","panose-1":"0 0 0 0 0 0 0 0 0 0","ascent":"277","descent":"-83","bbox":"-22 -270 330 90","underline-thickness":"18","underline-position":"-18","unicode-range":"U+0020-U+201D"},"glyphs":{" ":{"w":70},"`":{"d":"8,-253v17,2,39,-6,46,7v8,14,23,39,35,57r-37,1v-13,-16,-33,-46,-44,-65","w":112},"@":{"d":"184,-215v65,0,109,46,109,103v0,61,-33,94,-75,94v-23,0,-38,-8,-43,-25v-18,45,-90,31,-90,-24v0,-75,78,-105,142,-78r-11,72v-3,22,3,29,16,29v18,0,32,-26,32,-58v0,-51,-30,-86,-93,-86v-62,0,-122,46,-122,115v0,90,94,120,166,79r3,25v-86,47,-197,10,-198,-95v0,-92,77,-151,164,-151xm147,-50v24,7,33,-40,35,-69v-30,-8,-54,10,-54,46v0,15,9,23,19,23","w":323},"a":{"d":"30,-168v53,-23,134,-12,134,51r0,117r-47,0v-1,-7,1,-17,-2,-22v-22,43,-104,29,-104,-33v0,-47,54,-65,105,-57v2,-38,-51,-34,-81,-20xm85,-33v20,1,32,-16,31,-50v-23,-5,-55,-1,-55,25v0,14,9,25,24,25","w":185},"B":{"d":"191,-75v3,74,-90,86,-167,72r0,-237v71,-14,160,-6,160,55v0,26,-18,46,-41,54v31,9,48,28,48,56xm72,-144v32,2,60,-1,60,-31v0,-28,-27,-36,-60,-31r0,62xm139,-70v0,-33,-30,-40,-67,-37r0,69v34,4,67,0,67,-32","w":205},"!":{"d":"81,-25v0,16,-13,29,-29,29v-16,0,-28,-13,-28,-29v0,-16,12,-28,28,-28v16,0,29,12,29,28xm72,-71r-40,0r-3,-173r46,0","w":104},"\"":{"d":"53,-152r-35,0r-2,-88v-1,-16,28,-13,45,-13xm123,-152r-35,0r-2,-88v-1,-16,28,-13,46,-13","w":144},"#":{"d":"182,-138r-37,0r-6,39r33,0r0,27r-37,0r-10,59r-30,0r10,-59r-31,0r-9,59r-30,0r9,-59r-32,0r0,-27r37,0r6,-39r-33,0r0,-27r37,0r10,-59r30,0r-10,59r31,0r10,-59r29,0r-9,59r32,0r0,27xm109,-99r7,-39r-31,0r-6,39r30,0","w":194},"$":{"d":"111,-143v83,14,79,120,2,131r0,37r-35,0r0,-36v-18,-1,-37,-6,-51,-14r5,-37v21,9,43,14,61,14v19,0,30,-9,30,-24v0,-15,-11,-24,-34,-28v-72,-12,-77,-106,-9,-121r0,-41r36,0r0,38v19,1,36,7,47,13r-5,38v-18,-13,-72,-23,-78,5v0,13,8,21,31,25"},"%":{"d":"227,-119v34,0,61,25,61,61v0,36,-27,62,-61,62v-34,0,-61,-26,-61,-62v0,-36,27,-61,61,-61xm227,-32v11,0,20,-9,20,-26v0,-17,-9,-26,-20,-26v-11,0,-21,9,-21,26v0,17,10,26,21,26xm79,-240v34,0,61,25,61,61v0,36,-27,61,-61,61v-34,0,-61,-25,-61,-61v0,-36,27,-61,61,-61xm79,-153v11,0,21,-9,21,-26v0,-17,-10,-26,-21,-26v-11,0,-20,9,-20,26v0,17,9,26,20,26xm218,-248r35,0r-165,255r-35,0","w":306},"&":{"d":"253,0r-65,0v-5,-5,-7,-12,-13,-16v-50,38,-162,21,-162,-51v0,-33,22,-55,58,-74v-13,-12,-27,-29,-27,-53v0,-33,31,-54,69,-54v39,0,67,26,67,55v1,27,-18,43,-43,60r46,53v6,-9,11,-25,12,-42r48,0v-1,33,-13,57,-30,76xm112,-210v-27,2,-18,38,-1,45v19,-5,28,-44,1,-45xm65,-70v0,37,62,44,84,22r-52,-63v-18,9,-32,20,-32,41","w":261},"'":{"d":"53,-152r-35,0r-2,-88v-1,-16,28,-13,45,-13","w":74},"(":{"d":"99,-255v-42,97,-42,191,0,289r-35,0v-20,-33,-39,-88,-39,-145v0,-57,19,-111,39,-144r35,0","w":111},")":{"d":"13,34v42,-98,42,-192,0,-289r35,0v20,33,39,87,39,144v0,57,-19,112,-39,145r-35,0","w":111},"*":{"d":"73,-243r39,0v-1,18,-10,43,-6,57r50,-24r12,36v-18,5,-39,6,-55,12r39,41r-32,23v-10,-16,-17,-35,-28,-50r-27,50r-32,-23v13,-14,27,-27,39,-42r-55,-11r12,-36v18,8,33,18,52,24","w":185},"+":{"d":"127,-110r71,0r0,35r-71,0r0,75r-40,0r0,-75r-71,0r0,-35r71,0r0,-74r40,0r0,74","w":213},",":{"d":"22,-27v5,-21,30,-18,55,-18v-10,30,-23,67,-37,100r-43,4v11,-34,21,-67,25,-86","w":93},"-":{"d":"120,-110r0,35r-99,0r0,-35r99,0","w":141},".":{"d":"45,-53v16,0,28,12,28,28v0,16,-12,29,-28,29v-16,0,-28,-13,-28,-29v0,-16,12,-28,28,-28","w":90},"\/":{"d":"111,-252r44,0r-113,265r-44,0","w":153},"0":{"d":"100,-240v57,0,94,47,94,122v0,75,-37,122,-94,122v-57,0,-93,-47,-93,-122v0,-75,36,-122,93,-122xm100,-35v29,0,42,-26,42,-83v0,-57,-13,-84,-42,-84v-29,0,-41,27,-41,84v0,57,12,83,41,83"},"1":{"d":"36,-202v35,-11,57,-36,104,-35r0,237r-48,0r0,-182r-51,17"},"2":{"d":"181,-176v7,47,-64,100,-99,137r100,0r0,39r-161,0r0,-38v31,-32,122,-116,108,-133v0,-37,-56,-37,-89,-20r-5,-38v58,-25,149,-9,146,53"},"3":{"d":"181,-69v0,70,-104,90,-165,59r5,-39v33,17,108,26,108,-17v0,-21,-20,-32,-54,-34r0,-37v57,6,62,-66,8,-65v-14,0,-32,4,-47,10r-5,-38v54,-20,143,-11,143,46v0,33,-27,51,-54,57v35,5,61,25,61,58"},"4":{"d":"164,-237r0,150r35,0r0,38r-35,0r0,49r-48,0r0,-49r-112,0r0,-39r89,-149r71,0xm116,-87r1,-109v-9,22,-32,55,-63,109r62,0"},"5":{"d":"74,-145v52,-22,111,12,111,66v0,82,-101,99,-166,69r5,-38v41,19,106,23,109,-27v2,-31,-38,-48,-63,-29r-43,-1r5,-132r142,0r0,39r-98,0"},"6":{"d":"98,4v-45,0,-83,-31,-83,-96v0,-83,62,-144,139,-148r5,38v-45,3,-82,32,-90,70v42,-38,117,-2,117,55v0,54,-42,81,-88,81xm134,-72v6,-47,-63,-51,-67,-11v-4,56,66,64,67,11"},"7":{"d":"186,-237r0,39r-96,198r-49,0r97,-198r-116,0r0,-39r164,0"},"8":{"d":"185,-66v0,48,-42,70,-85,70v-48,0,-85,-25,-85,-67v-1,-30,23,-46,51,-59v-67,-28,-45,-118,37,-118v85,0,102,89,35,115v32,15,47,35,47,59xm102,-203v-37,5,-33,48,1,60v31,-7,39,-59,-1,-60xm100,-35v21,0,34,-13,34,-31v0,-18,-9,-29,-34,-40v-44,7,-45,71,0,71"},"9":{"d":"103,-240v45,0,82,31,82,96v0,83,-62,144,-139,148r-5,-38v45,-3,83,-32,91,-70v-41,40,-117,3,-117,-54v0,-54,42,-82,88,-82xm67,-164v-6,47,63,53,67,12v4,-57,-66,-66,-67,-12"},":":{"d":"45,-53v16,0,28,12,28,28v0,16,-12,29,-28,29v-16,0,-28,-13,-28,-29v0,-16,12,-28,28,-28xm45,-121v-16,0,-28,-12,-28,-28v0,-16,12,-29,28,-29v16,0,28,13,28,29v0,16,-12,28,-28,28","w":90},"<":{"d":"50,-96v31,19,67,32,100,49r0,45r-139,-70r0,-46r139,-70r0,45","w":169},";":{"d":"22,-27v5,-21,30,-18,55,-18v-10,30,-23,67,-37,100r-43,4v11,-34,21,-67,25,-86xm52,-121v-16,0,-28,-12,-28,-28v0,-16,12,-29,28,-29v16,0,29,13,29,29v0,16,-13,28,-29,28","w":97},"[":{"d":"115,-217r-45,0r0,213r45,0r0,35r-85,0r0,-283r85,0r0,35","w":125},"\\":{"d":"42,-252r113,265r-44,0r-113,-265r44,0","w":153},"]":{"d":"10,-217r0,-35r86,0r0,283r-86,0r0,-35r45,0r0,-213r-45,0","w":125},"^":{"d":"125,-243r63,141r-44,0r-42,-98r-42,98r-43,0r63,-141r45,0","w":204},"_":{"d":"199,51r-190,0r0,-35r190,0r0,35","w":208},"~":{"d":"194,-53v-19,8,-115,-47,-123,-41v-9,0,-17,9,-17,33r-36,0v0,-43,22,-68,60,-68v19,-8,115,47,123,41v9,0,17,-9,17,-33r35,0v0,44,-21,68,-59,68","w":271},"}":{"d":"35,-70v-3,-24,14,-35,35,-41v-42,-3,-37,-45,-30,-82v2,-17,-9,-27,-31,-27r0,-36v45,0,77,17,72,58v-4,30,-15,75,24,70r0,35v-39,-5,-28,40,-24,70v5,41,-27,58,-72,58r0,-36v43,2,30,-38,26,-69","w":127},"|":{"d":"70,90r-40,0r0,-360r40,0r0,360","w":99},"{":{"d":"57,-111v20,6,38,16,35,41v-4,31,-17,71,26,69r0,36v-45,0,-77,-17,-72,-58v4,-30,15,-75,-24,-70r0,-35v39,5,28,-40,24,-70v-5,-41,27,-58,72,-58r0,36v-43,-2,-29,38,-26,69v3,23,-12,37,-35,40","w":127},"z":{"d":"21,-176r131,0r0,37r-83,102r85,0r0,37r-143,0r0,-36r83,-103r-73,0r0,-37","w":164},"y":{"d":"122,-13v-25,65,-54,83,-99,87r-5,-37v29,-3,42,-14,50,-36r-68,-177r51,0r43,134v11,-48,28,-89,42,-134r49,0","w":183},"Z":{"d":"63,-38v39,4,86,0,128,1r0,37r-182,0r0,-40r121,-167r-110,0r0,-37r164,0r0,40","w":198},"=":{"d":"215,-113r-190,0r0,-35r190,0r0,35xm215,-36r-190,0r0,-35r190,0r0,35","w":239},">":{"d":"19,-47r101,-49r-101,-47r0,-45r139,70r0,46r-139,70r0,-45","w":169},"?":{"d":"94,-25v0,-16,-13,-28,-29,-28v-16,0,-28,12,-28,28v0,16,12,29,28,29v16,0,29,-13,29,-29xm41,-71v-11,-45,53,-76,53,-113v0,-30,-56,-30,-80,-14r-5,-37v50,-26,141,-13,137,48v10,37,-59,70,-58,116r-47,0","w":159},"\u201d":{"d":"39,-236v5,-22,31,-16,55,-17v-10,30,-23,66,-37,99r-43,5v11,-34,21,-68,25,-87xm116,-236v5,-22,32,-17,56,-17v-10,30,-24,66,-38,99r-43,5v11,-34,20,-68,25,-87","w":187},"\u2019":{"d":"39,-236v5,-22,31,-16,55,-17v-10,30,-23,66,-37,99r-43,5v11,-34,21,-68,25,-87","w":110},"\u201c":{"d":"149,-167v-5,22,-31,18,-56,18v10,-30,24,-67,38,-100r43,-4v-11,34,-21,67,-25,86xm72,-167v-5,22,-31,18,-56,18v10,-30,24,-67,38,-100r42,-4v-11,34,-20,67,-24,86","w":187},"\u2018":{"d":"72,-167v-5,22,-31,18,-56,18v10,-30,24,-67,38,-100r42,-4v-11,34,-20,67,-24,86","w":110},"q":{"d":"145,-21v-47,52,-133,17,-133,-64v0,-80,82,-124,133,-70r1,-21r47,0r0,247r-48,0r0,-92xm105,-33v29,0,40,-25,40,-59v0,-31,-15,-50,-40,-50v-28,0,-43,22,-43,55v0,33,14,54,43,54","w":217},"Q":{"d":"261,-122v0,53,-30,96,-74,115r14,51r-47,12r-13,-53v-76,6,-131,-53,-131,-125v0,-71,52,-125,125,-125v73,0,126,54,126,125xm135,-35v41,0,73,-30,73,-87v0,-57,-32,-87,-73,-87v-41,0,-72,30,-72,87v0,57,31,87,72,87","w":270},"S":{"d":"26,-176v0,-71,90,-83,145,-63r-5,38v-25,-10,-90,-17,-90,20v0,21,15,29,38,35v40,12,66,29,66,71v0,75,-97,93,-164,69r5,-39v39,13,108,21,108,-22v0,-20,-13,-30,-36,-36v-37,-10,-67,-29,-67,-73","w":196},"R":{"d":"72,-136v35,2,63,-3,63,-36v0,-33,-30,-39,-63,-34r0,70xm143,0v-16,-42,-3,-112,-71,-99r0,99r-48,0r0,-240v25,-4,54,-6,74,-6v107,0,115,103,45,124v38,14,36,79,53,122r-53,0"},"r":{"d":"128,-179r-1,47v-41,5,-54,11,-55,66r0,66r-48,0r0,-176r47,0v1,10,-1,24,2,32v10,-19,32,-34,55,-35","w":128,"k":{"v":-8,"t":-4,"y":-8}},"s":{"d":"67,-67v-30,-8,-48,-22,-48,-55v0,-50,65,-69,111,-49r-5,36v-14,-7,-54,-14,-56,8v0,9,5,16,17,19v37,10,52,23,52,53v0,56,-77,71,-127,49r5,-36v22,10,72,17,72,-7v0,-9,-8,-14,-21,-18","w":149},"T":{"d":"207,-244r0,38r-77,0r0,206r-48,0r0,-206r-77,0r0,-38r202,0","w":212,"k":{"A":30,"c":33,"d":33,"e":33,"g":33,"J":35,"m":35,"n":35,"o":33,"x":26,"w":25,"v":26,"u":35,"s":35,"r":35,"q":33,"y":22,"z":32,"a":31}},"t":{"d":"131,-176r0,37r-45,0v3,44,-18,124,44,103r5,35v-43,12,-97,6,-97,-50r0,-88r-30,0r0,-37r30,0r0,-40r48,0r0,40r45,0","w":145},"u":{"d":"96,-35v54,0,33,-88,37,-141r48,0r0,176r-47,0v-1,-7,1,-17,-2,-22v-30,45,-111,30,-111,-41r0,-113r48,0r0,106v0,24,8,35,27,35","w":205},"U":{"d":"210,-84v0,58,-42,88,-94,88v-52,0,-93,-30,-93,-81r0,-167r48,0r0,163v0,31,22,46,46,46v25,0,48,-13,48,-46r0,-163r45,0r0,160","w":231},"V":{"d":"168,-244r49,0r-85,244r-49,0r-84,-244r51,0r32,100v9,24,16,61,28,98v19,-81,37,-127,58,-198","w":213,"k":{"A":27,"c":15,"d":15,"e":15,"g":15,"J":22,"o":15,"s":20,"q":15,"z":13,"a":19}},"v":{"d":"136,-176r49,0r-68,176r-50,0r-67,-176r51,0r43,134v11,-48,28,-89,42,-134","w":183},"W":{"d":"282,-244r48,0r-73,244r-49,0v-16,-70,-33,-113,-43,-196v-11,82,-27,126,-44,196r-48,0r-73,-244r50,0v16,68,37,119,47,198r16,-81r29,-117r48,0v16,68,35,118,44,197v13,-69,31,-133,48,-197","w":327,"k":{"A":24,"c":13,"d":13,"e":13,"g":13,"J":21,"o":13,"s":18,"q":13,"z":11,"a":17}},"w":{"d":"232,-176r49,0r-60,176r-50,0v-11,-45,-25,-82,-30,-134v-7,50,-19,90,-30,134r-50,0r-60,-176r52,0v11,42,29,93,34,137v5,-42,20,-95,31,-137r49,0r32,137v4,-45,23,-95,33,-137","w":280},"x":{"d":"116,-92r65,92r-59,0v-13,-18,-20,-41,-35,-57r-33,57r-55,0r63,-90r-62,-86r59,0v11,17,19,36,31,52r31,-52r56,0","w":181},"X":{"d":"195,-244r-70,118r76,126r-57,0r-47,-85r-45,85r-53,0r73,-123r-72,-121r57,0r43,78r42,-78r53,0","w":197},"Y":{"d":"153,-244r52,0r-78,139r0,105r-49,0r0,-101r-79,-143r55,0r50,99","w":201,"k":{"A":32,"c":28,"d":28,"e":28,"g":28,"J":26,"m":22,"n":22,"o":28,"u":22,"s":31,"q":28,"a":31}},"P":{"d":"72,-206r0,80v36,2,63,-5,64,-41v0,-35,-29,-44,-64,-39xm24,0r0,-240v78,-17,167,-2,164,68v-2,65,-53,92,-116,85r0,87r-48,0","w":192,"k":{"c":4,"d":4,"e":4,"g":4,"J":27,"o":4,"q":4,"a":10}},"p":{"d":"72,-155v47,-51,134,-16,134,64v0,81,-84,126,-134,70r0,92r-48,0r0,-247r47,0xm112,-142v-29,0,-40,24,-40,58v0,31,15,51,40,51v28,0,43,-22,43,-55v0,-33,-14,-54,-43,-54","w":217},"N":{"d":"235,-244r0,244r-68,0v-35,-69,-69,-119,-100,-197r1,197r-45,0r0,-244r68,0v35,70,68,118,100,197r-1,-197r45,0","w":257},"O":{"d":"135,-247v73,0,126,54,126,125v0,71,-53,126,-126,126v-73,0,-125,-55,-125,-126v0,-71,52,-125,125,-125xm135,-35v41,0,73,-30,73,-87v0,-57,-32,-87,-73,-87v-41,0,-72,30,-72,87v0,57,31,87,72,87","w":270},"o":{"d":"101,-179v56,0,90,40,90,91v0,51,-34,92,-90,92v-56,0,-89,-41,-89,-92v0,-51,33,-91,89,-91xm101,-33v27,0,39,-24,39,-55v0,-31,-12,-54,-39,-54v-27,0,-39,23,-39,54v0,31,12,55,39,55","w":202},"n":{"d":"109,-141v-54,0,-33,88,-37,141r-48,0r0,-176r47,0v1,7,-1,18,2,23v30,-46,112,-30,112,41r0,112r-49,0r0,-105v0,-24,-8,-36,-27,-36","w":205},"M":{"d":"215,-235r59,0r9,235r-49,0r-2,-118v-1,-22,2,-40,1,-57v-12,58,-39,114,-57,168r-51,0v-17,-53,-44,-112,-56,-167r-1,174r-45,0r8,-235r59,0v20,62,48,119,62,187v18,-65,41,-126,63,-187","w":306},"m":{"d":"72,-153v20,-34,87,-35,101,6v28,-52,109,-40,109,33r0,114r-49,0r0,-107v0,-22,-8,-34,-26,-34v-42,-2,-28,94,-30,141r-48,0r0,-107v0,-22,-8,-34,-26,-34v-41,-2,-30,93,-31,141r-48,0r0,-176r47,0","w":302},"L":{"d":"24,-244r48,0r0,207r110,0r0,37r-158,0r0,-244","w":184},"l":{"d":"72,0r-48,0r0,-259r48,0r0,259","w":95},"k":{"d":"190,-176r-74,74r79,102r-61,0v-18,-21,-32,-48,-52,-67v-16,9,-8,43,-10,67r-48,0r0,-259r48,0r1,151v17,-24,35,-45,53,-68r64,0","w":187},"K":{"d":"215,-244r-104,114r111,130r-66,0r-77,-96r-7,9r0,87r-48,0r0,-244r48,0r1,100r81,-100r61,0","w":214},"J":{"d":"119,-86v2,78,-59,101,-125,85r5,-38v39,12,72,-2,72,-45r0,-160r48,0r0,158","w":137},"j":{"d":"53,-191v-15,0,-28,-13,-28,-28v0,-15,13,-27,28,-27v15,0,28,12,28,27v0,15,-13,28,-28,28xm77,-14v0,64,-41,84,-94,88r-5,-37v31,-4,51,-15,51,-49r0,-164r48,0r0,162","w":100},"i":{"d":"24,0r0,-176r48,0r0,176r-48,0xm48,-191v-15,0,-28,-13,-28,-28v0,-15,13,-27,28,-27v15,0,28,12,28,27v0,15,-13,28,-28,28","w":95},"I":{"d":"72,0r-48,0r0,-244r48,0r0,244","w":95},"H":{"d":"183,-244r48,0r0,244r-48,0r0,-107r-111,0r0,107r-48,0r0,-244r48,0r0,99r111,0r0,-99","w":254},"h":{"d":"109,-141v-54,0,-33,88,-37,141r-48,0r0,-259r48,0r1,106v30,-46,112,-30,112,41r0,112r-49,0r0,-105v0,-24,-8,-36,-27,-36","w":205},"g":{"d":"193,-176r0,150v4,90,-89,119,-167,88r5,-37v49,24,120,16,113,-48v-47,51,-132,16,-132,-63v0,-79,83,-123,132,-69r1,-21r48,0xm104,-142v-27,0,-42,20,-42,53v0,33,15,53,43,53v28,0,39,-23,39,-56v0,-31,-15,-50,-40,-50","w":216},"G":{"d":"211,-198v-68,-25,-149,-10,-149,76v0,74,53,99,113,82r0,-54r-44,0r0,-38r92,0r0,121v-98,34,-213,14,-213,-107v0,-111,113,-153,206,-118","w":242},"F":{"d":"72,0r-48,0r0,-244r142,0r0,38r-94,0r0,65r82,0r0,38r-82,0r0,103","w":169},"f":{"d":"37,-176v-3,-67,52,-100,113,-82r-5,36v-31,-12,-64,3,-59,46r43,0r0,37r-43,0r0,139r-49,0r0,-139r-29,0r0,-37r29,0","w":135},"E":{"d":"72,-39r97,0r0,39r-145,0r0,-244r142,0r0,38r-94,0r0,61r82,0r0,38r-82,0r0,68","w":179},"e":{"d":"103,-179v54,0,80,50,70,105r-114,0v1,47,63,48,99,30r5,36v-62,29,-151,7,-151,-75v0,-58,36,-96,91,-96xm98,-142v-19,0,-33,15,-37,35r68,0v-1,-18,-10,-35,-31,-35","w":187},"d":{"d":"145,-21v-47,52,-133,17,-133,-64v0,-80,82,-124,133,-70r0,-104r48,0r0,259r-47,0xm105,-33v29,0,40,-25,40,-59v0,-31,-15,-50,-40,-50v-28,0,-43,22,-43,55v0,33,14,54,43,54","w":217},"D":{"d":"24,-240v105,-19,223,3,223,108v0,117,-108,149,-223,129r0,-237xm72,-205r0,167v70,7,121,-11,123,-87v2,-66,-54,-90,-123,-80","w":256},"C":{"d":"10,-120v0,-108,115,-151,207,-116r-5,38v-68,-24,-150,-12,-150,76v0,86,81,102,147,75r5,39v-91,32,-204,3,-204,-112","w":225},"c":{"d":"63,-87v0,56,54,63,92,45r5,36v-64,26,-148,3,-148,-77v0,-85,84,-112,150,-86r-5,36v-40,-18,-94,-10,-94,46","w":170},"b":{"d":"72,-155v47,-51,134,-16,134,64v0,81,-84,126,-134,70r-1,21r-47,0r0,-259r48,0r0,104xm112,-142v-29,0,-40,24,-40,58v0,31,15,51,40,51v28,0,43,-22,43,-55v0,-33,-14,-54,-43,-54","w":217},"A":{"d":"172,0r-23,-72r-73,0r-23,72r-48,0r84,-244r50,0r84,244r-51,0xm113,-199r-26,89r51,0v-8,-24,-15,-48,-25,-89","w":227,"k":{"Y":32,"w":14,"W":24,"v":16,"V":27,"T":30,"y":9}},"\u00a0":{"w":70}}});
