<?php
/*
Plugin Name: Subscription Mate
Plugin URI: http://subscriptionmate.com
Description: - Subscription Mate Membership Plugin - Supports ClickBank, Paypal & DigiResult
Version: 1.2.1
Author: Jimmy Brown & Adrian Ling
Author URI: http://subscriptionmate.com
*/
// ---------------------------- THE FUN BEGINS -----------------------------------------//
include_once("subm_includes.php");
include_once("subm_options_page.php");
include_once("subm_privileges.php");

// -----------------------------------------//
// Activation & De-activation of the Plugin //
// -----------------------------------------//
register_activation_hook(__FILE__,'subm_activate'); // run when plugin activated
register_deactivation_hook( __FILE__, 'subm_deactivate' );  // run when plugin de-activated

// ---------------//
// Define Filters //
// ---------------//
add_filter('login_redirect', 'redirect_after_login', 10, 3);
add_filter('the_content','subm_members_priv'); // in subm_privileges.php file
add_filter('the_title','subm_hide_title'); // in subm_hide_title() - in subm_privileges.php file
add_filter('the_tags','subm_hide_tags'); // hide subm_levelX tags

add_action( 'pre_get_posts', 'subm_exclude_tags' ); //__hide private posts from Loop__ 17 Apr 2012_______//
add_shortcode('subm_show_optin', 'subm_show_optin'); // callback to show optin form
add_shortcode('dprotect', 'subm_download_protect'); // callback func to protect download
add_shortcode('subm_confirm_optin', 'subm_confirm_optin');// callback func. for free signup
add_shortcode('subm_thankyou', 'subm_thankyou');  // callback func. to process CB orders

// ---------------//
// Define Actions //
// ---------------//
if(is_admin() ) {
  add_action('admin_menu','subm_add_menu');     // add "Plugin Options" menu
  add_action('admin_init','subm_metabox_init'); 
  add_action('admin_init','subm_add_roles' ); // in the subm_includes.php file
  //  add_action('save_post','subm_metabox_save');  // #4  <-- dont put it here, cause 'warnings'
}

// ----------------------------------------//
// Create a Menu & Submenus - Options Page //
// ----------------------------------------//
function subm_add_menu() {  // add to existing menu: wordpress "Options" page //
  add_menu_page('Subscription Mate Settings','SubscriptionMate','administrator','__FILE__','subm_options_page');
  add_submenu_page('__FILE__','SubcriptionMate Download Protection','Download Protection','administrator','__FILE__'.'downloadprotection','subm_options_protect');
  
  add_action('admin_init','subm_register_settings');
}

function subm_register_settings() {
  register_setting('subm_members_group','subm_members_option');
  register_setting('subm_members_dwnld','subm_members_dwnld'); 
}
?>