<?php
// -------------------------- //
// Filter the subm_levelX tags //
// ---------------------------//
function subm_hide_tags($subm_tags) {
   global $current_user;      
   get_currentuserinfo();
   if($current_user->user_login=="") {
      $subm_leveltags = array("level1","level2","level3","level4","level5");
      $subm_tags = str_ireplace($subm_leveltags,'[private content]',$subm_tags);
      return $subm_tags;
   } 
   if( current_user_can("subm_members") && $current_user->user_login!="") {
      return $subm_tags; // user has logged in AND is a member
   }
   if( !current_user_can("subm_members") && $current_user->user_login!="") {
      $subm_leveltags = array("level1","level2","level3","level4","level5");
      $subm_tags = str_ireplace($subm_leveltags,'[private content]',$subm_tags);
      return $subm_tags;
   }
}
// ----------------------------------------------------------------//
// function to determine the num. of elapse days since mbr sign-up //
// ----------------------------------------------------------------//
function find_elapse_days($mypost_id) {
  global $current_user;  get_currentuserinfo();

  $today_date = date("Y-m-d");    list($y,$m,$d) = explode("-",$today_date);
  $thisday = mktime(0,0,0,$m,$d,$y);

  list($user_regdate,$xx) = explode(" ",$current_user->user_registered);
  if($user_regdate == "") { $user_regdate = $today_date; } // public, not logged in
  list($y,$m,$d) = explode("-",$user_regdate);
  $user_joindate = mktime(0,0,0,$m,$d,$y);
    
  $diff = $thisday - $user_joindate;
  if($diff==0) { // do nothing, on the same day?
     $elapse_days = 0;
  } else { // find num of days elapse since user signed up
     $elapse_days = date("z",$diff) ;
  }
  
  // ---------------------------------------//
  // Get the dripped content "delay" value  // 
  // ---------------------------------------//
  $delay_days = get_post_meta($mypost_id,'_subm_days',true);
  if($delay_days == "") { $delay_days = 0; }
  
  // return both data
  $ret_data = "$elapse_days|$delay_days|$user_regdate";
  return($ret_data);
}

// -------------------------- //
// Filter the Post Title?     //
// ---------------------------//
function subm_hide_title($title) {

  if( current_user_can("delete_users") ) {  return $title; }
  // get post ID //
  // -----------//
  $mypost_id = get_the_ID();  // get the ID of the current post (must be used within the loop)
  $posttags = get_the_tags(); 
  
  list($elapse_days, $delay_days, $user_regdate) = explode('|', find_elapse_days($mypost_id) );
  
  if( $delay_days!=0 ) {
      if($elapse_days >= $delay_days) { $disp_title = 1; } // wait period over, display title
      else { 
          $disp_title=0;  // do not display title yet.
          $wait_days = $delay_days - $elapse_days; 
      }
  } else { // the post is NOT setup for dripped content.
      $disp_title=1; 
  }
  
  if($disp_title) { // display title, no need to modify anything.
  } else {
    $title='';// reset or hide the title 
  }
  return($title);

} // end of subm_hide_title()

// -----------------------------------------------------//
//  Filter the Content/Posts to see if Members can view //
// -----------------------------------------------------//
function subm_members_priv($content) {
  // Admin User - Over-ride all settings //
  if( current_user_can("delete_users") ) {  return $content; }

  $today = date("Y-m-d");
  // get post ID //
  $mypost_id = get_the_ID();  // get the ID of the current post (must be used within the loop)
  $posttags = get_the_tags(); 
  
  list($elapse_days, $delay_days, $user_regdate) = explode('|', find_elapse_days($mypost_id));
   
  if( $delay_days!=0) {
      if($elapse_days >= $delay_days) { $disp_drip = 1; } // wait period over, disp. content
      else { 
          $disp_drip=0;  // do not display content yet.
          $wait_days = $delay_days - $elapse_days; 
      }
  } else {  $disp_drip=1; }// the post is NOT setup for dripped content.
  
  $level = ""; // initialize the default level, i.e. public posts don't have 'level requirements'
  if($posttags) {
    foreach($posttags as $tag) {
      // check each posts for priv. posts and setup the level privileges //
      if(preg_match('/level1/',$tag->name)) { $level = "read_level1"; $mbr_content = 'Basic Members Content'; }
      if(preg_match('/level2/',$tag->name)) { $level = "read_level2"; $mbr_content = 'Bronze Members Content';}
      if(preg_match('/level3/',$tag->name)) { $level = "read_level3"; $mbr_content = 'Silver Members Content';}
      if(preg_match('/level4/',$tag->name)) { $level = "read_level4"; $mbr_content = 'Gold Members Content';}
      if(preg_match('/level5/',$tag->name)) { $level = "read_level5"; $mbr_content = 'Platinum Members Content';}
    }
    //-----------------------------------------------------------------//
    // return normal (PUBLIC) posts that do not have the 'levelX' tags //
    // ---------------------------------------------------------------//
    if($level == "") {  return $content;   }
    
    // ------------------------------------//
    // display Premium Content for Members //
    // ------------------------------------//
    if(current_user_can($level)) {
        //$dbugtxt = "<hr>PostID: $mypost_id | Delay by: $delay_days days.<BR>
        //            Mbr registered on: $user_regdate (Today: $today)<BR>Elapse Days: $elapse_days";
        if($disp_drip) {
          $content = $content . $dbugtxt;
          // $content;
        } else {
           $content = "Sorry, the content will be available in $wait_days day(s) time." . $dbugtxt;
           //$content = ''; // reset (hide) the content.
        }
        return $content;
    } else { //____ask public/lower-members to Upgrade //
        $subm_mbrs = get_option('subm_members_option');
        $upgrademsg = $subm_mbrs[upgrademsg];
        
        if(is_home()) {
            $content = 'Private (Members Only) Content'; return $content; 
        } else { //$content = "You are trying to access $mbr_content<P>" . $upgrademsg; return $content;
            $content = $upgrademsg; return $content;
        }
    }  
  }    // ---------------------------------------------------------------------
  else { // No 'levelX tags', e.g. => public posts, and posts withOUT any tags
    return $content;
  } 
  
} // end of subm_members_priv() function
?>