<?php
/*
Plugin Name: Content Pizazz
Plugin URI: http://www.kevinsspace.ca/content-pizazz/
Description: This plugin gives the user a number of shortcodes to spice up posts and pages. There are shortcoded to add linkable buttons, message boxes, list icons, drop caps, quotes, columns, and text enhancement.
Version: 1.0.0
Author: Kevin Archibald
Author URI: http://www.kevinsspace.ca
License: GPLv3
*/
/*
===================================================================================================
                       LICENSE
===================================================================================================

License: GNU General Public License V3
License URI: see the license.txt file for license details.

	Content Pizazz is a plugin for WordPress
    Copyright (C) 2012 Kevin Archibald

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * This is the main plugin file for Content Pizazz
 *
 * @package		Content Pizazz WordPress Plugin
 * @copyright	Copyright (c) 2012, Kevin Archibald
 * @license		http://www.gnu.org/licenses/quick-guide-gplv3.html  GNU Public License
 * @author		Kevin Archibald <www.kevinsspace.ca/contact/>
 */

/*# ---------------------------------- #
# prevent file from being accessed directly
# ---------------------------------- #*/
if ('content-pizazz.php' == basename($_SERVER['SCRIPT_FILENAME']))
	die ('Please do not access this file directly. Thanks!');

register_activation_hook( __FILE__, 'kacp_content_pizazz_activate' );

function kacp_content_pizazz_activate() {
	//Check version compatibilities
    if ( version_compare( get_bloginfo( 'version' ), '3.2', '<' ) ) {
        deactivate_plugins( basename( __FILE__ ) ); // Deactivate our plugin
        die ('Please Upgrade your WprdPress to use this plugin.');
    }
}

add_action( 'plugins_loaded','kacp_content_pizazz_plugin_setup');

function kacp_content_pizazz_plugin_setup() {
	add_action('wp_enqueue_scripts','kacb_add_user_style');
	add_shortcode('cp_one_fourth', 'content_pizazz_one_fourth_col');
	add_shortcode('cp_one_third', 'content_pizazz_one_third_col');
	add_shortcode('cp_two_third', 'content_pizazz_two_third_col');
	add_shortcode('cp_one_half', 'content_pizazz_one_half_col');
	add_shortcode('cp_three_fourth', 'content_pizazz_three_fourth_col');
	add_shortcode('cp_clear', 'content_pizazz_clear');
	add_shortcode('cp_list', 'content_pizazz_list_func');
	add_shortcode('cp_list_1', 'content_pizazz_list_func_1');
	add_shortcode('cp_list_2', 'content_pizazz_list_func_2');
	add_shortcode('cp_list_3', 'content_pizazz_list_func_3');
	add_shortcode('cp_list_4', 'content_pizazz_list_func_4');
	add_shortcode('cp_messagebox', 'content_pizazz_messagebox_func');
	add_shortcode('cp_button', 'content_pizazz_button_func');
	add_shortcode('cp_3d_button', 'content_pizazz_3d_button_func');
	add_shortcode('cp_special_text', 'content_pizazz_special_text_functon');
	add_shortcode('cp_quote', 'content_pizazz_quote_func');
	add_shortcode('cp_dropcaps', 'content_pizazz_drop_caps_func');
}

/**
 * Register styles for shortcodes
 *
 * @param int|string $user Either an ID or a username
 * @param PDO $pdo A valid PDO object
 * @return User Returns User object or null if not found
 */

 function kacb_add_user_style(){
	wp_register_style( 'kacb_user_styles',plugin_dir_url(__FILE__).'kacp_user_styles.css' );
	wp_enqueue_style( 'kacb_user_styles' );
}

/**
 *--------------column shortcodes --------------------------------------------- 
 * useage [cp_one_fourth]text[/cp_one_fourth]
 * options cp_one_fourth,cp_one_half,cp_three_fourth,cp_one_third,cp_two_third
 * -----------------------------------------------------------------------------
 *
 * @param array $atts needs to be there but is not used in these shortcodes
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */
 
function content_pizazz_one_fourth_col ($atts,$content = null) {
	return '<div class="cp_one_fourth">'.do_shortcode($content).'</div>';
}


function content_pizazz_one_third_col ($atts, $content = null) {
	return '<div class="cp_one_third">'.do_shortcode($content).'</div>';
}


function content_pizazz_two_third_col ($atts, $content = null) {
	return '<div class="cp_two_third">'.do_shortcode($content).'</div>';
}


function content_pizazz_one_half_col ($atts, $content = null) {
	return '<div class="cp_one_half">'.do_shortcode($content).'</div>';
}


function content_pizazz_three_fourth_col ($atts, $content = null) {
	return '<div class="cp_three_fourth">'.do_shortcode($content).'</div>';
}

/**
 *---------------css clear shortcode--------------------------------------------- 
 * useage [cp_clear] used to clear css floats
 * -----------------------------------------------------------------------------
 *
 * @param array $atts needs to be there but is not used in these shortcodes
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */
 
function content_pizazz_clear ($atts) {
	return '<div class="cp_clear"></div>';
}

/**
 * --------------list shortcodes ------------------------------------------- 
 * useage [cp_list style="dot"]<li>Item 1</li>[/cp_list] 
 * style options: dot,arrow_1,arrow_2,arrow_3,check_1,check_2,cog,happy
 * -------------------------------------------------------------------------
 *
 * @param array $atts default style
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */
function content_pizazz_list_func ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'style' => 'dot',
    ), $atts));
	if ( $style != 'arrow_1' && $style != 'arrow_2' && $style != 'arrow_3' && $style != 'check_1' 
	      && $style != 'check_2' && $style != 'star' && $style != 'cog' && $style != 'happy' && $style != 'dot' ) $style = 'dot';
    $list_string = '<ul class="cp_'.$style.'">'.do_shortcode($content).'</ul>';
	$list_string = str_replace(array('<p>','</p>','<br/>','<br />'), '', $list_string);
    return $list_string;
}
 
function content_pizazz_list_func_1 ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'style' => 'dot',
    ), $atts));
	if ( $style != 'arrow_1' && $style != 'arrow_2' && $style != 'arrow_3' && $style != 'check_1' 
	      && $style != 'check_2' && $style != 'star' && $style != 'cog' && $style != 'happy' && $style != 'dot' ) $style = 'dot';
    $list_string = '<ul class="cp_'.$style.'">'.do_shortcode($content).'</ul>';
	$list_string = str_replace(array('<p>','</p>','<br/>','<br />'), '', $list_string);
    return $list_string;
}

function content_pizazz_list_func_2 ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'style' => 'dot',
    ), $atts));
	if ( $style != 'arrow_1' && $style != 'arrow_2' && $style != 'arrow_3' && $style != 'check_1' 
	      && $style != 'check_2' && $style != 'star' && $style != 'cog' && $style != 'happy' && $style != 'dot' ) $style = 'dot';
    $list_string = '<ul class="cp_'.$style.'">'.do_shortcode($content).'</ul>';
	$list_string = str_replace(array('<p>','</p>','<br/>','<br />'), '', $list_string);
    return $list_string;
}

function content_pizazz_list_func_3 ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'style' => 'dot',
    ), $atts));
	if ( $style != 'arrow_1' && $style != 'arrow_2' && $style != 'arrow_3' && $style != 'check_1' 
	      && $style != 'check_2' && $style != 'star' && $style != 'cog' && $style != 'happy' && $style != 'dot' ) $style = 'dot';
    $list_string = '<ul class="cp_'.$style.'">'.do_shortcode($content).'</ul>';
	$list_string = str_replace(array('<p>','</p>','<br/>','<br />'), '', $list_string);
    return $list_string;
}

function content_pizazz_list_func_4 ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'style' => 'dot',
    ), $atts));
	if ( $style != 'arrow_1' && $style != 'arrow_2' && $style != 'arrow_3' && $style != 'check_1' 
	      && $style != 'check_2' && $style != 'star' && $style != 'cog' && $style != 'happy' && $style != 'dot' ) $style = 'dot';
    $list_string = '<ul class="cp_'.$style.'">'.do_shortcode($content).'</ul>';
	$list_string = str_replace(array('<p>','</p>','<br/>','<br />'), '', $list_string);
    return $list_string;
}

/**
 * ------------------ messagebox shortcode ------------------------------------------------------------------------------------------- 
 * useage : [messagebox color="#ffffff" border="#000000" font_color="#000000" align="left" shade="noshade"]Your Message[/messagebox] 
 * align : left(default),right,center
 * color : any hex color or web color, default is #ffffff or white
 * border : any hex color or web color, default is #000000 or black
 * shade : noshade(default), light,dark
 * font-color : any hex color or web color, default is #000000 or black
 * Message Text : Place your message here, keep the message on one line
 * -----------------------------------------------------------------------------------------------------------------------------------
 *
 * @param array $atts default styles
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */

function content_pizazz_messagebox_func ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'color' => '#ffffff',
	    'border' => '#000000',
	    'font_color' => '#000000',
	    'shade' => 'noshade',
	    'align' => 'left',
    ), $atts));
	// Do a little validation
	$color = sanitize_text_field(trim($color));
	$border = sanitize_text_field(trim($border));
	$font_color = sanitize_text_field(trim($font_color));
	$shade = sanitize_text_field(trim($shade));
	if ( $shade != 'noshade' && $shade != 'dark' && $shade != 'light' ) $shade = 'noshade';
	$align = sanitize_text_field(trim($align));
	if ( $align != 'left' && $align != 'right' && $align != 'center' ) $align = 'left' ;
	// ok return html
	if($align == 'left') {
		return '<div class="cp_messagebox cp_mb_left" ><span class="cp_messagebox_mb'.$shade.'" style="background-color:'.$color.'; border: 2px solid '.$border.'; color:'.$font_color.'; ">'.do_shortcode($content).'</span></div>';	
	} elseif ($align == 'right'){
		return '<div class="cp_messagebox cp_mb_right" ><span class="cp_messagebox_mb'.$shade.'" style="background-color:'.$color.'; border: 2px solid '.$border.'; color:'.$font_color.'; ">'.do_shortcode($content).'</span></div>';	
	} elseif ($align == 'center') {
		return '<div class="cp_messagebox cp_mb_center" ><span class="cp_messagebox_mb'.$shade.'" style="background-color:'.$color.'; border: 2px solid '.$border.'; color:'.$font_color.'; ">'.do_shortcode($content).'</span></div>';
	} else {
		return '<div class="cp_messagebox cp_mb_left" ><span class="cp_messagebox_mb'.$shade.'" style="background-color:'.$color.'; border: 2px solid '.$border.'; color:'.$font_color.'; ">'.do_shortcode($content).'</span></div>';
	}   
}

/**
 * ------------------ button shortcode -------------------------------------------------------------------------------- 
 * useage : [button color="gray" font_color="#000000" align="left" link="http://www.yourlink.ext"]Button Text[/button]
 * color : gray(dfefault), blue, brown, dark, green, red, yellow
 * font-color : Any hex color number or web color, default is #000000
 * align : left(default), right, center
 * link : any internet url, default is "#"
 * -------------------------------------------------------------------------------------------------------------------
 *
 * @param array $atts default styles
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */

function content_pizazz_button_func ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'color' => 'gray',
	    'font_color' => '#000000',
	    'align' =>'left',
	    'link' => '#',
	    'title' => '',
    ), $atts));
	/* Do a little validation */
	$title = sanitize_text_field($title);
	if ($link != '#') $link = esc_url(trim($link));
	$color = trim($color);
	if ($color != 'gray' && $color != 'blue' && $color != 'dark' && $color != 'brown' && $color != 'red' && $color != 'yellow' && $color != 'green') $color = 'gray';
	$image_left = "'images/buttons/".$color."_l.png'";
	$image_right = "'images/buttons/".$color."_r.png'";
	$align=trim($align);
	if($align != 'left' && $align != 'right' && $align != 'center') $align = 'left';
	/* Return html */
    if($align == 'left') {
		return '<div class="cp_button_left" ><a class="cp_button cp_button_'.$color.'" href="'.$link.'" title="'.$title.'"><span style="color:'.$font_color.';">'.do_shortcode($content).'</span></a></div>';	
	} elseif ($align == 'right'){
		return '<div class="cp_button_right" > <a class="cp_button cp_button_'.$color.'" href="'.$link.'" title="'.$title.'"><span style="color:'.$font_color.';">'.do_shortcode($content).'</span></a></div>';	
	} elseif ($align == 'center') {
		return '<div class="cp_button_center" > <a class="cp_button cp_button_'.$color.'" href="'.$link.'" title="'.$title.'"><span style="color:'.$font_color.';">'.do_shortcode($content).'</span></a></div>';	
	} else {
		return '<div class="cp_button_left" ><a class="cp_button cp_button_'.$color.'" href="'.$link.'" title="'.$title.'"><span style="color:'.$font_color.';">'.do_shortcode($content).'</span></a></div>';	
	}
}

/**
 * ------------------ 3D (css3) button shortcode ----------------------------------------------------------------------- 
 * useage : [cp_button color="gray" font_color="#000000" align="left" link="http://www.yourlink.ext"]Button Text[/cp_button]
 * title: This text will appear when you hover over the button
 * align: left(default), right, center, in-line
 * size: small(default), medium, large
 * background-color: any hex color (default #cccccc) or web color (ex: red)
 * font-color: any hex color (default #000000) or web color (ex: red)
 * link: any url of the form http://www.yourlink.ext/
 * -------------------------------------------------------------------------------------------------------------------
 *
 * @param array $atts default styles
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */

function content_pizazz_3d_button_func ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'background_color' => '#cccccc',
	    'font_color' => '#000000',
	    'align' =>'left',
	    'link' => '#',
	    'size' => 'small',
	    'title' => '',
    ), $atts));
	/* Do a little validation */
	$title = sanitize_text_field($title);
	if ($link != '#') $link = esc_url(trim($link));
	$background_color = trim($background_color);
	$font_color=trim($font_color);
	$css_style = 'background-color:'.$background_color.';'.
				' color:'.$font_color.';';
	if ($link != '#') $link = esc_url(trim($link));
	$size = trim($size);
	if($size != 'small' && $size != 'medium' && $size != 'large') $size = 'small';
	$align=trim($align);
	if($align != 'left' && $align != 'right' && $align != 'center' && $align != 'in-line') $align = 'left';
	
	/* Return html */
    if($align == 'left') {
		return '<div class="cp_button_left" ><a class="cp_3d_button cp_css_button_'.$size.'" title="'.$title.'" style="'.$css_style.'" href="'.$link.'">'.do_shortcode($content).'</a></div>';	
	} elseif ($align == 'right'){
		return '<div class="cp_button_right" ><a class="cp_3d_button cp_css_button_'.$size.'" title="'.$title.'" style="'.$css_style.'" href="'.$link.'">'.do_shortcode($content).'</a></div>';	
	} elseif ($align == 'center') {
		return '<div class="cp_button_center" ><a class="cp_3d_button cp_css_button_'.$size.'" title="'.$title.'" style="'.$css_style.'" href="'.$link.'">'.do_shortcode($content).'</a></div>';	
	} elseif ($align == 'in-line') {
		return '<a class="cp_3d_button cp_css_button_'.$size.'" title="'.$title.'" style="'.$css_style.'" href="'.$link.'">'.do_shortcode($content).'</a>';
	} else {
		return '<div class="cp_button_left" ><a class="cp_3d_button cp_css_button_'.$size.'" title="'.$title.'" style="'.$css_style.'" href="'.$link.'">'.do_shortcode($content).'</a></div>';	
	}
}

/**
 * ------------------ special text shortcode ----------------------------------------- 
 * useage : [cp_special_text color="red" size="large"]Special Text[/cp_special_text]
 * color: red(default), white, black, yellow, green, blue, gray
 * size: small, normal(default), medium, large
 * -----------------------------------------------------------------------------------
 *
 * @param array $atts default styles
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */

function content_pizazz_special_text_functon( $atts, $content = null ) {
     extract(shortcode_atts(array(
         'color' => 'red',
         'size' => 'normal',
     ),$atts));
	 //data validation
	 $size = sanitize_text_field(trim($size));
	 if ( $size != 'small' && $size != 'medium'  && $size != 'large' && $size != 'normal' ) $size = 'normal';
	 $color=sanitize_text_field(trim($color));
	 if ( $color != 'white' && $color != 'black' && $color != 'red' && $color != 'yellow' && $color != 'green' && $color != 'blue' && $color != 'gray' ) $color = 'red';
	//return html
   	return '<span class="cp_st_'.$color.' cp_st_'.$size.'">'. $content . '</span>';
}

/**
 * ------------------ quote shortcode --------------------------------------------------- 
 * useage : [cp_quote style="quote_left_dark"]Your Quote[/cp_quote]
 * style options : quote_left_dark, quote_right_dark, quote_left_light, quote_left_dark
 *                quote_normal_dark, quote_normal_light
 * -------------------------------------------------------------------------------------
 *
 * @param array $atts default styles
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */

function content_pizazz_quote_func ( $atts, $content = null ) {
    extract(shortcode_atts(array(
	    'style' => 'quote_left_dark',
    ), $atts));
    return '<div class="cp_'.$style.'">'.do_shortcode($content).'</div>';
}

/**
 * ------------------ drop caps shortcode --------------------------------
 *
 * @param array $atts not used here but must be present
 * @param string $content is the string of text between the shortcode tags
 * @return html formated string
 */
/*  */

function content_pizazz_drop_caps_func ( $atts, $content = null ) {
	return '<div class="cp_dropcaps">'.do_shortcode($content).'</div>';	
}

 